/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sample.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdFsmFileRefPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5crm.api.sample.payload.SampleReturnRecordPayload;
import com.elitesland.tw.tw5crm.api.sample.query.SampleReturnRecordQuery;
import com.elitesland.tw.tw5crm.api.sample.service.SampleReturnRecordService;
import com.elitesland.tw.tw5crm.api.sample.vo.SampleReturnRecordVO;
import com.elitesland.tw.tw5crm.server.common.constants.FileTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SampleEnum;
import com.elitesland.tw.tw5crm.server.sample.convert.SampleReturnRecordConvert;
import com.elitesland.tw.tw5crm.server.sample.dao.SampleReturnRecordDAO;
import com.elitesland.tw.tw5crm.server.sample.entity.SampleReturnRecordDO;
import com.elitesland.tw.tw5crm.server.sample.repo.SampleReturnRecordRepo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SampleReturnRecordServiceImpl
extends BaseServiceImpl
implements SampleReturnRecordService {
    private static final Logger log = LoggerFactory.getLogger(SampleReturnRecordServiceImpl.class);
    private final SampleReturnRecordRepo sampleReturnRecordRepo;
    private final SampleReturnRecordDAO sampleReturnRecordDAO;
    private final PrdFsmFileRefService prdFsmFileRefService;

    public PagingVO<SampleReturnRecordVO> queryPaging(SampleReturnRecordQuery query) {
        return this.sampleReturnRecordDAO.queryPaging(query);
    }

    public List<SampleReturnRecordVO> queryListDynamic(SampleReturnRecordQuery query) {
        return this.sampleReturnRecordDAO.queryListDynamic(query);
    }

    public SampleReturnRecordVO queryByKey(Long key) {
        SampleReturnRecordDO entity = this.sampleReturnRecordRepo.findById(key).orElseGet(SampleReturnRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SampleReturnRecordVO vo = SampleReturnRecordConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public SampleReturnRecordVO insert(SampleReturnRecordPayload payload) {
        if (payload.getSampleDetailsId() == null || payload.getReturnNumber() == null || payload.getReturnDate() == null) {
            throw TwException.error((String)"", (String)"\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u5b57\u6bb5\u672a\u8f93\u5165");
        }
        SampleReturnRecordDO entityDo = SampleReturnRecordConvert.INSTANCE.toDo(payload);
        int returnedNumSum = this.sampleReturnRecordDAO.queryReturnedNumSum(payload.getSampleDetailsId());
        entityDo.setReturnedNumSum(returnedNumSum);
        HashSet<Long> sampleDetailsIds = new HashSet<Long>(1);
        sampleDetailsIds.add(payload.getSampleDetailsId());
        Map<Long, Integer> returnedTotalMap = this.sampleReturnRecordDAO.getReturnedTotal(sampleDetailsIds);
        Integer allNeedReturnNum = returnedTotalMap.get(payload.getSampleDetailsId());
        if (allNeedReturnNum == null) {
            throw TwException.error((String)"", (String)"\u8be5\u4ea7\u54c1\u65e0\u9700\u5f52\u8fd8\uff01");
        }
        if (payload.getReturnNumber() == null) {
            throw TwException.error((String)"", (String)"\u8bf7\u8f93\u5165\u5f52\u8fd8\u6570\u91cf\uff01");
        }
        if (returnedNumSum + payload.getReturnNumber() > allNeedReturnNum) {
            throw TwException.error((String)"", (String)"\u5f52\u8fd8\u6570\u91cf\u8d85\u8fc7\u603b\u6570\uff0c\u8bf7\u91cd\u65b0\u5f52\u8fd8\uff01");
        }
        if (returnedNumSum + payload.getReturnNumber() == allNeedReturnNum) {
            payload.setReturnStatus(SampleEnum.FULL_RETURN.getCode());
        } else {
            payload.setReturnStatus(SampleEnum.PARTIAL_RETURN.getCode());
        }
        SampleReturnRecordDO save = (SampleReturnRecordDO)this.sampleReturnRecordRepo.save(entityDo);
        PrdFsmFileRefPayload prdFsmFileRefPayload = new PrdFsmFileRefPayload();
        prdFsmFileRefPayload.setObjId(save.getId());
        prdFsmFileRefPayload.setObjType(FileTypeEnum.sample.getCode());
        prdFsmFileRefPayload.setFileCode(payload.getFeedbackFileCode());
        this.prdFsmFileRefService.insert(prdFsmFileRefPayload);
        return SampleReturnRecordConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public SampleReturnRecordVO update(SampleReturnRecordPayload payload) {
        SampleReturnRecordDO entity = this.sampleReturnRecordRepo.findById(payload.getId()).orElseGet(SampleReturnRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SampleReturnRecordDO entityDo = SampleReturnRecordConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SampleReturnRecordConvert.INSTANCE.toVo((SampleReturnRecordDO)this.sampleReturnRecordRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(SampleReturnRecordPayload payload) {
        SampleReturnRecordDO entity = this.sampleReturnRecordRepo.findById(payload.getId()).orElseGet(SampleReturnRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.sampleReturnRecordDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.sampleReturnRecordRepo.findById(id);
                if (!optional.isEmpty()) {
                    SampleReturnRecordDO entity = (SampleReturnRecordDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.sampleReturnRecordRepo.save(entity);
                }
            });
        }
    }

    public List<SampleReturnRecordVO> queryListBySampleId(Long sampleId) {
        List<SampleReturnRecordVO> sampleReturnRecordVOS = this.sampleReturnRecordDAO.queryListBySampleId(sampleId);
        Set<Long> sampleDetailsIds = sampleReturnRecordVOS.stream().map(SampleReturnRecordVO::getSampleDetailsId).collect(Collectors.toSet());
        Map<Long, Integer> returnedTotalMap = this.sampleReturnRecordDAO.getReturnedTotal(sampleDetailsIds);
        sampleReturnRecordVOS.forEach(sampleReturnRecordVO -> {
            String returnProgress = sampleReturnRecordVO.getReturnedNumSum() + sampleReturnRecordVO.getReturnNumber() + "/" + returnedTotalMap.get(sampleReturnRecordVO.getSampleDetailsId());
            sampleReturnRecordVO.setReturnProgress(returnProgress);
        });
        return sampleReturnRecordVOS;
    }

    public SampleReturnRecordServiceImpl(SampleReturnRecordRepo sampleReturnRecordRepo, SampleReturnRecordDAO sampleReturnRecordDAO, PrdFsmFileRefService prdFsmFileRefService) {
        this.sampleReturnRecordRepo = sampleReturnRecordRepo;
        this.sampleReturnRecordDAO = sampleReturnRecordDAO;
        this.prdFsmFileRefService = prdFsmFileRefService;
    }
}

