/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sample.service;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5crm.api.sample.payload.SampleDetailsPayload;
import com.elitesland.tw.tw5crm.api.sample.payload.SamplePayload;
import com.elitesland.tw.tw5crm.api.sample.query.SampleQuery;
import com.elitesland.tw.tw5crm.api.sample.service.SampleDetailsService;
import com.elitesland.tw.tw5crm.api.sample.service.SampleReturnRecordService;
import com.elitesland.tw.tw5crm.api.sample.service.SampleService;
import com.elitesland.tw.tw5crm.api.sample.vo.SampleDetailsVO;
import com.elitesland.tw.tw5crm.api.sample.vo.SampleReturnProVO;
import com.elitesland.tw.tw5crm.api.sample.vo.SampleVO;
import com.elitesland.tw.tw5crm.server.common.constants.SampleEnum;
import com.elitesland.tw.tw5crm.server.sample.convert.SampleConvert;
import com.elitesland.tw.tw5crm.server.sample.convert.SampleDetailsConvert;
import com.elitesland.tw.tw5crm.server.sample.dao.SampleDAO;
import com.elitesland.tw.tw5crm.server.sample.entity.SampleDO;
import com.elitesland.tw.tw5crm.server.sample.entity.SampleDetailsDO;
import com.elitesland.tw.tw5crm.server.sample.repo.SampleDetailsRepo;
import com.elitesland.tw.tw5crm.server.sample.repo.SampleRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SampleServiceImpl
extends BaseServiceImpl
implements SampleService {
    private static final Logger log = LoggerFactory.getLogger(SampleServiceImpl.class);
    private final SampleRepo sampleRepo;
    private final SampleDAO sampleDAO;
    private final SampleDetailsService sampleDetailsService;
    private final SampleDetailsRepo sampleDetailsRepo;
    private final SampleReturnRecordService sampleReturnService;
    @Value(value="${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final WorkflowService workflowService;

    public PagingVO<SampleVO> queryPaging(SampleQuery query) {
        PagingVO<SampleVO> sampleVOPagingVO = this.sampleDAO.queryPaging(query);
        List records = sampleVOPagingVO.getRecords();
        if (records != null && !records.isEmpty()) {
            List<Long> sampleIds = records.stream().map(BaseViewModel::getId).toList();
            List sampleDetailsVOS = this.sampleDetailsService.queryListBySampleIds(sampleIds);
            records.forEach(record -> {
                List<SampleDetailsVO> sampleDetailsVOSBySampleId = sampleDetailsVOS.stream().filter(sampleDetailsVO -> Objects.equals(sampleDetailsVO.getSampleId(), record.getId())).toList();
                Integer total = 0;
                Integer returnTotal = 0;
                BigDecimal amount = BigDecimal.ZERO;
                for (SampleDetailsVO sampleDetailsVO2 : sampleDetailsVOSBySampleId) {
                    total = total + sampleDetailsVO2.getNumber();
                    if (SampleEnum.NEED.getCode().equals(sampleDetailsVO2.getReturnDemand())) {
                        returnTotal = returnTotal + sampleDetailsVO2.getNumber();
                    }
                    BigDecimal standardPrice = sampleDetailsVO2.getStandardPrice();
                    BigDecimal number = BigDecimal.valueOf(sampleDetailsVO2.getNumber().intValue());
                    amount = amount.add(standardPrice.multiply(number));
                }
                record.setTotal(total);
                record.setReturnTotal(returnTotal);
                record.setAmount(amount);
                record.setSampleDetailsVOS(sampleDetailsVOSBySampleId);
            });
        }
        return sampleVOPagingVO.setRecords(records);
    }

    public List<SampleVO> queryListDynamic(SampleQuery query) {
        return this.sampleDAO.queryListDynamic(query);
    }

    public SampleVO queryByKey(Long key) {
        SampleVO sampleVO = this.sampleDAO.queryByKey(key);
        List sampleDetailsVOS = this.sampleDetailsService.queryListBySampleId(key);
        sampleVO.setSampleDetailsVOS(sampleDetailsVOS);
        WorkflowResult workflowResult = this.workflowService.currentTaskInfo(sampleVO.getProcInstId());
        if (workflowResult.isSuccess()) {
            TaskInfo taskInfo = (TaskInfo)workflowResult.getData();
            sampleVO.setTaskInfo(taskInfo);
        }
        return sampleVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public SampleVO insertOrUpdate(SamplePayload payload) {
        List sampleDetailsPayloads = payload.getSampleDetailsPayloads();
        if (sampleDetailsPayloads == null || sampleDetailsPayloads.isEmpty()) {
            throw TwException.error((String)"", (String)"\u6837\u54c1\u4fe1\u606f\u81f3\u5c11\u6dfb\u52a0\u4e00\u884c\u6570\u636e!");
        }
        if (payload.getId() == null) {
            payload.setSampleCode(this.generateSeqNum("CRM_SAMPLE", new String[0]));
            payload.setSampleStatus(SampleEnum.CREATE.getCode());
            payload.setReturnStatus(SampleEnum.NO_RETURN.getCode());
            SampleDO save = (SampleDO)this.sampleRepo.save(SampleConvert.INSTANCE.toDo(payload));
            payload.setId(save.getId());
            HashSet productSkuIds = new HashSet(sampleDetailsPayloads.size());
            ArrayList sampleDetailsDOS = new ArrayList(sampleDetailsPayloads.size());
            sampleDetailsPayloads.forEach(sampleDetailsPayload -> {
                if (productSkuIds.contains(sampleDetailsPayload.getProductSkuId())) {
                    throw TwException.error((String)"", (String)"\u8bf7\u52ff\u91cd\u590d\u9009\u62e9\u6837\u54c1\uff01");
                }
                productSkuIds.add(sampleDetailsPayload.getProductSkuId());
                sampleDetailsPayload.setSampleId(save.getId());
                SampleDetailsDO sampleDetailsDO = SampleDetailsConvert.INSTANCE.toDo((SampleDetailsPayload)sampleDetailsPayload);
                sampleDetailsDOS.add(sampleDetailsDO);
            });
            this.sampleDetailsRepo.saveAll(sampleDetailsDOS);
        } else {
            if (!SampleEnum.CREATE.getCode().equals(payload.getSampleStatus())) {
                throw TwException.error((String)"", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u4e0b\u7684\u6837\u54c1\u7533\u8bf7\u624d\u80fd\u591f\u4fee\u6539\uff01");
            }
            SampleDO entity = this.sampleRepo.findById(payload.getId()).orElseGet(SampleDO::new);
            Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
            List<SampleDetailsDO> oldSampleDetailsDOS = this.sampleDetailsRepo.findBySampleIdAndDeleteFlag(payload.getId(), 0);
            List<SampleDetailsDO> newSampleDetailsDOS = SampleDetailsConvert.INSTANCE.toDos(sampleDetailsPayloads);
            HashSet productSkuIds = new HashSet(newSampleDetailsDOS.size());
            newSampleDetailsDOS.forEach(newSampleDetailsDO -> {
                if (productSkuIds.contains(newSampleDetailsDO.getProductSkuId())) {
                    throw TwException.error((String)"", (String)"\u8bf7\u52ff\u91cd\u590d\u9009\u62e9\u6837\u54c1\uff01");
                }
                productSkuIds.add(newSampleDetailsDO.getProductSkuId());
                newSampleDetailsDO.setSampleId(payload.getId());
            });
            this.sampleDetailsRepo.saveAll(newSampleDetailsDOS);
            List newDetailsIds = newSampleDetailsDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
            if (oldSampleDetailsDOS != null && !oldSampleDetailsDOS.isEmpty()) {
                List oldDetailsIds = oldSampleDetailsDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
                oldDetailsIds.removeAll(newDetailsIds);
                this.sampleDetailsService.deleteSoft(oldDetailsIds);
            }
        }
        this.sampleDAO.updateByKeyDynamic(payload);
        return this.sampleDAO.queryByKey(payload.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public SampleVO update(SamplePayload payload) {
        SampleDO entity = this.sampleRepo.findById(payload.getId()).orElseGet(SampleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SampleDO entityDo = SampleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SampleConvert.INSTANCE.toVo((SampleDO)this.sampleRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(SamplePayload payload) {
        SampleDO entity = this.sampleRepo.findById(payload.getId()).orElseGet(SampleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.sampleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.sampleRepo.findById(id);
                if (!optional.isEmpty()) {
                    SampleDO entity = (SampleDO)optional.get();
                    entity.setDeleteFlag(1);
                    if (!SampleEnum.CREATE.getCode().equals(entity.getSampleStatus())) {
                        throw TwException.error((String)"", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u6837\u54c1\u7533\u8bf7\u624d\u80fd\u591f\u5220\u9664!");
                    }
                    this.sampleRepo.save(entity);
                }
            });
        }
    }

    public PagingVO<SampleVO> returnPaging(SampleQuery query) {
        PagingVO<SampleVO> sampleVOPagingVO = this.sampleDAO.queryReturnPaging(query);
        List records = sampleVOPagingVO.getRecords();
        if (records != null && !records.isEmpty()) {
            List<Long> sampleIds = records.stream().map(BaseViewModel::getId).toList();
            List sampleDetailsVOS = this.sampleDetailsService.queryListBySampleIds(sampleIds);
            Map<Long, Integer> returnedTotalMap = this.sampleDAO.getReturnedTotal(sampleIds);
            records.forEach(record -> {
                Integer returnTotal = sampleDetailsVOS.stream().filter(sampleDetailsVO -> Objects.equals(sampleDetailsVO.getSampleId(), record.getId())).filter(sampleDetailsVO -> SampleEnum.NEED.getCode().equals(sampleDetailsVO.getReturnDemand())).mapToInt(SampleDetailsVO::getNumber).sum();
                record.setReturnTotal(returnTotal);
                Integer returnedTotal = returnedTotalMap.get(record.getId()) == null ? 0 : (Integer)returnedTotalMap.get(record.getId());
                record.setReturnedTotal(returnedTotal);
            });
        }
        return sampleVOPagingVO.setRecords(records);
    }

    public List<SampleReturnProVO> queryReturnProListBySampleId(Long sampleId) {
        return this.sampleDAO.queryReturnProListBySampleId(sampleId);
    }

    public SampleVO queryReturnByKey(Long key) {
        SampleVO sampleVO = this.sampleDAO.queryByKey(key);
        List sampleReturnRecordVOS = this.sampleReturnService.queryListBySampleId(key);
        sampleVO.setSampleReturnRecordVOS(sampleReturnRecordVOS);
        return sampleVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateReturnStatus(SamplePayload payload) {
        this.sampleDAO.updateReturnStatus(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void submit(SamplePayload payload) {
        if (payload.getSampleStatus() != null && !SampleEnum.CREATE.getCode().equals(payload.getSampleStatus())) {
            throw TwException.error((String)"", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u624d\u80fd\u591f\u63d0\u4ea4\uff01");
        }
        SampleVO sampleVO = this.insertOrUpdate(payload);
        payload.setId(sampleVO.getId());
        payload.setSampleCode(sampleVO.getSampleCode());
        this.submitProc(payload);
    }

    void submitProc(SamplePayload payload) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap batchMap = new HashMap();
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.SAMPLE.name(), (String)("\u6837\u54c1\u7ba1\u7406-" + payload.getSampleCode() + "-\u5ba1\u6279\u6d41\u7a0b"), (String)("" + payload.getId()), batchMap));
        }
        if (Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        }
        SamplePayload payload0 = new SamplePayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus());
        payload0.setSubmitTime(LocalDateTime.now());
        payload0.setSampleStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.sampleDAO.updateWorkFlow(payload0));
    }

    public SampleServiceImpl(SampleRepo sampleRepo, SampleDAO sampleDAO, SampleDetailsService sampleDetailsService, SampleDetailsRepo sampleDetailsRepo, SampleReturnRecordService sampleReturnService, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, WorkflowService workflowService) {
        this.sampleRepo = sampleRepo;
        this.sampleDAO = sampleDAO;
        this.sampleDetailsService = sampleDetailsService;
        this.sampleDetailsRepo = sampleDetailsRepo;
        this.sampleReturnService = sampleReturnService;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.workflowService = workflowService;
    }
}

