/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.visit.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.visit.payload.VisitTaskPayload;
import com.elitesland.tw.tw5crm.api.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5crm.api.visit.vo.VisitTaskVO;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskStatusEnum;
import com.elitesland.tw.tw5crm.server.visit.entity.QVisitPlanDO;
import com.elitesland.tw.tw5crm.server.visit.entity.QVisitTaskDO;
import com.elitesland.tw.tw5crm.server.visit.entity.VisitTaskDO;
import com.elitesland.tw.tw5crm.server.visit.repo.VisitTaskRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Repository
public class VisitTaskDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final VisitTaskRepo repo;
    private final QVisitTaskDO qdo = QVisitTaskDO.visitTaskDO;
    private final QVisitPlanDO qVisitPlanDO = QVisitPlanDO.visitPlanDO;

    private JPAQuery<VisitTaskVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(VisitTaskVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createUserId, this.qdo.creator, this.qdo.modifyTime, this.qdo.planId, this.qdo.taskName, this.qdo.taskNo, this.qdo.planName, this.qdo.planType, this.qdo.customerId, this.qdo.partnerId, this.qdo.customerName, this.qdo.status, this.qdo.visitMemberId, this.qdo.visitMemberName, this.qdo.teamMemberIds, this.qdo.startTime, this.qdo.endTime, this.qdo.submitTime, this.qdo.objType, this.qdo.objId, this.qdo.objName, this.qdo.planCreateUserId, this.qdo.evalStatus, this.qdo.leaderGradle, this.qdo.nextPlan, this.qdo.customerGradle, this.qdo.customerAdvise, this.qdo.customerDesc, this.qdo.result, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5, this.qdo.sortNo, this.qdo.taskType, this.qdo.pageId})).from((EntityPath)this.qdo);
    }

    private JPAQuery<VisitTaskVO> getJpaQueryWhere(VisitTaskQuery query) {
        JPAQuery<VisitTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(VisitTaskQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    public long countByPlanId(Long planId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();
        taskQuery.setPlanId(planId);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(VisitTaskStatusEnum.OK.getCode());
        statusList.add(VisitTaskStatusEnum.READY.getCode());
        taskQuery.setStatusList(statusList);
        return this.count(taskQuery);
    }

    public long done(VisitTaskQuery query) {
        Long count = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0).and((Predicate)this.qdo.visitMemberId.eq((Object)query.getVisitMemberId())).and((Predicate)this.qdo.status.in(query.getStatusList())))).fetchOne();
        return count;
    }

    public long updateSendFlag(Long id) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo);
        update.set(this.qdo.sendFlag, (Object)1);
        update.where(new Predicate[]{this.qdo.id.eq((Object)id)});
        return update.execute();
    }

    private Predicate where(VisitTaskQuery query) {
        BooleanExpression jpaQueryOr;
        ArrayList<Object> list = new ArrayList<Object>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanId())) {
            list.add(this.qdo.planId.eq((Object)query.getPlanId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskName())) {
            list.add(this.qdo.taskName.like(SqlUtil.toSqlLikeString((String)query.getTaskName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskNo())) {
            list.add(this.qdo.taskNo.like(SqlUtil.toSqlLikeString((String)query.getTaskNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanName())) {
            list.add(this.qdo.planName.like(SqlUtil.toSqlLikeString((String)query.getPlanName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanType())) {
            list.add(this.qdo.planType.eq((Object)query.getPlanType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerId())) {
            list.add(this.qdo.customerId.eq((Object)query.getCustomerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerId())) {
            list.add(this.qdo.partnerId.eq((Object)query.getPartnerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerName())) {
            list.add(this.qdo.customerName.like(SqlUtil.toSqlLikeString((String)query.getCustomerName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStatus())) {
            list.add(this.qdo.status.eq((Object)query.getStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStatusList())) {
            list.add(this.qdo.status.in(query.getStatusList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVisitMemberId())) {
            list.add(this.qdo.visitMemberId.eq((Object)query.getVisitMemberId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVisitMemberIds())) {
            list.add(this.qdo.visitMemberId.in((Collection)query.getVisitMemberIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVisitMemberParentId())) {
            list.add(this.qdo.visitMemberParentId.eq((Object)query.getVisitMemberParentId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVisitMemberName())) {
            list.add(this.qdo.visitMemberName.like(SqlUtil.toSqlLikeString((String)query.getVisitMemberName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTeamMemberIds())) {
            list.add(this.qdo.teamMemberIds.like(SqlUtil.toSqlLikeString((String)query.getTeamMemberIds())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObjType())) {
            list.add(this.qdo.objType.eq((Object)query.getObjType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObjId())) {
            list.add(this.qdo.objId.eq((Object)query.getObjId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObjName())) {
            list.add(this.qdo.objName.like(SqlUtil.toSqlLikeString((String)query.getObjName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanCreateUserId())) {
            list.add(this.qdo.planCreateUserId.eq((Object)query.getPlanCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEvalStatus())) {
            list.add(this.qdo.evalStatus.eq((Object)query.getEvalStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEvalStatusPro())) {
            BooleanExpression eq = this.qdo.evalStatus.eq((Object)query.getEvalStatusPro()).or((Predicate)this.qdo.evalStatus.isNull());
            list.add(eq);
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeaderGradle())) {
            list.add(this.qdo.leaderGradle.eq((Object)query.getLeaderGradle()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNextPlan())) {
            list.add(this.qdo.nextPlan.like(SqlUtil.toSqlLikeString((String)query.getNextPlan())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerGradle())) {
            list.add(this.qdo.customerGradle.eq((Object)query.getCustomerGradle()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerAdvise())) {
            list.add(this.qdo.customerAdvise.like(SqlUtil.toSqlLikeString((String)query.getCustomerAdvise())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qdo.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt2())) {
            list.add(this.qdo.ext2.eq((Object)query.getExt2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt3())) {
            list.add(this.qdo.ext3.eq((Object)query.getExt3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt4())) {
            list.add(this.qdo.ext4.eq((Object)query.getExt4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt5())) {
            list.add(this.qdo.ext5.eq((Object)query.getExt5()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortNo())) {
            list.add(this.qdo.sortNo.eq((Object)query.getSortNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskType())) {
            list.add(this.qdo.taskType.eq((Object)query.getTaskType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartTime())) {
            list.add(this.qdo.startTime.goe((Comparable)query.getStartTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndTime())) {
            list.add(this.qdo.endTime.loe((Comparable)query.getEndTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVisitTime())) {
            BooleanExpression right = this.qdo.startTime.loe((Comparable)query.getVisitTime()).and((Predicate)this.qdo.endTime.goe((Comparable)query.getVisitTime()).and((Predicate)this.qdo.status.in((Object[])new String[]{VisitTaskStatusEnum.NEW.getCode(), VisitTaskStatusEnum.READY.getCode()})));
            BooleanExpression left = this.qdo.status.eq((Object)VisitTaskStatusEnum.OK.getCode()).and((Predicate)this.qdo.submitTime.goe((Comparable)query.getVisitTime().atStartOfDay()).and((Predicate)this.qdo.submitTime.lt((Comparable)query.getVisitTime().plusDays(1L).atStartOfDay())));
            Predicate or = ExpressionUtils.or((Predicate)right, (Predicate)left);
            list.add(or);
        }
        if (query.getPermissionFlag().booleanValue()) {
            if (null == query.getCreateUserIdPro()) {
                throw TwException.error((String)"", (String)"createUserIdPro\u53c2\u6570\u7f3a\u5931");
            }
            jpaQueryOr = this.qdo.createUserId.eq((Object)query.getCreateUserIdPro()).or((Predicate)this.qdo.planCreateUserId.eq((Object)query.getCreateUserIdPro())).or((Predicate)this.qdo.visitMemberId.eq((Object)query.getCreateUserIdPro()));
            if (!CollectionUtils.isEmpty((Collection)query.getSubordinatesIds())) {
                jpaQueryOr = jpaQueryOr.or((Predicate)this.qdo.createUserId.in((Collection)query.getSubordinatesIds())).or((Predicate)this.qdo.visitMemberId.in((Collection)query.getSubordinatesIds()));
            }
            list.add(jpaQueryOr);
        }
        if (!CollectionUtils.isEmpty((Collection)query.getEvalSubordinatesIds())) {
            jpaQueryOr = this.qdo.visitMemberId.in((Collection)query.getEvalSubordinatesIds());
            list.add(jpaQueryOr);
        }
        return ExpressionUtils.allOf(list);
    }

    public VisitTaskVO queryByKey(Long id) {
        JPAQuery<VisitTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (VisitTaskVO)jpaQuery.fetchFirst();
    }

    public List<VisitTaskVO> queryListDynamic(VisitTaskQuery query) {
        JPAQuery<VisitTaskVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<VisitTaskVO> queryPaging(VisitTaskQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<VisitTaskVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public VisitTaskDO save(VisitTaskDO ado) {
        return (VisitTaskDO)this.repo.save(ado);
    }

    public List<VisitTaskDO> saveAll(List<VisitTaskDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(VisitTaskPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getPlanId() != null) {
            update.set(this.qdo.planId, (Object)payload.getPlanId());
        }
        if (payload.getTaskName() != null) {
            update.set((Path)this.qdo.taskName, (Object)payload.getTaskName());
        }
        if (payload.getTaskNo() != null) {
            update.set((Path)this.qdo.taskNo, (Object)payload.getTaskNo());
        }
        if (payload.getPlanName() != null) {
            update.set((Path)this.qdo.planName, (Object)payload.getPlanName());
        }
        if (payload.getPlanType() != null) {
            update.set((Path)this.qdo.planType, (Object)payload.getPlanType());
        }
        if (payload.getCustomerId() != null) {
            update.set(this.qdo.customerId, (Object)payload.getCustomerId());
        }
        if (payload.getPartnerId() != null) {
            update.set(this.qdo.partnerId, (Object)payload.getPartnerId());
        }
        if (payload.getCustomerName() != null) {
            update.set((Path)this.qdo.customerName, (Object)payload.getCustomerName());
        }
        if (payload.getStatus() != null) {
            update.set((Path)this.qdo.status, (Object)payload.getStatus());
        }
        if (payload.getVisitMemberId() != null) {
            update.set(this.qdo.visitMemberId, (Object)payload.getVisitMemberId());
        }
        if (payload.getVisitMemberParentId() != null) {
            update.set(this.qdo.visitMemberParentId, (Object)payload.getVisitMemberParentId());
        }
        if (payload.getVisitMemberName() != null) {
            update.set((Path)this.qdo.visitMemberName, (Object)payload.getVisitMemberName());
        }
        if (payload.getTeamMemberIds() != null) {
            update.set((Path)this.qdo.teamMemberIds, (Object)payload.getTeamMemberIds());
        }
        if (payload.getObjType() != null) {
            update.set((Path)this.qdo.objType, (Object)payload.getObjType());
        }
        if (payload.getObjId() != null) {
            update.set(this.qdo.objId, (Object)payload.getObjId());
        }
        if (payload.getObjName() != null) {
            update.set((Path)this.qdo.objName, (Object)payload.getObjName());
        }
        if (payload.getPlanCreateUserId() != null) {
            update.set(this.qdo.planCreateUserId, (Object)payload.getPlanCreateUserId());
        }
        if (payload.getEvalStatus() != null) {
            update.set((Path)this.qdo.evalStatus, (Object)payload.getEvalStatus());
        }
        if (payload.getLeaderGradle() != null) {
            update.set(this.qdo.leaderGradle, (Object)payload.getLeaderGradle());
        }
        if (payload.getNextPlan() != null) {
            update.set((Path)this.qdo.nextPlan, (Object)payload.getNextPlan());
        }
        if (payload.getCustomerGradle() != null) {
            update.set(this.qdo.customerGradle, (Object)payload.getCustomerGradle());
        }
        if (payload.getCustomerAdvise() != null) {
            update.set((Path)this.qdo.customerAdvise, (Object)payload.getCustomerAdvise());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        if (payload.getTaskType() != null) {
            update.set((Path)this.qdo.taskType, (Object)payload.getTaskType());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("planId")) {
                update.setNull(this.qdo.planId);
            }
            if (nullFields.contains("taskName")) {
                update.setNull((Path)this.qdo.taskName);
            }
            if (nullFields.contains("taskNo")) {
                update.setNull((Path)this.qdo.taskNo);
            }
            if (nullFields.contains("planName")) {
                update.setNull((Path)this.qdo.planName);
            }
            if (nullFields.contains("planType")) {
                update.setNull((Path)this.qdo.planType);
            }
            if (nullFields.contains("customerId")) {
                update.setNull(this.qdo.customerId);
            }
            if (nullFields.contains("partnerId")) {
                update.setNull(this.qdo.partnerId);
            }
            if (nullFields.contains("customerName")) {
                update.setNull((Path)this.qdo.customerName);
            }
            if (nullFields.contains("status")) {
                update.setNull((Path)this.qdo.status);
            }
            if (nullFields.contains("visitMemberId")) {
                update.setNull(this.qdo.visitMemberId);
            }
            if (nullFields.contains("visitMemberName")) {
                update.setNull((Path)this.qdo.visitMemberName);
            }
            if (nullFields.contains("teamMemberIds")) {
                update.setNull((Path)this.qdo.teamMemberIds);
            }
            if (nullFields.contains("objType")) {
                update.setNull((Path)this.qdo.objType);
            }
            if (nullFields.contains("objId")) {
                update.setNull(this.qdo.objId);
            }
            if (nullFields.contains("objName")) {
                update.setNull((Path)this.qdo.objName);
            }
            if (nullFields.contains("planCreateUserId")) {
                update.setNull(this.qdo.planCreateUserId);
            }
            if (nullFields.contains("evalStatus")) {
                update.setNull((Path)this.qdo.evalStatus);
            }
            if (nullFields.contains("leaderGradle")) {
                update.setNull(this.qdo.leaderGradle);
            }
            if (nullFields.contains("nextPlan")) {
                update.setNull((Path)this.qdo.nextPlan);
            }
            if (nullFields.contains("customerGradle")) {
                update.setNull(this.qdo.customerGradle);
            }
            if (nullFields.contains("customerAdvise")) {
                update.setNull((Path)this.qdo.customerAdvise);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
            if (nullFields.contains("sortNo")) {
                update.setNull(this.qdo.sortNo);
            }
            if (nullFields.contains("taskType")) {
                update.setNull((Path)this.qdo.taskType);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByPlanId(Long planId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.planId.eq((Object)planId)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public VisitTaskDAO(JPAQueryFactory jpaQueryFactory, VisitTaskRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

