/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.my.service;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5pms.api.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5pms.api.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5pms.api.my.query.TimesheetQuery;
import com.elitesland.tw.tw5pms.api.my.service.TimesheetService;
import com.elitesland.tw.tw5pms.api.my.vo.TimesheetVO;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskPackageService;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskService;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskPackageVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskVO;
import com.elitesland.tw.tw5pms.server.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5pms.server.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5pms.server.my.dao.TimesheetDAO;
import com.elitesland.tw.tw5pms.server.my.entity.QTimesheetDO;
import com.elitesland.tw.tw5pms.server.my.entity.TimesheetDO;
import com.elitesland.tw.tw5pms.server.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5pms.server.my.repo.TimesheetRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TimesheetServiceImpl
implements TimesheetService {
    private static final Logger log = LoggerFactory.getLogger(TimesheetServiceImpl.class);
    private final TimesheetRepo timesheetRepo;
    private final TimesheetDAO timesheetDao;
    private final CacheUtil cacheUtil;
    private final PmsTaskService taskService;
    private final PmsTaskPackageService taskPackageService;
    private final PmsProjectService projectService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdUserService userService;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;

    public PagingVO<TimesheetVO> paging(TimesheetQuery query) {
        this.getPermissionParams(query);
        return this.timesheetDao.queryPaging(query);
    }

    private void getPermissionParams(TimesheetQuery query) {
        if (query.getIsPermission().booleanValue()) {
            boolean isAdmin;
            Long loginUserId = GlobalUtil.getLoginUserId();
            boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
            if (!isSystemAdmin && !(isAdmin = "admin_pms".equals(GlobalUtil.getLoginGeneralUser().getUsername()))) {
                HashSet<Long> queryUserIds = new HashSet<Long>();
                queryUserIds.add(loginUserId);
                List userIdsByPlatRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
                List organizationDOList = this.prdOrgOrganizationDAO.queryByManagerId(loginUserId);
                Set orgIdList = null;
                if (!CollectionUtils.isEmpty((Collection)organizationDOList)) {
                    orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toSet());
                }
                List empRef = this.userService.queryLowListByKey(null);
                Set empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty((Collection)userIdsByPlatRole) || !userIdsByPlatRole.contains(loginUserId)) {
                    if (orgIdList != null && !orgIdList.isEmpty()) {
                        List prdOrgEmployeeRefVOS = this.prdOrgOrganizationDAO.queryEmployeeList(orgIdList);
                        Set collect = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toSet());
                        queryUserIds.addAll(collect);
                    }
                    if (empRefUserIdList != null && !empRefUserIdList.isEmpty()) {
                        queryUserIds.addAll(empRefUserIdList);
                    }
                }
                query.setTsUserIdList(queryUserIds);
            }
        }
    }

    public PagingVO pagingGroup(TimesheetQuery query) {
        query.setOrders(null);
        Page<Object[]> page = this.timesheetRepo.pagingGroup(query.getCreateUserId(), query.getApprUserId(), query.getTsStatus(), query.getTsUserBuId(), (Pageable)query.getPageRequest());
        List content = page.getContent();
        List<TimesheetVO> all = this.getAll(content);
        this.setTheoryGetEqva(all);
        return PagingVO.builder().records(all).total(page.getTotalElements()).build();
    }

    public void setTheoryGetEqva(List<TimesheetVO> list) {
        if (list != null && list.size() > 0) {
            List taskIds = list.stream().map(TimesheetVO::getTaskId).collect(Collectors.toList());
            List tasks = this.taskService.queryListByIds(taskIds);
            Map<Long, BigDecimal> workHourMap = tasks.stream().collect(Collectors.toMap(BaseViewModel::getId, PmsTaskVO::getEqvaRatio));
            for (TimesheetVO timeView : list) {
                String[] groupIdsArr = timeView.getGroupIds().split(",");
                BigDecimal bd = new BigDecimal("0");
                for (int i = 0; i < groupIdsArr.length; ++i) {
                    TimesheetVO data = this.queryByKey(Long.valueOf(groupIdsArr[i]));
                    if (data.getTaskId() == null || data.getTaskId() <= 0L || !workHourMap.containsKey(data.getTaskId())) continue;
                    bd = bd.add(data.getWorkHour().divide(new BigDecimal("8"), 1, RoundingMode.UP).multiply(workHourMap.get(data.getTaskId())));
                }
                timeView.setTheoryGetEqva(bd);
            }
        }
    }

    public List<TimesheetVO> getAll(List<Object[]> objects) {
        ArrayList<TimesheetVO> list = new ArrayList<TimesheetVO>();
        for (Object[] obj : objects) {
            TimesheetVO timesheetVO = new TimesheetVO();
            timesheetVO.setGroupIds(String.valueOf(obj[0]));
            timesheetVO.setWorkHour(BigDecimal.valueOf(Double.parseDouble(String.valueOf(obj[1]))));
            timesheetVO.setProjId(obj[2] != null ? Long.valueOf(String.valueOf(obj[2])) : null);
            timesheetVO.setProjNo(String.valueOf(obj[3]));
            timesheetVO.setProjName(String.valueOf(obj[4]));
            timesheetVO.setTsStatus(String.valueOf(obj[5]));
            timesheetVO.setApprUserId(obj[6] != null ? Long.valueOf(String.valueOf(obj[6])) : null);
            timesheetVO.setWeekStartDate(obj[7] != null ? LocalDate.parse(String.valueOf(obj[7])) : null);
            timesheetVO.setTaskId(obj[8] != null ? Long.valueOf(String.valueOf(obj[8])) : null);
            timesheetVO.setTaskNo(String.valueOf(obj[9]));
            timesheetVO.setTaskName(String.valueOf(obj[10]));
            timesheetVO.setTsUserId(obj[11] != null ? Long.valueOf(String.valueOf(obj[11])) : null);
            timesheetVO.setTsUserBuId(obj[12] != null ? Long.valueOf(String.valueOf(obj[12])) : null);
            timesheetVO.setTsUserBuName(this.cacheUtil.getOrgName(timesheetVO.getTsUserBuId()));
            timesheetVO.setTsUserIdName(this.cacheUtil.getUserName(timesheetVO.getTsUserId()));
            list.add(timesheetVO);
        }
        return list;
    }

    public List<TimesheetVO> listGroup(TimesheetQuery query) {
        QTimesheetDO qTimesheetDO = QTimesheetDO.timesheetDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qTimesheetDO).from((EntityPath)qTimesheetDO)).where((Predicate)qTimesheetDO.deleteFlag.eq((Object)0));
        if (null != query.getCreateUserId()) {
            jpaQuery.where((Predicate)qTimesheetDO.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (null != query.getApprUserId()) {
            jpaQuery.where((Predicate)qTimesheetDO.apprUserId.eq((Object)query.getApprUserId()));
        }
        if (StringUtils.hasText((String)query.getTsStatus())) {
            jpaQuery.where((Predicate)qTimesheetDO.tsStatus.eq((Object)query.getTsStatus()));
        }
        QueryResults queryResults = ((JPAQuery)((JPAQuery)jpaQuery.groupBy(new Expression[]{qTimesheetDO.projId, qTimesheetDO.yearWeek, qTimesheetDO.createUserId})).orderBy(new OrderSpecifier[]{qTimesheetDO.yearWeek.desc(), qTimesheetDO.createUserId.desc()})).fetchResults();
        List timesheetVOList = TimesheetConvert.INSTANCE.toVoList(queryResults.getResults());
        return timesheetVOList;
    }

    public List<TimesheetVO> queryList(TimesheetQuery query) {
        return this.timesheetDao.queryList(query);
    }

    public Map<LocalDate, String> getTimesheetOverview(TimesheetQuery query) {
        HashMap<LocalDate, String> result = new HashMap<LocalDate, String>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (loginUserId == null) {
            throw TwException.error((String)"", (String)"\u7528\u6237\u67e5\u8be2\u5931\u8d25\uff01");
        }
        query.setCreateUserId(loginUserId);
        List<TimesheetVO> timesheetVOS = this.queryList(query);
        Map<LocalDate, List<TimesheetVO>> groupTimesheetMap = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getWorkDate));
        List workDate = query.getWorkDate();
        LocalDate startDate = (LocalDate)workDate.get(0);
        LocalDate endDate = (LocalDate)workDate.get(1);
        LocalDate localDate = startDate;
        while (localDate.isBefore(endDate.plusDays(1L))) {
            List<TimesheetVO> timesheetVOS1 = groupTimesheetMap.get(localDate);
            if (timesheetVOS1 == null || timesheetVOS1.isEmpty()) {
                result.put(localDate, "");
            } else {
                String status = "";
                int rejectedNum = 0;
                int createNum = 0;
                int approvingNum = 0;
                int approvedNum = 0;
                int settledNum = 0;
                for (TimesheetVO timesheetVO : timesheetVOS1) {
                    String tsStatus = timesheetVO.getTsStatus();
                    switch (TimesheetStatus.valueOf(tsStatus)) {
                        case CREATE: {
                            ++createNum;
                            break;
                        }
                        case REJECTED: {
                            ++rejectedNum;
                            break;
                        }
                        case APPROVING: {
                            ++approvingNum;
                            break;
                        }
                        case APPROVED: {
                            ++approvedNum;
                            break;
                        }
                        case SETTLED: {
                            ++settledNum;
                        }
                    }
                }
                if (rejectedNum > 0) {
                    status = TimesheetStatus.REJECTED.getCode();
                } else if (createNum > 0) {
                    status = TimesheetStatus.CREATE.getCode();
                } else if (approvingNum > 0) {
                    status = TimesheetStatus.APPROVING.getCode();
                } else if (approvedNum > 0) {
                    status = TimesheetStatus.APPROVED.getCode();
                } else if (settledNum > 0) {
                    status = TimesheetStatus.SETTLED.getCode();
                }
                result.put(localDate, status);
            }
            localDate = localDate.plusDays(1L);
        }
        return result;
    }

    public long count(TimesheetQuery query) {
        return this.timesheetRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder));
    }

    public TimesheetVO queryByKey(Long key) {
        TimesheetDO entity = this.timesheetRepo.findById(key).orElseGet(TimesheetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
        TimesheetVO vo = TimesheetConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetVO insert(TimesheetPayload payload) {
        this.check(payload);
        this.initData(payload);
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        this.biweeklyReadFlagRepo.updateReadFlag(payload.getTsUserId(), 0);
        return TimesheetConvert.INSTANCE.toVo((TimesheetDO)((Object)this.timesheetRepo.save((Object)entityDo)));
    }

    private void check(TimesheetPayload payload) {
        if (payload.isSubmitted()) {
            if (payload.getId() != null && payload.getId() > 0L) {
                TimesheetVO timesheetVO = this.queryByKey(payload.getId());
                if (!TimesheetStatus.CREATE.getCode().equals(timesheetVO.getTsStatus()) && !TimesheetStatus.REJECTED.getCode().equals(timesheetVO.getTsStatus())) {
                    throw TwException.error((String)"", (String)"\u53ea\u80fd\u63d0\u4ea4\u65b0\u5efa\u6216\u5df2\u9000\u56de\u7684\u5355\u636e");
                }
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
            if (null == payload.getProjId()) {
                throw TwException.error((String)"", (String)"\u8bf7\u9009\u62e9\u9879\u76ee");
            }
            if (null == payload.getWorkDate()) {
                throw TwException.error((String)"", (String)"\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5\u671f");
            }
            if (!StringUtils.hasText((String)payload.getWorkDesc())) {
                throw TwException.error((String)"", (String)"\u8bf7\u8f93\u5165\u5de5\u4f5c\u65e5\u5fd7");
            }
            if (null == payload.getWorkHour()) {
                throw TwException.error((String)"", (String)"\u8bf7\u586b\u5199\u5de5\u65f6");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TimesheetVO> batchInsert(TimesheetListPayload payload) {
        List deleteIdList;
        ArrayList<TimesheetVO> timesheetVOList = new ArrayList<TimesheetVO>();
        List timesheetList0 = payload.getTimesheetList();
        if (!CollectionUtils.isEmpty((Collection)timesheetList0)) {
            if (payload.isCheckFlag() && !this.workHourValidate(payload)) {
                throw TwException.error((String)"", (String)"\u5f53\u5929\u5de5\u65f6\u5df2\u8d85\u8fc78\u5c0f\u65f6");
            }
            List timesheetList = timesheetList0.stream().filter(vo -> !TimesheetStatus.APPROVED.getCode().equals(vo.getTsStatus())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(timesheetList)) {
                List projectIds = timesheetList.stream().map(TimesheetPayload::getProjId).collect(Collectors.toList());
                List taskPackages = this.taskPackageService.queryListByProjectIds(projectIds);
                HashMap<Long, Long> map = new HashMap<Long, Long>();
                if (!ObjectUtils.isEmpty((Object)taskPackages)) {
                    for (PmsTaskPackageVO taskPackage : taskPackages) {
                        map.put(taskPackage.getProjectId(), taskPackage.getExpenseOrgId());
                    }
                }
                if (payload.isSubmitted()) {
                    this.checkWorkDate(payload);
                    for (TimesheetPayload timesheet : timesheetList) {
                        timesheet.setSubmitTime(LocalDateTime.now());
                        timesheet.setExpenseBuId((Long)map.get(timesheet.getProjId()));
                        timesheetVOList.add(this.insert(timesheet));
                        if (0 == timesheet.getProjId().intValue()) continue;
                        this.taskService.useTask(timesheet.getTaskId(), GlobalUtil.getLoginUserId(), timesheet.getWorkHour());
                    }
                } else {
                    for (TimesheetPayload timesheet : timesheetList) {
                        timesheet.setExpenseBuId((Long)map.get(timesheet.getProjId()));
                        timesheetVOList.add(this.insert(timesheet));
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(deleteIdList = payload.getDeleteIdList()))) {
            this.deleteSoft(deleteIdList);
        }
        return timesheetVOList;
    }

    private void checkWorkDate(TimesheetListPayload payload) {
        long count;
        LocalDate now = LocalDate.now();
        List timesheetList = payload.getTimesheetList();
        if (!CollectionUtils.isEmpty((Collection)timesheetList) && (count = timesheetList.stream().filter(timesheetPayload -> timesheetPayload.getWorkDate().isAfter(now)).count()) > 0L) {
            throw TwException.error((String)"", (String)"\u4e0d\u5141\u8bb8\u63d0\u524d\u63d0\u4ea4\u5de5\u65f6");
        }
    }

    private boolean tsStatusCheck(TimesheetPayload timesheetPayload) {
        timesheetPayload.setCreateUserId(GlobalUtil.getLoginUserId());
        boolean flag = timesheetPayload.getTsStatus() != null && (timesheetPayload.getTsStatus().equals(TimesheetStatus.CREATE.getCode()) || timesheetPayload.getTsStatus().equals(TimesheetStatus.REJECTED.getCode()));
        return flag;
    }

    private BigDecimal calProjTsUsedEqvasByTsDetail(LocalDate workDate, BigDecimal eqvaRatio, Long projId, BigDecimal workHour) {
        if (workDate == null || projId == null) {
            return null;
        }
        if (eqvaRatio == null) {
            return null;
        }
        if (workHour == null) {
            workHour = BigDecimal.valueOf(8L);
        }
        return eqvaRatio.multiply(workHour).divide(BigDecimal.valueOf(8L), 2, RoundingMode.DOWN);
    }

    private boolean workHourValidate(TimesheetListPayload payload) {
        Map<LocalDate, Double> resultMap = payload.getTimesheetList().stream().filter(timesheetPayload -> timesheetPayload.getTsStatus() != null && (timesheetPayload.getTsStatus().equals(TimesheetStatus.CREATE.getCode()) || timesheetPayload.getTsStatus().equals(TimesheetStatus.REJECTED.getCode()))).collect(Collectors.groupingBy(TimesheetPayload::getWorkDate, Collectors.summingDouble(TimesheetPayload::getDoubleWorkHour)));
        ArrayList isValid = new ArrayList();
        resultMap.forEach((date, workHour) -> {
            TimesheetQuery query = new TimesheetQuery();
            query.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
            query.setCreateUserId(GlobalUtil.getLoginUserId());
            query.setWorkDateQuery(date);
            List<TimesheetVO> timesheetVOList = this.queryList(query);
            Double wh = timesheetVOList.stream().collect(Collectors.summingDouble(t -> t.getWorkHour().doubleValue()));
            if (workHour + wh > 8.0) {
                isValid.add(false);
            }
        });
        return !isValid.contains(false);
    }

    private void initData(TimesheetPayload payload) {
        List list;
        payload.setCreateUserId(GlobalUtil.getLoginUserId());
        List prdOrgDataRefVOS = this.userService.queryOrgList();
        if (!CollectionUtils.isEmpty((Collection)prdOrgDataRefVOS) && !CollectionUtils.isEmpty(list = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            Long orgId = ((PrdOrgDataRefVO)list.get(0)).getOrgId();
            payload.setOrgId(orgId);
        }
        if (null != payload.getProjId()) {
            PmsProjectVO projectVO = this.projectService.queryByKey(payload.getProjId());
            if (!StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjectCode() : "");
            }
            if (!StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjectName() : "");
            }
        }
        payload.setApprResult(null);
        if (payload.isSubmitted()) {
            payload.setTsStatus(TimesheetStatus.APPROVING.getCode());
            if (ObjectUtils.isEmpty((Object)payload.getApprUserId())) {
                payload.setApprUserId(this.findApprUserId(payload));
            }
            if (payload.getId() != null && payload.getId() > 0L) {
                entity = this.timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
                Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
                payload.setSubmitTime(entity.getSubmitTime());
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
        } else if (payload.getId() != null && payload.getId() > 0L) {
            entity = this.timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
            Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
            payload.setSubmitTime(entity.getSubmitTime());
            payload.setTsStatus(entity.getTsStatus());
        } else {
            payload.setTsStatus(TimesheetStatus.CREATE.getCode());
        }
        if (payload.getWorkDate() != null) {
            payload.setYearWeek(Integer.valueOf(Integer.parseInt(DateUtil.getYearWeek((LocalDate)payload.getWorkDate()))));
            payload.setWeekStartDate(DateUtil.getStartWeekDay((LocalDate)payload.getWorkDate()));
        }
    }

    private Long findApprUserId(TimesheetPayload payload) {
        PmsProjectVO projectVO;
        Long user = null;
        if (payload.getProjId().intValue() > 0 && !ObjectUtils.isEmpty((Object)(projectVO = this.projectService.queryByKey(payload.getProjId())))) {
            user = projectVO.getManagerUserId();
        }
        if (ObjectUtils.isEmpty(user)) {
            PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(payload.getCreateUserId());
            if (null == prdOrgEmployeeRefVO) {
                log.error("\u3010\u5339\u914d\u4e0d\u5230\u5ba1\u6279\u4eba\u3011\uff1a\u5de5\u65f6\u586b\u62a5\u7528\u6237\u4e3b\u952e\uff1a{} ; \u5de5\u65f6\u6570\u636e\uff1a{}", (Object)payload.getCreateUserId(), (Object)payload);
                throw TwException.error((String)"", (String)"\u5339\u914d\u4e0d\u5230\u5ba1\u6279\u4eba\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            user = prdOrgEmployeeRefVO.getParentId();
        }
        return user;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetVO update(TimesheetPayload payload) {
        if (payload.getProjId() != null) {
            PmsProjectVO projectVO = this.projectService.queryByKey(payload.getProjId());
            if (!StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjectCode() : "");
            }
            if (!StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjectName() : "");
            }
        }
        TimesheetDO entity = this.timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetConvert.INSTANCE.toVo((TimesheetDO)((Object)this.timesheetRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus()) && !TimesheetStatus.REJECTED.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error((String)"", (String)"\u53ea\u80fd\u5220\u9664\u72b6\u6001\u4e3a\u521b\u5efa\u6216\u8005\u9000\u56de\u7684\u5de5\u65f6");
                    }
                    entity.setDeleteFlag(1);
                    this.timesheetRepo.save((Object)entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void toApproved(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error((String)"", (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6279\u901a\u8fc7");
                    }
                    if (!GlobalUtil.getLoginUserId().equals(entity.getApprUserId())) {
                        throw TwException.error((String)"", (String)"\u5ba1\u6279\u4eba\u9519\u8bef");
                    }
                    entity.setTsStatus(TimesheetStatus.APPROVED.getCode());
                    entity.setApprResult("\u5ba1\u6279\u901a\u8fc7");
                    entity.setApprovalTime(LocalDateTime.now());
                    this.timesheetRepo.save((Object)entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void toAdvanced(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus()) && !TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error((String)"", (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u6216\u65b0\u5efa\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6279\u901a\u8fc7");
                    }
                    entity.setTsStatus(TimesheetStatus.APPROVED.getCode());
                    entity.setApprResult("\u5ba1\u6279\u901a\u8fc7");
                    this.timesheetRepo.save((Object)entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void rejected(List<Long> keys, String apprResult) {
        List<TimesheetVO> list;
        if (!keys.isEmpty() && !ObjectUtils.isEmpty(list = this.timesheetDao.queryByKeys(keys))) {
            for (TimesheetVO entity : list) {
                if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                    throw TwException.error((String)"", (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6279\u62d2\u7edd");
                }
                if (!GlobalUtil.getLoginUserId().equals(entity.getApprUserId())) {
                    throw TwException.error((String)"", (String)"\u5ba1\u6279\u4eba\u9519\u8bef");
                }
                entity.setTsStatus(TimesheetStatus.REJECTED.getCode());
                entity.setApprResult(apprResult);
                this.timesheetRepo.save((Object)((TimesheetDO)((Object)TimesheetConvert.INSTANCE.toEntity(entity))));
                if (0 == entity.getProjId().intValue()) continue;
                this.taskService.useTask(entity.getTaskId(), entity.getTsUserId(), entity.getWorkHour().negate());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void revoked(List<Long> keys) {
        List<TimesheetVO> list;
        if (!keys.isEmpty() && !ObjectUtils.isEmpty(list = this.timesheetDao.queryByKeys(keys))) {
            for (TimesheetVO entity : list) {
                if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                    throw TwException.error((String)"", (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u624d\u5141\u8bb8\u64a4\u56de");
                }
                entity.setTsStatus(TimesheetStatus.CREATE.getCode());
                entity.setApprUserId(null);
                entity.setApprResult("\u5ba1\u6279\u64a4\u56de");
                this.timesheetRepo.save((Object)((TimesheetDO)((Object)TimesheetConvert.INSTANCE.toEntity(entity))));
                if (0 == entity.getProjId().intValue()) continue;
                this.taskService.useTask(entity.getTaskId(), entity.getTsUserId(), entity.getWorkHour().negate());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateApprUserId(List<Long> keys, Long apprUserId) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error((String)"", (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u624d\u5141\u8bb8\u4fee\u6539\u5ba1\u6279\u4eba");
                    }
                    entity.setApprUserId(apprUserId);
                    this.timesheetRepo.save((Object)entity);
                }
            });
        }
    }

    public TimesheetServiceImpl(TimesheetRepo timesheetRepo, TimesheetDAO timesheetDao, CacheUtil cacheUtil, PmsTaskService taskService, PmsTaskPackageService taskPackageService, PmsProjectService projectService, PrdOrgEmployeeDAO employeeDAO, JPAQueryFactory jpaQueryFactory, PrdSystemRoleDAO systemRoleDAO, PrdUserService userService, PrdOrgOrganizationDAO prdOrgOrganizationDAO, TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo) {
        this.timesheetRepo = timesheetRepo;
        this.timesheetDao = timesheetDao;
        this.cacheUtil = cacheUtil;
        this.taskService = taskService;
        this.taskPackageService = taskPackageService;
        this.projectService = projectService;
        this.employeeDAO = employeeDAO;
        this.jpaQueryFactory = jpaQueryFactory;
        this.systemRoleDAO = systemRoleDAO;
        this.userService = userService;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
        this.biweeklyReadFlagRepo = biweeklyReadFlagRepo;
    }
}

