/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsClosurePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsClosureQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsClosureVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsClosureDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsClosureDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsClosureRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsClosureDao {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsClosureRepo repo;
    private final QPmsClosureDO qdo = QPmsClosureDO.pmsClosureDO;

    private JPAQuery<PmsClosureVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsClosureVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.projectId, this.qdo.templateId, this.qdo.node, this.qdo.procInstId, this.qdo.submitTime})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsClosureVO> getJpaQueryWhere(PmsClosureQuery query) {
        JPAQuery<PmsClosureVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    private Predicate where(PmsClosureQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsClosureVO queryByKey(Long id) {
        JPAQuery<PmsClosureVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsClosureVO)jpaQuery.fetchFirst();
    }

    public PmsClosureVO queryByProjectId(Long projectId) {
        JPAQuery<PmsClosureVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsClosureVO)jpaQuery.fetchFirst();
    }

    public List<PmsClosureVO> queryListDynamic(PmsClosureQuery query) {
        JPAQuery<PmsClosureVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PmsClosureDO save(PmsClosureDO ado) {
        return (PmsClosureDO)this.repo.save(ado);
    }

    public List<PmsClosureDO> saveAll(List<PmsClosureDO> dos) {
        return this.repo.saveAll(dos);
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateWorkFlow(Long id, String node) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.node, (Object)node).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateWorkFlow(PmsClosurePayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstId())) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstStatus())) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getSubmitTime())) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getNode())) {
            update.set((Path)this.qdo.node, (Object)payload.getNode());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDeleteFlag())) {
            update.set(this.qdo.deleteFlag, (Object)payload.getDeleteFlag());
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsClosureDao(JPAQueryFactory jpaQueryFactory, PmsClosureRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

