/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsClosurePayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectEvaluationPayload;
import com.elitesland.tw.tw5pms.api.project.service.PmsClosureInspectionItemsService;
import com.elitesland.tw.tw5pms.api.project.service.PmsClosureService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsClosureVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectEvaluationVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ClosureEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5pms.server.project.convert.PmsClosureConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsProjectEvaluationConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsClosureDao;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsProjectEvaluationDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsClosureDO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectEvaluationDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsClosureRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsClosureServiceImpl
extends BaseServiceImpl
implements PmsClosureService {
    private static final Logger log = LoggerFactory.getLogger(PmsClosureServiceImpl.class);
    private final PmsClosureDao pmsClosureDao;
    private final PmsClosureRepo repo;
    private final CacheUtil cacheUtil;
    private final PmsProjectDAO projectDAO;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final PmsClosureInspectionItemsService inspectionItemsService;
    private final PmsProjectEvaluationDAO pmsProjectEvaluationDAO;
    private final PrdUserService userService;

    public PmsClosureVO queryByProjectId(Long projectId) {
        List<String> roleCodes;
        Long loginUserId = GlobalUtil.getLoginUserId();
        PmsProjectVO projectVO = this.projectDAO.queryByKey(projectId);
        if (ObjectUtils.isEmpty((Object)projectVO)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsClosureVO vo = this.pmsClosureDao.queryByProjectId(projectId);
        if (ObjectUtil.isEmpty((Object)vo)) {
            vo = new PmsClosureVO();
            vo.setCreateUserId(GlobalUtil.getLoginUserId());
            vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        } else {
            vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        }
        vo.setProjectId(projectId);
        vo.setProjectStatus(projectVO.getProjectStatus());
        vo.setProjectCode(projectVO.getProjectCode());
        vo.setProjectName(projectVO.getProjectName());
        vo.setAccountStatus(projectVO.getAccountStatus());
        vo.setManagerUserName(this.cacheUtil.getUserName(projectVO.getManagerUserId()));
        vo.setSaleManagerUserName(this.cacheUtil.getUserName(projectVO.getSaleManagerUserId()));
        vo.setPayManagerUserName(this.cacheUtil.getUserName(projectVO.getPayManagerUserId()));
        vo.setPmoManagerUserName(this.cacheUtil.getUserName(projectVO.getPmoManagerUserId()));
        vo.setFinanceUserName(this.cacheUtil.getUserName(projectVO.getFinanceUserId()));
        vo.setProjectStatusName(this.cacheUtil.transferSystemSelection("PMS:PROJECT:STATUS", vo.getProjectStatus()));
        PrdOrgDataRefVO orgDataRefVO = this.cacheUtil.getDefaultOrgInfoByUserId(projectVO.getPayManagerUserId());
        if (!ObjectUtils.isEmpty((Object)orgDataRefVO)) {
            vo.setPayManagerUserBU(orgDataRefVO.getOrgName());
        }
        if (!ObjectUtils.isEmpty(roleCodes = this.getRoleCodes(projectVO, loginUserId))) {
            String roleCode = this.getRoleCode(roleCodes, vo.getNode());
            if (ObjectUtils.isEmpty((Object)roleCode)) {
                vo.setRoleCode(this.getRoleCodes(roleCodes));
                if (roleCodes.contains(ClosureEnum.ROLE_FR.getCode())) {
                    roleCodes = Arrays.asList(ClosureEnum.ROLE_SR.getCode(), ClosureEnum.ROLE_FD.getCode(), ClosureEnum.ROLE_PMO.getCode());
                }
                vo.setInspectionItemsList(this.inspectionItemsService.queryinspectionItemsList(projectId, roleCodes));
            } else {
                vo.setRoleCode(roleCode);
                roleCodes = Arrays.asList(roleCode);
                if (ClosureEnum.ROLE_FR.getCode().equals(roleCode)) {
                    roleCodes = Arrays.asList(ClosureEnum.ROLE_SR.getCode(), ClosureEnum.ROLE_FD.getCode(), ClosureEnum.ROLE_PMO.getCode());
                }
                vo.setInspectionItemsList(this.inspectionItemsService.queryinspectionItemsList(projectId, roleCodes));
            }
        }
        vo.setRoleCodes(roleCodes);
        return vo;
    }

    public PmsClosureVO queryByKey(Long key) {
        return this.pmsClosureDao.queryByKey(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsClosureVO save(PmsClosurePayload payload) {
        this.checkData(payload);
        PmsProjectVO projectVO = this.projectDAO.queryByKey(payload.getProjectId());
        if (ObjectUtils.isEmpty((Object)projectVO)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        String node = null;
        if (!ObjectUtils.isEmpty((Object)payload.getId())) {
            PmsClosureVO vo = this.pmsClosureDao.queryByKey(payload.getId());
            if (ObjectUtils.isEmpty((Object)vo)) {
                throw TwException.error((String)"", (String)"\u9879\u76ee\u7ed3\u9879\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            node = vo.getNode();
        }
        if (ObjectUtils.isEmpty(node) || "0".equals(node)) {
            payload.setNode(ClosureEnum.NODE_APPLYING.getCode());
            PmsClosureDO closureDO = this.pmsClosureDao.save(PmsClosureConvert.INSTANCE.toDo(payload));
            if (payload.getSubmit().booleanValue()) {
                if (ObjectUtils.isEmpty((Object)payload.getProcInstId()) && !ProjectStatusEnum.APPROVED.getCode().equals(projectVO.getProjectStatus()) && !ProjectStatusEnum.CLOSE_EJECTED.getCode().equals(projectVO.getProjectStatus())) {
                    throw TwException.error((String)"", (String)"\u53ea\u6709\u6fc0\u6d3b\u4e2d\u6216\u8005\u7ed3\u9879\u9a73\u56de\u7684\u7684\u9879\u76ee\u624d\u5141\u8bb8\u63d0\u4ea4\u7ed3\u9879\u7533\u8bf7\uff01");
                }
                if (!GlobalUtil.getLoginUserId().equals(projectVO.getManagerUserId())) {
                    throw TwException.error((String)"", (String)"\u53ea\u6709\u9879\u76ee\u7ecf\u7406\u53ef\u4ee5\u53d1\u8d77\u7ed3\u9879\u7533\u8bf7");
                }
                if (ObjectUtils.isEmpty((Object)projectVO.getFinanceUserId())) {
                    throw TwException.error((String)"", (String)"\u8d22\u52a1\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtils.isEmpty((Object)projectVO.getPmoManagerUserId())) {
                    throw TwException.error((String)"", (String)"pmo\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtils.isEmpty((Object)projectVO.getPayManagerUserId())) {
                    throw TwException.error((String)"", (String)"\u4ea4\u4ed8\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                }
                this.projectDAO.updateProjectStatus(payload.getProjectId(), ProjectStatusEnum.CLOSING.getCode(), ClosureEnum.PENDING_ACCOUNT_CLOSURE.getCode());
                payload.setId(closureDO.getId());
                this.submitWorkFlow(payload, projectVO);
            }
        }
        this.inspectionItemsService.batchInsertOrUpdate(payload);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void toApproved(PmsClosurePayload payload) {
        if (ClosureEnum.NODE_FINANCIAL_VERIFICATION.getCode().equals(payload.getNode())) {
            this.projectDAO.updateProjectStatus(payload.getProjectId(), ProjectStatusEnum.CLOSING.getCode(), ClosureEnum.CLOSED_ACCOUNT.getCode());
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION.getCode());
        } else if (ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION.getCode().equals(payload.getNode())) {
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_AUDITING.getCode());
        } else if (ClosureEnum.NODE_AUDITING.getCode().equals(payload.getNode())) {
            this.projectDAO.updateProjectStatus(payload.getProjectId(), ProjectStatusEnum.CLOSED.getCode(), ClosureEnum.CLOSED_ACCOUNT.getCode());
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_END.getCode());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void toApproved(PmsClosurePayload payload, String taskKey) {
        if (ClosureEnum.NODE_FINANCIAL_VERIFICATION_KEY.getCode().equals(taskKey)) {
            this.projectDAO.updateProjectStatus(payload.getProjectId(), ProjectStatusEnum.CLOSING.getCode(), ClosureEnum.CLOSED_ACCOUNT.getCode());
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION.getCode());
        } else if (ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION_KEY.getCode().equals(taskKey)) {
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_AUDITING.getCode());
        } else if (ClosureEnum.NODE_AUDITING_KEY.getCode().equals(taskKey)) {
            this.projectDAO.updateProjectStatus(payload.getProjectId(), ProjectStatusEnum.CLOSED.getCode(), ClosureEnum.CLOSED_ACCOUNT.getCode());
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_END.getCode());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void rejected(PmsClosurePayload payload) {
        if (ClosureEnum.NODE_FINANCIAL_VERIFICATION.getCode().equals(payload.getNode())) {
            this.projectDAO.updateProjectStatus(payload.getProjectId(), ProjectStatusEnum.CLOSE_EJECTED.getCode(), "");
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_APPLYING.getCode());
        } else if (ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION.getCode().equals(payload.getNode())) {
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_FINANCIAL_VERIFICATION.getCode());
            this.projectDAO.updateProjectStatus(payload.getProjectId(), ProjectStatusEnum.CLOSE_EJECTED.getCode(), ClosureEnum.PENDING_ACCOUNT_CLOSURE.getCode());
        } else if (ClosureEnum.NODE_AUDITING.getCode().equals(payload.getNode())) {
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION.getCode());
            this.projectDAO.updateProjectStatus(payload.getProjectId(), ProjectStatusEnum.CLOSE_EJECTED.getCode(), ClosureEnum.CLOSED_ACCOUNT.getCode());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void invalid(PmsClosurePayload payload) {
        this.pmsClosureDao.updateWorkFlow(payload);
        this.inspectionItemsService.deleteByProjecId(payload.getProjectId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void rejected(PmsClosurePayload payload, String taskKey, String nextKey) {
        if (ClosureEnum.NODE_FINANCIAL_VERIFICATION_KEY.getCode().equals(taskKey)) {
            this.rejected(payload, taskKey);
        } else if (ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION_KEY.getCode().equals(taskKey)) {
            if (ClosureEnum.NODE_FINANCIAL_VERIFICATION_KEY.getCode().equals(nextKey)) {
                this.rejected(payload, taskKey);
            } else {
                this.rejected(payload, ClosureEnum.NODE_FINANCIAL_VERIFICATION_KEY.getCode());
            }
        } else if (ClosureEnum.NODE_AUDITING_KEY.getCode().equals(taskKey)) {
            if (ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION_KEY.getCode().equals(nextKey)) {
                this.rejected(payload, taskKey);
            } else if (ClosureEnum.NODE_FINANCIAL_VERIFICATION_KEY.getCode().equals(nextKey)) {
                this.rejected(payload, ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION_KEY.getCode());
            } else {
                this.rejected(payload, ClosureEnum.NODE_FINANCIAL_VERIFICATION_KEY.getCode());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void rejected(PmsClosurePayload payload, String taskKey) {
        if (ClosureEnum.NODE_FINANCIAL_VERIFICATION_KEY.getCode().equals(taskKey)) {
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_APPLYING.getCode());
            this.projectDAO.updateProjectStatus(payload.getProjectId(), ProjectStatusEnum.CLOSE_EJECTED.getCode(), "");
        } else if (ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION_KEY.getCode().equals(taskKey)) {
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_FINANCIAL_VERIFICATION.getCode());
            this.projectDAO.updateProjectStatus(payload.getProjectId(), ProjectStatusEnum.CLOSE_EJECTED.getCode(), ClosureEnum.PENDING_ACCOUNT_CLOSURE.getCode());
        } else if (ClosureEnum.NODE_AUDITING_KEY.getCode().equals(taskKey)) {
            this.pmsClosureDao.updateWorkFlow(payload.getId(), ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION.getCode());
            this.projectDAO.updateProjectStatus(payload.getProjectId(), ProjectStatusEnum.CLOSE_EJECTED.getCode(), ClosureEnum.CLOSED_ACCOUNT.getCode());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void appraise(PmsProjectEvaluationPayload payload) {
        PmsProjectVO projectVO = this.projectDAO.queryByKey(payload.getProjectId());
        if (ObjectUtils.isEmpty((Object)projectVO)) {
            throw TwException.error((String)"", (String)"\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ProjectStatusEnum.CLOSING.getCode().equals(projectVO.getProjectStatus()) || ProjectStatusEnum.CLOSE_EJECTED.getCode().equals(projectVO.getProjectStatus()) || ProjectStatusEnum.CLOSED.getCode().equals(projectVO.getProjectStatus())) {
            PmsProjectEvaluationVO evaluationVO = this.pmsProjectEvaluationDAO.queryByProjectIdAndUserId(payload.getProjectId(), payload.getUserId());
            if (!ObjectUtils.isEmpty((Object)evaluationVO)) {
                throw TwException.error((String)"", (String)"\u4e0d\u53ef\u91cd\u590d\u8bc4\u4ef7\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            Long loginUserId = GlobalUtil.getLoginUserId();
            if (!projectVO.getPayManagerUserId().equals(loginUserId) && !projectVO.getManagerUserId().equals(loginUserId)) {
                throw TwException.error((String)"", (String)"\u65e0\u8be5\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (1 == payload.getAppraiseType()) {
                if (!projectVO.getPayManagerUserId().equals(loginUserId)) {
                    throw TwException.error((String)"", (String)"\u53ea\u6709\u4ea4\u4ed8\u8d1f\u8d23\u4eba\u53ef\u4ee5\u8bc4\u4ef7\u9879\u76ee\u7ecf\u7406\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            } else if (!projectVO.getManagerUserId().equals(loginUserId)) {
                throw TwException.error((String)"", (String)"\u53ea\u6709\u9879\u76ee\u7ecf\u7406\u53ef\u4ee5\u8bc4\u4ef7\u9879\u76ee\u6210\u5458\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        } else {
            throw TwException.error((String)"", (String)"\u672a\u63d0\u4ea4\u7ed3\u9879\u7684\u9879\u76ee\u4e0d\u53ef\u8bc4\u4ef7\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectEvaluationDO evaluationDO = PmsProjectEvaluationConvert.INSTANCE.toDo(payload);
        this.pmsProjectEvaluationDAO.save(evaluationDO);
    }

    public PmsProjectEvaluationVO appraiseInfo(Long projectId, Long userId) {
        return this.pmsProjectEvaluationDAO.queryByProjectIdAndUserId(projectId, userId);
    }

    void checkData(PmsClosurePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error((String)"", (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    void submitWorkFlow(PmsClosurePayload payload, PmsProjectVO projectVO) {
        PmsClosurePayload payload0 = new PmsClosurePayload();
        payload0.setId(payload.getId());
        if (ObjectUtils.isEmpty((Object)payload.getProcInstId())) {
            HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
            batchMap.put(ClosureEnum.NODE_FINANCIAL_VERIFICATION_KEY.getCode(), Lists.newArrayList((Object[])new String[]{projectVO.getFinanceUserId().toString()}));
            batchMap.put(ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION_KEY.getCode(), Lists.newArrayList((Object[])new String[]{projectVO.getPmoManagerUserId().toString()}));
            batchMap.put(ClosureEnum.NODE_AUDITING_KEY.getCode(), Lists.newArrayList((Object[])new String[]{projectVO.getPayManagerUserId().toString()}));
            ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)PmsProcDefKey.PMS_CLOSURE.name(), (String)(projectVO.getProjectName() + "-\u9879\u76ee\u7ed3\u9879\u5ba1\u6279\u6d41\u7a0b"), (String)("" + projectVO.getId()), batchMap));
            payload0.setProcInstId(processInfo.getProcInstId());
            payload0.setProcInstStatus(ProcInstStatus.APPROVING);
            payload0.setSubmitTime(LocalDateTime.now());
        }
        payload0.setNode(ClosureEnum.NODE_FINANCIAL_VERIFICATION.getCode());
        this.transactionUtilService.executeWithRunnable(() -> this.pmsClosureDao.updateWorkFlow(payload0));
    }

    public Map<String, Object> getCarryoverInformation(PmsClosurePayload payload) {
        if (!ClosureEnum.ROLE_FD.getCode().equals(payload.getRoleCode())) {
            throw TwException.error((String)"", (String)"\u53ea\u6709\u8d22\u52a1\u624d\u53ef\u4ee5\u67e5\u770b\u7ed3\u8f6c\u4fe1\u606f\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectAccountName", "\u5236\u9020\u4e1a\u4ea4\u4ed8\u9879\u76ee");
        map.put("deliveryAccountName", "\u4ea4\u4ed8\u90e8\u95e8");
        map.put("projectAccountBalance", new BigDecimal(2000000));
        map.put("projectAccountCashBalance", new BigDecimal(4000000));
        return map;
    }

    public String getRoleCode(List<String> roleCodes, String node) {
        if (!ObjectUtils.isEmpty(roleCodes)) {
            if ((ObjectUtils.isEmpty((Object)node) || ClosureEnum.NODE_APPLYING.getCode().equals(node)) && roleCodes.contains(ClosureEnum.ROLE_SR.getCode())) {
                return ClosureEnum.ROLE_SR.getCode();
            }
            if (ClosureEnum.NODE_FINANCIAL_VERIFICATION.getCode().equals(node) && roleCodes.contains(ClosureEnum.ROLE_FD.getCode())) {
                return ClosureEnum.ROLE_FD.getCode();
            }
            if (ClosureEnum.NODE_KNOWLEDGE_PRECIPITATION.getCode().equals(node) && roleCodes.contains(ClosureEnum.ROLE_PMO.getCode())) {
                return ClosureEnum.ROLE_PMO.getCode();
            }
            if (ClosureEnum.NODE_AUDITING.getCode().equals(node) && roleCodes.contains(ClosureEnum.ROLE_FR.getCode())) {
                return ClosureEnum.ROLE_FR.getCode();
            }
        }
        return null;
    }

    public List<String> getRoleCodes(PmsProjectVO projectVO, Long loginUserId) {
        ArrayList<String> roleCodes = new ArrayList<String>();
        if (loginUserId.equals(projectVO.getManagerUserId())) {
            roleCodes.add(ClosureEnum.ROLE_SR.getCode());
        }
        if (loginUserId.equals(projectVO.getPayManagerUserId())) {
            roleCodes.add(ClosureEnum.ROLE_FR.getCode());
        }
        if (loginUserId.equals(projectVO.getPmoManagerUserId())) {
            roleCodes.add(ClosureEnum.ROLE_PMO.getCode());
        }
        if (loginUserId.equals(projectVO.getFinanceUserId())) {
            roleCodes.add(ClosureEnum.ROLE_FD.getCode());
        }
        return roleCodes;
    }

    public String getRoleCodes(List<String> roleCodes) {
        String roleCode = "";
        if (roleCodes.contains(ClosureEnum.ROLE_SR.getCode())) {
            roleCode = ClosureEnum.ROLE_SR.getCode();
        }
        if (roleCodes.contains(ClosureEnum.ROLE_FD.getCode())) {
            roleCode = ClosureEnum.ROLE_FD.getCode();
        }
        if (roleCodes.contains(ClosureEnum.ROLE_PMO.getCode())) {
            roleCode = ClosureEnum.ROLE_PMO.getCode();
        }
        if (roleCodes.contains(ClosureEnum.ROLE_FR.getCode())) {
            roleCode = ClosureEnum.ROLE_FR.getCode();
        }
        return roleCode;
    }

    public PmsClosureServiceImpl(PmsClosureDao pmsClosureDao, PmsClosureRepo repo, CacheUtil cacheUtil, PmsProjectDAO projectDAO, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, PmsClosureInspectionItemsService inspectionItemsService, PmsProjectEvaluationDAO pmsProjectEvaluationDAO, PrdUserService userService) {
        this.pmsClosureDao = pmsClosureDao;
        this.repo = repo;
        this.cacheUtil = cacheUtil;
        this.projectDAO = projectDAO;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.inspectionItemsService = inspectionItemsService;
        this.pmsProjectEvaluationDAO = pmsProjectEvaluationDAO;
        this.userService = userService;
    }
}

