/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.workflow;

import com.elitesland.tw.tw5pms.api.project.payload.PmsClosurePayload;
import com.elitesland.tw.tw5pms.api.project.service.PmsClosureService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsClosureVO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsClosureDao;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ActionType;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/PMS_CLOSURE/callBack"})
@Transactional
public class PmsClosureCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PmsClosureCallBackController.class);
    private final PmsClosureService closureService;
    private final PmsClosureDao pmsClosureDao;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        String taskDefKey = payload.getCommentInfo().getTaskDefKey();
        ActionType actionType = payload.getCommentInfo().getType();
        String nextTaskKey = payload.getTaskKey();
        PmsClosureVO closureVO = this.pmsClosureDao.queryByProjectId(Long.valueOf(businessKey));
        if (closureVO != null) {
            PmsClosurePayload closurePayload = new PmsClosurePayload();
            closurePayload.setId(closureVO.getId());
            closurePayload.setProjectId(closureVO.getProjectId());
            closurePayload.setNode(closureVO.getNode());
            switch (actionType) {
                case REJECTED: {
                    this.closureService.rejected(closurePayload, taskDefKey, nextTaskKey);
                    break;
                }
                case AGREE: {
                    this.closureService.toApproved(closurePayload, taskDefKey);
                }
            }
        }
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    @Transactional
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        PmsClosureVO closureVO = this.pmsClosureDao.queryByProjectId(Long.valueOf(businessKey));
        if (closureVO != null) {
            PmsClosurePayload closurePayload = new PmsClosurePayload();
            closurePayload.setId(closureVO.getId());
            closurePayload.setProjectId(closureVO.getProjectId());
            closurePayload.setNode(closureVO.getNode());
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    break;
                }
                case INTERRUPT: {
                    break;
                }
                case INVALID: {
                    closurePayload.setDeleteFlag(Integer.valueOf(1));
                    closurePayload.setProcInstStatus(ProcInstStatus.INVALID);
                    this.closureService.invalid(closurePayload);
                    break;
                }
                case REJECTED: {
                    closurePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    this.closureService.rejected(closurePayload);
                    break;
                }
                case APPROVED: {
                    closurePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    this.closureService.toApproved(closurePayload);
                    break;
                }
            }
        }
    }

    public PmsClosureCallBackController(PmsClosureService closureService, PmsClosureDao pmsClosureDao) {
        this.closureService = closureService;
        this.pmsClosureDao = pmsClosureDao;
    }
}

