/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.company.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.company.payload.CompanyPayload;
import com.elitesland.tw.tw5.api.company.query.CompanyQuery;
import com.elitesland.tw.tw5.api.company.vo.CompanySimpleVO;
import com.elitesland.tw.tw5.api.company.vo.CompanyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.company.entity.CompanyDO;
import com.elitesland.tw.tw5.server.company.entity.QCompanyDO;
import com.elitesland.tw.tw5.server.company.repo.CompanyRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class CompanyDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CompanyRepo repo;
    private final QCompanyDO qdo = QCompanyDO.companyDO;

    private JPAQuery<CompanyVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CompanyVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.parentId, this.qdo.bookId, this.qdo.companyNo, this.qdo.companyName, this.qdo.companySimpleName, this.qdo.companyLegal, this.qdo.companyStatus, this.qdo.businessRegistrationNo, this.qdo.registrationAddress, this.qdo.currency, this.qdo.taxpayerType, this.qdo.taxpayerNo, this.qdo.sortNo, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5})).from((EntityPath)this.qdo);
    }

    private JPAQuery<CompanyVO> getJpaQueryWhere(CompanyQuery query) {
        JPAQuery<CompanyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(CompanyQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(CompanyQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentId())) {
            list.add(this.qdo.parentId.eq((Object)query.getParentId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBookId())) {
            list.add(this.qdo.bookId.eq((Object)query.getBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCompanyNo())) {
            list.add(this.qdo.companyNo.eq((Object)query.getCompanyNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCompanyName())) {
            list.add(this.qdo.companyName.like(SqlUtil.toSqlLikeString((String)query.getCompanyName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCompanySimpleName())) {
            list.add(this.qdo.companySimpleName.eq((Object)query.getCompanySimpleName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCompanyLegal())) {
            list.add(this.qdo.companyLegal.like(SqlUtil.toSqlLikeString((String)query.getCompanyLegal())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCompanyStatus())) {
            list.add(this.qdo.companyStatus.eq((Object)query.getCompanyStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBusinessRegistrationNo())) {
            list.add(this.qdo.businessRegistrationNo.eq((Object)query.getBusinessRegistrationNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRegistrationAddress())) {
            list.add(this.qdo.registrationAddress.eq((Object)query.getRegistrationAddress()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCurrency())) {
            list.add(this.qdo.currency.eq((Object)query.getCurrency()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaxpayerType())) {
            list.add(this.qdo.taxpayerType.eq((Object)query.getTaxpayerType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaxpayerNo())) {
            list.add(this.qdo.taxpayerNo.eq((Object)query.getTaxpayerNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortNo())) {
            list.add(this.qdo.sortNo.eq((Object)query.getSortNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qdo.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt2())) {
            list.add(this.qdo.ext2.eq((Object)query.getExt2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt3())) {
            list.add(this.qdo.ext3.eq((Object)query.getExt3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt4())) {
            list.add(this.qdo.ext4.eq((Object)query.getExt4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt5())) {
            list.add(this.qdo.ext5.eq((Object)query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    public CompanyVO queryByKey(Long id) {
        JPAQuery<CompanyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CompanyVO)jpaQuery.fetchFirst();
    }

    public List<CompanyVO> queryListDynamic(CompanyQuery query) {
        JPAQuery<CompanyVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<CompanyVO> queryPaging(CompanyQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<CompanyVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public CompanyDO save(CompanyDO ado) {
        return (CompanyDO)this.repo.save(ado);
    }

    public List<CompanyDO> saveAll(List<CompanyDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(CompanyPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getParentId() != null) {
            update.set(this.qdo.parentId, (Object)payload.getParentId());
        }
        if (payload.getBookId() != null) {
            update.set(this.qdo.bookId, (Object)payload.getBookId());
        }
        if (payload.getCompanyNo() != null) {
            update.set((Path)this.qdo.companyNo, (Object)payload.getCompanyNo());
        }
        if (payload.getCompanyName() != null) {
            update.set((Path)this.qdo.companyName, (Object)payload.getCompanyName());
        }
        if (payload.getCompanySimpleName() != null) {
            update.set((Path)this.qdo.companySimpleName, (Object)payload.getCompanySimpleName());
        }
        if (payload.getCompanyLegal() != null) {
            update.set((Path)this.qdo.companyLegal, (Object)payload.getCompanyLegal());
        }
        if (payload.getCompanyStatus() != null) {
            update.set((Path)this.qdo.companyStatus, (Object)payload.getCompanyStatus());
        }
        if (payload.getBusinessRegistrationNo() != null) {
            update.set((Path)this.qdo.businessRegistrationNo, (Object)payload.getBusinessRegistrationNo());
        }
        if (payload.getRegistrationAddress() != null) {
            update.set((Path)this.qdo.registrationAddress, (Object)payload.getRegistrationAddress());
        }
        if (payload.getCurrency() != null) {
            update.set((Path)this.qdo.currency, (Object)payload.getCurrency());
        }
        if (payload.getTaxpayerType() != null) {
            update.set((Path)this.qdo.taxpayerType, (Object)payload.getTaxpayerType());
        }
        if (payload.getTaxpayerNo() != null) {
            update.set((Path)this.qdo.taxpayerNo, (Object)payload.getTaxpayerNo());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("parentId")) {
                update.setNull(this.qdo.parentId);
            }
            if (nullFields.contains("bookId")) {
                update.setNull(this.qdo.bookId);
            }
            if (nullFields.contains("companyNo")) {
                update.setNull((Path)this.qdo.companyNo);
            }
            if (nullFields.contains("companyName")) {
                update.setNull((Path)this.qdo.companyName);
            }
            if (nullFields.contains("companySimpleName")) {
                update.setNull((Path)this.qdo.companySimpleName);
            }
            if (nullFields.contains("companyLegal")) {
                update.setNull((Path)this.qdo.companyLegal);
            }
            if (nullFields.contains("companyStatus")) {
                update.setNull((Path)this.qdo.companyStatus);
            }
            if (nullFields.contains("businessRegistrationNo")) {
                update.setNull((Path)this.qdo.businessRegistrationNo);
            }
            if (nullFields.contains("registrationAddress")) {
                update.setNull((Path)this.qdo.registrationAddress);
            }
            if (nullFields.contains("currency")) {
                update.setNull((Path)this.qdo.currency);
            }
            if (nullFields.contains("taxpayerType")) {
                update.setNull((Path)this.qdo.taxpayerType);
            }
            if (nullFields.contains("taxpayerNo")) {
                update.setNull((Path)this.qdo.taxpayerNo);
            }
            if (nullFields.contains("sortNo")) {
                update.setNull(this.qdo.sortNo);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<CompanySimpleVO> querylistSimple() {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CompanySimpleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.companyName, this.qdo.companyNo})).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetch();
    }

    public List<Long> judgeCompanyName(String companyName) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdo.id).from((EntityPath)this.qdo)).where((Predicate)this.qdo.companyName.eq((Object)companyName))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetch();
    }

    public CompanyDAO(JPAQueryFactory jpaQueryFactory, CompanyRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

