/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.business.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.business.constants.PartnerBusinessTypeEnum;
import com.elitesland.tw.tw5.api.partner.business.payload.BusinessOperationEmployeesPayload;
import com.elitesland.tw.tw5.api.partner.business.payload.BusinessOperationEnterpriseInfoPayload;
import com.elitesland.tw.tw5.api.partner.business.payload.BusinessOperationPartnerPayload;
import com.elitesland.tw.tw5.api.partner.business.payload.BusinessOperationSitesPayload;
import com.elitesland.tw.tw5.api.partner.business.service.BusinessOperationEmployeesService;
import com.elitesland.tw.tw5.api.partner.business.service.BusinessOperationEnterpriseInfoService;
import com.elitesland.tw.tw5.api.partner.business.service.BusinessOperationPartnerService;
import com.elitesland.tw.tw5.api.partner.business.service.BusinessOperationSitesService;
import com.elitesland.tw.tw5.api.partner.business.service.CrmBusinessPartnerService;
import com.elitesland.tw.tw5.api.partner.business.vo.PartnerBusinessCountVO;
import com.elitesland.tw.tw5.api.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActDynamicVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmFollowDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmFollowDO;
import com.elitesland.tw.tw5.server.prd.crm.service.CrmFollowServiceImpl;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbBasicInfoDTO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbEntBriefDTO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbGetEmployeeDTO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbGetWebSiteDTO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbPartnersDTO;
import com.elitesland.tw.tw5.server.prd.qixin.dto.QxbRootDTO;
import com.elitesland.tw.tw5.server.prd.qixin.service.QiXinService;
import com.elitesland.tw.tw5crm.api.contract.query.ContractQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractService;
import com.elitesland.tw.tw5crm.api.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5crm.api.visit.service.VisitTaskService;
import com.elitesland.tw.tw5crm.api.visit.vo.VisitTaskVO;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskStatusEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CrmBusinessPartnerServiceImpl
extends BaseServiceImpl
implements CrmBusinessPartnerService {
    private static final Logger log = LoggerFactory.getLogger(CrmBusinessPartnerServiceImpl.class);
    private final BusinessOperationEnterpriseInfoService enterpriseInfoService;
    private final BusinessOperationSitesService sitesService;
    private final BusinessOperationPartnerService partnersService;
    private final BusinessOperationEmployeesService employeesService;
    private final QiXinService qiXinService;
    private final CrmFollowDAO followDAO;
    private final CrmFollowServiceImpl followService;
    private final CrmLeadsDAO leadsDAO;
    private final CrmOpportunityDAO opportunityDAO;
    private final CrmActActivityDAO actActivityDAO;
    @Resource
    private VisitTaskService visitTaskService;
    @Resource
    private BusinessPartnerService businessPartnerService;
    @Resource
    private CrmOpportunityService crmOpportunityService;
    @Resource
    private CrmLeadsService crmLeadsService;
    @Resource
    private ContractService contractService;
    private static final Map<String, String> qxbTypeNewMap = new HashMap<String, String>(){
        {
            this.put("01", "\u5927\u9646\u4f01\u4e1a");
            this.put("02", "\u793e\u4f1a\u7ec4\u7ec7");
            this.put("03", "\u673a\u5173\u53ca\u4e8b\u4e1a\u5355\u4f4d");
            this.put("04", "\u6e2f\u6fb3\u53f0\u53ca\u56fd\u5916\u4f01\u4e1a");
            this.put("05", "\u5f8b\u6240\u53ca\u5176\u4ed6\u7ec4\u7ec7\u673a\u6784");
        }
    };

    @Transactional(rollbackFor={Exception.class})
    public boolean fillQxbInfo(String partnerName, long partnerId, Long bookId) {
        if (!StringUtils.hasText((String)partnerName)) {
            log.error("\u8865\u5145\u542f\u4fe1\u5b9d\u4fe1\u606f \u53c2\u6570\u7f3a\u5931partnerName:{}", (Object)partnerName);
            return false;
        }
        partnerName = partnerName.trim();
        String qxbBasicInfoStr = this.qiXinService.getBasicInfo(partnerName);
        log.info("\u6839\u636e\u5173\u952e\u5b57[{}]\u67e5\u8be2\u542f\u4fe1\u5b9d\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u7ed3\u679c:{}", (Object)partnerName, (Object)qxbBasicInfoStr);
        QxbRootDTO qxbBasicInfoRoot = (QxbRootDTO)JSON.parseObject((String)qxbBasicInfoStr, QxbRootDTO.class);
        if (!"200".equals(qxbBasicInfoRoot.getStatus())) {
            log.error("\u542f\u4fe1\u5b9d\u67e5\u8be2\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)qxbBasicInfoStr);
            return false;
        }
        QxbBasicInfoDTO qxbBasicInfoDTO = (QxbBasicInfoDTO)qxbBasicInfoRoot.getData().toJavaObject(QxbBasicInfoDTO.class);
        BusinessOperationEnterpriseInfoPayload operationEnterpriseInfoPayload = new BusinessOperationEnterpriseInfoPayload();
        operationEnterpriseInfoPayload.setOrgNo(qxbBasicInfoDTO.getOrgNo());
        operationEnterpriseInfoPayload.setStartDate(qxbBasicInfoDTO.getStartDate());
        operationEnterpriseInfoPayload.setOperName(qxbBasicInfoDTO.getOperName());
        operationEnterpriseInfoPayload.setCreditNo(qxbBasicInfoDTO.getCreditNo());
        operationEnterpriseInfoPayload.setNewStatus(qxbBasicInfoDTO.getNew_status());
        operationEnterpriseInfoPayload.setActualCapi(qxbBasicInfoDTO.getActualCapi());
        operationEnterpriseInfoPayload.setTitle(qxbBasicInfoDTO.getTitle());
        operationEnterpriseInfoPayload.setCheckDate(qxbBasicInfoDTO.getCheckDate());
        if (StringUtils.hasText((String)qxbBasicInfoDTO.getType_new())) {
            String typeNew = qxbTypeNewMap.get(qxbBasicInfoDTO.getType_new());
            operationEnterpriseInfoPayload.setTypeNew(typeNew);
        }
        operationEnterpriseInfoPayload.setScope(qxbBasicInfoDTO.getScope());
        String entBriefStr = this.qiXinService.getEntBriefByName(partnerName);
        log.info("\u6839\u636e\u5173\u952e\u5b57[{}]\u67e5\u8be2\u542f\u4fe1\u5b9d\u4f01\u4e1a\u7b80\u4ecb\u7ed3\u679c:{}", (Object)partnerName, (Object)entBriefStr);
        QxbRootDTO qxbEntBriefRoot = (QxbRootDTO)JSON.parseObject((String)entBriefStr, QxbRootDTO.class);
        if ("200".equals(qxbEntBriefRoot.getStatus())) {
            QxbEntBriefDTO qxbEntBriefDTO = (QxbEntBriefDTO)qxbEntBriefRoot.getData().toJavaObject(QxbEntBriefDTO.class);
            operationEnterpriseInfoPayload.setEnterpriseDesc(qxbEntBriefDTO.getBrief());
        }
        this.saveEnterpriseInfo(operationEnterpriseInfoPayload, partnerId, bookId);
        String qxbGetWebsitesStr = this.qiXinService.getGetWebsites(partnerName, null);
        log.info("\u6839\u636e\u5173\u952e\u5b57[{}]\u67e5\u8be2\u542f\u4fe1\u5b9d\u4f01\u4e1a\u5e74\u62a5\u7f51\u5740\u7ed3\u679c:{}", (Object)partnerName, (Object)qxbGetWebsitesStr);
        QxbRootDTO qxbGetWebsitesRoot = (QxbRootDTO)JSON.parseObject((String)qxbGetWebsitesStr, QxbRootDTO.class);
        if ("200".equals(qxbGetWebsitesRoot.getStatus())) {
            JSONObject data = qxbGetWebsitesRoot.getData();
            JSONArray items = data.getJSONArray("items");
            List qxbGetWebSiteDTOList = items.toJavaList(QxbGetWebSiteDTO.class);
            List<BusinessOperationSitesPayload> sitesList = qxbGetWebSiteDTOList.stream().map(qxbGetWebSiteDTO -> {
                BusinessOperationSitesPayload sitesPayload = new BusinessOperationSitesPayload();
                sitesPayload.setDate(qxbGetWebSiteDTO.getDate());
                sitesPayload.setUrl(qxbGetWebSiteDTO.getUrl());
                return sitesPayload;
            }).collect(Collectors.toList());
            this.saveSites(sitesList, partnerId, bookId);
        }
        String qxbPartnersStr = this.qiXinService.getPartners(partnerName, null);
        log.info("\u6839\u636e\u5173\u952e\u5b57[{}]\u67e5\u8be2\u542f\u4fe1\u5b9d\u80a1\u4e1c\u4fe1\u606f\u7ed3\u679c:{}", (Object)partnerName, (Object)qxbPartnersStr);
        QxbRootDTO qxbPartnersDTO = (QxbRootDTO)JSON.parseObject((String)qxbPartnersStr, QxbRootDTO.class);
        if ("200".equals(qxbPartnersDTO.getStatus())) {
            JSONObject data = qxbPartnersDTO.getData();
            JSONArray items = data.getJSONArray("items");
            List qxbPartnersDTOList = items.toJavaList(QxbPartnersDTO.class);
            List<BusinessOperationPartnerPayload> partnersList = qxbPartnersDTOList.stream().map(qxbPartnersDTO1 -> {
                BusinessOperationPartnerPayload partnersPayload = new BusinessOperationPartnerPayload();
                partnersPayload.setName(qxbPartnersDTO1.getName());
                partnersPayload.setStockPercent(qxbPartnersDTO1.getStockPercent());
                partnersPayload.setTotalShouldCapi(qxbPartnersDTO1.getTotalShouldCapi());
                partnersPayload.setTotalRealCapi(qxbPartnersDTO1.getTotalRealCapi());
                return partnersPayload;
            }).collect(Collectors.toList());
            this.savePartners(partnersList, partnerId, bookId);
        }
        String qxbGetEmployeesStr = this.qiXinService.getGetEmployees(partnerName, null);
        log.info("\u6839\u636e\u5173\u952e\u5b57[{}]\u67e5\u8be2\u542f\u4fe1\u5b9d\u4e3b\u8981\u4eba\u5458\u5b57\u6bb5\u7ed3\u679c:{}", (Object)partnerName, (Object)qxbGetEmployeesStr);
        QxbRootDTO qxbGetEmployeesRoot = (QxbRootDTO)JSON.parseObject((String)qxbGetEmployeesStr, QxbRootDTO.class);
        if ("200".equals(qxbGetEmployeesRoot.getStatus())) {
            JSONObject data = qxbGetEmployeesRoot.getData();
            JSONArray items = data.getJSONArray("items");
            List qxbGetEmployeeDTOList = items.toJavaList(QxbGetEmployeeDTO.class);
            List<BusinessOperationEmployeesPayload> employeesList = qxbGetEmployeeDTOList.stream().map(qxbGetEmployeeDTO -> {
                BusinessOperationEmployeesPayload employeesPayload = new BusinessOperationEmployeesPayload();
                employeesPayload.setName(qxbGetEmployeeDTO.getName());
                employeesPayload.setTitle(qxbGetEmployeeDTO.getTitle());
                employeesPayload.setIsHistory(qxbGetEmployeeDTO.getIs_history());
                return employeesPayload;
            }).collect(Collectors.toList());
            this.saveEmployees(employeesList, partnerId, bookId);
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean fillQxbInfo(List<Long> keys) {
        AtomicBoolean result = new AtomicBoolean(false);
        if (!keys.isEmpty()) {
            List businessPartnerVOS = this.businessPartnerService.queryListByIds(keys);
            businessPartnerVOS.forEach(businessPartnerVO -> result.set(this.fillQxbInfo(businessPartnerVO.getPartnerName(), businessPartnerVO.getId(), businessPartnerVO.getBookId())));
        }
        return result.get();
    }

    public List<CrmFollowVO> followList(Long partnerId) {
        List<Long> oppoIds;
        if (null == partnerId) {
            return Collections.emptyList();
        }
        ArrayList<Object> followVOS = new ArrayList<Object>();
        List<Long> leadIds = this.leadsDAO.queryByFormalPartnerId(partnerId);
        if (!CollectionUtils.isEmpty(leadIds)) {
            List<Long> actIds;
            List<CrmFollowDO> leadsFollowDos = this.followDAO.queryByObjectIdsAndObjectType(leadIds, CrmFollowObjectEnum.Leads.getCode());
            followVOS.addAll(this.followService.toListVo(CrmFollowObjectEnum.Leads, leadsFollowDos));
            List<Long> activiyProjIds = this.actActivityDAO.queryByLeadsIds(leadIds);
            if (!CollectionUtils.isEmpty(activiyProjIds) && (actIds = this.actActivityDAO.queryByIds(activiyProjIds)) != null && !actIds.isEmpty()) {
                ArrayList<CrmFollowVO> activityFollowVOS = new ArrayList<CrmFollowVO>();
                List<CrmActDynamicVO> dynamicVOS = this.actActivityDAO.queryActDynamicByPrjIds(actIds);
                for (CrmActDynamicVO dynamicVO : dynamicVOS) {
                    CrmFollowVO followVO = new CrmFollowVO();
                    followVO.setCreateTime(dynamicVO.getCreateTime());
                    followVO.setCreateUserId(dynamicVO.getCreateUserId());
                    followVO.setCreateUserName(dynamicVO.getEmployeeName());
                    followVO.setFollowContent(dynamicVO.getDynamicContent());
                    followVO.setFollowObject("activity");
                    followVO.setFollowObjectDesc("\u5e02\u573a\u6d3b\u52a8");
                    followVO.setFollowType(dynamicVO.getDynamicType());
                    followVO.setFollowTypeDesc(dynamicVO.getDynamicTypeName());
                    followVO.setId(dynamicVO.getId());
                    followVO.setModifyTime(dynamicVO.getModifyTime());
                    followVO.setModifyUserId(dynamicVO.getModifyUserId());
                    activityFollowVOS.add(followVO);
                }
                followVOS.addAll(activityFollowVOS);
            }
        }
        if (!CollectionUtils.isEmpty(oppoIds = this.opportunityDAO.queryByFormalPartnerId(partnerId))) {
            List<CrmFollowDO> oppoFollowDos = this.followDAO.queryByObjectIdsAndObjectType(oppoIds, CrmFollowObjectEnum.Opportunity.getCode());
            followVOS.addAll(this.followService.toListVo(CrmFollowObjectEnum.Opportunity, oppoFollowDos));
        }
        VisitTaskQuery visitTaskQuery = new VisitTaskQuery();
        visitTaskQuery.setStatus(VisitTaskStatusEnum.OK.getCode());
        visitTaskQuery.setPartnerId(partnerId);
        OrderItem orderItem = OrderItem.desc((String)"submitTime");
        ArrayList<OrderItem> orderItemList = new ArrayList<OrderItem>();
        orderItemList.add(orderItem);
        visitTaskQuery.setOrders(orderItemList);
        List visitTaskVOS = this.visitTaskService.queryListDynamicWithoutPermission(visitTaskQuery);
        if (!CollectionUtils.isEmpty((Collection)visitTaskVOS)) {
            ArrayList<CrmFollowVO> activityFollowVOS = new ArrayList<CrmFollowVO>();
            for (VisitTaskVO visitTaskVO : visitTaskVOS) {
                CrmFollowVO followVO = new CrmFollowVO();
                followVO.setCreateTime(visitTaskVO.getSubmitTime());
                Long visitMemberId = visitTaskVO.getVisitMemberId();
                followVO.setCreateUserId(visitMemberId);
                followVO.setCreateUserName(visitTaskVO.getVisitMemberName());
                Object followContent = "";
                if (StringUtils.hasText((String)visitTaskVO.getCustomerDesc())) {
                    followContent = (String)followContent + visitTaskVO.getCustomerDesc() + "\n";
                }
                if (StringUtils.hasText((String)visitTaskVO.getResult())) {
                    followContent = (String)followContent + visitTaskVO.getResult();
                }
                followVO.setFollowContent((String)followContent);
                followVO.setFollowObject("VISIT_TASK");
                followVO.setFollowObjectDesc("\u9500\u552e\u62dc\u8bbf");
                followVO.setFollowType("task");
                followVO.setFollowTypeDesc("\u89c1\u9762\u62dc\u8bbf");
                followVO.setId(visitTaskVO.getId());
                followVO.setModifyTime(visitTaskVO.getModifyTime());
                followVO.setModifyUserId(visitTaskVO.getModifyUserId());
                activityFollowVOS.add(followVO);
            }
            followVOS.addAll(activityFollowVOS);
        }
        List<CrmFollowVO> resultList = followVOS.stream().sorted(Comparator.comparing(BaseViewModel::getCreateTime)).collect(Collectors.toList());
        return resultList;
    }

    public long countFollowList(Long partnerId) {
        List<Long> oppoIds;
        int result = 0;
        if (null == partnerId) {
            return result;
        }
        ArrayList followVOS = new ArrayList();
        List<Long> leadIds = this.leadsDAO.queryByFormalPartnerId(partnerId);
        if (!CollectionUtils.isEmpty(leadIds)) {
            List<Long> actIds;
            long leadCount = this.followDAO.countByObjectIdsAndObjectType(leadIds, CrmFollowObjectEnum.Leads.getCode());
            result = (int)((long)result + leadCount);
            List<Long> activiyProjIds = this.actActivityDAO.queryByLeadsIds(leadIds);
            if (!CollectionUtils.isEmpty(activiyProjIds) && (actIds = this.actActivityDAO.queryByIds(activiyProjIds)) != null && !actIds.isEmpty()) {
                ArrayList activityFollowVOS = new ArrayList();
                List<CrmActDynamicVO> dynamicVOS = this.actActivityDAO.queryActDynamicByPrjIds(actIds);
                result += dynamicVOS.size();
            }
        }
        if (!CollectionUtils.isEmpty(oppoIds = this.opportunityDAO.queryByFormalPartnerId(partnerId))) {
            long oppoCount = this.followDAO.countByObjectIdsAndObjectType(oppoIds, CrmFollowObjectEnum.Opportunity.getCode());
            result = (int)((long)result + oppoCount);
        }
        VisitTaskQuery visitTaskQuery = new VisitTaskQuery();
        visitTaskQuery.setStatus(VisitTaskStatusEnum.OK.getCode());
        visitTaskQuery.setPartnerId(partnerId);
        OrderItem orderItem = OrderItem.desc((String)"submitTime");
        ArrayList<OrderItem> orderItemList = new ArrayList<OrderItem>();
        orderItemList.add(orderItem);
        visitTaskQuery.setOrders(orderItemList);
        long visitTaskCount = this.visitTaskService.count(visitTaskQuery);
        result = (int)((long)result + visitTaskCount);
        return result;
    }

    public long countBusiness(Long partnerId) {
        int result = 0;
        if (null == partnerId) {
            return result;
        }
        CrmOpportunityQuery opportunityQuery = new CrmOpportunityQuery();
        opportunityQuery.setPartnerId(partnerId);
        long oppoCount = this.crmOpportunityService.count(opportunityQuery);
        result = (int)((long)result + oppoCount);
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setPartnerId(partnerId);
        long leadCount = this.crmLeadsService.countLeadByQuery(leadsQuery);
        result = (int)((long)result + leadCount);
        ContractQuery contractQuery = new ContractQuery();
        contractQuery.setPartnerId(partnerId);
        long contractCount = this.contractService.count(contractQuery);
        result = (int)((long)result + contractCount);
        return result;
    }

    public List<PartnerBusinessCountVO> businessCount(Long partnerId) {
        if (null == partnerId) {
            return Collections.emptyList();
        }
        ArrayList<PartnerBusinessCountVO> result = new ArrayList<PartnerBusinessCountVO>();
        CrmOpportunityQuery opportunityQuery = new CrmOpportunityQuery();
        opportunityQuery.setPartnerId(partnerId);
        long oppoCount = this.crmOpportunityService.count(opportunityQuery);
        result.add(new PartnerBusinessCountVO(PartnerBusinessTypeEnum.OPPO, Integer.valueOf(Long.valueOf(oppoCount).intValue())));
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setPartnerId(partnerId);
        long leadCount = this.crmLeadsService.countLeadByQuery(leadsQuery);
        result.add(new PartnerBusinessCountVO(PartnerBusinessTypeEnum.LEAD, Integer.valueOf(Long.valueOf(leadCount).intValue())));
        ContractQuery contractQuery = new ContractQuery();
        contractQuery.setPartnerId(partnerId);
        long contractCount = this.contractService.count(contractQuery);
        result.add(new PartnerBusinessCountVO(PartnerBusinessTypeEnum.CONTRACT, Integer.valueOf(Long.valueOf(contractCount).intValue())));
        return result;
    }

    private void saveEmployees(List<BusinessOperationEmployeesPayload> employeesList, Long partnerId, Long bookId) {
        if (!CollectionUtils.isEmpty(employeesList)) {
            employeesList.forEach(employeesPayload -> {
                employeesPayload.setPartnerId(partnerId);
                employeesPayload.setBookId(bookId);
                this.employeesService.insert(employeesPayload);
            });
        }
    }

    private void savePartners(List<BusinessOperationPartnerPayload> partnersList, Long partnerId, Long bookId) {
        if (!CollectionUtils.isEmpty(partnersList)) {
            partnersList.forEach(partnersPayload -> {
                partnersPayload.setPartnerId(partnerId);
                partnersPayload.setBookId(bookId);
                this.partnersService.insert(partnersPayload);
            });
        }
    }

    private void saveSites(List<BusinessOperationSitesPayload> sitesList, Long partnerId, Long bookId) {
        if (!CollectionUtils.isEmpty(sitesList)) {
            sitesList.forEach(site -> {
                site.setPartnerId(partnerId);
                site.setBookId(bookId);
                this.sitesService.insert(site);
            });
        }
    }

    private void saveEnterpriseInfo(BusinessOperationEnterpriseInfoPayload enterpriseInfo, Long partnerId, Long bookId) {
        if (null != enterpriseInfo) {
            enterpriseInfo.setPartnerId(partnerId);
            enterpriseInfo.setBookId(bookId);
            this.enterpriseInfoService.insert(enterpriseInfo);
        }
    }

    public CrmBusinessPartnerServiceImpl(BusinessOperationEnterpriseInfoService enterpriseInfoService, BusinessOperationSitesService sitesService, BusinessOperationPartnerService partnersService, BusinessOperationEmployeesService employeesService, QiXinService qiXinService, CrmFollowDAO followDAO, CrmFollowServiceImpl followService, CrmLeadsDAO leadsDAO, CrmOpportunityDAO opportunityDAO, CrmActActivityDAO actActivityDAO) {
        this.enterpriseInfoService = enterpriseInfoService;
        this.sitesService = sitesService;
        this.partnersService = partnersService;
        this.employeesService = employeesService;
        this.qiXinService = qiXinService;
        this.followDAO = followDAO;
        this.followService = followService;
        this.leadsDAO = leadsDAO;
        this.opportunityDAO = opportunityDAO;
        this.actActivityDAO = actActivityDAO;
    }
}

