/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.identity.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.partner.identity.vo.BusinessCustomerSimpleVO;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.partner.identity.convert.BusinessCustomerInfoConvert;
import com.elitesland.tw.tw5.server.partner.identity.dao.BusinessCustomerInfoDAO;
import com.elitesland.tw.tw5.server.partner.identity.entity.BusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.partner.identity.repo.BusinessCustomerInfoRepo;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5crm.api.partner.business.payload.BusinessCustomerOperationPayload;
import com.elitesland.tw.tw5crm.api.partner.business.query.BusinessCustomerOperationQuery;
import com.elitesland.tw.tw5crm.api.partner.business.service.BusinessCustomerOperationService;
import com.elitesland.tw.tw5crm.api.partner.business.vo.BusinessCustomerOperationVO;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessCustomerInfoServiceImpl
extends BaseServiceImpl
implements BusinessCustomerInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusinessCustomerInfoServiceImpl.class);
    private final BusinessCustomerInfoRepo businessCustomerInfoRepo;
    private final BusinessCustomerInfoDAO businessCustomerInfoDAO;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    @Resource
    private BusinessCustomerOperationService businessCustomerOperationService;

    public PagingVO<BusinessCustomerInfoVO> queryPaging(BusinessCustomerInfoQuery query) {
        return this.businessCustomerInfoDAO.queryPaging(query);
    }

    public List<BusinessCustomerInfoVO> queryListDynamic(BusinessCustomerInfoQuery query) {
        return this.businessCustomerInfoDAO.queryListDynamic(query);
    }

    public BusinessCustomerInfoVO queryByKey(Long key) {
        BusinessCustomerInfoDO entity = this.businessCustomerInfoRepo.findById(key).orElseGet(BusinessCustomerInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerInfoVO vo = BusinessCustomerInfoConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerInfoVO insert(BusinessCustomerInfoPayload payload) {
        BusinessCustomerInfoDO entityDo = BusinessCustomerInfoConvert.INSTANCE.toDo(payload);
        BusinessCustomerInfoDO save = (BusinessCustomerInfoDO)this.businessCustomerInfoRepo.save(entityDo);
        return BusinessCustomerInfoConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerInfoVO update(BusinessCustomerInfoPayload payload) {
        BusinessCustomerInfoDO entity = this.businessCustomerInfoRepo.findById(payload.getId()).orElseGet(BusinessCustomerInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerInfoDO entityLog = new BusinessCustomerInfoDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessCustomerInfoDO entityDo = BusinessCustomerInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (null != payload.getPartnerId()) {
            StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
            fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
                this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
        }
        BusinessCustomerInfoDO save = (BusinessCustomerInfoDO)this.businessCustomerInfoRepo.save(entity);
        Long partnerId = save.getPartnerId();
        if (save.getIsOperate() != null && save.getIsOperate().booleanValue()) {
            String custGrade = payload.getCustGrade();
            if (StringUtils.hasText((String)custGrade)) {
                BusinessCustomerOperationQuery operationQuery = new BusinessCustomerOperationQuery();
                operationQuery.setPartnerId(partnerId);
                List businessCustomerOperationVOS = this.businessCustomerOperationService.queryListDynamic(operationQuery);
                if (CollectionUtils.isEmpty((Collection)businessCustomerOperationVOS)) {
                    BusinessCustomerOperationPayload operationPayload = new BusinessCustomerOperationPayload();
                    operationPayload.setPartnerId(partnerId);
                    operationPayload.setCustGrade(custGrade);
                    this.businessCustomerOperationService.insert(operationPayload);
                } else {
                    BusinessCustomerOperationVO businessCustomerOperationVO = (BusinessCustomerOperationVO)businessCustomerOperationVOS.get(0);
                    BusinessCustomerOperationPayload operationPayload = new BusinessCustomerOperationPayload();
                    operationPayload.setId(businessCustomerOperationVO.getId());
                    operationPayload.setPartnerId(partnerId);
                    operationPayload.setCustGrade(custGrade);
                    this.businessCustomerOperationService.update(operationPayload);
                }
                this.businessCustomerOperationService.initOpertionPlanCommon(custGrade, partnerId);
            } else {
                BusinessCustomerOperationQuery operationQuery = new BusinessCustomerOperationQuery();
                operationQuery.setPartnerId(save.getPartnerId());
                List businessCustomerOperationVOS = this.businessCustomerOperationService.queryListDynamic(operationQuery);
                if (!CollectionUtils.isEmpty((Collection)businessCustomerOperationVOS)) {
                    BusinessCustomerOperationVO businessCustomerOperationVO = (BusinessCustomerOperationVO)businessCustomerOperationVOS.get(0);
                    custGrade = businessCustomerOperationVO.getCustGrade();
                    this.businessCustomerOperationService.initOpertionPlanCommon(custGrade, partnerId);
                }
            }
        }
        return BusinessCustomerInfoConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessCustomerInfoRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessCustomerInfoDO entity = (BusinessCustomerInfoDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessCustomerInfoRepo.save(entity);
                }
            });
        }
    }

    public List<BusinessCustomerSimpleVO> listSimple(String identity) {
        return this.businessCustomerInfoDAO.listSimple(identity);
    }

    public CrmCustomerSimpleVO listSimpleByPartnerId(Long partnerId) {
        return this.businessCustomerInfoDAO.listSimpleByPartnerId(partnerId);
    }

    public List<BusinessStrategyCustomerVO> queryCustomerList(BusinessPartnerQuery query) {
        return this.businessCustomerInfoDAO.queryCustomerList(query);
    }

    public void updateCustomerGrade() {
        this.businessCustomerInfoDAO.updateCustomerGrade();
    }

    public BusinessCustomerInfoServiceImpl(BusinessCustomerInfoRepo businessCustomerInfoRepo, BusinessCustomerInfoDAO businessCustomerInfoDAO, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService) {
        this.businessCustomerInfoRepo = businessCustomerInfoRepo;
        this.businessCustomerInfoDAO = businessCustomerInfoDAO;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
    }
}

