/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.strategy.service;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.partner.strategy.payload.BusinessStrategyGradeSettingPayload;
import com.elitesland.tw.tw5.api.partner.strategy.payload.BusinessStrategyIndexRecordPayload;
import com.elitesland.tw.tw5.api.partner.strategy.payload.BusinessStrategyPayload;
import com.elitesland.tw.tw5.api.partner.strategy.query.BusinessModelIndexQuery;
import com.elitesland.tw.tw5.api.partner.strategy.query.BusinessModelIndexSettingQuery;
import com.elitesland.tw.tw5.api.partner.strategy.query.BusinessStrategyQuery;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessModelIndexService;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessModelIndexSettingService;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessStrategyGradeSettingService;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessStrategyIndexRecordService;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessStrategyIndexSettingService;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessStrategyModelService;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessStrategyRangeSettingService;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessStrategyRefService;
import com.elitesland.tw.tw5.api.partner.strategy.service.BusinessStrategyService;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessModelIndexSettingVO;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessModelIndexVO;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessStrategyGradeSettingVO;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessStrategyIndexModelRefVO;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessStrategyIndexRecordVO;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessStrategyVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.partner.constants.BusinessStrategyRangeEnum;
import com.elitesland.tw.tw5.server.partner.strategy.convert.BusinessStrategyConvert;
import com.elitesland.tw.tw5.server.partner.strategy.dao.BusinessStrategyDAO;
import com.elitesland.tw.tw5.server.partner.strategy.entity.BusinessStrategyDO;
import com.elitesland.tw.tw5.server.partner.strategy.repo.BusinessStrategyRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5crm.api.contract.query.ContractQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractVO;
import com.elitesland.tw.tw5crm.server.common.constants.BusinessCutomizeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.BusinessModelDateEnum;
import com.elitesland.tw.tw5crm.server.common.constants.BusinessStrategyIndexEnum;
import com.elitesland.tw.tw5crm.server.common.constants.BusinessStrategyStatusEnum;
import com.elitesland.tw.tw5crm.server.common.constants.CustomerGradeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.SearchScopeEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BusinessStrategyServiceImpl
extends BaseServiceImpl
implements BusinessStrategyService {
    private static final Logger log = LoggerFactory.getLogger(BusinessStrategyServiceImpl.class);
    private final BusinessStrategyRepo businessStrategyRepo;
    private final BusinessStrategyDAO businessStrategyDAO;
    private final BusinessStrategyRangeSettingService businessStrategyRangeSettingService;
    private final BusinessStrategyRefService businessStrategyRefService;
    private final BusinessStrategyIndexSettingService businessStrategyIndexSettingService;
    private final BusinessStrategyGradeSettingService businessStrategyGradeSettingService;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final CacheUtil cacheUtil;
    private final BusinessStrategyModelService businessStrategyModelService;
    private final BusinessModelIndexService businessModelIndexService;
    private final BusinessModelIndexSettingService businessModelIndexSettingService;
    private final ContractService contractService;
    private final BusinessStrategyIndexRecordService businessStrategyIndexRecordService;

    public PagingVO<BusinessStrategyVO> queryPaging(BusinessStrategyQuery query) {
        return this.businessStrategyDAO.queryPaging(query);
    }

    public List<BusinessStrategyVO> queryListDynamic(BusinessStrategyQuery query) {
        return this.businessStrategyDAO.queryListDynamic(query);
    }

    public BusinessStrategyVO queryByKey(Long key) {
        StringBuilder stringBuilder;
        BusinessStrategyDO entity = this.businessStrategyRepo.findById(key).orElseGet(BusinessStrategyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessStrategyVO vo = BusinessStrategyConvert.INSTANCE.toVo(entity);
        Long strategyId = vo.getId();
        if (BusinessStrategyRangeEnum.CUSTOMIZE.getCode().equals(vo.getStrategyRange())) {
            List businessStrategyRangeSettingVOS = this.businessStrategyRangeSettingService.queryListByStrategyId(strategyId);
            vo.setStrategyRangeSettingList(businessStrategyRangeSettingVOS);
            stringBuilder = new StringBuilder();
            businessStrategyRangeSettingVOS.stream().forEach(businessStrategyRangeSettingVO -> {
                String desc = SearchScopeEnum.valueOf(businessStrategyRangeSettingVO.getSearchScope()).getDesc();
                stringBuilder.append(businessStrategyRangeSettingVO.getFieldName() + desc + businessStrategyRangeSettingVO.getExt1() + "\u3001");
            });
            if (stringBuilder.length() > 0) {
                vo.setStrategyRangeDetail(stringBuilder.substring(0, stringBuilder.length() - 1));
            }
        }
        if (BusinessStrategyRangeEnum.APPOINT.getCode().equals(vo.getStrategyRange())) {
            List businessStrategyRefVOS = this.businessStrategyRefService.queryListByStrategyId(strategyId);
            stringBuilder = new StringBuilder("");
            businessStrategyRefVOS.stream().forEach(businessStrategyRefVO -> stringBuilder.append(businessStrategyRefVO.getPartnerName() + "\u3001"));
            if (stringBuilder.length() > 0) {
                vo.setStrategyRangeDetail(stringBuilder.substring(0, stringBuilder.length() - 1));
            }
            vo.setStrategyBusinessRefList(this.businessStrategyRefService.queryListByStrategyId(strategyId));
        }
        vo.setStrategyIndexList(this.businessStrategyIndexSettingService.queryListByStrategyId(strategyId));
        vo.setStrategyGradeList(this.businessStrategyGradeSettingService.queryListByStrategyId(strategyId));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(BusinessStrategyPayload payload) {
        Boolean rangFlag = false;
        String oldStrategyRange = "";
        Long strategyId = payload.getId();
        BusinessStrategyQuery query = new BusinessStrategyQuery();
        if (strategyId != null) {
            query.setStrategyPriority(payload.getStrategyPriority());
            businessStrategyVOS = this.queryListDynamic(query);
            if (!CollectionUtils.isEmpty(businessStrategyVOS)) {
                if (businessStrategyVOS.size() > 1) {
                    throw TwException.error((String)"", (String)"\u5b58\u5728\u76f8\u540c\u4f18\u5148\u7ea7\u7684\u7b56\u7565\uff0c\u8bf7\u4fee\u6539\u4f18\u5148\u7ea7\u540e\u4fdd\u5b58");
                }
                if (!businessStrategyVOS.get(0).getId().equals(payload.getId())) {
                    throw TwException.error((String)"", (String)"\u5b58\u5728\u76f8\u540c\u4f18\u5148\u7ea7\u7684\u7b56\u7565\uff0c\u8bf7\u4fee\u6539\u4f18\u5148\u7ea7\u540e\u4fdd\u5b58");
                }
            }
            BusinessStrategyDO entity = this.businessStrategyRepo.findById(payload.getId()).orElseGet(BusinessStrategyDO::new);
            Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
            if (!entity.getStrategyRange().equals(payload.getStrategyRange())) {
                rangFlag = true;
                oldStrategyRange = entity.getStrategyRange();
            }
            BusinessStrategyDO entityDo = BusinessStrategyConvert.INSTANCE.toDo(payload);
            entity.copy(entityDo);
            this.businessStrategyRepo.save(entity);
        } else {
            query.setStrategyPriority(payload.getStrategyPriority());
            businessStrategyVOS = this.queryListDynamic(query);
            if (!CollectionUtils.isEmpty(businessStrategyVOS)) {
                throw TwException.error((String)"", (String)"\u5b58\u5728\u76f8\u540c\u4f18\u5148\u7ea7\u7684\u7b56\u7565\uff0c\u8bf7\u4fee\u6539\u4f18\u5148\u7ea7\u540e\u4fdd\u5b58");
            }
            BusinessStrategyDO entityDo = BusinessStrategyConvert.INSTANCE.toDo(payload);
            BusinessStrategyDO save = (BusinessStrategyDO)this.businessStrategyRepo.save(entityDo);
            strategyId = save.getId();
        }
        Long id = strategyId;
        if (BusinessStrategyRangeEnum.CUSTOMIZE.getCode().equals(payload.getStrategyRange()) && !CollectionUtils.isEmpty((Collection)payload.getStrategyRangeSettingList())) {
            this.businessStrategyRangeSettingService.deleteSoftByStrategyId(strategyId);
            payload.getStrategyRangeSettingList().stream().forEach(strategyRangeSettingPayload -> {
                strategyRangeSettingPayload.setStrategyId(id);
                if (!StringUtils.isEmpty((CharSequence)strategyRangeSettingPayload.getSearchCondition())) {
                    this.businessStrategyRangeSettingService.insert(strategyRangeSettingPayload);
                }
            });
        }
        if (BusinessStrategyRangeEnum.APPOINT.getCode().equals(payload.getStrategyRange()) && !CollectionUtils.isEmpty((Collection)payload.getStrategyBusinessRefList())) {
            this.businessStrategyRefService.deleteSoftByStrategyId(strategyId);
            payload.getStrategyBusinessRefList().forEach(strategyBusinessRefPayLoad -> {
                strategyBusinessRefPayLoad.setStrategyId(id);
                this.businessStrategyRefService.insert(strategyBusinessRefPayLoad);
            });
        }
        if (rangFlag.booleanValue() && BusinessStrategyRangeEnum.CUSTOMIZE.getCode().equals(oldStrategyRange)) {
            this.businessStrategyRangeSettingService.deleteSoftByStrategyId(id);
        }
        if (rangFlag.booleanValue() && BusinessStrategyRangeEnum.APPOINT.getCode().equals(oldStrategyRange)) {
            this.businessStrategyRefService.deleteSoftByStrategyId(id);
        }
        if (CollectionUtils.isEmpty((Collection)payload.getStrategyIndexList())) {
            log.error("\u5206\u7ea7\u7b56\u7565\u7684\u6307\u6807\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            throw TwException.error((String)"", (String)"\u5206\u7ea7\u7b56\u7565\u7684\u6307\u6807\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.businessStrategyIndexSettingService.deleteByStrategyId(id);
        payload.getStrategyIndexList().forEach(strategyIndexPayload -> {
            strategyIndexPayload.setStrategyId(id);
            this.businessStrategyIndexSettingService.insert(strategyIndexPayload);
        });
        List strategyGradePayLoadList = payload.getStrategyGradeList();
        if (CollectionUtils.isEmpty((Collection)strategyGradePayLoadList)) {
            log.error("\u5206\u7ea7\u7b56\u7565\u7684\u7b49\u7ea7\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            throw TwException.error((String)"", (String)"\u5206\u7ea7\u7b56\u7565\u7684\u7b49\u7ea7\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkStrategyGrade(strategyGradePayLoadList);
        strategyGradePayLoadList.forEach(strategyGradePayLoad -> {
            if (strategyGradePayLoad.getId() != null) {
                this.businessStrategyGradeSettingService.update(strategyGradePayLoad);
            } else {
                strategyGradePayLoad.setStrategyId(id);
                this.businessStrategyGradeSettingService.insert(strategyGradePayLoad);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessStrategyVO update(BusinessStrategyPayload payload) {
        BusinessStrategyDO entity = this.businessStrategyRepo.findById(payload.getId()).orElseGet(BusinessStrategyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessStrategyDO entityDo = BusinessStrategyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessStrategyConvert.INSTANCE.toVo((BusinessStrategyDO)this.businessStrategyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessStrategyPayload payload) {
        BusinessStrategyDO entity = this.businessStrategyRepo.findById(payload.getId()).orElseGet(BusinessStrategyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessStrategyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.businessStrategyRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessStrategyDO entity = (BusinessStrategyDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.businessStrategyRepo.save(entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStrategyStatus(List<Long> keys, String strategyStatus) {
        if (!keys.isEmpty()) {
            Long count;
            if (BusinessStrategyStatusEnum.OPEN.getCode().equals(strategyStatus) && (count = this.businessStrategyIndexSettingService.quertDeleteModelCountByStrategyIds(keys)) > 0L) {
                throw TwException.error((String)"", (String)"\u6a21\u578b\u88ab\u5220\u9664\uff0c\u8bf7\u5728\u7f16\u8f91\u4e2d\u91cd\u65b0\u9009\u62e9\u6a21\u578b\u540e\u518d\u8fdb\u884c\u542f\u7528");
            }
            keys.stream().forEach(id -> {
                Optional optional = this.businessStrategyRepo.findById(id);
                if (!optional.isEmpty()) {
                    BusinessStrategyDO entity = (BusinessStrategyDO)optional.get();
                    entity.setStrategyStatus(strategyStatus);
                    this.businessStrategyRepo.save(entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void businessStrategyJobHandler() {
        this.businessCustomerInfoService.updateCustomerGrade();
        List<BusinessStrategyVO> businessStrategyVOList = this.businessStrategyDAO.queryStraegyJobHandler();
        if (CollectionUtils.isEmpty(businessStrategyVOList)) {
            log.error("\u5206\u7ea7\u7b56\u7565\u672a\u914d\u7f6e");
            return;
        }
        for (BusinessStrategyVO businessStrategyVO : businessStrategyVOList) {
            List businessCustomerInfoVOS;
            Long strategyId = businessStrategyVO.getId();
            List<BusinessStrategyIndexModelRefVO> strategyIndexModelRefData = this.getStrategyData(strategyId);
            List strategyGradeData = this.businessStrategyGradeSettingService.queryListByStrategyId(strategyId);
            if (StringUtils.isEmpty((CharSequence)businessStrategyVO.getStrategyRange())) continue;
            if (BusinessStrategyRangeEnum.ALL.getCode().equals(businessStrategyVO.getStrategyRange()) && !CollectionUtils.isEmpty((Collection)(businessCustomerInfoVOS = this.businessCustomerInfoService.queryCustomerList(new BusinessPartnerQuery())))) {
                this.dealData(businessCustomerInfoVOS, strategyIndexModelRefData, strategyGradeData, strategyId);
            }
            if (BusinessStrategyRangeEnum.APPOINT.getCode().equals(businessStrategyVO.getStrategyRange()) && !CollectionUtils.isEmpty((Collection)(businessCustomerInfoVOS = this.businessStrategyRefService.queryAppointCustomerInfoByStrategyId(strategyId)))) {
                this.dealData(businessCustomerInfoVOS, strategyIndexModelRefData, strategyGradeData, strategyId);
            }
            if (!BusinessStrategyRangeEnum.CUSTOMIZE.getCode().equals(businessStrategyVO.getStrategyRange())) continue;
            List businessStrategyRangeSettingVOS = this.businessStrategyRangeSettingService.queryListByStrategyId(strategyId);
            BusinessPartnerQuery businessPartnerQuery = new BusinessPartnerQuery();
            ArrayList countryList = new ArrayList();
            ArrayList industryList = new ArrayList();
            ArrayList natureList = new ArrayList();
            businessStrategyRangeSettingVOS.stream().forEach(vo -> {
                if (BusinessCutomizeEnum.COUNTRY.getCode().equals(vo.getFieldKey())) {
                    countryList.add(vo.getSearchCondition());
                }
                if (BusinessCutomizeEnum.INDUSTRY.getCode().equals(vo.getFieldKey())) {
                    industryList.add(vo.getSearchCondition());
                }
                if (BusinessCutomizeEnum.NATURE.getCode().equals(vo.getFieldKey())) {
                    natureList.add(vo.getSearchCondition());
                }
            });
            businessPartnerQuery.setCountryList(countryList);
            businessPartnerQuery.setPartnerIndustryList(industryList);
            businessPartnerQuery.setPartnerNatureList(natureList);
            List businessCustomerInfoVOS2 = this.businessCustomerInfoService.queryCustomerList(businessPartnerQuery);
            if (CollectionUtils.isEmpty((Collection)businessCustomerInfoVOS2)) continue;
            this.dealData(businessCustomerInfoVOS2, strategyIndexModelRefData, strategyGradeData, strategyId);
        }
    }

    public void dealData(List<BusinessStrategyCustomerVO> businessCustomerInfoVOS, List<BusinessStrategyIndexModelRefVO> strategyIndexModelRefData, List<BusinessStrategyGradeSettingVO> strategyGradeData, Long strategyId) {
        if (!CollectionUtils.isEmpty(businessCustomerInfoVOS)) {
            BusinessCustomerInfoPayload payload = new BusinessCustomerInfoPayload();
            businessCustomerInfoVOS.forEach(vo -> {
                Map map = this.countCustomerGrade(strategyIndexModelRefData, (BusinessStrategyCustomerVO)vo, strategyGradeData, strategyId);
                payload.setId(vo.getId());
                payload.setCustomerGradle((String)map.get("gradleType"));
                payload.setStrategyId(strategyId);
                payload.setScore((BigDecimal)map.get("score"));
                payload.setPartnerId(vo.getPartnerId());
                String list = JSONUtil.toJsonStr(map.get("list"));
                payload.setIndexInfo(list);
                this.businessCustomerInfoService.update(payload);
            });
        }
    }

    public List<BusinessStrategyIndexModelRefVO> getStrategyData(Long strategyId) {
        List businessStrategyIndexModelRefVOS = this.businessStrategyIndexSettingService.queryIndexModelRef(strategyId);
        businessStrategyIndexModelRefVOS.stream().forEach(vo -> {
            if (vo.getStandaryFlag().booleanValue()) {
                vo.setBusinessModelIndexVOList(this.businessStrategyModelService.findRfmSettingByDate(vo.getDateRange()));
                if (!CollectionUtils.isEmpty((Collection)vo.getBusinessModelIndexVOList())) {
                    vo.getBusinessModelIndexVOList().forEach(indexVO -> {
                        if (BusinessStrategyIndexEnum.R.getCode().equals(indexVO.getSourceField())) {
                            indexVO.setWeight(vo.getRWeight());
                        }
                        if (BusinessStrategyIndexEnum.F.getCode().equals(indexVO.getSourceField())) {
                            indexVO.setWeight(vo.getFWeight());
                        }
                        if (BusinessStrategyIndexEnum.M.getCode().equals(indexVO.getSourceField())) {
                            indexVO.setWeight(vo.getMWeight());
                        }
                    });
                }
            } else {
                BusinessModelIndexQuery businessModelIndexQuery = new BusinessModelIndexQuery();
                businessModelIndexQuery.setModelId(vo.getModelId());
                List businessModelIndexVOS = this.businessModelIndexService.queryListDynamic(businessModelIndexQuery);
                BusinessModelIndexSettingQuery businessModelIndexSettingQuery = new BusinessModelIndexSettingQuery();
                businessModelIndexVOS.stream().forEach(businessModelIndexVO -> {
                    businessModelIndexSettingQuery.setIndexId(businessModelIndexVO.getId());
                    businessModelIndexVO.setBusinessModelIndexSettingVOList(this.businessModelIndexSettingService.queryListDynamic(businessModelIndexSettingQuery));
                });
                vo.setBusinessModelIndexVOList(businessModelIndexVOS);
            }
        });
        return businessStrategyIndexModelRefVOS;
    }

    public Map countCustomerGrade(List<BusinessStrategyIndexModelRefVO> businessStrategyIndexModelRefVOS, BusinessStrategyCustomerVO businessStrategyCustomerVO, List<BusinessStrategyGradeSettingVO> strategyGradeDataList, Long strategyId) {
        BigDecimal endScore = BigDecimal.ZERO;
        ArrayList<BusinessStrategyIndexRecordVO> list = new ArrayList<BusinessStrategyIndexRecordVO>();
        for (BusinessStrategyIndexModelRefVO vo : businessStrategyIndexModelRefVOS) {
            BigDecimal score = BigDecimal.ZERO;
            if (vo.getStandaryFlag().booleanValue()) {
                LocalDateTime createTimeStart = BusinessModelDateEnum.YEAR.getCode().equals(vo.getDateRange()) ? LocalDateTime.of(LocalDate.now(), LocalTime.MIN).minusYears(1L) : LocalDateTime.of(LocalDate.now(), LocalTime.MIN).minusMonths(6L);
                score = score.add(this.dealStandardModel(vo, businessStrategyCustomerVO.getPartnerId(), createTimeStart));
            } else {
                score = score.add(this.dealNotStandardModel(vo, businessStrategyCustomerVO));
            }
            BigDecimal indexScore = score.multiply(new BigDecimal(vo.getIndexWeight()).divide(new BigDecimal("100"))).setScale(2, RoundingMode.HALF_UP);
            BusinessStrategyIndexRecordPayload payload = new BusinessStrategyIndexRecordPayload();
            payload.setCustomerId(businessStrategyCustomerVO.getId());
            payload.setStrategyId(strategyId);
            payload.setPartnerId(businessStrategyCustomerVO.getPartnerId());
            payload.setIndexName(vo.getIndexName());
            payload.setIndexWeight(vo.getIndexWeight());
            payload.setIndexScore(indexScore);
            this.businessStrategyIndexRecordService.insert(payload);
            BusinessStrategyIndexRecordVO businessStrategyIndexRecordVO = new BusinessStrategyIndexRecordVO();
            businessStrategyIndexRecordVO.setCustomerId(businessStrategyCustomerVO.getId());
            businessStrategyIndexRecordVO.setStrategyId(strategyId);
            businessStrategyIndexRecordVO.setPartnerId(businessStrategyCustomerVO.getPartnerId());
            businessStrategyIndexRecordVO.setIndexName(vo.getIndexName());
            businessStrategyIndexRecordVO.setIndexWeight(vo.getIndexWeight());
            businessStrategyIndexRecordVO.setIndexScore(indexScore);
            list.add(businessStrategyIndexRecordVO);
            endScore = endScore.add(indexScore);
        }
        String gradleType = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("score", endScore);
        map.put("gradleType", gradleType);
        map.put("list", list);
        for (BusinessStrategyGradeSettingVO strategyData : strategyGradeDataList) {
            if (strategyData.getScoreStart().compareTo(endScore) > 0 || strategyData.getScoreEnd().compareTo(endScore) < 0) continue;
            gradleType = strategyData.getGradleType();
            map.put("gradleType", gradleType);
            break;
        }
        return map;
    }

    public BigDecimal dealStandardModel(BusinessStrategyIndexModelRefVO businessStrategyIndexModelRefVO, Long partnerId, LocalDateTime createTimeStart) {
        ContractQuery query = new ContractQuery();
        query.setCreateTimeStart(createTimeStart);
        query.setPartnerId(partnerId);
        query.setDataPermissionFlag(Boolean.valueOf(false));
        List contractVOS = this.contractService.contractSaleCount(query);
        BigDecimal score = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)contractVOS)) {
            Integer size = contractVOS.size();
            BigDecimal contractTotalAmount = BigDecimal.ZERO;
            LocalDateTime time = createTimeStart;
            for (ContractVO contractVO : contractVOS) {
                contractTotalAmount = contractTotalAmount.add(contractVO.getContractAmount());
                if (time.compareTo(contractVO.getCreateTime()) >= 0) continue;
                time = contractVO.getCreateTime();
            }
            int months = Period.between(time.toLocalDate(), LocalDate.now()).getMonths();
            List businessModelIndexVOList = businessStrategyIndexModelRefVO.getBusinessModelIndexVOList();
            block1: for (BusinessModelIndexVO vo : businessModelIndexVOList) {
                List businessModelIndexSettingVOList;
                if (BusinessStrategyIndexEnum.R.getCode().equals(vo.getSourceField())) {
                    businessModelIndexSettingVOList = vo.getBusinessModelIndexSettingVOList();
                    for (BusinessModelIndexSettingVO indexSettingVO : businessModelIndexSettingVOList) {
                        if (Integer.valueOf(indexSettingVO.getExt2()).compareTo(months) > 0 || !StringUtils.isEmpty((CharSequence)indexSettingVO.getExt3()) && Integer.valueOf(indexSettingVO.getExt3()).compareTo(months) <= 0) continue;
                        score = score.add(indexSettingVO.getOptionScore().multiply(vo.getWeight().divide(new BigDecimal("100"))));
                        break;
                    }
                }
                if (BusinessStrategyIndexEnum.F.getCode().equals(vo.getSourceField())) {
                    businessModelIndexSettingVOList = vo.getBusinessModelIndexSettingVOList();
                    for (BusinessModelIndexSettingVO indexSettingVO : businessModelIndexSettingVOList) {
                        if (Integer.valueOf(indexSettingVO.getExt2()).compareTo(size) > 0 || !StringUtils.isEmpty((CharSequence)indexSettingVO.getExt3()) && Integer.valueOf(indexSettingVO.getExt3()).compareTo(size) < 0) continue;
                        score = score.add(indexSettingVO.getOptionScore().multiply(vo.getWeight().divide(new BigDecimal("100"))));
                        break;
                    }
                }
                if (!BusinessStrategyIndexEnum.M.getCode().equals(vo.getSourceField())) continue;
                businessModelIndexSettingVOList = vo.getBusinessModelIndexSettingVOList();
                for (BusinessModelIndexSettingVO indexSettingVO : businessModelIndexSettingVOList) {
                    if (new BigDecimal(indexSettingVO.getExt2()).compareTo(contractTotalAmount) > 0 || !StringUtils.isEmpty((CharSequence)indexSettingVO.getExt3()) && new BigDecimal(indexSettingVO.getExt3()).compareTo(contractTotalAmount) <= 0) continue;
                    score = score.add(indexSettingVO.getOptionScore().multiply(vo.getWeight().divide(new BigDecimal("100"))));
                    continue block1;
                }
            }
        }
        return score;
    }

    public BigDecimal dealNotStandardModel(BusinessStrategyIndexModelRefVO vo, BusinessStrategyCustomerVO businessStrategyCustomerVO) {
        List businessModelIndexVOList = vo.getBusinessModelIndexVOList();
        BigDecimal score = BigDecimal.ZERO;
        for (BusinessModelIndexVO indexVO : businessModelIndexVOList) {
            BigDecimal indexScore;
            if (BusinessStrategyIndexEnum.businessStrategy.getCode().equals(indexVO.getSourceField())) {
                String businessStrategy = businessStrategyCustomerVO.getBusinessStrategy();
                indexScore = this.dealNotStandaryIndexDetail(indexVO.getBusinessModelIndexSettingVOList(), businessStrategy);
                score = score.add(indexScore.multiply(indexVO.getWeight().divide(new BigDecimal("100"))));
            }
            if (BusinessStrategyIndexEnum.companyTightness.getCode().equals(indexVO.getSourceField())) {
                String companyTightness = businessStrategyCustomerVO.getCompanyTightness();
                indexScore = this.dealNotStandaryIndexDetail(indexVO.getBusinessModelIndexSettingVOList(), companyTightness);
                score = score.add(indexScore.multiply(indexVO.getWeight().divide(new BigDecimal("100"))));
            }
            if (BusinessStrategyIndexEnum.organizationScale.getCode().equals(indexVO.getSourceField())) {
                String organizationScale = businessStrategyCustomerVO.getOrganizationScale();
                indexScore = this.dealNotStandaryIndexDetail(indexVO.getBusinessModelIndexSettingVOList(), organizationScale);
                score = score.add(indexScore.multiply(indexVO.getWeight().divide(new BigDecimal("100"))));
            }
            if (BusinessStrategyIndexEnum.industryStand.getCode().equals(indexVO.getSourceField())) {
                String industryStand = businessStrategyCustomerVO.getIndustryStand();
                indexScore = this.dealNotStandaryIndexDetail(indexVO.getBusinessModelIndexSettingVOList(), industryStand);
                score = score.add(indexScore.multiply(indexVO.getWeight().divide(new BigDecimal("100"))));
            }
            if (!BusinessStrategyIndexEnum.partnerNature.getCode().equals(indexVO.getSourceField())) continue;
            String partnerNature = businessStrategyCustomerVO.getPartnerNature();
            indexScore = this.dealNotStandaryIndexDetail(indexVO.getBusinessModelIndexSettingVOList(), partnerNature);
            score = score.add(indexScore.multiply(indexVO.getWeight().divide(new BigDecimal("100"))));
        }
        return score;
    }

    public BigDecimal dealNotStandaryIndexDetail(List<BusinessModelIndexSettingVO> businessModelIndexSettingVOList, String sourceFileValue) {
        BigDecimal indexScore = BigDecimal.ZERO;
        for (BusinessModelIndexSettingVO indexSettingVO : businessModelIndexSettingVOList) {
            if (!indexSettingVO.getSourceFiledOption().equals(sourceFileValue)) continue;
            indexScore = indexSettingVO.getOptionScore();
            break;
        }
        return indexScore;
    }

    public void checkStrategyGrade(List<BusinessStrategyGradeSettingPayload> payloadList) {
        HashMap map = new HashMap();
        payloadList.stream().forEach(payload -> map.put(payload.getGradleType(), payload));
        if (((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.E.getCode())).getScoreStart().compareTo(BigDecimal.ZERO) != 0) {
            log.error("E\u7b49\u7ea7\u5206\u6570\u914d\u7f6e\u9700\u4ece0\u5f00\u59cb");
            throw TwException.error((String)"", (String)"E\u7b49\u7ea7\u5206\u6570\u914d\u7f6e\u9700\u4ece0\u5f00\u59cb");
        }
        if (((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.S.getCode())).getScoreEnd().compareTo(new BigDecimal("100")) != 0) {
            log.error("S\u7b49\u7ea7\u5206\u6570\u914d\u7f6e\u6700\u5927\u503c\u5e94\u4e3a100");
            throw TwException.error((String)"", (String)"S\u7b49\u7ea7\u5206\u6570\u914d\u7f6e\u6700\u5927\u503c\u5e94\u4e3a100");
        }
        if (((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.E.getCode())).getScoreEnd().compareTo(((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.D.getCode())).getScoreStart()) != 0) {
            log.error("E\u7684\u6700\u5927\u503c\u5e94\u7b49\u4e8eD\u7684\u6700\u5c0f\u503c");
            throw TwException.error((String)"", (String)"E\u7684\u6700\u5927\u503c\u5e94\u7b49\u4e8eD\u7684\u6700\u5c0f\u503c");
        }
        if (((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.D.getCode())).getScoreEnd().compareTo(((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.C.getCode())).getScoreStart()) != 0) {
            log.error("D\u7684\u6700\u5927\u503c\u5e94\u7b49\u4e8eC\u7684\u6700\u5c0f\u503c");
            throw TwException.error((String)"", (String)"D\u7684\u6700\u5927\u503c\u5e94\u7b49\u4e8eC\u7684\u6700\u5c0f\u503c");
        }
        if (((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.C.getCode())).getScoreEnd().compareTo(((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.B.getCode())).getScoreStart()) != 0) {
            log.error("C\u7684\u6700\u5927\u503c\u5e94\u7b49\u4e8eB\u7684\u6700\u5c0f\u503c");
            throw TwException.error((String)"", (String)"C\u7684\u6700\u5927\u503c\u5e94\u7b49\u4e8eB\u7684\u6700\u5c0f\u503c");
        }
        if (((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.B.getCode())).getScoreEnd().compareTo(((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.A.getCode())).getScoreStart()) != 0) {
            log.error("B\u7684\u6700\u5927\u503c\u5e94\u7b49\u4e8eA\u7684\u6700\u5c0f\u503c");
            throw TwException.error((String)"", (String)"B\u7684\u6700\u5927\u503c\u5e94\u7b49\u4e8eA\u7684\u6700\u5c0f\u503c");
        }
        if (((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.A.getCode())).getScoreEnd().compareTo(((BusinessStrategyGradeSettingPayload)map.get(CustomerGradeEnum.S.getCode())).getScoreStart()) != 0) {
            log.error("A\u7684\u6700\u5927\u503c\u5e94\u7b49\u4e8eS\u7684\u6700\u5c0f\u503c");
            throw TwException.error((String)"", (String)"A\u7684\u6700\u5927\u503c\u5e94\u7b49\u4e8eS\u7684\u6700\u5c0f\u503c");
        }
    }

    public BusinessStrategyServiceImpl(BusinessStrategyRepo businessStrategyRepo, BusinessStrategyDAO businessStrategyDAO, BusinessStrategyRangeSettingService businessStrategyRangeSettingService, BusinessStrategyRefService businessStrategyRefService, BusinessStrategyIndexSettingService businessStrategyIndexSettingService, BusinessStrategyGradeSettingService businessStrategyGradeSettingService, BusinessCustomerInfoService businessCustomerInfoService, CacheUtil cacheUtil, BusinessStrategyModelService businessStrategyModelService, BusinessModelIndexService businessModelIndexService, BusinessModelIndexSettingService businessModelIndexSettingService, ContractService contractService, BusinessStrategyIndexRecordService businessStrategyIndexRecordService) {
        this.businessStrategyRepo = businessStrategyRepo;
        this.businessStrategyDAO = businessStrategyDAO;
        this.businessStrategyRangeSettingService = businessStrategyRangeSettingService;
        this.businessStrategyRefService = businessStrategyRefService;
        this.businessStrategyIndexSettingService = businessStrategyIndexSettingService;
        this.businessStrategyGradeSettingService = businessStrategyGradeSettingService;
        this.businessCustomerInfoService = businessCustomerInfoService;
        this.cacheUtil = cacheUtil;
        this.businessStrategyModelService = businessStrategyModelService;
        this.businessModelIndexService = businessModelIndexService;
        this.businessModelIndexSettingService = businessModelIndexSettingService;
        this.contractService = contractService;
        this.businessStrategyIndexRecordService = businessStrategyIndexRecordService;
    }
}

