/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustOperInfoSysPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustOperInfoSysQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustOperInfoSysService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustOperInfoSysVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustOperInfoSysConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustOperInfoSysDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustOperInfoSysDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustOperInfoSysRepo;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmCustOperInfoSysServiceImpl
implements CrmCustOperInfoSysService {
    private static final Logger log = LoggerFactory.getLogger(CrmCustOperInfoSysServiceImpl.class);
    private final CrmCustOperInfoSysRepo infoSysRepo;
    private final PrdSystemLogService logService;
    private final CrmCustOperInfoSysDAO infoSysDAO;

    @Transactional(rollbackFor={Exception.class})
    public void save(CrmCustOperInfoSysPayload payload) {
        CrmCustOperInfoSysDO saveDO;
        String name;
        if (StringUtils.isBlank((CharSequence)payload.getSysType())) {
            throw new BusinessException("\u7cfb\u7edf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)payload.getSysName())) {
            throw new BusinessException("\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)payload.getBelongCompany())) {
            throw new BusinessException("\u7cfb\u7edf\u6240\u5c5e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (payload.getId() == null) {
            name = PrdSystemLogEnum.CREATE.getDesc();
            saveDO = (CrmCustOperInfoSysDO)this.infoSysRepo.save(CrmCustOperInfoSysConvert.INSTANCE.toDo(payload));
        } else {
            name = PrdSystemLogEnum.UPDATE.getDesc();
            CrmCustOperInfoSysDO infoSysDO = (CrmCustOperInfoSysDO)this.infoSysRepo.findById(payload.getId()).orElseThrow(new BusinessException("\u6839\u636eid" + payload.getId() + "\u672a\u67e5\u8be2\u5230\u6570\u636e"));
            CrmCustOperInfoSysConvert.INSTANCE.copy(payload, infoSysDO);
            saveDO = (CrmCustOperInfoSysDO)this.infoSysRepo.save(infoSysDO);
        }
        this.logService.saveNewLog(saveDO.getOperId(), PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), name + PrdSystemObjectEnum.CUSTOMER_OPERATION_INFO_SYS.getDesc());
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(long id) {
        Optional optional = this.infoSysRepo.findById(id);
        this.infoSysRepo.deleteById(id);
        this.logService.saveNewLog(((CrmCustOperInfoSysDO)optional.get()).getOperId(), PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), PrdSystemLogEnum.DELETE.getDesc() + PrdSystemObjectEnum.CUSTOMER_OPERATION_INFO_SYS.getDesc());
    }

    public PagingVO<CrmCustOperInfoSysVO> paging(CrmCustOperInfoSysQuery query) {
        if (query.getOperId() == null) {
            throw TwException.error((String)"", (String)"operId\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        return this.infoSysDAO.paging(query);
    }

    public CrmCustOperInfoSysServiceImpl(CrmCustOperInfoSysRepo infoSysRepo, PrdSystemLogService logService, CrmCustOperInfoSysDAO infoSysDAO) {
        this.infoSysRepo = infoSysRepo;
        this.logService = logService;
        this.infoSysDAO = infoSysDAO;
    }
}

