/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanTempPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanTempDetailService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanTempService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanTempVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOperationPlanTempConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOperationPlanTempDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOperationPlanTempRepo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CrmOperationPlanTempServiceImpl
implements CrmOperationPlanTempService {
    private static final Logger log = LoggerFactory.getLogger(CrmOperationPlanTempServiceImpl.class);
    private final CrmOperationPlanTempRepo repo;
    private final CrmOperationPlanTempDetailService detailService;

    @Transactional(rollbackFor={Exception.class})
    public CrmOperationPlanTempVO insert(CrmOperationPlanTempPayload payload) {
        if (StringUtils.isEmpty((CharSequence)payload.getCustGrade())) {
            throw TwException.error((String)"", (String)"\u7ea7\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CrmOperationPlanTempQuery query = new CrmOperationPlanTempQuery();
        query.setCustGrade(payload.getCustGrade());
        if (this.count(query) > 0L) {
            throw TwException.error((String)"", (String)"\u91cd\u590d\u6570\u636e");
        }
        CrmOperationPlanTempDO entityDo = CrmOperationPlanTempConvert.INSTANCE.toDo(payload);
        this.repo.save((Object)entityDo);
        if (!CollectionUtils.isEmpty((Collection)payload.getDetailList())) {
            payload.getDetailList().forEach(crmOperationPlanTempDetailPayload -> crmOperationPlanTempDetailPayload.setTempId(entityDo.getId()));
            this.detailService.saveAll(payload.getDetailList());
        }
        return CrmOperationPlanTempConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmOperationPlanTempVO update(CrmOperationPlanTempPayload payload) {
        CrmOperationPlanTempDO entity = this.repo.findById(payload.getId()).orElseGet(CrmOperationPlanTempDO::new);
        Long tempId = entity.getId();
        Assert.notNull((Object)tempId, (String)"\u4e0d\u5b58\u5728");
        CrmOperationPlanTempDO entityDo = CrmOperationPlanTempConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        CrmOperationPlanTempDO save = (CrmOperationPlanTempDO)((Object)this.repo.save((Object)entity));
        this.detailService.deleteSoftByTempId(tempId);
        if (!CollectionUtils.isEmpty((Collection)payload.getDetailList())) {
            payload.getDetailList().forEach(crmOperationPlanTempDetailPayload -> crmOperationPlanTempDetailPayload.setTempId(entityDo.getId()));
            this.detailService.saveAll(payload.getDetailList());
        }
        return CrmOperationPlanTempConvert.INSTANCE.toVo(save);
    }

    public CrmOperationPlanTempVO queryByKey(Long key) {
        CrmOperationPlanTempDO entity = this.repo.findById(key).orElseGet(CrmOperationPlanTempDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmOperationPlanTempVO crmCustomerOperationVO = CrmOperationPlanTempConvert.INSTANCE.toVo(entity);
        CrmOperationPlanTempDetailQuery planTempDetailQuery = new CrmOperationPlanTempDetailQuery();
        planTempDetailQuery.setTempId(key);
        List planTempDetailVOList = this.detailService.queryList(planTempDetailQuery);
        crmCustomerOperationVO.setDetailList(planTempDetailVOList);
        return crmCustomerOperationVO;
    }

    public List<CrmOperationPlanTempVO> queryList(CrmOperationPlanTempQuery query) {
        return CrmOperationPlanTempConvert.INSTANCE.toVoList(this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder)));
    }

    public long count(CrmOperationPlanTempQuery query) {
        return this.repo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder));
    }

    public PagingVO<CrmOperationPlanTempVO> paging(CrmOperationPlanTempQuery query) {
        Page page = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo((Page)page.map(CrmOperationPlanTempConvert.INSTANCE::toVo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.repo.findById(id);
                if (!optional.isEmpty()) {
                    CrmOperationPlanTempDO entity = (CrmOperationPlanTempDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.repo.save((Object)entity);
                }
            });
        }
    }

    public CrmOperationPlanTempServiceImpl(CrmOperationPlanTempRepo repo, CrmOperationPlanTempDetailService detailService) {
        this.repo = repo;
        this.detailService = detailService;
    }
}

