/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.bid.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.bid.payload.BidCostRecordsPayload;
import com.elitesland.tw.tw5crm.api.bid.query.BidCostRecordsQuery;
import com.elitesland.tw.tw5crm.api.bid.vo.BidCostRecordsVO;
import com.elitesland.tw.tw5crm.server.bid.entity.BidCostRecordsDO;
import com.elitesland.tw.tw5crm.server.bid.entity.QBidCostRecordsDO;
import com.elitesland.tw.tw5crm.server.bid.entity.QBidDO;
import com.elitesland.tw.tw5crm.server.bid.repo.BidCostRecordsRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BidCostRecordsDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BidCostRecordsRepo repo;
    private final QBidCostRecordsDO qdo = QBidCostRecordsDO.bidCostRecordsDO;
    private final QBidDO qBidDO = QBidDO.bidDO;

    private JPAQuery<BidCostRecordsVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BidCostRecordsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.bidId, this.qdo.costType, this.qdo.costAmount, this.qdo.payee, this.qdo.whetherRefund, this.qdo.refundAmount})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBidDO)).on((Predicate)this.qBidDO.id.longValue().eq(this.qdo.bidId));
    }

    private JPAQuery<BidCostRecordsVO> getJpaQueryWhere(BidCostRecordsQuery query) {
        JPAQuery<BidCostRecordsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(BidCostRecordsQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BidCostRecordsQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBidId())) {
            list.add(this.qdo.bidId.eq((Object)query.getBidId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostType())) {
            list.add(this.qdo.costType.eq((Object)query.getCostType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostAmount())) {
            list.add(this.qdo.costAmount.eq((Object)query.getCostAmount()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayee())) {
            list.add(this.qdo.payee.eq((Object)query.getPayee()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWhetherRefund())) {
            list.add(this.qdo.whetherRefund.eq(query.getWhetherRefund()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRefundAmount())) {
            list.add(this.qdo.refundAmount.eq((Object)query.getRefundAmount()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BidCostRecordsVO queryByKey(Long id) {
        JPAQuery<BidCostRecordsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BidCostRecordsVO)jpaQuery.fetchFirst();
    }

    public List<BidCostRecordsVO> queryListDynamic(BidCostRecordsQuery query) {
        JPAQuery<BidCostRecordsVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<BidCostRecordsVO> queryPaging(BidCostRecordsQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BidCostRecordsVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BidCostRecordsDO save(BidCostRecordsDO ado) {
        return (BidCostRecordsDO)this.repo.save(ado);
    }

    public List<BidCostRecordsDO> saveAll(List<BidCostRecordsDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BidCostRecordsPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBidId() != null) {
            update.set(this.qdo.bidId, (Object)payload.getBidId());
        }
        if (payload.getCostType() != null) {
            update.set((Path)this.qdo.costType, (Object)payload.getCostType());
        }
        if (payload.getCostAmount() != null) {
            update.set(this.qdo.costAmount, (Object)payload.getCostAmount());
        }
        if (payload.getPayee() != null) {
            update.set((Path)this.qdo.payee, (Object)payload.getPayee());
        }
        if (payload.getWhetherRefund() != null) {
            update.set((Path)this.qdo.whetherRefund, (Object)payload.getWhetherRefund());
        }
        if (payload.getRefundAmount() != null) {
            update.set(this.qdo.refundAmount, (Object)payload.getRefundAmount());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("bidId")) {
                update.setNull(this.qdo.bidId);
            }
            if (nullFields.contains("costType")) {
                update.setNull((Path)this.qdo.costType);
            }
            if (nullFields.contains("costAmount")) {
                update.setNull(this.qdo.costAmount);
            }
            if (nullFields.contains("payee")) {
                update.setNull((Path)this.qdo.payee);
            }
            if (nullFields.contains("whetherRefund")) {
                update.setNull((Path)this.qdo.whetherRefund);
            }
            if (nullFields.contains("refundAmount")) {
                update.setNull(this.qdo.refundAmount);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<BidCostRecordsVO> queryCostRecordsByBidKey(Long bidKey) {
        JPAQuery<BidCostRecordsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qBidDO.id.longValue().eq((Object)bidKey));
        return jpaQuery.fetch();
    }

    public BidCostRecordsDAO(JPAQueryFactory jpaQueryFactory, BidCostRecordsRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

