/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.bid.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5crm.api.bid.payload.BidOpeningDetailsPayload;
import com.elitesland.tw.tw5crm.api.bid.query.BidOpeningDetailsQuery;
import com.elitesland.tw.tw5crm.api.bid.service.BidOpeningDetailsService;
import com.elitesland.tw.tw5crm.api.bid.vo.BidOpeningDetailsVO;
import com.elitesland.tw.tw5crm.server.bid.convert.BidOpeningDetailsConvert;
import com.elitesland.tw.tw5crm.server.bid.dao.BidOpeningDetailsDAO;
import com.elitesland.tw.tw5crm.server.bid.entity.BidOpeningDetailsDO;
import com.elitesland.tw.tw5crm.server.bid.repo.BidOpeningDetailsRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BidOpeningDetailsServiceImpl
extends BaseServiceImpl
implements BidOpeningDetailsService {
    private static final Logger log = LoggerFactory.getLogger(BidOpeningDetailsServiceImpl.class);
    private final BidOpeningDetailsRepo bidOpeningDetailsRepo;
    private final BidOpeningDetailsDAO bidOpeningDetailsDAO;
    private final PrdSystemLogService logService;

    public PagingVO<BidOpeningDetailsVO> queryPaging(BidOpeningDetailsQuery query) {
        return this.bidOpeningDetailsDAO.queryPaging(query);
    }

    public List<BidOpeningDetailsVO> queryListDynamic(BidOpeningDetailsQuery query) {
        return this.bidOpeningDetailsDAO.queryListDynamic(query);
    }

    public BidOpeningDetailsVO queryByKey(Long key) {
        BidOpeningDetailsDO entity = this.bidOpeningDetailsRepo.findById(key).orElseGet(BidOpeningDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BidOpeningDetailsVO vo = BidOpeningDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BidOpeningDetailsVO insert(BidOpeningDetailsPayload payload) {
        BidOpeningDetailsDO entityDo = BidOpeningDetailsConvert.INSTANCE.toDo(payload);
        String changeLog = "\u521b\u5efa\u4e00\u6761\u5f00\u6807\u660e\u7ec6";
        this.logService.saveNewLog(payload.getBidId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog);
        return BidOpeningDetailsConvert.INSTANCE.toVo((BidOpeningDetailsDO)this.bidOpeningDetailsRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BidOpeningDetailsVO update(BidOpeningDetailsPayload payload) {
        BidOpeningDetailsDO entity = this.bidOpeningDetailsRepo.findById(payload.getId()).orElseGet(BidOpeningDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BidOpeningDetailsDO entityDo = BidOpeningDetailsConvert.INSTANCE.toDo(payload);
        String changeLog = "\u4fee\u6539\u4e00\u6761\u5f00\u6807\u660e\u7ec6";
        this.logService.saveNewLog(payload.getBidId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog);
        entity.copy(entityDo);
        return BidOpeningDetailsConvert.INSTANCE.toVo((BidOpeningDetailsDO)this.bidOpeningDetailsRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.bidOpeningDetailsRepo.findById(id);
                if (!optional.isEmpty()) {
                    BidOpeningDetailsDO entity = (BidOpeningDetailsDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.bidOpeningDetailsRepo.save(entity);
                    String changeLog = "\u5220\u9664\u4e00\u6761\u5f00\u6807\u660e\u7ec6";
                    this.logService.saveNewLog(entity.getBidId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog);
                }
            });
        }
    }

    public List<BidOpeningDetailsVO> queryOpeningDetailsByBidKey(Long bidKey) {
        return this.bidOpeningDetailsDAO.queryOpeningDetailsByBidKey(bidKey);
    }

    public BidOpeningDetailsServiceImpl(BidOpeningDetailsRepo bidOpeningDetailsRepo, BidOpeningDetailsDAO bidOpeningDetailsDAO, PrdSystemLogService logService) {
        this.bidOpeningDetailsRepo = bidOpeningDetailsRepo;
        this.bidOpeningDetailsDAO = bidOpeningDetailsDAO;
        this.logService = logService;
    }
}

