/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractCollectionPlanPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractCollectionPlanQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractCollectionPlanService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractCollectionPlanSimpleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5408\u540c\u7ba1\u7406-\u5408\u540c\u6536\u6b3e\u8ba1\u5212"})
@RestController
@RequestMapping(value={"/api/crm/contract/collectionPlan"})
public class ContractCollectionPlanController {
    private static final Logger log = LoggerFactory.getLogger(ContractCollectionPlanController.class);
    private final ContractCollectionPlanService contractCollectionPlanService;

    @PostMapping
    @ApiOperation(value="\u6536\u6b3e\u8ba1\u5212-\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody ContractCollectionPlanPayload payload) {
        return TwOutputUtil.ok((Object)this.contractCollectionPlanService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u6536\u6b3e\u8ba1\u5212-\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody ContractCollectionPlanPayload payload) {
        return TwOutputUtil.ok((Object)this.contractCollectionPlanService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u6536\u6b3e\u8ba1\u5212-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.contractCollectionPlanService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u6536\u6b3e\u8ba1\u5212-\u5206\u9875")
    public TwOutputUtil paging(ContractCollectionPlanQuery query) {
        return TwOutputUtil.ok((Object)this.contractCollectionPlanService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u6536\u6b3e\u8ba1\u5212-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(ContractCollectionPlanQuery query) {
        return TwOutputUtil.ok((Object)this.contractCollectionPlanService.queryListDynamic(query));
    }

    @GetMapping(value={"/listSimple"})
    @ApiOperation(value="\u6536\u6b3e\u8ba1\u5212\u4e0b\u62c9\u9009\u62e9")
    public TwOutputUtil<List<ContractCollectionPlanSimpleVO>> listSimple(ContractCollectionPlanQuery query) {
        return TwOutputUtil.ok((Object)this.contractCollectionPlanService.queryListDynamicSimple(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u6536\u6b3e\u8ba1\u5212-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.contractCollectionPlanService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/queryListByPlanId"})
    @UdcNameClass
    @ApiOperation(value="\u901a\u8fc7\u6536\u6b3e\u8ba1\u5212id\u67e5\u8be2\u6536\u6b3e\u8ba1\u5212\u660e\u7ec6")
    public TwOutputUtil<ContractCollectionPlanSimpleVO> queryListByPlanId(@RequestBody JSONObject jsonObject) {
        String id = jsonObject.getString("id");
        String[] planIdArray = id.split(",");
        List planIdList = Arrays.stream(planIdArray).map(planId -> Long.valueOf(planId)).collect(Collectors.toList());
        List contractCollectionPlanSimpleVOList = this.contractCollectionPlanService.queryListByplanId(planIdList);
        return TwOutputUtil.ok((Object)contractCollectionPlanSimpleVOList);
    }

    public ContractCollectionPlanController(ContractCollectionPlanService contractCollectionPlanService) {
        this.contractCollectionPlanService = contractCollectionPlanService;
    }
}

