/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractReceiveDetailsPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractReceiveDetailsQuery;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractReceiveDetailsVO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractReceiveDetailsDO;
import com.elitesland.tw.tw5crm.server.contract.entity.QContractReceiveDetailsDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractReceiveDetailsRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class ContractReceiveDetailsDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ContractReceiveDetailsRepo repo;
    private final QContractReceiveDetailsDO qdo = QContractReceiveDetailsDO.contractReceiveDetailsDO;

    private JPAQuery<ContractReceiveDetailsVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ContractReceiveDetailsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.contractId, this.qdo.contractName, this.qdo.planId, this.qdo.phase, this.qdo.customerId, this.qdo.customerName, this.qdo.saleDutyId, this.qdo.receiveMoney, this.qdo.saleDutyName})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ContractReceiveDetailsVO> getJpaQueryWhere(ContractReceiveDetailsQuery query) {
        JPAQuery<ContractReceiveDetailsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(ContractReceiveDetailsQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(ContractReceiveDetailsQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getReceiveAccountId())) {
            list.add(this.qdo.receiveAccountId.eq((Object)query.getReceiveAccountId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractId())) {
            list.add(this.qdo.contractId.eq((Object)query.getContractId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractName())) {
            list.add(this.qdo.contractName.like(SqlUtil.toSqlLikeString((String)query.getContractName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanId())) {
            list.add(this.qdo.planId.eq((Object)query.getPlanId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPhase())) {
            list.add(this.qdo.phase.like(SqlUtil.toSqlLikeString((String)query.getPhase())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerId())) {
            list.add(this.qdo.customerId.eq((Object)query.getCustomerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerName())) {
            list.add(this.qdo.customerName.like(SqlUtil.toSqlLikeString((String)query.getCustomerName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleDutyId())) {
            list.add(this.qdo.saleDutyId.eq((Object)query.getSaleDutyId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiveMoney())) {
            list.add(this.qdo.receiveMoney.eq((Object)query.getReceiveMoney()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleDutyName())) {
            list.add(this.qdo.saleDutyName.eq((Object)query.getSaleDutyName()));
        }
        if (query.getSaleDutyIds() != null && query.getSaleDutyIds().size() > 0) {
            list.add(this.qdo.saleDutyId.in((Collection)query.getSaleDutyIds()));
        }
        return ExpressionUtils.allOf(list);
    }

    public ContractReceiveDetailsVO queryByKey(Long id) {
        JPAQuery<ContractReceiveDetailsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ContractReceiveDetailsVO)jpaQuery.fetchFirst();
    }

    public List<ContractReceiveDetailsVO> queryListDynamic(ContractReceiveDetailsQuery query) {
        JPAQuery<ContractReceiveDetailsVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<ContractReceiveDetailsVO> queryPaging(ContractReceiveDetailsQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<ContractReceiveDetailsVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public ContractReceiveDetailsDO save(ContractReceiveDetailsDO ado) {
        return (ContractReceiveDetailsDO)this.repo.save(ado);
    }

    public List<ContractReceiveDetailsDO> saveAll(List<ContractReceiveDetailsDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(ContractReceiveDetailsPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        List nullFields = payload.getNullFields();
        if (nullFields == null || nullFields.size() > 0) {
            // empty if block
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public BigDecimal queryTotalReceiveMoneyByPlanId(Long planId) {
        BigDecimal totalReceiveMoney = (BigDecimal)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.receiveMoney.sum()).from((EntityPath)this.qdo)).where((Predicate)this.qdo.planId.eq((Object)planId))).fetchOne();
        if (totalReceiveMoney == null) {
            totalReceiveMoney = BigDecimal.ZERO;
        }
        return totalReceiveMoney;
    }

    public ContractReceiveDetailsDAO(JPAQueryFactory jpaQueryFactory, ContractReceiveDetailsRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

