/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.contract.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5crm.api.contract.payload.ContractReceiveDetailsPayload;
import com.elitesland.tw.tw5crm.api.contract.query.ContractReceiveDetailsQuery;
import com.elitesland.tw.tw5crm.api.contract.service.ContractReceiveDetailsService;
import com.elitesland.tw.tw5crm.api.contract.vo.ContractReceiveDetailsVO;
import com.elitesland.tw.tw5crm.server.contract.convert.ContractReceiveDetailsConvert;
import com.elitesland.tw.tw5crm.server.contract.dao.ContractReceiveDetailsDAO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractDO;
import com.elitesland.tw.tw5crm.server.contract.entity.ContractReceiveDetailsDO;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractReceiveDetailsRepo;
import com.elitesland.tw.tw5crm.server.contract.repo.ContractRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ContractReceiveDetailsServiceImpl
extends BaseServiceImpl
implements ContractReceiveDetailsService {
    private static final Logger log = LoggerFactory.getLogger(ContractReceiveDetailsServiceImpl.class);
    private final ContractReceiveDetailsRepo contractReceiveDetailsRepo;
    private final ContractReceiveDetailsDAO contractReceiveDetailsDAO;
    private final ContractRepo contractRepo;

    public PagingVO<ContractReceiveDetailsVO> queryPaging(ContractReceiveDetailsQuery query) {
        return this.contractReceiveDetailsDAO.queryPaging(query);
    }

    public List<ContractReceiveDetailsVO> queryListDynamic(ContractReceiveDetailsQuery query) {
        return this.contractReceiveDetailsDAO.queryListDynamic(query);
    }

    public ContractReceiveDetailsVO queryByKey(Long key) {
        ContractReceiveDetailsDO entity = this.contractReceiveDetailsRepo.findById(key).orElseGet(ContractReceiveDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u6536\u6b3e\u660e\u7ec6\u4e0d\u5b58\u5728");
        ContractReceiveDetailsVO vo = ContractReceiveDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractReceiveDetailsVO insert(ContractReceiveDetailsPayload payload) {
        ContractDO contractDO = this.contractRepo.findById(payload.getContractId()).orElseGet(ContractDO::new);
        payload.setCustomerName(contractDO.getCustomerName());
        payload.setSaleDutyId(contractDO.getSaleDutyId());
        ContractReceiveDetailsDO entityDo = ContractReceiveDetailsConvert.INSTANCE.toDo(payload);
        return ContractReceiveDetailsConvert.INSTANCE.toVo((ContractReceiveDetailsDO)this.contractReceiveDetailsRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ContractReceiveDetailsVO update(ContractReceiveDetailsPayload payload) {
        ContractReceiveDetailsDO entity = this.contractReceiveDetailsRepo.findById(payload.getId()).orElseGet(ContractReceiveDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u6536\u6b3e\u660e\u7ec6\u4e0d\u5b58\u5728");
        ContractReceiveDetailsDO entityDo = ContractReceiveDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ContractReceiveDetailsConvert.INSTANCE.toVo((ContractReceiveDetailsDO)this.contractReceiveDetailsRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.contractReceiveDetailsRepo.findById(id);
                if (!optional.isEmpty()) {
                    ContractReceiveDetailsDO entity = (ContractReceiveDetailsDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.contractReceiveDetailsRepo.save(entity);
                }
            });
        }
    }

    public ContractReceiveDetailsServiceImpl(ContractReceiveDetailsRepo contractReceiveDetailsRepo, ContractReceiveDetailsDAO contractReceiveDetailsDAO, ContractRepo contractRepo) {
        this.contractReceiveDetailsRepo = contractReceiveDetailsRepo;
        this.contractReceiveDetailsDAO = contractReceiveDetailsDAO;
        this.contractRepo = contractRepo;
    }
}

