/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.handover.service;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.api.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsPayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.partner.common.dao.BookAddressDAO;
import com.elitesland.tw.tw5.server.partner.team.dao.BusinessTeamMemberDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5crm.api.handover.query.HandoverQuery;
import com.elitesland.tw.tw5crm.api.handover.service.HandoverService;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverAllTypeVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryBusPartnerVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryLeadsVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryOpportunityVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverTotalTatVo;
import com.elitesland.tw.tw5crm.server.common.handover.HandOverEnum;
import com.elitesland.tw.tw5crm.server.common.handover.HandOverRoleEnum;
import com.elitesland.tw.tw5crm.server.common.util.BusinessPartnerUtils;
import com.elitesland.tw.tw5crm.server.handover.dao.HandoverDao;
import com.elitesland.tw.tw5crm.server.handover.dao.HandoverRecordDAO;
import com.elitesland.tw.tw5crm.server.handover.entity.HandoverRecordDO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class HandoverServiceImpl
implements HandoverService {
    private static final Logger log = LoggerFactory.getLogger(HandoverServiceImpl.class);
    private final HandoverDao handoverDao;
    private final HandoverRecordDAO handoverRecordDAO;
    private final CacheUtil cacheUtil;
    private final BookAddressDAO bookAddressDAO;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final CrmLeadsDAO crmLeadsDAO;
    private final CrmOpportunityDAO crmOpportunityDAO;
    private final BusinessTeamMemberDAO businessTeamMemberDAO;

    public List<HandoverQueryLeadsVO> queryHaveLeads(HandoverQuery query) {
        List<HandoverQueryLeadsVO> handoverQueryLeadsVOS = this.handoverDao.queryHaveLeads(query);
        if (CollectionUtil.isEmpty(handoverQueryLeadsVOS)) {
            return null;
        }
        handoverQueryLeadsVOS.stream().forEach(item -> {
            item.setSaleUserName(this.cacheUtil.getUserName(item.getSaleUserId()));
            item.setCurrentUserRole(HandOverRoleEnum.SALEROLE.getCode());
            item.setCurrentUserRoleDesc(HandOverRoleEnum.SALEROLE.getName());
            item.setPartnerIndustryDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), item.getPartnerIndustry()));
            item.setDemandProductDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), item.getDemandProduct()));
            item.setObjType(HandOverEnum.LEADSTYPE.getCode());
            item.setFormUserId(item.getSaleUserId());
            item.setFormUserName(this.cacheUtil.getUserName(item.getSaleUserId()));
        });
        return handoverQueryLeadsVOS;
    }

    public List<HandoverQueryOpportunityVO> queryHaveOpportunity(HandoverQuery query) {
        List<HandoverQueryOpportunityVO> opportunityVOS = this.handoverDao.queryHaveOpportunity(query);
        if (CollectionUtil.isEmpty(opportunityVOS)) {
            return null;
        }
        ArrayList<HandoverQueryOpportunityVO> result = new ArrayList<HandoverQueryOpportunityVO>();
        opportunityVOS.stream().forEach(item -> {
            HandoverQueryOpportunityVO op;
            item.setObjType(HandOverEnum.OPPORTUNITYTYPE.getCode());
            item.setOppoLevelDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoLevel.getCode(), item.getOppoLevel()));
            item.setProbabilityDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmProbability.getCode(), item.getProbability()));
            item.setSalePhaseDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmSalePhase.getCode(), item.getSalePhase()));
            item.setPartnerIndustryDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), item.getPartnerIndustry()));
            item.setProjectStatusDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), item.getProjectStatus()));
            if (item.getPreSaleUserId() != null && item.getPreSaleUserId().equals(query.getUserId())) {
                item.setFormUserId(item.getPreSaleUserId());
                item.setFormUserName(this.cacheUtil.getUserName(item.getPreSaleUserId()));
                item.setCurrentUserRole(HandOverRoleEnum.PRESALESROLE.getCode());
                item.setCurrentUserRoleDesc(HandOverRoleEnum.PRESALESROLE.getName());
                op = new HandoverQueryOpportunityVO();
                BeanUtils.copyProperties((Object)item, (Object)op);
                result.add(op);
            }
            if (item.getDeliUserId() != null && item.getDeliUserId().equals(query.getUserId())) {
                item.setFormUserId(item.getDeliUserId());
                item.setFormUserName(this.cacheUtil.getUserName(item.getDeliUserId()));
                item.setCurrentUserRole(HandOverRoleEnum.DELIVERROLE.getCode());
                item.setCurrentUserRoleDesc(HandOverRoleEnum.DELIVERROLE.getName());
                op = new HandoverQueryOpportunityVO();
                BeanUtils.copyProperties((Object)item, (Object)op);
                result.add(op);
            }
            if (item.getSaleUserId() != null && item.getSaleUserId().equals(query.getUserId())) {
                item.setFormUserId(item.getSaleUserId());
                item.setFormUserName(this.cacheUtil.getUserName(item.getSaleUserId()));
                item.setCurrentUserRole(HandOverRoleEnum.SALEROLE.getCode());
                item.setCurrentUserRoleDesc(HandOverRoleEnum.SALEROLE.getName());
                op = new HandoverQueryOpportunityVO();
                BeanUtils.copyProperties((Object)item, (Object)op);
                result.add(op);
            }
        });
        return result;
    }

    public List<HandoverQueryBusPartnerVO> queryHaveBusPartner(HandoverQuery query) {
        List<HandoverQueryBusPartnerVO> busPartnerVOS = this.handoverDao.queryHaveBusPartner(query);
        if (CollectionUtil.isEmpty(busPartnerVOS)) {
            return null;
        }
        List<Long> bookIds = busPartnerVOS.stream().map(HandoverQueryBusPartnerVO::getBookId).collect(Collectors.toList());
        List<BookAddressVO> bookAddressVOS = this.bookAddressDAO.queryAddressByBookId(bookIds);
        Map<Long, BookAddressVO> bookMap = bookAddressVOS.stream().collect(Collectors.toMap(BookAddressVO::getBookId, a -> a, (k1, k2) -> k1));
        busPartnerVOS.stream().forEach(item -> {
            item.setPartnerIdentityDesc(BusinessPartnerUtils.transIdentity(item.getPartnerIdentity()));
            item.setCurrentUserRoleDesc(BusinessTeamRoleEnum.queryDescByCode((String)item.getCurrentUserRole()));
            item.setFormUserName(this.cacheUtil.getUserName(item.getFormUserId()));
            item.setObjType(HandOverEnum.BUSPARTNERTYPE.getCode());
            BookAddressVO bk = (BookAddressVO)bookMap.get(item.getBookId());
            if (bk != null) {
                String pr = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), bk.getProvince());
                String p = StringUtils.isBlank((CharSequence)pr) ? "-" : pr;
                String ci = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), bk.getCity());
                String c = StringUtils.isBlank((CharSequence)ci) ? "-" : ci;
                String di = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), bk.getDistrict());
                String t = StringUtils.isBlank((CharSequence)di) ? "-" : di;
                item.setAddress(p + "/" + c + "/" + t);
            }
        });
        return busPartnerVOS;
    }

    public PagingVO<HandoverTotalTatVo> queryTotalTatList(HandoverQuery query) {
        PagingVO<PrdOrgEmployeeVO> paging = this.handoverDao.queryUserPaging(query);
        List records = paging.getRecords();
        ArrayList tempRecord = new ArrayList();
        records.stream().forEach(item -> {
            query.setUserId(item.getUserId());
            HandoverTotalTatVo totalTatVo = new HandoverTotalTatVo();
            totalTatVo.setUserId(item.getUserId());
            totalTatVo.setEmployeeId(item.getId());
            totalTatVo.setUserName(this.cacheUtil.getUserName(item.getUserId()));
            totalTatVo.setRecordFlag("0");
            long l = this.handoverRecordDAO.queryRecordCount(item.getUserId());
            if (l > 0L) {
                totalTatVo.setRecordFlag("1");
            }
            List<HandoverQueryLeadsVO> leads = this.queryHaveLeads(query);
            totalTatVo.setLeadsvos(leads);
            totalTatVo.setLeadsNum(Integer.valueOf(CollectionUtil.isNotEmpty(leads) ? leads.size() : 0));
            List<HandoverQueryOpportunityVO> oppos = this.queryHaveOpportunity(query);
            totalTatVo.setOppovos(oppos);
            totalTatVo.setOpportunityNum(Integer.valueOf(CollectionUtil.isNotEmpty(oppos) ? oppos.size() : 0));
            List<HandoverQueryBusPartnerVO> bus = this.queryHaveBusPartner(query);
            totalTatVo.setBuspartvos(bus);
            totalTatVo.setBusPartnerNum(Integer.valueOf(CollectionUtil.isNotEmpty(bus) ? bus.size() : 0));
            tempRecord.add(totalTatVo);
        });
        PagingVO result = new PagingVO();
        result.setTotal(paging.getTotal());
        result.setRecords(tempRecord);
        return result;
    }

    @Transactional(rollbackOn={Exception.class})
    public int handoverActive(List<HandoverAllTypeVO> handovers) {
        for (HandoverAllTypeVO member : handovers) {
            if (HandOverEnum.LEADSTYPE.getCode().equals(member.getObjType())) {
                CrmLeadsPayload crmLeadsPayload = new CrmLeadsPayload();
                crmLeadsPayload.setId(member.getId());
                crmLeadsPayload.setSaleUserId(member.getToUserId());
                this.crmLeadsDAO.updateByKeyDynamic(crmLeadsPayload);
            }
            if (HandOverEnum.OPPORTUNITYTYPE.getCode().equals(member.getObjType())) {
                this.crmOpportunityDAO.updateHeadUserId(member);
            }
            if (!HandOverEnum.BUSPARTNERTYPE.getCode().equals(member.getObjType())) continue;
            BusinessTeamMemberPayload payload = new BusinessTeamMemberPayload();
            payload.setId(member.getTeamMemberId());
            payload.setUserId(member.getToUserId());
            payload.setMemberName(this.cacheUtil.getUserName(member.getToUserId()));
            this.businessTeamMemberDAO.updateByKeyDynamic(payload);
        }
        List<HandoverRecordDO> handoverRecordDOS = this.assemblyAndSave(handovers);
        return handoverRecordDOS.size();
    }

    private List<HandoverRecordDO> assemblyAndSave(List<HandoverAllTypeVO> handovers) {
        ArrayList<HandoverRecordDO> result = new ArrayList<HandoverRecordDO>();
        handovers.stream().forEach(member -> {
            HandoverRecordDO aDo = new HandoverRecordDO();
            aDo.setFormUserId(member.getFormUserId());
            aDo.setFormUserName(member.getFormUserName());
            aDo.setToUserId(member.getToUserId());
            aDo.setToUserName(member.getToUserName());
            aDo.setObjId(member.getId());
            aDo.setObjType(member.getObjType());
            aDo.setTableCloumValue(member.getCurrentUserRoleDesc());
            aDo.setPartnerName(member.getPartnerName());
            aDo.setPartnerPhone(member.getPartnerPhone());
            aDo.setPartnerIndustry(member.getPartnerIndustryDesc());
            aDo.setOperateUserId(GlobalUtil.getLoginUserId());
            aDo.setOperateUserName(GlobalUtil.getLoginUserName());
            result.add(aDo);
        });
        return this.handoverRecordDAO.saveAll(result);
    }

    public HandoverServiceImpl(HandoverDao handoverDao, HandoverRecordDAO handoverRecordDAO, CacheUtil cacheUtil, BookAddressDAO bookAddressDAO, PrdOrgEmployeeService prdOrgEmployeeService, CrmLeadsDAO crmLeadsDAO, CrmOpportunityDAO crmOpportunityDAO, BusinessTeamMemberDAO businessTeamMemberDAO) {
        this.handoverDao = handoverDao;
        this.handoverRecordDAO = handoverRecordDAO;
        this.cacheUtil = cacheUtil;
        this.bookAddressDAO = bookAddressDAO;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.crmLeadsDAO = crmLeadsDAO;
        this.crmOpportunityDAO = crmOpportunityDAO;
        this.businessTeamMemberDAO = businessTeamMemberDAO;
    }
}

