/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sample.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5crm.api.sample.payload.SampleDetailsPayload;
import com.elitesland.tw.tw5crm.api.sample.query.SampleDetailsQuery;
import com.elitesland.tw.tw5crm.api.sample.service.SampleDetailsService;
import com.elitesland.tw.tw5crm.api.sample.vo.SampleDetailsVO;
import com.elitesland.tw.tw5crm.server.sample.convert.SampleDetailsConvert;
import com.elitesland.tw.tw5crm.server.sample.dao.SampleDetailsDAO;
import com.elitesland.tw.tw5crm.server.sample.entity.SampleDetailsDO;
import com.elitesland.tw.tw5crm.server.sample.repo.SampleDetailsRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SampleDetailsServiceImpl
extends BaseServiceImpl
implements SampleDetailsService {
    private static final Logger log = LoggerFactory.getLogger(SampleDetailsServiceImpl.class);
    private final SampleDetailsRepo sampleDetailsRepo;
    private final SampleDetailsDAO sampleDetailsDAO;

    public PagingVO<SampleDetailsVO> queryPaging(SampleDetailsQuery query) {
        return this.sampleDetailsDAO.queryPaging(query);
    }

    public List<SampleDetailsVO> queryListDynamic(SampleDetailsQuery query) {
        return this.sampleDetailsDAO.queryListDynamic(query);
    }

    public SampleDetailsVO queryByKey(Long key) {
        SampleDetailsDO entity = this.sampleDetailsRepo.findById(key).orElseGet(SampleDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SampleDetailsVO vo = SampleDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public SampleDetailsVO insert(SampleDetailsPayload payload) {
        SampleDetailsDO entityDo = SampleDetailsConvert.INSTANCE.toDo(payload);
        return SampleDetailsConvert.INSTANCE.toVo((SampleDetailsDO)this.sampleDetailsRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public SampleDetailsVO update(SampleDetailsPayload payload) {
        SampleDetailsDO entity = this.sampleDetailsRepo.findById(payload.getId()).orElseGet(SampleDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SampleDetailsDO entityDo = SampleDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SampleDetailsConvert.INSTANCE.toVo((SampleDetailsDO)this.sampleDetailsRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(SampleDetailsPayload payload) {
        SampleDetailsDO entity = this.sampleDetailsRepo.findById(payload.getId()).orElseGet(SampleDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.sampleDetailsDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.sampleDetailsRepo.findById(id);
                if (!optional.isEmpty()) {
                    SampleDetailsDO entity = (SampleDetailsDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.sampleDetailsRepo.save(entity);
                }
            });
        }
    }

    public List<SampleDetailsVO> queryListBySampleId(Long sampleId) {
        return this.sampleDetailsDAO.queryListBySampleId(sampleId);
    }

    public List<SampleDetailsVO> queryListBySampleIds(List<Long> sampleIds) {
        return this.sampleDetailsDAO.queryListBySampleIds(sampleIds);
    }

    public SampleDetailsServiceImpl(SampleDetailsRepo sampleDetailsRepo, SampleDetailsDAO sampleDetailsDAO) {
        this.sampleDetailsRepo = sampleDetailsRepo;
        this.sampleDetailsDAO = sampleDetailsDAO;
    }
}

