/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sample.workflow;

import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5crm.api.sample.payload.SamplePayload;
import com.elitesland.tw.tw5crm.api.sample.vo.SampleVO;
import com.elitesland.tw.tw5crm.server.sample.dao.SampleDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/SAMPLE/callBack"})
@Transactional
public class SampleWorkflowController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(SampleWorkflowController.class);
    private final SampleDAO sampleDAO;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    @Transactional
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        SamplePayload updatePayload = new SamplePayload();
        long id = Long.parseLong(businessKey);
        updatePayload.setId(Long.valueOf(id));
        SampleVO vo = this.sampleDAO.queryByKey(Long.valueOf(businessKey));
        updatePayload.setProcInstStatus(procInstStatus);
        if (vo != null) {
            updatePayload.setProcInstId(vo.getProcInstId());
            updatePayload.setSubmitTime(vo.getSubmitTime());
            updatePayload.setApprovedTime(vo.getApprovedTime());
            boolean deleteFlag = false;
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    updatePayload.setSampleStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    break;
                }
                case INTERRUPT: {
                    updatePayload.setSampleStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    break;
                }
                case INVALID: {
                    updatePayload.setSampleStatus(WorkFlowStatusEnum.INVALID.getCode());
                    deleteFlag = true;
                    break;
                }
                case REJECTED: {
                    updatePayload.setSampleStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    break;
                }
                case APPROVED: {
                    updatePayload.setSampleStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    updatePayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
                case APPROVING: {
                    updatePayload.setSampleStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            this.sampleDAO.updateWorkFlow(updatePayload);
            if (deleteFlag) {
                this.sampleDAO.deleteSoft(Arrays.asList(id));
            }
        }
    }

    public SampleWorkflowController(SampleDAO sampleDAO) {
        this.sampleDAO = sampleDAO;
    }
}

