/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.my.service;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5pms.api.my.payload.TimesheetBiweeklyDetailPayload;
import com.elitesland.tw.tw5pms.api.my.payload.TimesheetBiweeklyPayload;
import com.elitesland.tw.tw5pms.api.my.query.TimesheetBiweeklyDetailQuery;
import com.elitesland.tw.tw5pms.api.my.query.TimesheetBiweeklyQuery;
import com.elitesland.tw.tw5pms.api.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5pms.api.my.query.TimesheetQuery;
import com.elitesland.tw.tw5pms.api.my.service.TimesheetBiweeklyDetailService;
import com.elitesland.tw.tw5pms.api.my.service.TimesheetBiweeklyService;
import com.elitesland.tw.tw5pms.api.my.service.TimesheetPlanService;
import com.elitesland.tw.tw5pms.api.my.service.TimesheetService;
import com.elitesland.tw.tw5pms.api.my.vo.TimesheetBiweeklyDetailVO;
import com.elitesland.tw.tw5pms.api.my.vo.TimesheetBiweeklyVO;
import com.elitesland.tw.tw5pms.api.my.vo.TimesheetPlanVO;
import com.elitesland.tw.tw5pms.api.my.vo.TimesheetReportFormVO;
import com.elitesland.tw.tw5pms.api.my.vo.TimesheetVO;
import com.elitesland.tw.tw5pms.server.my.constant.TimesheetBiweeklyDetailTypeEnum;
import com.elitesland.tw.tw5pms.server.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5pms.server.my.convert.TimesheetBiweeklyConvert;
import com.elitesland.tw.tw5pms.server.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5pms.server.my.convert.TimesheetPlanConvert;
import com.elitesland.tw.tw5pms.server.my.dao.TimesheetBiweeklyDAO;
import com.elitesland.tw.tw5pms.server.my.entity.TimesheetBiweeklyDO;
import com.elitesland.tw.tw5pms.server.my.entity.TimesheetBiweeklyReadFlagDO;
import com.elitesland.tw.tw5pms.server.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5pms.server.my.repo.TimesheetBiweeklyRepo;
import com.elitesland.tw.tw5pms.server.my.repo.TimesheetPlanRepo;
import com.elitesland.tw.tw5pms.server.my.repo.TimesheetRepo;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TimesheetBiweeklyServiceImpl
implements TimesheetBiweeklyService {
    private static final Logger log = LoggerFactory.getLogger(TimesheetBiweeklyServiceImpl.class);
    private final TimesheetBiweeklyRepo timesheetBiweeklyRepo;
    private final PrdUserService prdUserService;
    private final TimesheetService timesheetService;
    private final TimesheetRepo timesheetRepo;
    private final TimesheetPlanService timesheetPlanService;
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final TimesheetBiweeklyDetailService timesheetBiweeklyDetailService;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final PrdUserDAO daoUser;
    private final TimesheetBiweeklyDAO timesheetBiweeklyDAO;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;

    public PagingVO<TimesheetBiweeklyVO> paging(TimesheetBiweeklyQuery query) {
        Specification & Serializable spec = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            Predicate predicate = QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(predicate);
            criteriaQuery.distinct(true);
            ArrayList<Predicate> dataFilterQuery = new ArrayList<Predicate>();
            List userIdsByPlatRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
            if (CollectionUtils.isEmpty((Collection)userIdsByPlatRole) || !userIdsByPlatRole.contains(query.getUserId())) {
                if (null != query.getUserId() && null == query.getCreateUserId()) {
                    Predicate tsUserId = criteriaBuilder.equal((Expression)root.get("tsUserId"), (Object)query.getUserId());
                    Predicate receiveUserIds = criteriaBuilder.like((Expression)root.get("receiveUserIds"), SqlUtil.toSqlLikeString((String)("" + query.getUserId())));
                    dataFilterQuery.add(tsUserId);
                    dataFilterQuery.add(receiveUserIds);
                }
                if (!CollectionUtils.isEmpty(dataFilterQuery)) {
                    Predicate[] predicatesListResult = dataFilterQuery.toArray(new Predicate[dataFilterQuery.size()]);
                    predicates.add(criteriaBuilder.or(predicatesListResult));
                }
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        Page page = this.timesheetBiweeklyRepo.findAll(spec, (Pageable)query.getPageRequest());
        return PageUtil.toPageVo((Page)page.map(TimesheetBiweeklyConvert.INSTANCE::toVo));
    }

    public PagingVO<TimesheetBiweeklyVO> pagingNew(TimesheetBiweeklyQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        if (query.getCreateUserId() != null) {
            query.setTsUserId(query.getCreateUserId());
            query.setCreateUserId(null);
        }
        this.getPermissionParams(query);
        query.setReadUserId(userId);
        PagingVO<TimesheetBiweeklyVO> pagingVO = this.timesheetBiweeklyDAO.queryListBiweekly(query);
        return pagingVO;
    }

    public PagingVO<TimesheetReportFormVO> pagingReportForms(TimesheetBiweeklyQuery query) {
        LocalDate date = LocalDate.now();
        if (!ObjectUtils.isEmpty((Object)query.getMonthDate())) {
            date = LocalDate.parse(query.getMonthDate());
        }
        LocalDate firstDay = LocalDate.of(date.getYear(), date.getMonth(), 1);
        LocalDate lastDay = date.with(TemporalAdjusters.lastDayOfMonth());
        WeekFields weekFields = WeekFields.ISO;
        firstDay = firstDay.with(weekFields.dayOfWeek(), 1L);
        lastDay = lastDay.with(weekFields.dayOfWeek(), 7L);
        if (query.getTsUserId() != null) {
            query.setTsUserId(query.getTsUserId());
            query.setCreateUserId(null);
        }
        this.getPermissionParams(query);
        PagingVO<TimesheetReportFormVO> pagingVO = this.timesheetBiweeklyDAO.queryTimesheetReport(query);
        List records = pagingVO.getRecords();
        for (TimesheetReportFormVO record : records) {
            List<LocalDate> tsDateList = this.timesheetRepo.queryTsDateList(firstDay, lastDay, record.getTsUserId());
            List<LocalDate> planDateList = this.timesheetPlanRepo.queryPlanDateList(firstDay, lastDay, record.getTsUserId());
            record.setTsDateList(tsDateList);
            record.setPlanDateList(planDateList);
        }
        return pagingVO;
    }

    @Transactional
    public TimesheetBiweeklyVO queryByUserIdAndDate(Long userId, LocalDate date) {
        int yearWeek = Integer.parseInt(DateUtil.getYearWeek((LocalDate)date));
        Long loginUserId = GlobalUtil.getLoginUserId();
        TimesheetBiweeklyReadFlagDO readFlagDO = this.biweeklyReadFlagRepo.findByUserIdAndReadUserId(userId, loginUserId);
        if (ObjectUtils.isEmpty((Object)((Object)readFlagDO))) {
            readFlagDO = new TimesheetBiweeklyReadFlagDO();
            readFlagDO.setReadFlag(1);
            readFlagDO.setUserId(userId);
            readFlagDO.setReadUserId(loginUserId);
            this.biweeklyReadFlagRepo.save((Object)readFlagDO);
        } else {
            this.biweeklyReadFlagRepo.updateReadFlagById(readFlagDO.getId(), 1);
        }
        LocalDate weekStartDate = date.with(WeekFields.ISO.dayOfWeek(), 1L);
        TimesheetBiweeklyVO vo = new TimesheetBiweeklyVO();
        vo.setCreateUserId(userId);
        vo.setStartWeekDate(weekStartDate);
        vo.setYearWeek(Integer.valueOf(yearWeek));
        vo.setEndWeekDate(weekStartDate.plusDays(6L));
        ArrayList<Object> biweeklyDetailVOS = new ArrayList<Object>();
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setYearWeek(Integer.valueOf(yearWeek));
        timesheetQuery.setTsUserId(userId);
        List timesheetVOS = this.timesheetService.queryList(timesheetQuery);
        for (TimesheetVO timesheetVO : timesheetVOS) {
            if (TimesheetStatus.CREATE.getCode().equals(timesheetVO.getTsStatus())) continue;
            TimesheetBiweeklyDetailVO biweeklyDetailVO = TimesheetConvert.INSTANCE.toTimesheetBiweeklyDetailVo(timesheetVO);
            biweeklyDetailVO.setTsbDate(timesheetVO.getWorkDate());
            biweeklyDetailVO.setType("20");
            biweeklyDetailVOS.add(biweeklyDetailVO);
        }
        TimesheetPlanQuery thisWeekPlanQuery = new TimesheetPlanQuery();
        thisWeekPlanQuery.setCreateUserId(userId);
        thisWeekPlanQuery.setYearWeek(Integer.valueOf(yearWeek));
        List thisWeekTimesheetPlanVOS = this.timesheetPlanService.queryList(thisWeekPlanQuery);
        for (TimesheetPlanVO thisWeekTimesheetPlanVO : thisWeekTimesheetPlanVOS) {
            TimesheetBiweeklyDetailVO biweeklyDetailVO = TimesheetPlanConvert.INSTANCE.toTimesheetBiweeklyDetailVo(thisWeekTimesheetPlanVO);
            biweeklyDetailVO.setTsbDate(thisWeekTimesheetPlanVO.getWorkDate());
            biweeklyDetailVO.setType("10");
            biweeklyDetailVOS.add(biweeklyDetailVO);
        }
        TimesheetPlanQuery nextWeekPlanQuery = new TimesheetPlanQuery();
        nextWeekPlanQuery.setCreateUserId(userId);
        nextWeekPlanQuery.setYearWeek(Integer.valueOf(Integer.parseInt(DateUtil.getYearWeek((LocalDate)date.plusWeeks(1L)))));
        List nextWeekTimesheetPlanVOS = this.timesheetPlanService.queryList(nextWeekPlanQuery);
        for (TimesheetPlanVO nextWeekTimesheetPlanVO : nextWeekTimesheetPlanVOS) {
            TimesheetBiweeklyDetailVO biweeklyDetailVO = TimesheetPlanConvert.INSTANCE.toTimesheetBiweeklyDetailVo(nextWeekTimesheetPlanVO);
            biweeklyDetailVO.setTsbDate(nextWeekTimesheetPlanVO.getWorkDate());
            biweeklyDetailVO.setType("30");
            biweeklyDetailVOS.add(biweeklyDetailVO);
        }
        vo.setDetailList(biweeklyDetailVOS);
        return vo;
    }

    private void getPermissionParams(TimesheetBiweeklyQuery query) {
        if (query.getIsPermission().booleanValue()) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            List userIdsByPlatRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
            List organizationDOList = this.prdOrgOrganizationDAO.queryByManagerId(loginUserId);
            Set orgIdList = null;
            if (!CollectionUtils.isEmpty((Collection)organizationDOList)) {
                orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toSet());
                Set childOrgs = this.prdOrgOrganizationDAO.queryAllChildOrgs(orgIdList);
                orgIdList.addAll(childOrgs);
            }
            List empRef = this.daoUser.queryLowListByKey(null, loginUserId);
            Set empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty((Collection)userIdsByPlatRole) || !userIdsByPlatRole.contains(loginUserId)) {
                HashSet<Long> queryUserIds = new HashSet<Long>();
                queryUserIds.add(loginUserId);
                if (orgIdList != null && !orgIdList.isEmpty()) {
                    List prdOrgEmployeeRefVOS = this.prdOrgOrganizationDAO.queryEmployeeList(orgIdList);
                    Set collect = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toSet());
                    queryUserIds.addAll(collect);
                }
                if (empRefUserIdList != null && !empRefUserIdList.isEmpty()) {
                    queryUserIds.addAll(empRefUserIdList);
                }
                query.setUserIdList(queryUserIds);
            }
        }
    }

    public List<TimesheetBiweeklyVO> queryList(TimesheetBiweeklyQuery query) {
        return TimesheetBiweeklyConvert.INSTANCE.toVoList(this.timesheetBiweeklyRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate((Root)root, (Object)query, (CriteriaBuilder)criteriaBuilder)));
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetBiweeklyVO queryByKey(Long key) {
        TimesheetBiweeklyDO entity = this.timesheetBiweeklyRepo.findById(key).orElseGet(TimesheetBiweeklyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TimesheetBiweeklyVO vo = TimesheetBiweeklyConvert.INSTANCE.toVo(entity);
        TimesheetBiweeklyDetailQuery query = new TimesheetBiweeklyDetailQuery();
        query.setTsbId(vo.getId());
        List timesheetBiweeklyDetailVOS = this.timesheetBiweeklyDetailService.queryList(query);
        vo.setDetailList(timesheetBiweeklyDetailVOS);
        if (entity.getReceiveUserIds().contains("" + GlobalUtil.getLoginUserId())) {
            TimesheetBiweeklyPayload update = new TimesheetBiweeklyPayload();
            update.setId(key);
            update.setIsRead(Integer.valueOf(1));
            this.update(update);
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetBiweeklyVO insert(TimesheetBiweeklyPayload payload) {
        TimesheetBiweeklyVO timesheetBiweeklyVOResult;
        if (payload.getGenerateDate() == null) {
            payload.setGenerateDate(LocalDate.now());
        }
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate startWeekDay = DateUtil.getStartWeekDay((LocalDate)payload.getGenerateDate());
        LocalDate endWeekDay = DateUtil.getEndWeekDay((LocalDate)payload.getGenerateDate());
        endWeekDay = endWeekDay.plusDays(2L);
        TimesheetPlanQuery timesheetPlanQuery = new TimesheetPlanQuery();
        ArrayList<LocalDate> workDatePlanList = new ArrayList<LocalDate>();
        workDatePlanList.add(startWeekDay);
        workDatePlanList.add(endWeekDay);
        timesheetPlanQuery.setWorkDate(workDatePlanList);
        timesheetPlanQuery.setTsUserId(userId);
        timesheetPlanQuery.setWorkDescNotNull("null");
        List timesheetPlanVOList = this.timesheetPlanService.queryList(timesheetPlanQuery);
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        ArrayList<LocalDate> workDateList = new ArrayList<LocalDate>();
        workDateList.add(startWeekDay);
        workDateList.add(endWeekDay);
        timesheetQuery.setWorkDate(workDateList);
        timesheetQuery.setTsUserId(userId);
        ArrayList<String> tsStatusList = new ArrayList<String>();
        tsStatusList.add(TimesheetStatus.APPROVING.getCode());
        tsStatusList.add(TimesheetStatus.APPROVED.getCode());
        tsStatusList.add(TimesheetStatus.SETTLED.getCode());
        timesheetQuery.setTsStatusList(tsStatusList);
        List timesheetVOList = this.timesheetService.queryList(timesheetQuery);
        if (CollectionUtils.isEmpty((Collection)timesheetVOList)) {
            throw TwException.error((String)"", (String)"\u8bf7\u586b\u5199\u672c\u5468\u5de5\u4f5c\u65e5\u5fd7\uff0c\u786e\u4fdd\u5de5\u65f6\u72b6\u6001\u4e3a\u5ba1\u6279\u4e2d\u3001\u5df2\u5ba1\u6279");
        }
        LocalDate nextStartWeekDay = startWeekDay.plusDays(7L);
        LocalDate nextEndWeekDay = endWeekDay.plusDays(7L);
        TimesheetPlanQuery timesheetPlanNextQuery = new TimesheetPlanQuery();
        ArrayList<LocalDate> workDatePlanNextList = new ArrayList<LocalDate>();
        workDatePlanNextList.add(nextStartWeekDay);
        workDatePlanNextList.add(nextEndWeekDay);
        timesheetPlanNextQuery.setWorkDate(workDatePlanNextList);
        timesheetPlanNextQuery.setTsUserId(userId);
        timesheetPlanNextQuery.setWorkDescNotNull("null");
        List timesheetPlanVONextList = this.timesheetPlanService.queryList(timesheetPlanNextQuery);
        this.initData(payload);
        TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
        timesheetBiweeklyQuery.setStartWeekDateQuery(startWeekDay);
        timesheetBiweeklyQuery.setTsUserId(userId);
        List<TimesheetBiweeklyVO> timesheetBiweeklyVOS = this.queryList(timesheetBiweeklyQuery);
        ArrayList timesheetBiweeklyDetailPayloadList = new ArrayList();
        if (!CollectionUtils.isEmpty(timesheetBiweeklyVOS)) {
            timesheetBiweeklyVOResult = timesheetBiweeklyVOS.get(0);
            List delIdArr = timesheetBiweeklyVOS.stream().map(timesheetBiweeklyVO -> timesheetBiweeklyVO.getId()).collect(Collectors.toList());
            this.timesheetBiweeklyDetailService.deleteSoftByTsbIds(delIdArr, TimesheetBiweeklyDetailTypeEnum.TIMESHEET.getCode());
            timesheetVOList.forEach(timesheetVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVOResult.getId());
                week.setExt1(StringUtils.hasText((String)timesheetVO.getType()) ? timesheetVO.getType() : "PROJ");
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET.getCode());
                week.setYearWeek(timesheetVO.getYearWeek());
                week.setProjId(timesheetVO.getProjId());
                week.setProjectName(timesheetVO.getProjName());
                week.setTaskId(timesheetVO.getTaskId());
                week.setTaskName(timesheetVO.getTaskName());
                week.setActName(timesheetVO.getActName());
                week.setTsbDate(timesheetVO.getWorkDate());
                week.setWorkDesc(timesheetVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });
        } else {
            TimesheetBiweeklyVO timesheetBiweeklyVO2;
            TimesheetBiweeklyDO entityDo = TimesheetBiweeklyConvert.INSTANCE.toDo(payload);
            timesheetBiweeklyVOResult = timesheetBiweeklyVO2 = TimesheetBiweeklyConvert.INSTANCE.toVo((TimesheetBiweeklyDO)((Object)this.timesheetBiweeklyRepo.save((Object)entityDo)));
            timesheetPlanVOList.forEach(timesheetPlanVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVO2.getId());
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET_PLAN.getCode());
                week.setExt1(StringUtils.hasText((String)timesheetPlanVO.getType()) ? timesheetPlanVO.getType() : "PROJ");
                week.setYearWeek(timesheetPlanVO.getYearWeek());
                week.setProjId(timesheetPlanVO.getProjId());
                week.setProjectName(timesheetPlanVO.getProjName());
                week.setTaskId(timesheetPlanVO.getTaskId());
                week.setTaskName(timesheetPlanVO.getTaskName());
                week.setActName(timesheetPlanVO.getActName());
                week.setTsbDate(timesheetPlanVO.getWorkDate());
                week.setWorkDesc(timesheetPlanVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });
            timesheetPlanVONextList.forEach(timesheetPlanVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVO2.getId());
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET_PLAN_NEXT_WEEK.getCode());
                week.setExt1(StringUtils.hasText((String)timesheetPlanVO.getType()) ? timesheetPlanVO.getType() : "PROJ");
                week.setYearWeek(timesheetPlanVO.getYearWeek());
                week.setProjId(timesheetPlanVO.getProjId());
                week.setProjectName(timesheetPlanVO.getProjName());
                week.setTaskId(timesheetPlanVO.getTaskId());
                week.setTaskName(timesheetPlanVO.getTaskName());
                week.setActName(timesheetPlanVO.getActName());
                week.setTsbDate(timesheetPlanVO.getWorkDate());
                week.setWorkDesc(timesheetPlanVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });
            timesheetVOList.forEach(timesheetVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVO2.getId());
                week.setExt1(StringUtils.hasText((String)timesheetVO.getType()) ? timesheetVO.getType() : "PROJ");
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET.getCode());
                week.setYearWeek(timesheetVO.getYearWeek());
                week.setProjId(timesheetVO.getProjId());
                week.setProjectName(timesheetVO.getProjName());
                week.setTaskId(timesheetVO.getTaskId());
                week.setTaskName(timesheetVO.getTaskName());
                week.setActName(timesheetVO.getActName());
                week.setTsbDate(timesheetVO.getWorkDate());
                week.setWorkDesc(timesheetVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });
        }
        timesheetBiweeklyDetailPayloadList.forEach(timesheetBiweeklyDetailPayload -> this.timesheetBiweeklyDetailService.insert(timesheetBiweeklyDetailPayload));
        return timesheetBiweeklyVOResult;
    }

    private void initData(TimesheetBiweeklyPayload payload) {
        List list;
        List prdOrgDataRefVOS;
        Long loginUserId = GlobalUtil.getLoginUserId();
        payload.setTsUserId(loginUserId);
        Set parentIdsByUserId = this.prdOrgEmployeeService.queryParentIdsByUserId(loginUserId);
        String receiveUserIds = org.apache.commons.lang3.StringUtils.join((Object[])parentIdsByUserId.toArray(), (String)",");
        payload.setReceiveUserIds(receiveUserIds);
        if (!StringUtils.hasText((String)payload.getTsbType())) {
            payload.setTsbType("week");
        }
        if (!StringUtils.hasText((String)payload.getTitle())) {
            String title = "";
            if (payload.getTsbType().equals("week")) {
                title = "\u5468\u62a5";
            }
            payload.setTitle(GlobalUtil.getLoginUserName() + title);
        }
        if (null == payload.getIsRead()) {
            payload.setIsRead(Integer.valueOf(0));
        }
        if (null == payload.getStartWeekDate()) {
            LocalDate startWeekDay = DateUtil.getStartWeekDay((LocalDate)payload.getGenerateDate());
            if (null == startWeekDay) {
                throw TwException.error((String)"", (String)"\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u6307\u5b9a\u751f\u6210\u5468\u62a5\u65e5\u671f");
            }
            payload.setStartWeekDate(startWeekDay);
            payload.setEndWeekDate(startWeekDay.plusDays(7L));
            payload.setYearWeek(Integer.valueOf(Integer.parseInt(DateUtil.getYearWeek((LocalDate)startWeekDay))));
        }
        if (!CollectionUtils.isEmpty((Collection)(prdOrgDataRefVOS = this.prdUserService.queryOrgList())) && !CollectionUtils.isEmpty(list = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            Long orgId = ((PrdOrgDataRefVO)list.get(0)).getOrgId();
            payload.setTsbBuId(orgId);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetBiweeklyVO update(TimesheetBiweeklyPayload payload) {
        TimesheetBiweeklyDO entity = this.timesheetBiweeklyRepo.findById(payload.getId()).orElseGet(TimesheetBiweeklyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TimesheetBiweeklyDO entityDo = TimesheetBiweeklyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetBiweeklyConvert.INSTANCE.toVo((TimesheetBiweeklyDO)((Object)this.timesheetBiweeklyRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetBiweeklyRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetBiweeklyDO entity = (TimesheetBiweeklyDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.timesheetBiweeklyRepo.save((Object)entity);
                }
            });
        }
    }

    public void download(List<TimesheetBiweeklyVO> all, HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        for (TimesheetBiweeklyVO timesheetBiweekly : all) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u6807\u9898", timesheetBiweekly.getTitle());
            map.put("\u53cc\u5468\u8ba1\u5212\u7c7b\u578b", timesheetBiweekly.getTsbType());
            map.put("\u53cc\u5468\u8ba1\u5212Buid", timesheetBiweekly.getTsbBuId());
            map.put("\u53d1\u9001\u5bf9\u8c61", timesheetBiweekly.getReceiveUserIds());
            map.put("\u662f\u5426\u5df2\u8bfb", timesheetBiweekly.getIsRead());
            map.put("\u62d3\u5c551", timesheetBiweekly.getExt1());
            map.put("\u62d3\u5c552", timesheetBiweekly.getExt2());
            map.put("\u62d3\u5c553", timesheetBiweekly.getExt3());
            map.put("\u672c\u5468\u5f00\u59cb\u65e5\u671f", timesheetBiweekly.getStartWeekDate());
            list.add(map);
        }
        FileUtil.downloadExcel(list, (HttpServletResponse)response);
    }

    public TimesheetBiweeklyServiceImpl(TimesheetBiweeklyRepo timesheetBiweeklyRepo, PrdUserService prdUserService, TimesheetService timesheetService, TimesheetRepo timesheetRepo, TimesheetPlanService timesheetPlanService, TimesheetPlanRepo timesheetPlanRepo, TimesheetBiweeklyDetailService timesheetBiweeklyDetailService, PrdOrgEmployeeService prdOrgEmployeeService, PrdOrgEmployeeDAO prdOrgEmployeeDAO, PrdSystemRoleDAO systemRoleDAO, PrdOrgOrganizationDAO prdOrgOrganizationDAO, PrdUserDAO daoUser, TimesheetBiweeklyDAO timesheetBiweeklyDAO, TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo) {
        this.timesheetBiweeklyRepo = timesheetBiweeklyRepo;
        this.prdUserService = prdUserService;
        this.timesheetService = timesheetService;
        this.timesheetRepo = timesheetRepo;
        this.timesheetPlanService = timesheetPlanService;
        this.timesheetPlanRepo = timesheetPlanRepo;
        this.timesheetBiweeklyDetailService = timesheetBiweeklyDetailService;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.prdOrgEmployeeDAO = prdOrgEmployeeDAO;
        this.systemRoleDAO = systemRoleDAO;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
        this.daoUser = daoUser;
        this.timesheetBiweeklyDAO = timesheetBiweeklyDAO;
        this.biweeklyReadFlagRepo = biweeklyReadFlagRepo;
    }
}

