/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsBudgetQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.BudgetStatusEnum;
import com.elitesland.tw.tw5pms.server.project.entity.PmsBudgetDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsBudgetDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsBudgetDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsBudgetRepo repo;
    private final QPmsBudgetDO qdo = QPmsBudgetDO.pmsBudgetDO;

    private JPAQuery<PmsBudgetVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsBudgetVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.budgetName, this.qdo.budgetCode, this.qdo.templateId, this.qdo.startTime, this.qdo.endTime, this.qdo.budgetStatus, this.qdo.totalMoney, this.qdo.budgetFiles, this.qdo.projectId, this.qdo.procInstId, this.qdo.procInstStatus, this.qdo.submitTime, this.qdo.approvedTime, this.qdo.procInstStatus, this.qdo.currCode, this.qdo.budgetControl, this.qdo.paidMoney, this.qdo.usedMoney, this.qdo.proportion, this.qdo.appropriationProportion, this.qdo.residueMoney})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsBudgetVO> getJpaQueryWhere(PmsBudgetQuery query) {
        JPAQuery<PmsBudgetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsBudgetQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(PmsBudgetQuery query) {
        ArrayList list = new ArrayList();
        return ExpressionUtils.allOf(list);
    }

    public PmsBudgetVO queryByKey(Long id) {
        JPAQuery<PmsBudgetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsBudgetVO)jpaQuery.fetchFirst();
    }

    public PmsBudgetVO queryByProjectId(Long projectId) {
        JPAQuery<PmsBudgetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsBudgetVO)jpaQuery.fetchFirst();
    }

    public List<PmsBudgetVO> queryListDynamic(PmsBudgetQuery query) {
        JPAQuery<PmsBudgetVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsBudgetVO> queryPaging(PmsBudgetQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsBudgetVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsBudgetDO save(PmsBudgetDO ado) {
        return (PmsBudgetDO)this.repo.save(ado);
    }

    public List<PmsBudgetDO> saveAll(List<PmsBudgetDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsBudgetPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        List nullFields = payload.getNullFields();
        if (nullFields == null || nullFields.size() > 0) {
            // empty if block
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateWorkFlow(PmsBudgetPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstId())) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstStatus())) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getBudgetStatus())) {
            update.set((Path)this.qdo.budgetStatus, (Object)payload.getBudgetStatus());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getSubmitTime())) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getApprovedTime())) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDeleteFlag())) {
            update.set(this.qdo.deleteFlag, (Object)payload.getDeleteFlag());
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateAppropriationAmount(Long projectId, BigDecimal appropriationAmount) {
        PmsBudgetVO vo = this.queryByProjectId(projectId);
        BigDecimal paid = vo.getPaidMoney().add(appropriationAmount);
        BigDecimal appropriationProportion = BigDecimal.ZERO;
        if (vo.getTotalMoney().doubleValue() > 0.0) {
            appropriationProportion = paid.divide(vo.getTotalMoney(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        }
        BigDecimal residue = paid.subtract(vo.getUsedMoney());
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)vo.getId())});
        update.set(this.qdo.paidMoney, (Object)paid);
        update.set(this.qdo.appropriationProportion, (Object)appropriationProportion);
        update.set(this.qdo.residueMoney, (Object)residue);
        update.set((Path)this.qdo.budgetStatus, (Object)BudgetStatusEnum.APPROVED.getCode());
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateUsedMoney(Long projectId, BigDecimal usedMoney) {
        PmsBudgetVO vo = this.queryByProjectId(projectId);
        BigDecimal paid = BigDecimal.ZERO;
        if (!ObjectUtils.isEmpty((Object)vo.getPaidMoney())) {
            paid = vo.getPaidMoney();
        }
        BigDecimal used = BigDecimal.ZERO;
        used = ObjectUtils.isEmpty((Object)vo.getUsedMoney()) ? usedMoney : vo.getUsedMoney().add(usedMoney);
        BigDecimal proportion = BigDecimal.ZERO;
        if (vo.getTotalMoney().doubleValue() > 0.0) {
            proportion = used.divide(vo.getTotalMoney(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        }
        BigDecimal residue = paid.subtract(used);
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)vo.getId())});
        update.set(this.qdo.usedMoney, (Object)used);
        update.set(this.qdo.proportion, (Object)proportion);
        update.set(this.qdo.residueMoney, (Object)residue);
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateMoney(PmsBudgetVO vo, BigDecimal totalMoney, PmsBudgetPayload payload) {
        BigDecimal paid = BigDecimal.ZERO;
        if (!ObjectUtils.isEmpty((Object)vo.getPaidMoney())) {
            paid = vo.getPaidMoney();
        }
        BigDecimal used = vo.getUsedMoney();
        BigDecimal proportion = BigDecimal.ZERO;
        BigDecimal appropriationProportion = BigDecimal.ZERO;
        if (totalMoney.doubleValue() > 0.0) {
            proportion = used.divide(totalMoney, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
            appropriationProportion = paid.divide(totalMoney, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        }
        BigDecimal residue = paid.subtract(used);
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)vo.getId())});
        update.set(this.qdo.proportion, (Object)proportion);
        update.set(this.qdo.appropriationProportion, (Object)appropriationProportion);
        update.set(this.qdo.residueMoney, (Object)residue);
        update.set(this.qdo.totalMoney, (Object)totalMoney);
        update.set((Path)this.qdo.budgetStatus, (Object)BudgetStatusEnum.APPROVED.getCode());
        update.set(this.qdo.approvedTime, (Object)LocalDateTime.now());
        update.set((Path)this.qdo.budgetName, (Object)payload.getBudgetName());
        update.set(this.qdo.startTime, (Object)payload.getStartTime());
        update.set(this.qdo.endTime, (Object)payload.getEndTime());
        update.set((Path)this.qdo.budgetFiles, (Object)payload.getBudgetFiles());
        update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsBudgetDAO(JPAQueryFactory jpaQueryFactory, PmsBudgetRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

