/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectPlanVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskPackageVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsProjectPlanDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsProjectPlanDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsProjectPlanRepo;
import com.elitesland.tw.tw5pms.server.task.entity.QPmsTaskPackageDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class PmsProjectPlanDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectPlanRepo repo;
    private final QPmsProjectPlanDO qdo = QPmsProjectPlanDO.pmsProjectPlanDO;
    private final QPmsTaskPackageDO qdoTaskPackage = QPmsTaskPackageDO.pmsTaskPackageDO;

    private JPAQuery<PmsTaskPackageVO> getJpaQuerySelectTask() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsTaskPackageVO.class, (Expression[])new Expression[]{this.qdoTaskPackage.id, this.qdoTaskPackage.packageCode, this.qdoTaskPackage.packageName, this.qdoTaskPackage.packageStatus, this.qdoTaskPackage.taskProgress, this.qdoTaskPackage.startDate, this.qdoTaskPackage.endDate})).from((EntityPath)this.qdoTaskPackage);
    }

    public List<PmsTaskPackageVO> queryTaskPackageByKeys(List<Long> ids) {
        JPAQuery<PmsTaskPackageVO> jpaQuery = this.getJpaQuerySelectTask();
        jpaQuery.where((Predicate)this.qdoTaskPackage.id.in(ids));
        jpaQuery.where((Predicate)this.qdoTaskPackage.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    private JPAQuery<PmsProjectPlanVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectPlanVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.projectId, this.qdo.parentId, this.qdo.planCode, this.qdo.parentPlanCode, this.qdo.nodeCode, this.qdo.planType, this.qdo.planName, this.qdo.planProgress, this.qdo.sourceId, this.qdo.startDate, this.qdo.endDate, this.qdo.durationDay, this.qdo.managerUserId, this.qdo.sourceStatus, this.qdo.relySourceIds, this.qdo.relyPlanIds, this.qdo.relyPlanNames, this.qdo.relyType, this.qdo.relyDay, this.qdo.isKeyPath})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsProjectPlanVO> getJpaQueryWhere(PmsProjectPlanQuery query) {
        JPAQuery<PmsProjectPlanVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsProjectPlanQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(PmsProjectPlanQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentId())) {
            list.add(this.qdo.parentId.eq((Object)query.getParentId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentPlanCode())) {
            list.add(this.qdo.parentPlanCode.like(SqlUtil.toSqlLikeString((String)query.getParentPlanCode())));
        }
        if (!ObjectUtils.isEmpty((Object[])query.getPlanTypes())) {
            List<String> planTypes = Arrays.asList(query.getPlanTypes());
            list.add(this.qdo.planType.in(planTypes));
        } else if (!ObjectUtils.isEmpty((Object)query.getPlanType())) {
            list.add(this.qdo.planType.eq((Object)query.getPlanType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanName())) {
            list.add(this.qdo.planName.like(SqlUtil.toSqlLikeString((String)query.getPlanName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanSearch())) {
            list.add(this.qdo.planName.like(SqlUtil.toSqlLikeString((String)query.getPlanSearch())).or((Predicate)this.qdo.nodeCode.like(SqlUtil.toSqlLikeString((String)query.getPlanSearch()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceId())) {
            list.add(this.qdo.sourceId.eq((Object)query.getSourceId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDurationDay())) {
            list.add(this.qdo.durationDay.eq((Object)query.getDurationDay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManagerUserId())) {
            list.add(this.qdo.managerUserId.eq((Object)query.getManagerUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceStatus())) {
            list.add(this.qdo.sourceStatus.eq((Object)query.getSourceStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelyPlanIds())) {
            list.add(this.qdo.relyPlanIds.like(SqlUtil.toSqlLikeString((String)query.getRelyPlanIds())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelyPlanNames())) {
            list.add(this.qdo.relyPlanNames.like(SqlUtil.toSqlLikeString((String)query.getRelyPlanNames())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelyType())) {
            list.add(this.qdo.relyType.eq((Object)query.getRelyType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelyDay())) {
            list.add(this.qdo.relyDay.eq((Object)query.getRelyDay()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsProjectPlanVO queryByKey(Long id) {
        JPAQuery<PmsProjectPlanVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectPlanVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectPlanVO> queryByParentIdAndType(List<Long> parentIds, String type) {
        JPAQuery<PmsProjectPlanVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.parentId.in(parentIds));
        jpaQuery.where((Predicate)this.qdo.planType.eq((Object)type));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsProjectPlanVO> queryByProjectId(Long projectId) {
        JPAQuery<PmsProjectPlanVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsProjectPlanVO> queryListDynamic(PmsProjectPlanQuery query) {
        JPAQuery<PmsProjectPlanVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PmsProjectPlanVO queryDynamic(PmsProjectPlanQuery query) {
        JPAQuery<PmsProjectPlanVO> jpaQuery = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)query.getProjectId()))).where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        if (StringUtils.hasText((String)query.getPlanCode())) {
            jpaQuery.where((Predicate)this.qdo.planCode.notLike(SqlUtil.toSqlLikeString((String)query.getPlanCode())));
        }
        if (StringUtils.hasText((String)query.getParentPlanCode())) {
            jpaQuery.where((Predicate)this.qdo.parentPlanCode.eq((Object)query.getParentPlanCode()));
        }
        ArrayList<OrderItem> orderse = new ArrayList<OrderItem>();
        orderse.add(OrderItem.desc((String)"planCode"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, orderse));
        return (PmsProjectPlanVO)jpaQuery.fetchFirst();
    }

    public PagingVO<PmsProjectPlanVO> queryPaging(PmsProjectPlanQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectPlanVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsProjectPlanDO save(PmsProjectPlanDO ado) {
        return (PmsProjectPlanDO)this.repo.save(ado);
    }

    public List<PmsProjectPlanDO> saveAll(List<PmsProjectPlanDO> dos) {
        return this.repo.saveAll(dos);
    }

    public long updateKeyPathByIds(List<Long> ids, Boolean isKeyPath) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.in(ids)}).set((Path)this.qdo.isKeyPath, (Object)isKeyPath);
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    @Transactional
    public long updateByKeyDynamic(PmsProjectPlanPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getProjectId() != null) {
            update.set(this.qdo.projectId, (Object)payload.getProjectId());
        }
        if (payload.getParentId() != null) {
            update.set(this.qdo.parentId, (Object)payload.getParentId());
        }
        if (payload.getPlanCode() != null) {
            update.set((Path)this.qdo.planCode, (Object)payload.getPlanCode());
        }
        if (payload.getParentPlanCode() != null) {
            update.set((Path)this.qdo.parentPlanCode, (Object)payload.getParentPlanCode());
        }
        if (payload.getPlanType() != null) {
            update.set((Path)this.qdo.planType, (Object)payload.getPlanType());
        }
        if (payload.getPlanName() != null) {
            update.set((Path)this.qdo.planName, (Object)payload.getPlanName());
        }
        if (payload.getSourceId() != null) {
            update.set(this.qdo.sourceId, (Object)payload.getSourceId());
        }
        if (payload.getDurationDay() != null) {
            update.set(this.qdo.durationDay, (Object)payload.getDurationDay());
        }
        if (payload.getManagerUserId() != null) {
            update.set(this.qdo.managerUserId, (Object)payload.getManagerUserId());
        }
        if (payload.getSourceStatus() != null) {
            update.set((Path)this.qdo.sourceStatus, (Object)payload.getSourceStatus());
        }
        if (payload.getRelyPlanIds() != null) {
            update.set((Path)this.qdo.relyPlanIds, (Object)payload.getRelyPlanIds());
        }
        if (payload.getRelyPlanNames() != null) {
            update.set((Path)this.qdo.relyPlanNames, (Object)payload.getRelyPlanNames());
        }
        if (payload.getRelyType() != null) {
            update.set((Path)this.qdo.relyType, (Object)payload.getRelyType());
        }
        if (payload.getRelyDay() != null) {
            update.set(this.qdo.relyDay, (Object)payload.getRelyDay());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("projectId")) {
                update.setNull(this.qdo.projectId);
            }
            if (nullFields.contains("parentId")) {
                update.setNull(this.qdo.parentId);
            }
            if (nullFields.contains("planCode")) {
                update.setNull((Path)this.qdo.planCode);
            }
            if (nullFields.contains("parentPlanCode")) {
                update.setNull((Path)this.qdo.parentPlanCode);
            }
            if (nullFields.contains("planType")) {
                update.setNull((Path)this.qdo.planType);
            }
            if (nullFields.contains("planName")) {
                update.setNull((Path)this.qdo.planName);
            }
            if (nullFields.contains("sourceId")) {
                update.setNull(this.qdo.sourceId);
            }
            if (nullFields.contains("durationDay")) {
                update.setNull(this.qdo.durationDay);
            }
            if (nullFields.contains("managerUserId")) {
                update.setNull(this.qdo.managerUserId);
            }
            if (nullFields.contains("sourceStatus")) {
                update.setNull((Path)this.qdo.sourceStatus);
            }
            if (nullFields.contains("relyPlanIds")) {
                update.setNull((Path)this.qdo.relyPlanIds);
            }
            if (nullFields.contains("relyPlanNames")) {
                update.setNull((Path)this.qdo.relyPlanNames);
            }
            if (nullFields.contains("relyType")) {
                update.setNull((Path)this.qdo.relyType);
            }
            if (nullFields.contains("relyDay")) {
                update.setNull(this.qdo.relyDay);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsProjectPlanDAO(JPAQueryFactory jpaQueryFactory, PmsProjectPlanRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

