/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsWbsActCostPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsWbsActCostQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsWbsActCostVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsWbsActCostDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsWbsActCostDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsWbsActCostRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsWbsActCostDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsWbsActCostRepo repo;
    private final QPmsWbsActCostDO qdo = QPmsWbsActCostDO.pmsWbsActCostDO;

    private JPAQuery<PmsWbsActCostVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsWbsActCostVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.projectId, this.qdo.wbsId, this.qdo.wbsName, this.qdo.costName, this.qdo.costEstimate})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsWbsActCostVO> getJpaQueryWhere(PmsWbsActCostQuery query) {
        JPAQuery<PmsWbsActCostVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsWbsActCostQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(PmsWbsActCostQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsId())) {
            list.add(this.qdo.wbsId.eq((Object)query.getWbsId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsName())) {
            list.add(this.qdo.wbsName.like(SqlUtil.toSqlLikeString((String)query.getWbsName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostName())) {
            list.add(this.qdo.costName.like(SqlUtil.toSqlLikeString((String)query.getCostName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostEstimate())) {
            list.add(this.qdo.costEstimate.eq((Object)query.getCostEstimate()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsWbsActCostVO queryByKey(Long id) {
        JPAQuery<PmsWbsActCostVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsWbsActCostVO)jpaQuery.fetchFirst();
    }

    public List<PmsWbsActCostVO> queryByProjectId(Long ProjectId) {
        JPAQuery<PmsWbsActCostVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)ProjectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsWbsActCostVO> queryByWbsId(Long wbsId) {
        JPAQuery<PmsWbsActCostVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.wbsId.eq((Object)wbsId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsWbsActCostVO> queryListDynamic(PmsWbsActCostQuery query) {
        JPAQuery<PmsWbsActCostVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsWbsActCostVO> queryPaging(PmsWbsActCostQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsWbsActCostVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsWbsActCostDO save(PmsWbsActCostDO ado) {
        return (PmsWbsActCostDO)this.repo.save(ado);
    }

    public List<PmsWbsActCostDO> saveAll(List<PmsWbsActCostDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsWbsActCostPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getProjectId() != null) {
            update.set(this.qdo.projectId, (Object)payload.getProjectId());
        }
        if (payload.getWbsId() != null) {
            update.set(this.qdo.wbsId, (Object)payload.getWbsId());
        }
        if (payload.getWbsName() != null) {
            update.set((Path)this.qdo.wbsName, (Object)payload.getWbsName());
        }
        if (payload.getCostName() != null) {
            update.set((Path)this.qdo.costName, (Object)payload.getCostName());
        }
        if (payload.getCostEstimate() != null) {
            update.set(this.qdo.costEstimate, (Object)payload.getCostEstimate());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("projectId")) {
                update.setNull(this.qdo.projectId);
            }
            if (nullFields.contains("wbsId")) {
                update.setNull(this.qdo.wbsId);
            }
            if (nullFields.contains("wbsName")) {
                update.setNull((Path)this.qdo.wbsName);
            }
            if (nullFields.contains("costName")) {
                update.setNull((Path)this.qdo.costName);
            }
            if (nullFields.contains("costEstimate")) {
                update.setNull(this.qdo.costEstimate);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByWbsIds(List<Long> wbsIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.wbsId.in(wbsIds)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsWbsActCostDAO(JPAQueryFactory jpaQueryFactory, PmsWbsActCostRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

