/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetTemplateSubjectPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsBudgetSubjectQuery;
import com.elitesland.tw.tw5pms.api.project.query.PmsBudgetTemplateSubjectQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetSubjectService;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetTemplateSubjectService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetSubjectVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetTemplateSubjectVO;
import com.elitesland.tw.tw5pms.server.project.convert.PmsBudgetTemplateSubjectConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetTemplateSubjectDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsBudgetTemplateSubjectDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetTemplateSubjectRepo;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsBudgetTemplateSubjectServiceImpl
extends BaseServiceImpl
implements PmsBudgetTemplateSubjectService {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetTemplateSubjectServiceImpl.class);
    private final PmsBudgetTemplateSubjectRepo pmsBudgetTemplateSubjectRepo;
    private final PmsBudgetTemplateSubjectDAO pmsBudgetTemplateSubjectDAO;
    private final PmsBudgetSubjectService pmsBudgetSubjectService;

    public PagingVO<PmsBudgetTemplateSubjectVO> queryPaging(PmsBudgetTemplateSubjectQuery query) {
        return this.pmsBudgetTemplateSubjectDAO.queryPaging(query);
    }

    public List<PmsBudgetTemplateSubjectVO> queryListDynamic(PmsBudgetTemplateSubjectQuery query) {
        return this.pmsBudgetTemplateSubjectDAO.queryListDynamic(query);
    }

    public PmsBudgetTemplateSubjectVO queryByKey(Long key) {
        PmsBudgetTemplateSubjectDO entity = this.pmsBudgetTemplateSubjectRepo.findById(key).orElseGet(PmsBudgetTemplateSubjectDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsBudgetTemplateSubjectVO vo = PmsBudgetTemplateSubjectConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetTemplateSubjectVO insert(PmsBudgetTemplateSubjectPayload payload) {
        if (this.pmsBudgetTemplateSubjectDAO.queryBySubjectNameAndTemplateId(payload) != null) {
            throw TwException.error((String)"", (String)"\u9884\u7b97\u79d1\u76ee\u5df2\u5b58\u5728\uff01");
        }
        PmsBudgetTemplateSubjectDO entityDo = PmsBudgetTemplateSubjectConvert.INSTANCE.toDo(payload);
        return PmsBudgetTemplateSubjectConvert.INSTANCE.toVo((PmsBudgetTemplateSubjectDO)this.pmsBudgetTemplateSubjectRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetTemplateSubjectVO update(PmsBudgetTemplateSubjectPayload payload) {
        if (this.pmsBudgetTemplateSubjectDAO.queryBySubjectNameAndTemplateId(payload) != null && !Objects.equals(this.pmsBudgetTemplateSubjectDAO.queryByKey(payload.getId()).getId(), payload.getId())) {
            throw TwException.error((String)"", (String)"\u9884\u7b97\u79d1\u76ee\u5df2\u5b58\u5728\uff01");
        }
        PmsBudgetTemplateSubjectDO entity = this.pmsBudgetTemplateSubjectRepo.findById(payload.getId()).orElseGet(PmsBudgetTemplateSubjectDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsBudgetTemplateSubjectDO entityDo = PmsBudgetTemplateSubjectConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsBudgetTemplateSubjectConvert.INSTANCE.toVo((PmsBudgetTemplateSubjectDO)this.pmsBudgetTemplateSubjectRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsBudgetTemplateSubjectDAO.deleteSoft(keys);
        }
    }

    public void batchInsert(List<PmsBudgetTemplateSubjectPayload> details, Long templateId) {
        if (!ObjectUtils.isEmpty(details)) {
            List<PmsBudgetTemplateSubjectVO> vos = this.pmsBudgetTemplateSubjectDAO.queryByTemplateId(templateId);
            List formPage = details.stream().map(PmsBudgetTemplateSubjectPayload::getSubjectId).distinct().collect(Collectors.toList());
            List fromDb = vos.stream().map(PmsBudgetTemplateSubjectVO::getSubjectId).distinct().collect(Collectors.toList());
            ArrayList<PmsBudgetTemplateSubjectDO> dDetails = new ArrayList<PmsBudgetTemplateSubjectDO>();
            details.forEach(detail -> {
                if (!fromDb.contains(detail.getSubjectId())) {
                    detail.setTemplateId(templateId);
                    dDetails.add(PmsBudgetTemplateSubjectConvert.INSTANCE.toDo((PmsBudgetTemplateSubjectPayload)detail));
                }
            });
            vos.forEach(detail -> {
                if (!formPage.contains(detail.getSubjectId())) {
                    detail.setTemplateId(templateId);
                    detail.setDeleteFlag(Integer.valueOf(1));
                    dDetails.add(PmsBudgetTemplateSubjectConvert.INSTANCE.toDo(PmsBudgetTemplateSubjectConvert.INSTANCE.toPayload((PmsBudgetTemplateSubjectVO)detail)));
                }
            });
            this.pmsBudgetTemplateSubjectDAO.saveAll(dDetails);
        } else {
            this.pmsBudgetTemplateSubjectDAO.deleteSoftByTemplateId(templateId);
        }
    }

    public List<PmsBudgetSubjectVO> queryByTemplateId(Long templateId) {
        List<PmsBudgetTemplateSubjectVO> list = this.pmsBudgetTemplateSubjectDAO.queryByTemplateId(templateId);
        List subjectIds = list.stream().map(PmsBudgetTemplateSubjectVO::getSubjectId).distinct().collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(subjectIds)) {
            PmsBudgetSubjectQuery query = new PmsBudgetSubjectQuery();
            query.setSubjectIds(subjectIds);
            return this.pmsBudgetSubjectService.listByTree(query);
        }
        return new LinkedList<PmsBudgetSubjectVO>();
    }

    public PmsBudgetTemplateSubjectServiceImpl(PmsBudgetTemplateSubjectRepo pmsBudgetTemplateSubjectRepo, PmsBudgetTemplateSubjectDAO pmsBudgetTemplateSubjectDAO, PmsBudgetSubjectService pmsBudgetSubjectService) {
        this.pmsBudgetTemplateSubjectRepo = pmsBudgetTemplateSubjectRepo;
        this.pmsBudgetTemplateSubjectDAO = pmsBudgetTemplateSubjectDAO;
        this.pmsBudgetSubjectService = pmsBudgetSubjectService;
    }
}

