/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.task.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserCompositeVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeCompositeDO;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPayload;
import com.elitesland.tw.tw5pms.api.task.query.PmsTaskQuery;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5pms.server.task.entity.PmsTaskDO;
import com.elitesland.tw.tw5pms.server.task.entity.QPmsTaskDO;
import com.elitesland.tw.tw5pms.server.task.entity.QPmsTaskPackageDO;
import com.elitesland.tw.tw5pms.server.task.repo.PmsTaskRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsTaskDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsTaskRepo repo;
    private final QPmsTaskDO qdo = QPmsTaskDO.pmsTaskDO;
    private final QPrdOrgEmployeeCompositeDO qdoComposite = QPrdOrgEmployeeCompositeDO.prdOrgEmployeeCompositeDO;
    private final QPmsTaskPackageDO qdoPackage = QPmsTaskPackageDO.pmsTaskPackageDO;

    private JPAQuery<PrdUserCompositeVO> getJpaQueryEmployeeCompositeSelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdUserCompositeVO.class, (Expression[])new Expression[]{this.qdoComposite.id, this.qdoComposite.userId, this.qdoComposite.workType, this.qdoComposite.specialtyLevel, this.qdoComposite.manageLevel})).from((EntityPath)this.qdoComposite);
    }

    public PrdUserCompositeVO queryCompositeById(Long key) {
        JPAQuery<PrdUserCompositeVO> jpaQuery = this.getJpaQueryEmployeeCompositeSelect();
        jpaQuery.where((Predicate)this.qdoComposite.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdoComposite.deleteFlag.eq((Object)0));
        return (PrdUserCompositeVO)jpaQuery.fetchFirst();
    }

    private JPAQuery<PmsTaskVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsTaskVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.projectId, this.qdo.packageId, this.qdo.packageName, this.qdo.oldDays, this.qdo.authorizeId, this.qdo.distributeTime, this.qdo.distributeDetail, this.qdo.taskCode, this.qdo.taskName, this.qdo.taskStatus, this.qdo.oldTaskStatus, this.qdo.compositeId, this.qdo.isSettle, this.qdo.startDate, this.qdo.endDate, this.qdo.disterUserId, this.qdo.receiverUserId, this.qdo.workType, this.qdo.specialtyLevel, this.qdo.eqvaRatio, this.qdo.auditStandards, this.qdo.fileCodes, this.qdo.days, this.qdo.eqvaQty, this.qdo.addEqva, this.qdo.oldEqva, this.qdo.usedEqva, this.qdo.usedDays, this.qdo.settledDays, this.qdo.settledEqva, this.qdo.settledContent, this.qdo.disterAppraiseFlag, this.qdo.receiverAppraiseFlag, this.qdo.taskProgress, this.qdo.taskProgressData, this.qdo.finishProgress, this.qdo.applySettledEqva, this.qdo.applySettledTime, this.qdo.extStr1, this.qdo.extStr2, this.qdo.extStr3, this.qdo.extStr4, this.qdo.extStr5, this.qdoPackage.reasonName, this.qdoPackage.reasonType})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoPackage)).on((Predicate)this.qdo.packageId.eq(this.qdoPackage.id));
    }

    private JPAQuery<PmsTaskVO> getJpaQueryWhere(PmsTaskQuery query) {
        JPAQuery<PmsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsTaskQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(PmsTaskQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPackageId())) {
            list.add(this.qdo.packageId.eq((Object)query.getPackageId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAuthorizeId())) {
            list.add(this.qdo.authorizeId.eq((Object)query.getAuthorizeId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskCode())) {
            list.add(this.qdo.taskCode.like(SqlUtil.toSqlLikeString((String)query.getTaskCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskName())) {
            list.add(this.qdo.taskName.like(SqlUtil.toSqlLikeString((String)query.getTaskName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskStatus())) {
            if (query.getTaskStatusType() != null && query.getTaskStatusType() == 0) {
                list.add(this.qdo.taskStatus.ne((Object)query.getTaskStatus()));
            } else {
                list.add(this.qdo.taskStatus.eq((Object)query.getTaskStatus()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskStatusList())) {
            list.add(this.qdo.taskStatus.in((Collection)query.getTaskStatusList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIsSettle())) {
            list.add(this.qdo.isSettle.eq((Object)query.getIsSettle()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartDate())) {
            list.add(this.qdo.startDate.goe((Comparable)query.getStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndDate())) {
            list.add(this.qdo.endDate.loe((Comparable)query.getEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDisterUserId())) {
            list.add(this.qdo.disterUserId.eq((Object)query.getDisterUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiverUserId())) {
            list.add(this.qdo.receiverUserId.eq((Object)query.getReceiverUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkType())) {
            list.add(this.qdo.workType.eq((Object)query.getWorkType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpecialtyLevel())) {
            list.add(this.qdo.specialtyLevel.eq((Object)query.getSpecialtyLevel()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEqvaRatio())) {
            list.add(this.qdo.eqvaRatio.eq((Object)query.getEqvaRatio()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAuditStandards())) {
            list.add(this.qdo.auditStandards.eq((Object)query.getAuditStandards()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDisterAppraiseFlag())) {
            list.add(this.qdo.disterAppraiseFlag.eq((Object)query.getDisterAppraiseFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiverAppraiseFlag())) {
            list.add(this.qdo.receiverAppraiseFlag.eq((Object)query.getReceiverAppraiseFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplySettledEqva())) {
            list.add(this.qdo.applySettledEqva.isNotNull().and((Predicate)this.qdo.applySettledEqva.ne((Object)query.getApplySettledEqva())));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsTaskVO queryByKey(Long id) {
        JPAQuery<PmsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsTaskVO)jpaQuery.fetchFirst();
    }

    public List<PmsTaskVO> queryByKeys(List<Long> keys) {
        JPAQuery<PmsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(keys));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsTaskVO> queryByPackageIds(List<Long> packageIds) {
        JPAQuery<PmsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.packageId.in(packageIds));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsTaskVO> queryByPackageId(Long packageId) {
        JPAQuery<PmsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.packageId.eq((Object)packageId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PmsTaskVO queryByPackageIdOrder(Long packageId) {
        JPAQuery<PmsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.packageId.eq((Object)packageId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        ArrayList<OrderItem> orderse = new ArrayList<OrderItem>();
        orderse.add(OrderItem.asc((String)"taskStatus"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, orderse));
        return (PmsTaskVO)jpaQuery.fetchFirst();
    }

    public List<PmsTaskVO> queryListDynamic(PmsTaskQuery query) {
        JPAQuery<PmsTaskVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsTaskVO> queryPaging(PmsTaskQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsTaskVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    private Predicate whereView(PmsTaskQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getReasonType())) {
            list.add(this.qdoPackage.reasonType.eq((Object)query.getReasonType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonName())) {
            list.add(this.qdoPackage.reasonName.like(SqlUtil.toSqlLikeString((String)query.getReasonName())));
        }
        list.add(this.qdo.receiverUserId.eq((Object)query.getLoginUserId()).and((Predicate)this.qdo.taskStatus.ne((Object)TaskStatusEnum.CREATE.getCode())).and((Predicate)this.qdoPackage.deleteFlag.eq((Object)0)));
        if (!ObjectUtils.isEmpty((Object)query.getTaskStatus())) {
            list.add(this.qdo.taskStatus.eq((Object)query.getTaskStatus()));
            if (query.getTaskStatus().equals(TaskStatusEnum.APPROVED.getCode())) {
                if (query.getOverdueFlag().booleanValue()) {
                    list.add(this.qdo.endDate.lt((Comparable)LocalDate.now()));
                } else {
                    list.add(this.qdo.endDate.goe((Comparable)LocalDate.now()));
                }
            }
        }
        return ExpressionUtils.allOf(list);
    }

    public List<PmsTaskVO> queryViewPaging(PmsTaskQuery query) {
        JPAQuery<PmsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.whereView(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        List fetch = ((JPAQuery)((JPAQuery)jpaQuery.groupBy(this.qdo.id)).limit((long)query.getPageRequest().getPageSize())).fetch();
        return fetch;
    }

    public PmsTaskDO save(PmsTaskDO ado) {
        return (PmsTaskDO)this.repo.save(ado);
    }

    public List<PmsTaskDO> saveAll(List<PmsTaskDO> dos) {
        return this.repo.saveAll(dos);
    }

    public long updateByKeyDynamicInter(PmsTaskPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getTaskStatus() != null) {
            update.set((Path)this.qdo.taskStatus, (Object)payload.getTaskStatus());
        }
        if (payload.getOldTaskStatus() != null) {
            update.set((Path)this.qdo.oldTaskStatus, (Object)payload.getOldTaskStatus());
        }
        if (payload.getOldEqva() != null) {
            update.set(this.qdo.oldEqva, (Object)payload.getOldEqva());
        }
        if (payload.getOldDays() != null) {
            update.set(this.qdo.oldDays, (Object)payload.getOldDays());
        }
        if (payload.getDays() != null) {
            update.set(this.qdo.days, (Object)payload.getDays());
        }
        if (payload.getEqvaQty() != null) {
            update.set(this.qdo.eqvaQty, (Object)payload.getEqvaQty());
        }
        if (payload.getAddEqva() != null) {
            update.set(this.qdo.addEqva, (Object)payload.getAddEqva());
        }
        if (payload.getIsSettle() != null) {
            update.set(this.qdo.isSettle, (Object)payload.getIsSettle());
        }
        if (payload.getTaskProgress() != null) {
            update.set(this.qdo.taskProgress, (Object)payload.getTaskProgress());
        }
        if (payload.getTaskProgressData() != null) {
            update.set((Path)this.qdo.taskProgressData, (Object)payload.getTaskProgressData());
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    @Transactional
    public long updateByKeyDynamic(PmsTaskPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getTaskStatus() != null) {
            update.set((Path)this.qdo.taskStatus, (Object)payload.getTaskStatus());
        }
        if (payload.getIsSettle() != null) {
            update.set(this.qdo.isSettle, (Object)payload.getIsSettle());
        }
        if (payload.getAuditStandards() != null) {
            update.set((Path)this.qdo.auditStandards, (Object)payload.getAuditStandards());
        }
        if (payload.getFileCodes() != null) {
            update.set((Path)this.qdo.fileCodes, (Object)payload.getFileCodes());
        }
        if (payload.getAddEqva() != null) {
            update.set(this.qdo.addEqva, (Object)payload.getAddEqva());
        }
        if (payload.getOldEqva() != null) {
            update.set(this.qdo.oldEqva, (Object)payload.getOldEqva());
        }
        if (payload.getUsedEqva() != null) {
            update.set(this.qdo.usedEqva, (Object)payload.getUsedEqva());
        }
        if (payload.getUsedDays() != null) {
            update.set(this.qdo.usedDays, (Object)payload.getUsedDays());
        }
        if (payload.getSettledDays() != null) {
            update.set(this.qdo.settledDays, (Object)payload.getSettledDays());
        }
        if (payload.getSettledEqva() != null) {
            update.set(this.qdo.settledEqva, (Object)payload.getSettledEqva());
        }
        if (payload.getSettledContent() != null) {
            update.set((Path)this.qdo.settledContent, (Object)payload.getSettledContent());
        }
        if (payload.getDisterAppraiseFlag() != null) {
            update.set(this.qdo.disterAppraiseFlag, (Object)payload.getDisterAppraiseFlag());
        }
        if (payload.getReceiverAppraiseFlag() != null) {
            update.set(this.qdo.receiverAppraiseFlag, (Object)payload.getReceiverAppraiseFlag());
        }
        if (payload.getTaskProgress() != null) {
            update.set(this.qdo.taskProgress, (Object)payload.getTaskProgress());
        }
        if (payload.getTaskProgressData() != null) {
            update.set((Path)this.qdo.taskProgressData, (Object)payload.getTaskProgressData());
        }
        if (payload.getFinishProgress() != null) {
            update.set(this.qdo.finishProgress, (Object)payload.getFinishProgress());
        }
        if (payload.getApplySettledEqva() != null) {
            update.set(this.qdo.applySettledEqva, (Object)payload.getApplySettledEqva());
        }
        if (payload.getApplySettledTime() != null) {
            update.set(this.qdo.applySettledTime, (Object)payload.getApplySettledTime());
        }
        if (payload.getExtStr1() != null) {
            update.set((Path)this.qdo.extStr1, (Object)payload.getExtStr1());
        }
        if (payload.getExtStr2() != null) {
            update.set((Path)this.qdo.extStr2, (Object)payload.getExtStr2());
        }
        if (payload.getExtStr3() != null) {
            update.set((Path)this.qdo.extStr3, (Object)payload.getExtStr3());
        }
        if (payload.getExtStr4() != null) {
            update.set((Path)this.qdo.extStr4, (Object)payload.getExtStr4());
        }
        if (payload.getExtStr5() != null) {
            update.set((Path)this.qdo.extStr5, (Object)payload.getExtStr5());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("packageId")) {
                update.setNull(this.qdo.packageId);
            }
            if (nullFields.contains("authorizeId")) {
                update.setNull(this.qdo.authorizeId);
            }
            if (nullFields.contains("taskCode")) {
                update.setNull((Path)this.qdo.taskCode);
            }
            if (nullFields.contains("taskName")) {
                update.setNull((Path)this.qdo.taskName);
            }
            if (nullFields.contains("taskStatus")) {
                update.setNull((Path)this.qdo.taskStatus);
            }
            if (nullFields.contains("isSettle")) {
                update.setNull(this.qdo.isSettle);
            }
            if (nullFields.contains("startDate")) {
                update.setNull(this.qdo.startDate);
            }
            if (nullFields.contains("endDate")) {
                update.setNull(this.qdo.endDate);
            }
            if (nullFields.contains("disterUserId")) {
                update.setNull(this.qdo.disterUserId);
            }
            if (nullFields.contains("receiverUserId")) {
                update.setNull(this.qdo.receiverUserId);
            }
            if (nullFields.contains("workType")) {
                update.setNull((Path)this.qdo.workType);
            }
            if (nullFields.contains("specialtyLevel")) {
                update.setNull((Path)this.qdo.specialtyLevel);
            }
            if (nullFields.contains("eqvaRatio")) {
                update.setNull(this.qdo.eqvaRatio);
            }
            if (nullFields.contains("auditStandards")) {
                update.setNull((Path)this.qdo.auditStandards);
            }
            if (nullFields.contains("disterAppraiseFlag")) {
                update.setNull(this.qdo.disterAppraiseFlag);
            }
            if (nullFields.contains("receiverAppraiseFlag")) {
                update.setNull(this.qdo.receiverAppraiseFlag);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByPackageIds(List<Long> packageIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.packageId.in(packageIds)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateStatusByPackageId(Long packageId, String status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.taskStatus, (Object)status).where(new Predicate[]{this.qdo.packageId.eq((Object)packageId)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long updateStatus(List<Long> keys, String status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.taskStatus, (Object)status).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsTaskDAO(JPAQueryFactory jpaQueryFactory, PmsTaskRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

