/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.task.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskApplyPayload;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPackagePayload;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPayload;
import com.elitesland.tw.tw5pms.api.task.query.PmsTaskApplyQuery;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskApplyService;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskPackageService;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskApplyVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskPackageVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5pms.server.task.convert.PmsTaskApplyConvert;
import com.elitesland.tw.tw5pms.server.task.dao.PmsTaskApplyDAO;
import com.elitesland.tw.tw5pms.server.task.entity.PmsTaskApplyDO;
import com.elitesland.tw.tw5pms.server.task.repo.PmsTaskApplyRepo;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PmsTaskApplyServiceImpl
extends BaseServiceImpl
implements PmsTaskApplyService {
    private static final Logger log = LoggerFactory.getLogger(PmsTaskApplyServiceImpl.class);
    private final PmsTaskApplyRepo pmsTaskApplyRepo;
    private final PmsTaskApplyDAO pmsTaskApplyDAO;
    private final CacheUtil cacheUtil;
    private final PmsTaskPackageService pmsTaskPackageService;
    private final TransactionUtilService transactionUtilService;

    @Transactional(rollbackFor={Exception.class})
    public PmsTaskApplyVO insertOrUpdate(PmsTaskApplyPayload payload) {
        PmsTaskApplyVO pmsTaskApplyVO;
        if (payload.getId() != null && !(pmsTaskApplyVO = this.pmsTaskApplyDAO.queryByKey(payload.getId())).getApplyStatus().equals("0") && !pmsTaskApplyVO.getApplyStatus().equals("3")) {
            throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u65b0\u5efa\u6216\u5df2\u62d2\u7edd\u7684\u7533\u8bf7\u7f16\u8f91\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!payload.getApplyStatus().equals("1")) {
            payload.setApplyStatus("0");
        }
        PmsTaskApplyDO entityDo = PmsTaskApplyConvert.INSTANCE.toDo(payload);
        return PmsTaskApplyConvert.INSTANCE.toVo((PmsTaskApplyDO)this.pmsTaskApplyRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsTaskApplyVO operApply(PmsTaskApplyPayload payload) {
        PmsTaskApplyVO pmsTaskApplyVO = this.pmsTaskApplyDAO.queryByKey(payload.getId());
        if (!pmsTaskApplyVO.getApplyStatus().equals("1")) {
            throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u5904\u7406\u4e2d\u7684\u7533\u8bf7\u4fee\u6539\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!pmsTaskApplyVO.getDisterUserId().equals(GlobalUtil.getLoginUserId())) {
            throw TwException.error((String)"", (String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (payload.getApplyStatus().equals("2")) {
            PmsTaskPayload taskPayload = new PmsTaskPayload();
            taskPayload.setAuthorizeId(payload.getReasonId());
            taskPayload.setTaskName(pmsTaskApplyVO.getPackageName());
            taskPayload.setStartDate(pmsTaskApplyVO.getStartDate());
            taskPayload.setEndDate(pmsTaskApplyVO.getEndDate());
            taskPayload.setDisterUserId(pmsTaskApplyVO.getDisterUserId());
            taskPayload.setCreateUserId(pmsTaskApplyVO.getDisterUserId());
            taskPayload.setReceiverUserId(pmsTaskApplyVO.getReceiverUserId());
            taskPayload.setCompositeId(pmsTaskApplyVO.getCompositeId());
            taskPayload.setIsDistribute(Integer.valueOf(1));
            taskPayload.setDays(pmsTaskApplyVO.getDays());
            taskPayload.setIsSettle(Integer.valueOf(0));
            taskPayload.setDisterAppraiseFlag(Integer.valueOf(0));
            taskPayload.setReceiverAppraiseFlag(Integer.valueOf(0));
            PmsTaskPackagePayload packagePayload = new PmsTaskPackagePayload();
            packagePayload.setPackageName(pmsTaskApplyVO.getPackageName());
            packagePayload.setCooperationType(payload.getCooperationType());
            packagePayload.setReasonType(pmsTaskApplyVO.getReasonType());
            packagePayload.setAcceptMethod(pmsTaskApplyVO.getAcceptMethod());
            packagePayload.setPricingMethod(pmsTaskApplyVO.getPricingMethod());
            packagePayload.setExpenseOrgId(payload.getExpenseOrgId());
            packagePayload.setProjectId(payload.getProjectId());
            packagePayload.setPlanStageId(payload.getPlanStageId());
            packagePayload.setPlanActId(payload.getPlanActId());
            packagePayload.setStartDate(pmsTaskApplyVO.getStartDate());
            packagePayload.setEndDate(pmsTaskApplyVO.getEndDate());
            packagePayload.setTaskPayloads(List.of(taskPayload));
            PmsTaskPackageVO pmsTaskPackageVO = this.pmsTaskPackageService.insertOrUpdate(packagePayload);
            this.transactionUtilService.executeWithRunnable(() -> this.pmsTaskPackageService.updateStatus(pmsTaskPackageVO.getId(), TaskStatusEnum.APPROVED.getCode()));
            payload.setPackageId(pmsTaskPackageVO.getId());
        }
        PmsTaskApplyPayload pmsTaskApplyPayload = PmsTaskApplyConvert.INSTANCE.toPayload(pmsTaskApplyVO);
        PmsTaskApplyDO entity = PmsTaskApplyConvert.INSTANCE.toDo(pmsTaskApplyPayload);
        PmsTaskApplyDO entityDo = PmsTaskApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsTaskApplyConvert.INSTANCE.toVo((PmsTaskApplyDO)this.pmsTaskApplyRepo.save(entity));
    }

    public PagingVO<PmsTaskApplyVO> queryPaging(PmsTaskApplyQuery query) {
        this.operPermissionFlag(query);
        PagingVO<PmsTaskApplyVO> pagingVO = this.pmsTaskApplyDAO.queryPaging(query);
        pagingVO.getRecords().forEach(this::transferData);
        return pagingVO;
    }

    void operPermissionFlag(PmsTaskApplyQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.ADMIN_PMS.getCode(), RoleEnum.PROJECT_ADMIN.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        query.setLoginUserId(GlobalUtil.getLoginUserId());
    }

    public List<PmsTaskApplyVO> queryListDynamic(PmsTaskApplyQuery query) {
        List<PmsTaskApplyVO> pmsTaskApplyVOS = this.pmsTaskApplyDAO.queryListDynamic(query);
        pmsTaskApplyVOS.forEach(this::transferData);
        return pmsTaskApplyVOS;
    }

    void transferData(PmsTaskApplyVO taskApplyVO) {
        taskApplyVO.setApplyStatusName(taskApplyVO.getApplyStatus().equals("0") ? "\u65b0\u5efa" : (taskApplyVO.getApplyStatus().equals("1") ? "\u5904\u7406\u4e2d" : (taskApplyVO.getApplyStatus().equals("2") ? "\u5df2\u901a\u8fc7" : "\u5df2\u62d2\u7edd")));
        taskApplyVO.setWorkTypeName(this.cacheUtil.transferSystemSelection("org:employee:worktype", taskApplyVO.getWorkType()));
        taskApplyVO.setSpecialtyLevelName(this.cacheUtil.transferSystemSelection("org:employee:specialtylevel", taskApplyVO.getSpecialtyLevel()));
        taskApplyVO.setReceiverUserName(this.cacheUtil.getUserName(taskApplyVO.getReceiverUserId()));
        taskApplyVO.setDisterUserName(this.cacheUtil.getUserName(taskApplyVO.getDisterUserId()));
    }

    public PmsTaskApplyVO queryByKey(Long key) {
        PmsTaskApplyVO pmsTaskApplyVO = this.pmsTaskApplyDAO.queryByKey(key);
        this.transferData(pmsTaskApplyVO);
        return pmsTaskApplyVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsTaskApplyVO> pmsTaskApplyVOS = this.pmsTaskApplyDAO.queryByKeys(keys);
            Optional<PmsTaskApplyVO> first = pmsTaskApplyVOS.stream().filter(pmsTaskApplyVO -> !pmsTaskApplyVO.getApplyStatus().equals("0")).findFirst();
            if (first.isPresent()) {
                throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u65b0\u5efa\u7533\u8bf7\u7684\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            this.pmsTaskApplyDAO.deleteSoft(keys);
        }
    }

    public PmsTaskApplyServiceImpl(PmsTaskApplyRepo pmsTaskApplyRepo, PmsTaskApplyDAO pmsTaskApplyDAO, CacheUtil cacheUtil, PmsTaskPackageService pmsTaskPackageService, TransactionUtilService transactionUtilService) {
        this.pmsTaskApplyRepo = pmsTaskApplyRepo;
        this.pmsTaskApplyDAO = pmsTaskApplyDAO;
        this.cacheUtil = cacheUtil;
        this.pmsTaskPackageService = pmsTaskPackageService;
        this.transactionUtilService = transactionUtilService;
    }
}

