/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.task.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetDetailPlanService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetDetailPlanVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskAuthorizePayload;
import com.elitesland.tw.tw5pms.api.task.query.PmsTaskAuthorizeQuery;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskAuthorizeService;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskAuthorizeVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskReasonVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskAuthorizeStatusEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskReasonTypeEnum;
import com.elitesland.tw.tw5pms.server.task.convert.PmsTaskAuthorizeConvert;
import com.elitesland.tw.tw5pms.server.task.dao.PmsTaskAuthorizeDAO;
import com.elitesland.tw.tw5pms.server.task.entity.PmsTaskAuthorizeDO;
import com.elitesland.tw.tw5pms.server.task.repo.PmsTaskAuthorizeRepo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsTaskAuthorizeServiceImpl
extends BaseServiceImpl
implements PmsTaskAuthorizeService {
    private static final Logger log = LoggerFactory.getLogger(PmsTaskAuthorizeServiceImpl.class);
    private final PmsTaskAuthorizeRepo pmsTaskAuthorizeRepo;
    private final PmsTaskAuthorizeDAO pmsTaskAuthorizeDAO;
    private final PmsProjectService pmsProjectService;
    private final PmsBudgetDetailPlanService pmsBudgetDetailPlanService;
    private final CacheUtil cacheUtil;
    @Value(value="${tw5pms.user.preson_cost:2000}")
    private BigDecimal preson_cost;

    @Transactional(rollbackFor={Exception.class})
    public PmsTaskAuthorizeVO insertOrUpdate(PmsTaskAuthorizePayload payload) {
        this.checkData(payload);
        PmsTaskAuthorizeDO entityDo = PmsTaskAuthorizeConvert.INSTANCE.toDo(payload);
        return PmsTaskAuthorizeConvert.INSTANCE.toVo((PmsTaskAuthorizeDO)this.pmsTaskAuthorizeRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void withdrawAuthorize(List<Long> keys) {
        List<PmsTaskAuthorizeVO> pmsTaskAuthorizeVOS = this.pmsTaskAuthorizeDAO.queryByKeys(keys);
        if (ObjectUtils.isEmpty(pmsTaskAuthorizeVOS)) {
            throw TwException.error((String)"", (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        pmsTaskAuthorizeVOS.forEach(pmsTaskAuthorizeVO -> {
            if (pmsTaskAuthorizeVO.getDisterUserId().equals(loginUserId)) {
                if (!pmsTaskAuthorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.APPROVING.getCode())) {
                    throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u5904\u7406\u4e2d\u7684\u6388\u6743\u64a4\u56de\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            } else {
                throw TwException.error((String)"", (String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        });
        this.pmsTaskAuthorizeDAO.updateStatus(keys, TaskAuthorizeStatusEnum.CREATE.getCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void suspendAuthorize(List<Long> keys) {
        List<PmsTaskAuthorizeVO> pmsTaskAuthorizeVOS = this.pmsTaskAuthorizeDAO.queryByKeys(keys);
        if (ObjectUtils.isEmpty(pmsTaskAuthorizeVOS)) {
            throw TwException.error((String)"", (String)"\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        pmsTaskAuthorizeVOS.forEach(pmsTaskAuthorizeVO -> {
            if (pmsTaskAuthorizeVO.getDisterUserId().equals(loginUserId)) {
                if (!pmsTaskAuthorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.RUNNING.getCode())) {
                    throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u6388\u6743\u4e2d\u7684\u64cd\u4f5c\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            } else {
                throw TwException.error((String)"", (String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        });
        this.pmsTaskAuthorizeDAO.updateStatus(keys, TaskAuthorizeStatusEnum.SUSPEND.getCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsTaskAuthorizeVO> pmsTaskAuthorizeVOS = this.pmsTaskAuthorizeDAO.queryByKeys(keys);
            Long loginUserId = GlobalUtil.getLoginUserId();
            pmsTaskAuthorizeVOS.forEach(pmsTaskAuthorizeVO -> {
                if (pmsTaskAuthorizeVO.getDisterUserId().equals(loginUserId)) {
                    if (!pmsTaskAuthorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.CREATE.getCode())) {
                        throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u7684\u64cd\u4f5c\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                } else {
                    throw TwException.error((String)"", (String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            });
            this.pmsTaskAuthorizeDAO.deleteSoft(keys);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public void acceptAuthorize(PmsTaskAuthorizePayload payload) {
        PmsTaskAuthorizeVO authorizeVO = this.pmsTaskAuthorizeDAO.queryByKey(payload.getId());
        if (!authorizeVO.getReceiverUserId().equals(GlobalUtil.getLoginUserId())) throw TwException.error((String)"", (String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
        if (!authorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.APPROVING.getCode())) throw TwException.error((String)"", (String)"\u6388\u6743\u8d44\u6e90\u5df2\u64a4\u56de");
        if (payload.getIsAgree() == 1) {
            payload.setAuthorizeStatus(TaskAuthorizeStatusEnum.RUNNING.getCode());
        } else {
            payload.setAuthorizeStatus(TaskAuthorizeStatusEnum.REFUSED.getCode());
        }
        this.pmsTaskAuthorizeDAO.updateByKeyDynamic(payload);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public void adjustAuthorize(PmsTaskAuthorizePayload payload) {
        PmsTaskAuthorizeVO authorizeVO = this.pmsTaskAuthorizeDAO.queryByKey(payload.getId());
        if (authorizeVO == null) throw TwException.error((String)"", (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        if (!authorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.RUNNING.getCode()) && !authorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.FINISH.getCode())) throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u6388\u6743\u4e2d\u6216\u6388\u6743\u5b8c\u6bd5\u7684\u4fee\u6539\uff0c\u8bf7\u6838\u9a8c\uff01");
        if (!authorizeVO.getDisterUserId().equals(GlobalUtil.getLoginUserId())) throw TwException.error((String)"", (String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
        if (authorizeVO.getUsedEqva() != null) {
            if (payload.getAuthorizeEqva().compareTo(authorizeVO.getUsedEqva()) > 0) {
                BigDecimal subtract;
                if (authorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.FINISH.getCode())) {
                    payload.setAuthorizeStatus(TaskAuthorizeStatusEnum.RUNNING.getCode());
                }
                if ((subtract = payload.getAuthorizeEqva().subtract(authorizeVO.getAuthorizeEqva())).compareTo(BigDecimal.ZERO) > 0 && authorizeVO.getReasonType().equals(TaskReasonTypeEnum.PROJECT.getCode())) {
                    List pmsBudgetDetailPlanVOS = this.pmsBudgetDetailPlanService.queryByProjectIds(List.of(authorizeVO.getReasonId()), "PROJECT");
                    if (ObjectUtils.isEmpty((Object)pmsBudgetDetailPlanVOS)) throw TwException.error((String)"", (String)"\u9879\u76ee\u9884\u7b97\u4e0d\u8db3\uff0c\u8bf7\u5148\u7ef4\u62a4\u9879\u76ee\u9884\u7b97\uff0c\u8bf7\u6838\u9a8c\uff01");
                    PmsBudgetDetailPlanVO pmsBudgetDetailPlanVO = (PmsBudgetDetailPlanVO)pmsBudgetDetailPlanVOS.get(0);
                    BigDecimal residueEqva = pmsBudgetDetailPlanVO.getResidueMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
                    if (residueEqva.compareTo(subtract) < 0) {
                        throw TwException.error((String)"", (String)("\u8bf7\u586b\u5199(0\uff0c" + residueEqva + "]\u8303\u56f4\u5185\u7684\u503c"));
                    }
                }
            } else {
                if (payload.getAuthorizeEqva().compareTo(authorizeVO.getUsedEqva()) != 0) throw TwException.error((String)"", (String)"\u4e0d\u5728\u53ef\u5141\u8bb8\u53d8\u66f4\u8303\u56f4\u5185\uff0c\u8bf7\u6838\u9a8c\uff01");
                if (authorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.RUNNING.getCode())) {
                    payload.setAuthorizeStatus(TaskAuthorizeStatusEnum.FINISH.getCode());
                }
            }
        }
        payload.setUsedEqva(authorizeVO.getUsedEqva());
        this.update(payload);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void checkData(PmsTaskAuthorizePayload payload) {
        payload.setUsedEqva(null);
        if (!StringUtils.hasText((String)payload.getReasonType())) {
            throw TwException.error((String)"", (String)"\u4e8b\u7531\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (payload.getReasonId() == null) {
            throw TwException.error((String)"", (String)"\u5f52\u5c5e\u4e8b\u7531\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (payload.getReasonType().equals(TaskReasonTypeEnum.PROJECT.getCode())) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(payload.getReasonId());
            if (pmsProjectVO == null) {
                throw TwException.error((String)"", (String)"\u5f52\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (!pmsProjectVO.getProjectStatus().equals(ProjectStatusEnum.APPROVED.getCode())) {
                throw TwException.error((String)"", (String)"\u9879\u76ee\u9884\u7b97\u672a\u6fc0\u6d3b\uff0c\u8bf7\u5148\u7ef4\u62a4\u9879\u76ee\u9884\u7b97\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            Long loginUserId = GlobalUtil.getLoginUserId();
            if (!loginUserId.equals(pmsProjectVO.getManagerUserId())) {
                throw TwException.error((String)"", (String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            payload.setDisterUserId(loginUserId);
            payload.setReasonName(pmsProjectVO.getProjectName());
            payload.setReasonCode(pmsProjectVO.getProjectCode());
        }
        if (payload.getDisterUserId().equals(payload.getReceiverUserId())) {
            throw TwException.error((String)"", (String)"\u4e0d\u80fd\u4e3a\u81ea\u5df1\u6388\u6743\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (payload.getId() != null) {
            PmsTaskAuthorizeVO pmsTaskAuthorizeVO = this.pmsTaskAuthorizeDAO.queryByKey(payload.getId());
            if (pmsTaskAuthorizeVO == null) throw TwException.error((String)"", (String)"\u7f16\u8f91\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            if (!pmsTaskAuthorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.CREATE.getCode()) && !pmsTaskAuthorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.REFUSED.getCode())) {
                throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u65b0\u5efa\u6216\u5df2\u62d2\u7edd\u72b6\u6001\u7684\u4fee\u6539\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            payload.setAuthorizeStatus(pmsTaskAuthorizeVO.getAuthorizeStatus());
        } else {
            String code = this.generateSeqNum("PMS_TASK_AUTHORIZE", new String[0]);
            payload.setAuthorizeCode(code);
            payload.setAuthorizeStatus(TaskAuthorizeStatusEnum.CREATE.getCode());
        }
        if (payload.getIsAauthorize() != 1) return;
        if (payload.getReasonType().equals(TaskReasonTypeEnum.PROJECT.getCode())) {
            List pmsBudgetDetailPlanVOS = this.pmsBudgetDetailPlanService.queryByProjectIds(List.of(payload.getReasonId()), "PROJECT");
            if (ObjectUtils.isEmpty((Object)pmsBudgetDetailPlanVOS)) throw TwException.error((String)"", (String)"\u9879\u76ee\u9884\u7b97\u4e0d\u8db3\uff0c\u8bf7\u5148\u7ef4\u62a4\u9879\u76ee\u9884\u7b97\uff0c\u8bf7\u6838\u9a8c\uff01");
            PmsBudgetDetailPlanVO pmsBudgetDetailPlanVO = (PmsBudgetDetailPlanVO)pmsBudgetDetailPlanVOS.get(0);
            BigDecimal residueEqva = pmsBudgetDetailPlanVO.getResidueMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
            if (residueEqva.compareTo(payload.getAuthorizeEqva()) < 0) {
                throw TwException.error((String)"", (String)("\u8bf7\u586b\u5199(0\uff0c" + residueEqva + "]\u8303\u56f4\u5185\u7684\u503c"));
            }
        }
        payload.setAuthorizeStatus(TaskAuthorizeStatusEnum.APPROVING.getCode());
    }

    public PagingVO<PmsTaskAuthorizeVO> queryPaging(PmsTaskAuthorizeQuery query) {
        this.operPermissionFlag(query);
        PagingVO<PmsTaskAuthorizeVO> pmsTaskAuthorizeVOPagingVO = this.pmsTaskAuthorizeDAO.queryPaging(query);
        if (!ObjectUtils.isEmpty((Object)pmsTaskAuthorizeVOPagingVO.getRecords())) {
            pmsTaskAuthorizeVOPagingVO.getRecords().forEach(this::transferData);
        }
        return pmsTaskAuthorizeVOPagingVO;
    }

    public PmsTaskAuthorizeVO queryByKey(Long key) {
        List pmsBudgetDetailPlanVOS;
        PmsTaskAuthorizeVO vo = this.pmsTaskAuthorizeDAO.queryByKey(key);
        if (vo.getReasonType().equals(TaskReasonTypeEnum.PROJECT.getCode()) && !ObjectUtils.isEmpty((Object)(pmsBudgetDetailPlanVOS = this.pmsBudgetDetailPlanService.queryByProjectIds(List.of(vo.getReasonId()), "PROJECT")))) {
            PmsBudgetDetailPlanVO pmsBudgetDetailPlanVO = (PmsBudgetDetailPlanVO)pmsBudgetDetailPlanVOS.get(0);
            BigDecimal residueEqva = pmsBudgetDetailPlanVO.getResidueMoney().divide(this.preson_cost, 4, RoundingMode.DOWN);
            vo.setResidueEqva(residueEqva);
        }
        this.transferData(vo);
        return vo;
    }

    public List<PmsTaskAuthorizeVO> queryListDynamic(PmsTaskAuthorizeQuery query) {
        this.operPermissionFlag(query);
        List<PmsTaskAuthorizeVO> pmsTaskAuthorizeVOS = this.pmsTaskAuthorizeDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(pmsTaskAuthorizeVOS)) {
            pmsTaskAuthorizeVOS.forEach(this::transferData);
        }
        return pmsTaskAuthorizeVOS;
    }

    public List<PmsTaskAuthorizeVO> queryViewListDynamic(PmsTaskAuthorizeQuery query) {
        query.setPermissionFlag(Boolean.valueOf(true));
        query.setLoginUserId(GlobalUtil.getLoginUserId());
        List<PmsTaskAuthorizeVO> pmsTaskAuthorizeVOS = this.pmsTaskAuthorizeDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(pmsTaskAuthorizeVOS)) {
            pmsTaskAuthorizeVOS.forEach(this::transferData);
        }
        return pmsTaskAuthorizeVOS;
    }

    public List<PmsTaskReasonVO> queryReasonList(String reasonType) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        PmsTaskAuthorizeQuery query = new PmsTaskAuthorizeQuery();
        query.setReasonType(reasonType);
        query.setPermissionFlag(Boolean.valueOf(true));
        query.setLoginUserId(loginUserId);
        List<PmsTaskAuthorizeVO> pmsTaskAuthorizeVOS = this.pmsTaskAuthorizeDAO.queryListDynamic(query);
        ArrayList<PmsTaskReasonVO> reasonVOS = new ArrayList<PmsTaskReasonVO>();
        if (!ObjectUtils.isEmpty(pmsTaskAuthorizeVOS)) {
            Map<Long, List<PmsTaskAuthorizeVO>> collect = pmsTaskAuthorizeVOS.stream().collect(Collectors.groupingBy(PmsTaskAuthorizeVO::getReasonId));
            for (Map.Entry<Long, List<PmsTaskAuthorizeVO>> entry : collect.entrySet()) {
                PmsTaskAuthorizeVO pmsTaskAuthorizeVO = entry.getValue().get(0);
                PmsTaskReasonVO vo = new PmsTaskReasonVO();
                vo.setReasonId(entry.getKey());
                vo.setReasonName(pmsTaskAuthorizeVO.getReasonName());
                vo.setReasonType(pmsTaskAuthorizeVO.getReasonType());
                vo.setReasonCode(pmsTaskAuthorizeVO.getReasonCode());
                if (pmsTaskAuthorizeVO.getDisterUserId().equals(loginUserId)) {
                    vo.setReasonOrg(Integer.valueOf(0));
                } else {
                    vo.setReasonOrg(Integer.valueOf(1));
                }
                reasonVOS.add(vo);
            }
        }
        return reasonVOS;
    }

    public List<PmsTaskAuthorizeVO> queryListByKeys(List<Long> keys) {
        return this.pmsTaskAuthorizeDAO.queryByKeys(keys);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(PmsTaskAuthorizePayload payload) {
        long l = this.pmsTaskAuthorizeDAO.updateByKeyDynamic(payload);
    }

    void transferData(PmsTaskAuthorizeVO vo) {
        vo.setCooperationTypeName(this.cacheUtil.transferSystemSelection("PMS:TASK:COOP:TYPE", vo.getCooperationType()));
        vo.setReasonTypeName(this.cacheUtil.transferSystemSelection("PMS:TASK:ORIGIN:TYPE", vo.getReasonType()));
        vo.setAcceptMethodName(this.cacheUtil.transferSystemSelection("PMS:TASK:CHECK:WAY", vo.getAcceptMethod()));
        vo.setAuthorizeStatusName(this.cacheUtil.transferSystemSelection("PMS:TASK:AUTHORIZE", vo.getAuthorizeStatus()));
        vo.setExpenseOrgName(this.cacheUtil.getOrgName(vo.getExpenseOrgId()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        vo.setReceiverUserName(this.cacheUtil.getUserName(vo.getReceiverUserId()));
        vo.setDisterUserName(this.cacheUtil.getUserName(vo.getDisterUserId()));
    }

    void operPermissionFlag(PmsTaskAuthorizeQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.ADMIN_PMS.getCode(), RoleEnum.PROJECT_ADMIN.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        query.setLoginUserId(GlobalUtil.getLoginUserId());
    }

    public PmsTaskAuthorizeServiceImpl(PmsTaskAuthorizeRepo pmsTaskAuthorizeRepo, PmsTaskAuthorizeDAO pmsTaskAuthorizeDAO, PmsProjectService pmsProjectService, PmsBudgetDetailPlanService pmsBudgetDetailPlanService, CacheUtil cacheUtil) {
        this.pmsTaskAuthorizeRepo = pmsTaskAuthorizeRepo;
        this.pmsTaskAuthorizeDAO = pmsTaskAuthorizeDAO;
        this.pmsProjectService = pmsProjectService;
        this.pmsBudgetDetailPlanService = pmsBudgetDetailPlanService;
        this.cacheUtil = cacheUtil;
    }
}

