/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.task.service;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserCompositeVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdCommentService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdCommentObjTypeEnum;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanDataPayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsProjectPlanPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsProjectPlanQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetDetailPlanService;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectPlanService;
import com.elitesland.tw.tw5pms.api.project.service.PmsProjectService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetDetailPlanVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectPlanVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsProjectVO;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskAuthorizePayload;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPackageEqvaPayload;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPackageMemberPayload;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPackagePayload;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPayload;
import com.elitesland.tw.tw5pms.api.task.query.PmsTaskPackageQuery;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskAuthorizeService;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskPackageMemberService;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskPackageService;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskPackageDataVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskPackageVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskVO;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ComLogTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskAuthorizeStatusEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskReasonTypeEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskRoleEnum;
import com.elitesland.tw.tw5pms.server.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5pms.server.task.convert.PmsTaskConvert;
import com.elitesland.tw.tw5pms.server.task.convert.PmsTaskPackageConvert;
import com.elitesland.tw.tw5pms.server.task.dao.PmsTaskDAO;
import com.elitesland.tw.tw5pms.server.task.dao.PmsTaskPackageDAO;
import com.elitesland.tw.tw5pms.server.task.entity.PmsTaskDO;
import com.elitesland.tw.tw5pms.server.task.entity.PmsTaskPackageDO;
import com.elitesland.tw.tw5pms.server.task.repo.PmsTaskPackageRepo;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsTaskPackageServiceImpl
extends BaseServiceImpl
implements PmsTaskPackageService {
    private static final Logger log = LoggerFactory.getLogger(PmsTaskPackageServiceImpl.class);
    private final PmsTaskPackageRepo pmsTaskPackageRepo;
    private final PmsTaskPackageDAO pmsTaskPackageDAO;
    private final PmsTaskDAO pmsTaskDAO;
    private final PmsProjectPlanService pmsProjectPlanService;
    private final PmsProjectService pmsProjectService;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
    private final PmsTaskPackageMemberService pmsTaskPackageMemberService;
    private final PmsBudgetDetailPlanService pmsBudgetDetailPlanService;
    private final PrdCommentService prdCommentService;
    private final PrdFsmFileRefService prdFsmFileRefService;
    private final PmsBudgetService pmsBudgetService;
    private final ComLogService logService;
    private final PmsTaskAuthorizeService pmsTaskAuthorizeService;
    @Value(value="${tw5pms.user.preson_cost:2000}")
    private BigDecimal preson_cost;

    @Transactional(rollbackFor={Exception.class})
    public PmsTaskPackageVO insertOrUpdate(PmsTaskPackagePayload payload) {
        ArrayList<ComLogPayload> logPayloads = new ArrayList<ComLogPayload>();
        ArrayList<PmsTaskPackageMemberPayload> memberPayloads = new ArrayList<PmsTaskPackageMemberPayload>();
        this.checkPackageData(memberPayloads, payload, logPayloads);
        PmsTaskPackageDO entityDo = PmsTaskPackageConvert.INSTANCE.toDo(payload);
        entityDo = (PmsTaskPackageDO)this.pmsTaskPackageRepo.save(entityDo);
        Long id = entityDo.getId();
        if (!ObjectUtils.isEmpty((Object)payload.getDelTaskIds())) {
            this.pmsTaskDAO.deleteSoft(payload.getDelTaskIds());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getTaskPayloads())) {
            List<PmsTaskDO> entityDos = payload.getTaskPayloads().stream().map(e -> {
                e.setPackageId(id);
                PmsTaskDO taskDO = PmsTaskConvert.INSTANCE.toDo((PmsTaskPayload)e);
                return taskDO;
            }).collect(Collectors.toList());
            this.pmsTaskDAO.saveAll(entityDos);
        }
        this.operProjectPlan(payload, id);
        this.pmsTaskPackageMemberService.operate(id, memberPayloads);
        this.updateLog(logPayloads, id);
        this.logService.insertBacth(logPayloads);
        return PmsTaskPackageConvert.INSTANCE.toVo(entityDo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PmsProjectVO checkPackageData(List<PmsTaskPackageMemberPayload> memberPayloads, PmsTaskPackagePayload payload, List<ComLogPayload> logPayloads) {
        if (payload.getProjectId() == null) {
            throw TwException.error((String)"", (String)"\u5f52\u5c5e\u9879\u76ee\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(payload.getProjectId());
        if (pmsProjectVO == null) {
            throw TwException.error((String)"", (String)"\u5f52\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!pmsProjectVO.getProjectStatus().equals(ProjectStatusEnum.APPROVED.getCode())) {
            throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u6fc0\u6d3b\u9879\u76ee\u7684\u4efb\u52a1\u5305\u53d1\u653e\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        Long userId = loginUser.getId();
        payload.setAuthorizeFlag(Integer.valueOf(0));
        if (!pmsProjectVO.getManagerUserId().equals(userId)) {
            payload.setAuthorizeFlag(Integer.valueOf(1));
        }
        Object content = loginUser.getUsername();
        List<Object> pmsTaskVOS = new ArrayList();
        if (payload.getId() != null) {
            PmsTaskPackageVO pmsTaskPackageVO = this.pmsTaskPackageDAO.queryByKey(payload.getId());
            if (pmsTaskPackageVO == null) {
                throw TwException.error((String)"", (String)("\u3010" + pmsTaskPackageVO.getPackageName() + "\u3011\u7f16\u8f91\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01"));
            }
            if (!pmsTaskPackageVO.getPackageStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u65b0\u5efa\u4efb\u52a1\u7684\u4fee\u6539\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (!pmsTaskPackageVO.getDisterUserIds().equals("" + userId)) {
                throw TwException.error((String)"", (String)"\u65e0\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            pmsTaskVOS = this.pmsTaskDAO.queryByPackageIds(List.of(payload.getId()));
            content = (String)content + " \u7f16\u8f91\u4efb\u52a1\u5305";
        } else {
            String code = this.generateSeqNum("PMS_PACKAGE_TASK", new String[0]);
            payload.setPackageCode(code);
            PmsTaskPackageMemberPayload memberPayload = new PmsTaskPackageMemberPayload();
            memberPayload.setUserId(pmsProjectVO.getManagerUserId());
            memberPayload.setTaskRole(TaskRoleEnum.MANAGER.getCode());
            memberPayload.setUserName(this.cacheUtil.getUserName(pmsProjectVO.getManagerUserId()));
            memberPayloads.add(memberPayload);
            if (!pmsProjectVO.getManagerUserId().equals(pmsProjectVO.getPmoManagerUserId())) {
                PmsTaskPackageMemberPayload memberPayload0 = new PmsTaskPackageMemberPayload();
                memberPayload0.setUserId(pmsProjectVO.getPmoManagerUserId());
                memberPayload0.setTaskRole(TaskRoleEnum.PMO.getCode());
                memberPayload0.setUserName(this.cacheUtil.getUserName(pmsProjectVO.getPmoManagerUserId()));
                memberPayloads.add(memberPayload0);
            }
            if (!pmsProjectVO.getManagerUserId().equals(userId) && !pmsProjectVO.getPmoManagerUserId().equals(userId)) {
                PmsTaskPackageMemberPayload memberPayload1 = new PmsTaskPackageMemberPayload();
                memberPayload1.setUserId(userId);
                memberPayload1.setTaskRole(TaskRoleEnum.DISTER.getCode());
                memberPayload1.setUserName(loginUser.getUsername());
                memberPayloads.add(memberPayload1);
            }
            content = (String)content + " \u65b0\u5efa\u4efb\u52a1\u5305";
        }
        this.createLog(logPayloads, (String)content, null);
        payload.setDisterUserIds("" + userId);
        payload.setProjectName(pmsProjectVO.getProjectName());
        if (payload.getReasonType().equals(TaskReasonTypeEnum.PROJECT.getCode())) {
            payload.setReasonName(pmsProjectVO.getProjectName() + pmsProjectVO.getProjectCode());
        }
        payload.setProjectCode(pmsProjectVO.getProjectCode());
        if (!ObjectUtils.isEmpty((Object)payload.getDelTaskIds()) && !ObjectUtils.isEmpty(pmsTaskVOS)) {
            List taskVOS = pmsTaskVOS.stream().filter(pmsTaskVO -> payload.getDelTaskIds().contains(pmsTaskVO.getId()) && pmsTaskVO.getTaskStatus().equals(TaskStatusEnum.CREATE.getCode())).collect(Collectors.toList());
            if (taskVOS == null || taskVOS.size() != payload.getDelTaskIds().size()) {
                throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u65b0\u5efa\u4efb\u52a1\u7684\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            pmsTaskVOS.removeAll(taskVOS);
        }
        String packageStatus = TaskStatusEnum.CREATE.getCode();
        if (!ObjectUtils.isEmpty((Object)payload.getTaskPayloads())) {
            ArrayList<Long> compositeIds = new ArrayList<Long>();
            for (PmsTaskPayload pmsTaskPayload2 : payload.getTaskPayloads()) {
                if (pmsTaskPayload2.getDays().compareTo(BigDecimal.ZERO) <= 0) {
                    throw TwException.error((String)"", (String)"\u4efb\u52a1\u6d3e\u53d1\u4eba\u5929\u6570\u636e\u4e0d\u5408\u7406\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (pmsTaskPayload2.getStartDate().isBefore(payload.getStartDate()) || pmsTaskPayload2.getEndDate().isAfter(payload.getEndDate())) {
                    throw TwException.error((String)"", (String)"\u4efb\u52a1\u7684\u8d77\u6b62\u65f6\u95f4\u8981\u5728\u4efb\u52a1\u5305\u7684\u8d77\u6b62\u65f6\u95f4\u5185\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (pmsTaskPayload2.getId() != null) {
                    Optional<PmsTaskVO> taskVO = pmsTaskVOS.stream().filter(pmsTaskVO -> pmsTaskVO.getId().equals(pmsTaskPayload2.getId())).findFirst();
                    if (!taskVO.isPresent()) throw TwException.error((String)"", (String)("\u3010" + pmsTaskPayload2.getTaskName() + "\u3011\u7f16\u8f91\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01"));
                    if (!taskVO.get().getTaskStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                        throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u65b0\u5efa\u4efb\u52a1\u7684\u4fee\u6539\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                } else {
                    String code = this.generateSeqNum("PMS_TASK", new String[0]);
                    pmsTaskPayload2.setTaskCode(code);
                    pmsTaskPayload2.setTaskProgress(BigDecimal.ZERO);
                }
                pmsTaskPayload2.setProjectId(payload.getProjectId());
                pmsTaskPayload2.setPackageName(payload.getPackageName());
                pmsTaskPayload2.setDisterUserId(userId);
                pmsTaskPayload2.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                if (pmsTaskPayload2.getIsDistribute() == 1) {
                    if (payload.getAuthorizeFlag() == 1 && pmsTaskPayload2.getAuthorizeId() == null) {
                        throw TwException.error((String)"", (String)"\u6388\u6743\u9879\u76ee\u8bf7\u9009\u62e9\u6388\u6743\u4e8b\u7531\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    pmsTaskPayload2.setDistributeTime(LocalDateTime.now());
                    pmsTaskPayload2.setTaskStatus(TaskStatusEnum.DISTRIBUTING.getCode());
                    packageStatus = TaskStatusEnum.DISTRIBUTING.getCode();
                    this.operTaskMember(memberPayloads, pmsTaskPayload2);
                    this.createLog(logPayloads, loginUser.getUsername() + " \u6d3e\u53d1\u4efb\u52a1 " + pmsTaskPayload2.getTaskName(), null);
                }
                if (pmsTaskPayload2.getCompositeId() == null) {
                    throw TwException.error((String)"", (String)"\u590d\u5408\u80fd\u529b\u4e3a\u5fc5\u9009\u9879\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                compositeIds.add(pmsTaskPayload2.getCompositeId());
            }
            PmsTaskPackageEqvaPayload eqvaPayload = new PmsTaskPackageEqvaPayload();
            eqvaPayload.setProjectId(payload.getProjectId());
            if (payload.getPlanStageId() != null) {
                eqvaPayload.setPlanId(payload.getPlanStageId());
            }
            if (payload.getPlanActId() != null) {
                eqvaPayload.setPlanId(payload.getPlanActId());
            }
            List<PrdUserCompositeVO> compositeVOS = this.pmsTaskPackageDAO.queryCompositeByIds(compositeIds);
            Map maps = compositeVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
            payload.getTaskPayloads().forEach(pmsTaskPayload -> this.assignmentComposite((PmsTaskPayload)pmsTaskPayload, maps, eqvaPayload));
            this.checkEqva(eqvaPayload);
        }
        payload.setPackageStatus(packageStatus);
        return pmsProjectVO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public void adjustTask(PmsTaskPackagePayload payload) {
        if (payload.getId() == null) throw TwException.error((String)"", (String)"\u5f52\u5c5e\u4efb\u52a1\u5305\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        ArrayList<ComLogPayload> logPayloads = new ArrayList<ComLogPayload>();
        ArrayList<PmsTaskPackageMemberPayload> memberPayloads = new ArrayList<PmsTaskPackageMemberPayload>();
        List<PmsTaskVO> pmsTaskVOS = this.pmsTaskDAO.queryByPackageId(payload.getId());
        if (ObjectUtils.isEmpty(pmsTaskVOS)) throw TwException.error((String)"", (String)"\u64cd\u4f5c\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        if (!ObjectUtils.isEmpty((Object)payload.getDelTaskIds())) {
            List delVOs = pmsTaskVOS.stream().filter(vo -> payload.getDelTaskIds().contains(vo.getId()) && !vo.getTaskStatus().equals(TaskStatusEnum.CREATE.getCode())).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(delVOs)) {
                throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u65b0\u5efa\u4efb\u52a1\u7684\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            this.pmsTaskDAO.deleteSoft(payload.getDelTaskIds());
        }
        if (ObjectUtils.isEmpty((Object)payload.getTaskPayloads())) return;
        PmsTaskPackageEqvaPayload eqvaPayload = new PmsTaskPackageEqvaPayload();
        eqvaPayload.setProjectId(payload.getProjectId());
        if (payload.getPlanStageId() != null) {
            eqvaPayload.setPlanId(payload.getPlanStageId());
        }
        if (payload.getPlanActId() != null) {
            eqvaPayload.setPlanId(payload.getPlanActId());
        }
        List<Long> compositeIds = payload.getTaskPayloads().stream().map(PmsTaskPayload::getCompositeId).collect(Collectors.toList());
        List<PrdUserCompositeVO> compositeVOS = this.pmsTaskPackageDAO.queryCompositeByIds(compositeIds);
        Map<Long, PrdUserCompositeVO> maps = compositeVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
        ArrayList<PmsTaskDO> taskDOS = new ArrayList<PmsTaskDO>();
        for (PmsTaskPayload taskPayload : payload.getTaskPayloads()) {
            if (taskPayload.getId() == null) throw TwException.error((String)"", (String)"\u4e0d\u652f\u6301\u4efb\u52a1\u65b0\u5efa\uff0c\u8bf7\u6838\u9a8c\uff01");
            List<String> asList = Arrays.asList(TaskStatusEnum.APPROVED.getCode(), TaskStatusEnum.DISTRIBUTING.getCode());
            Optional<PmsTaskVO> first = pmsTaskVOS.stream().filter(vo -> vo.getId().equals(taskPayload.getId())).findFirst();
            if (!first.isPresent()) throw TwException.error((String)"", (String)"\u53d8\u66f4\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            PmsTaskVO pmsTaskVO = first.get();
            if (pmsTaskVO.getTaskStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                this.assignmentComposite(taskPayload, maps, eqvaPayload);
                if (taskPayload.getIsDistribute() == 1) {
                    taskPayload.setDistributeTime(LocalDateTime.now());
                    taskPayload.setDisterUserId(GlobalUtil.getLoginUserId());
                    taskPayload.setTaskStatus(TaskStatusEnum.DISTRIBUTING.getCode());
                    this.operTaskMember(memberPayloads, taskPayload);
                    this.createLog(logPayloads, GlobalUtil.getLoginUserName() + " \u6d3e\u53d1\u4efb\u52a1 " + taskPayload.getTaskName(), payload.getId());
                } else {
                    taskPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                }
            } else {
                BigDecimal eqvaQty0;
                if (!asList.contains(pmsTaskVO.getTaskStatus())) throw TwException.error((String)"", (String)"\u4e0d\u652f\u6301\u8be5\u72b6\u6001\u4e0b\u7684\u5f53\u91cf\u8c03\u6574\uff0c\u8bf7\u6838\u9a8c\uff01");
                BigDecimal eqvaQty = taskPayload.getDays().multiply(pmsTaskVO.getEqvaRatio());
                taskPayload.setEqvaQty(eqvaQty);
                if (eqvaQty.compareTo(pmsTaskVO.getSettledEqva() == null ? BigDecimal.ZERO : pmsTaskVO.getSettledEqva()) < 0 || taskPayload.getDays().compareTo(pmsTaskVO.getSettledDays() == null ? BigDecimal.ZERO : pmsTaskVO.getSettledDays()) < 0) throw TwException.error((String)"", (String)"\u53ef\u7528\u5f53\u91cf\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                taskPayload.setOldTaskStatus(pmsTaskVO.getTaskStatus());
                taskPayload.setTaskStatus(TaskStatusEnum.DISTRIBUTING.getCode());
                taskPayload.setDistributeTime(LocalDateTime.now());
                taskPayload.setOldEqva(pmsTaskVO.getEqvaQty());
                taskPayload.setOldDays(pmsTaskVO.getDays());
                BigDecimal add = (pmsTaskVO.getAddEqva() == null ? BigDecimal.ZERO : pmsTaskVO.getAddEqva()).add(taskPayload.getEqvaQty().subtract(taskPayload.getOldEqva()));
                taskPayload.setAddEqva(add);
                this.createLog(logPayloads, GlobalUtil.getLoginUserName() + " \u8c03\u6574\u4efb\u52a1\u5f53\u91cf " + taskPayload.getTaskName(), payload.getId());
                if (taskPayload.getAuthorizeId() != null) {
                    BigDecimal bigDecimal;
                    HashMap<Long, BigDecimal> reasonEqvaQty = eqvaPayload.getReasonEqvaQty();
                    if (reasonEqvaQty == null) {
                        reasonEqvaQty = new HashMap<Long, BigDecimal>();
                        eqvaPayload.setReasonEqvaQty(reasonEqvaQty);
                    }
                    bigDecimal = (bigDecimal = (BigDecimal)reasonEqvaQty.get(taskPayload.getAuthorizeId())) != null ? bigDecimal.add(taskPayload.getEqvaQty().subtract(taskPayload.getOldEqva())) : taskPayload.getEqvaQty().subtract(taskPayload.getOldEqva());
                    reasonEqvaQty.put(taskPayload.getAuthorizeId(), bigDecimal);
                }
                eqvaQty0 = (eqvaQty0 = eqvaPayload.getEqvaQty()) != null ? eqvaQty0.add(taskPayload.getEqvaQty().subtract(taskPayload.getOldEqva())) : taskPayload.getEqvaQty().subtract(taskPayload.getOldEqva());
                eqvaPayload.setEqvaQty(eqvaQty0);
            }
            PmsTaskDO taskDO = PmsTaskConvert.INSTANCE.toDo(pmsTaskVO);
            PmsTaskDO pmsTaskDO = PmsTaskConvert.INSTANCE.toDo(taskPayload);
            taskDO.copy(pmsTaskDO);
            taskDOS.add(taskDO);
        }
        this.checkEqva(eqvaPayload);
        this.pmsTaskDAO.saveAll(taskDOS);
        this.pmsTaskPackageMemberService.operate(payload.getId(), memberPayloads);
        PmsTaskVO pmsTaskVO1 = this.pmsTaskDAO.queryByPackageIdOrder(payload.getId());
        this.pmsTaskPackageDAO.updateStatus(payload.getId(), pmsTaskVO1.getTaskStatus());
        this.logService.insertBacth(logPayloads);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void assignmentComposite(PmsTaskPayload pmsTaskPayload, Map<Long, PrdUserCompositeVO> maps, PmsTaskPackageEqvaPayload eqvaPayload) {
        PrdUserCompositeVO prdUserCompositeVO = maps.get(pmsTaskPayload.getCompositeId());
        if (prdUserCompositeVO == null) throw TwException.error((String)"", (String)"\u9009\u4e2d\u590d\u5408\u80fd\u529b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        if (prdUserCompositeVO.getUserId() != -1L && !prdUserCompositeVO.getUserId().equals(pmsTaskPayload.getReceiverUserId())) throw TwException.error((String)"", (String)"\u9009\u4e2d\u590d\u5408\u80fd\u529b\u5f52\u5c5e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        pmsTaskPayload.setWorkType(prdUserCompositeVO.getWorkType());
        pmsTaskPayload.setSpecialtyLevel(prdUserCompositeVO.getSpecialtyLevel());
        PrdSystemSelectionVO prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj("org:employee:specialtylevel", prdUserCompositeVO.getSpecialtyLevel());
        if (prdSystemSelectionVO == null) {
            throw TwException.error((String)"", (String)"\u9009\u4e2d\u5de5\u79cd\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        pmsTaskPayload.setEqvaRatio(new BigDecimal(String.valueOf(prdSystemSelectionVO.getExtString1())));
        pmsTaskPayload.setEqvaQty(pmsTaskPayload.getDays().multiply(pmsTaskPayload.getEqvaRatio()));
        if (pmsTaskPayload.getIsDistribute() != 1) return;
        this.assignmentEqva(eqvaPayload, pmsTaskPayload);
    }

    void assignmentEqva(PmsTaskPackageEqvaPayload eqvaPayload, PmsTaskPayload pmsTaskPayload) {
        BigDecimal eqvaQty;
        if (pmsTaskPayload.getAuthorizeId() != null) {
            BigDecimal bigDecimal;
            HashMap<Long, BigDecimal> reasonEqvaQty = eqvaPayload.getReasonEqvaQty();
            if (reasonEqvaQty == null) {
                reasonEqvaQty = new HashMap<Long, BigDecimal>();
                eqvaPayload.setReasonEqvaQty(reasonEqvaQty);
            }
            bigDecimal = (bigDecimal = (BigDecimal)reasonEqvaQty.get(pmsTaskPayload.getAuthorizeId())) != null ? bigDecimal.add(pmsTaskPayload.getEqvaQty()) : pmsTaskPayload.getEqvaQty();
            reasonEqvaQty.put(pmsTaskPayload.getAuthorizeId(), bigDecimal);
        }
        eqvaQty = (eqvaQty = eqvaPayload.getEqvaQty()) != null ? eqvaQty.add(pmsTaskPayload.getEqvaQty()) : pmsTaskPayload.getEqvaQty();
        eqvaPayload.setEqvaQty(eqvaQty);
    }

    void checkEqva(PmsTaskPackageEqvaPayload eqvaPayload) {
        if (eqvaPayload.getEqvaQty() != null) {
            BigDecimal multiply = eqvaPayload.getEqvaQty().multiply(this.preson_cost);
            if (eqvaPayload.getEqvaQty().compareTo(BigDecimal.ZERO) > 0) {
                List pmsBudgetDetailPlanVOS = this.pmsBudgetDetailPlanService.queryByProjectIds(List.of(eqvaPayload.getProjectId()), null);
                Optional<PmsBudgetDetailPlanVO> first = eqvaPayload.getPlanId() == null ? pmsBudgetDetailPlanVOS.stream().filter(vo -> vo.getProjectId().equals(eqvaPayload.getProjectId()) && vo.getPlanType().equals("PROJECT")).findFirst() : pmsBudgetDetailPlanVOS.stream().filter(vo -> vo.getProjectId().equals(eqvaPayload.getProjectId()) && vo.getPlanId() != null && vo.getPlanId().equals(eqvaPayload.getPlanId())).findFirst();
                if (first.isPresent()) {
                    PmsBudgetDetailPlanVO pmsBudgetDetailPlanVO = first.get();
                    BigDecimal residueMoney = pmsBudgetDetailPlanVO.getResidueMoney();
                    if (residueMoney.compareTo(multiply) < 0) {
                        throw TwException.error((String)"", (String)"\u5f53\u91cf\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                } else {
                    throw TwException.error((String)"", (String)"\u5f53\u91cf\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            }
            this.pmsBudgetService.updatePlanBudget(eqvaPayload.getProjectId(), eqvaPayload.getPlanId(), multiply);
        }
        if (eqvaPayload.getReasonEqvaQty() != null) {
            Map reasonEqvaQty = eqvaPayload.getReasonEqvaQty();
            List authorizeVOS = this.pmsTaskAuthorizeService.queryListByKeys(new ArrayList(reasonEqvaQty.keySet()));
            if (authorizeVOS == null || authorizeVOS.size() != reasonEqvaQty.size()) {
                throw TwException.error((String)"", (String)"\u8be5\u6388\u6743\u4e8b\u7531\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            authorizeVOS.forEach(authorizeVO -> {
                if (!authorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.RUNNING.getCode()) && !authorizeVO.getAuthorizeStatus().equals(TaskAuthorizeStatusEnum.FINISH.getCode())) throw TwException.error((String)"", (String)"\u4e0d\u652f\u6301\u8be5\u72b6\u6001\u4e0b\u6388\u6743\u4e8b\u7531\u9009\u62e9\uff0c\u8bf7\u6838\u9a8c\uff01");
                if (!authorizeVO.getReasonType().equals(TaskReasonTypeEnum.PROJECT.getCode())) return;
                if (!authorizeVO.getReasonId().equals(eqvaPayload.getProjectId())) throw TwException.error((String)"", (String)"\u6388\u6743\u4e8b\u7531\u4e0e\u9879\u76ee\u4e0d\u7b26\uff0c\u8bf7\u6838\u9a8c\uff01");
                if (!authorizeVO.getReceiverUserId().equals(GlobalUtil.getLoginUserId())) throw TwException.error((String)"", (String)"\u65e0\u8be5\u6388\u6743\u4e8b\u7531\u6743\u9650\uff0c\u8bf7\u6838\u9a8c\uff01");
                BigDecimal bigDecimal = (BigDecimal)reasonEqvaQty.get(authorizeVO.getId());
                BigDecimal usedEqva = (authorizeVO.getUsedEqva() == null ? BigDecimal.ZERO : authorizeVO.getUsedEqva()).add(bigDecimal);
                if (authorizeVO.getAuthorizeEqva().compareTo(usedEqva) < 0) throw TwException.error((String)"", (String)"\u6388\u6743\u5f53\u91cf\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                PmsTaskAuthorizePayload authorizePayload = new PmsTaskAuthorizePayload();
                authorizePayload.setId(authorizeVO.getId());
                authorizePayload.setUsedEqva(usedEqva);
                if (authorizeVO.getAuthorizeEqva().compareTo(usedEqva) == 0) {
                    authorizePayload.setAuthorizeStatus(TaskAuthorizeStatusEnum.FINISH.getCode());
                } else {
                    authorizePayload.setAuthorizeStatus(TaskAuthorizeStatusEnum.RUNNING.getCode());
                }
                this.pmsTaskAuthorizeService.update(authorizePayload);
            });
        }
    }

    public PagingVO<PmsTaskPackageVO> queryPaging(PmsTaskPackageQuery query) {
        this.operPermissionFlag(query);
        PagingVO<PmsTaskPackageVO> pmsTaskPackageVOPagingVO = this.pmsTaskPackageDAO.queryPaging(query);
        List packageVOS = pmsTaskPackageVOPagingVO.getRecords();
        if (!ObjectUtils.isEmpty((Object)packageVOS)) {
            List<Long> ids = packageVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<PmsTaskVO> pmsTaskVOS = this.pmsTaskDAO.queryByPackageIds(ids);
            Map<Long, List<PmsTaskVO>> groupedList = pmsTaskVOS.stream().collect(Collectors.groupingBy(PmsTaskVO::getPackageId));
            packageVOS.forEach(pmsTaskPackageVO -> {
                pmsTaskPackageVO.setTaskVOs((List)groupedList.get(pmsTaskPackageVO.getId()));
                this.transferData((PmsTaskPackageVO)pmsTaskPackageVO);
            });
        }
        return pmsTaskPackageVOPagingVO;
    }

    public PmsTaskPackageDataVO queryViewPaging(PmsTaskPackageQuery query) {
        if (StringUtils.hasText((String)query.getPackageType())) {
            if (query.getPackageType().equals("2") || query.getPackageType().equals("3")) {
                Map collect;
                query.setLoginUserId(GlobalUtil.getLoginUserId());
                query.setPackageStatus(TaskStatusEnum.APPROVED.getCode());
                query.setOverdueFlag(Boolean.valueOf(true));
                List<PmsTaskPackageVO> vo1 = this.pmsTaskPackageDAO.queryViewPaging(query);
                query.setOverdueFlag(Boolean.valueOf(false));
                List<PmsTaskPackageVO> vo2 = this.pmsTaskPackageDAO.queryViewPaging(query);
                query.setPackageStatus(TaskStatusEnum.PENDING.getCode());
                List<PmsTaskPackageVO> vo3 = this.pmsTaskPackageDAO.queryViewPaging(query);
                query.setPackageStatus(TaskStatusEnum.FINISH.getCode());
                List<PmsTaskPackageVO> vo4 = this.pmsTaskPackageDAO.queryViewPaging(query);
                HashMap<Long, Object> map = new HashMap<Long, Object>();
                if (!ObjectUtils.isEmpty(vo1)) {
                    collect = vo1.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
                    map.putAll(collect);
                }
                if (!ObjectUtils.isEmpty(vo2)) {
                    collect = vo2.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
                    map.putAll(collect);
                }
                if (!ObjectUtils.isEmpty(vo3)) {
                    collect = vo3.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
                    map.putAll(collect);
                }
                if (!ObjectUtils.isEmpty(vo4)) {
                    collect = vo4.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
                    map.putAll(collect);
                }
                if (!ObjectUtils.isEmpty(map)) {
                    map.forEach((key, taskPackageVO) -> {
                        taskPackageVO.setComments(Long.valueOf(this.prdCommentService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), taskPackageVO.getId())));
                        taskPackageVO.setFiles(Long.valueOf(this.prdFsmFileRefService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), taskPackageVO.getId())));
                    });
                }
                PmsTaskPackageDataVO packageDataVO = new PmsTaskPackageDataVO();
                packageDataVO.setVos1(vo1);
                packageDataVO.setVos2(vo2);
                packageDataVO.setVos3(vo3);
                packageDataVO.setVos4(vo4);
                return packageDataVO;
            }
            throw TwException.error((String)"", (String)"\u67e5\u8be2\u7c7b\u578b\u5f02\u5e38\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        throw TwException.error((String)"", (String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    public List<PmsTaskPackageVO> queryListDynamic(PmsTaskPackageQuery query) {
        List<PmsTaskPackageVO> pmsTaskPackageVOS = this.pmsTaskPackageDAO.queryListDynamic(query);
        pmsTaskPackageVOS.forEach(pmsTaskPackageVO -> {
            this.transferData((PmsTaskPackageVO)pmsTaskPackageVO);
            pmsTaskPackageVO.setComments(Long.valueOf(this.prdCommentService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), pmsTaskPackageVO.getId())));
            pmsTaskPackageVO.setFiles(Long.valueOf(this.prdFsmFileRefService.count(PrdCommentObjTypeEnum.PMS_TASK.getCode(), pmsTaskPackageVO.getId())));
        });
        return this.pmsTaskPackageDAO.queryListDynamic(query);
    }

    public PmsTaskPackageVO queryByKey(Long key) {
        PmsTaskPackageVO pmsTaskPackageVO = this.pmsTaskPackageDAO.queryByKey(key);
        pmsTaskPackageVO.setPresonCost(this.preson_cost);
        List<PmsTaskVO> pmsTaskVOS = this.pmsTaskDAO.queryByPackageIds(List.of(key));
        pmsTaskPackageVO.setTaskVOs(pmsTaskVOS);
        this.transferData(pmsTaskPackageVO);
        pmsTaskPackageVO.setFileDatas(this.fileUtil.getFileDatas(pmsTaskPackageVO.getFileCodes()));
        pmsTaskVOS.forEach(pmsTaskVO -> pmsTaskVO.setFileDatas(this.fileUtil.getFileDatas(pmsTaskVO.getFileCodes())));
        List pmsTaskPackageMemberVOS = this.pmsTaskPackageMemberService.queryTaskPackageMembers(key);
        pmsTaskPackageVO.setMemberVOS(pmsTaskPackageMemberVOS);
        return pmsTaskPackageVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsTaskPackageVO> pmsTaskPackageVOS = this.pmsTaskPackageDAO.queryByKeys(keys);
            pmsTaskPackageVOS.forEach(packageVO -> {
                if (!packageVO.getPackageStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                    throw TwException.error((String)"", (String)"\u4ec5\u652f\u6301\u65b0\u5efa\u4efb\u52a1\u5305\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            });
            this.pmsTaskPackageDAO.deleteSoft(keys);
            this.pmsTaskDAO.deleteSoftByPackageIds(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(Long key, String status) {
        this.pmsTaskPackageDAO.updateStatus(key, status);
        this.pmsTaskDAO.updateStatusByPackageId(key, status);
    }

    public List<PmsTaskPackageVO> queryListByProjectIds(List<Long> projectIds) {
        this.pmsTaskPackageDAO.queryByProjectIds(projectIds);
        return this.pmsTaskPackageDAO.queryByProjectIds(projectIds);
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsTaskPackageVO update(PmsTaskPackagePayload payload) {
        PmsTaskPackageDO entity = this.pmsTaskPackageRepo.findById(payload.getId()).orElseGet(PmsTaskPackageDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsTaskPackageDO entityDo = PmsTaskPackageConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsTaskPackageConvert.INSTANCE.toVo((PmsTaskPackageDO)this.pmsTaskPackageRepo.save(entity));
    }

    void operProjectPlan(PmsTaskPackagePayload payload, Long id) {
        PmsProjectPlanDataPayload planDataPayload = new PmsProjectPlanDataPayload();
        planDataPayload.setProjectId(payload.getProjectId());
        ArrayList<PmsProjectPlanPayload> planPayloads = new ArrayList<PmsProjectPlanPayload>();
        planDataPayload.setPlanPayloads(planPayloads);
        PmsProjectPlanPayload planPayload = new PmsProjectPlanPayload();
        planPayloads.add(planPayload);
        planPayload.setProjectId(payload.getProjectId());
        planPayload.setPlanName(payload.getPackageName());
        planPayload.setNodeCode(payload.getPackageCode());
        planPayload.setPlanType("TASK");
        planPayload.setSourceId(id);
        planPayload.setStartDate(payload.getStartDate());
        planPayload.setEndDate(payload.getEndDate());
        planPayload.setManagerUserId(payload.getCreateUserId());
        planPayload.setSourceStatus(payload.getPackageStatus());
        boolean isProjectTask = true;
        Long parentId = payload.getProjectId();
        if (payload.getPlanStageId() != null) {
            parentId = payload.getPlanStageId();
            isProjectTask = false;
        }
        if (payload.getPlanActId() != null) {
            parentId = payload.getPlanActId();
            isProjectTask = false;
        }
        PmsProjectPlanQuery query = new PmsProjectPlanQuery();
        query.setProjectId(payload.getProjectId());
        PmsProjectPlanVO pmsProjectPlanVO = null;
        if (!isProjectTask) {
            pmsProjectPlanVO = this.pmsProjectPlanService.queryByKey(parentId);
            query.setParentPlanCode(pmsProjectPlanVO.getPlanCode());
        } else {
            query.setPlanCode("-");
        }
        PmsProjectPlanVO pmsProjectPlanVO1 = this.pmsProjectPlanService.queryDynamic(query);
        if (pmsProjectPlanVO1 == null) {
            if (isProjectTask) {
                planPayload.setPlanCode("1");
            } else {
                planPayload.setPlanCode(pmsProjectPlanVO.getPlanCode() + "-1");
                planPayload.setParentPlanCode(pmsProjectPlanVO.getPlanCode());
                planPayload.setParentId(pmsProjectPlanVO.getId());
            }
        } else {
            String afterLast = pmsProjectPlanVO1.getPlanCode().substring(pmsProjectPlanVO1.getPlanCode().lastIndexOf("-") + 1);
            if (isProjectTask) {
                planPayload.setPlanCode("" + (Integer.valueOf(afterLast) + 1));
            } else {
                planPayload.setPlanCode(pmsProjectPlanVO.getPlanCode() + "-" + (Integer.valueOf(afterLast) + 1));
                planPayload.setParentPlanCode(pmsProjectPlanVO.getPlanCode());
                planPayload.setParentId(pmsProjectPlanVO.getId());
            }
        }
        if (payload.getId() != null) {
            PmsProjectPlanQuery query0 = new PmsProjectPlanQuery();
            query0.setPlanType("TASK");
            query0.setSourceId(payload.getId());
            List planVOS = this.pmsProjectPlanService.queryListDynamic(query0);
            if (!ObjectUtils.isEmpty((Object)planVOS)) {
                planPayload.setId(((PmsProjectPlanVO)planVOS.get(0)).getId());
            }
        }
        this.pmsProjectPlanService.batchInsertOrUpdate(planDataPayload);
    }

    void operTaskMember(List<PmsTaskPackageMemberPayload> memberPayloads, PmsTaskPayload pmsTaskPayload) {
        Optional<PmsTaskPackageMemberPayload> first = memberPayloads.stream().filter(member -> member.getUserId().equals(pmsTaskPayload.getReceiverUserId())).findFirst();
        if (!first.isPresent()) {
            PmsTaskPackageMemberPayload memberPayload = new PmsTaskPackageMemberPayload();
            memberPayload.setUserId(pmsTaskPayload.getReceiverUserId());
            memberPayload.setTaskRole(TaskRoleEnum.RECEIVER.getCode());
            memberPayload.setUserName(this.cacheUtil.getUserName(pmsTaskPayload.getReceiverUserId()));
            memberPayloads.add(memberPayload);
        }
    }

    void transferData(PmsTaskPackageVO vo) {
        vo.setPackageStatusName(this.cacheUtil.transferSystemSelection("PMS:TASK:SATUS", vo.getPackageStatus()));
        vo.setCooperationTypeName(this.cacheUtil.transferSystemSelection("PMS:TASK:COOP:TYPE", vo.getCooperationType()));
        vo.setReasonTypeName(this.cacheUtil.transferSystemSelection("PMS:TASK:ORIGIN:TYPE", vo.getReasonType()));
        vo.setPricingMethodName(this.cacheUtil.transferSystemSelection("PMS:TASK:PRICING:WAY", vo.getPricingMethod()));
        vo.setAcceptMethodName(this.cacheUtil.transferSystemSelection("PMS:TASK:CHECK:WAY", vo.getAcceptMethod()));
        vo.setExpenseOrgName(this.cacheUtil.getOrgName(vo.getExpenseOrgId()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        Object receiverUserName = "";
        Object disterUserName = "";
        BigDecimal days = BigDecimal.ZERO;
        BigDecimal oldDays = BigDecimal.ZERO;
        BigDecimal eqvaQty = BigDecimal.ZERO;
        BigDecimal oldEqva = BigDecimal.ZERO;
        BigDecimal usedEqva = BigDecimal.ZERO;
        BigDecimal usedDays = BigDecimal.ZERO;
        BigDecimal settledEqva = BigDecimal.ZERO;
        BigDecimal settledDays = BigDecimal.ZERO;
        if (!ObjectUtils.isEmpty((Object)vo.getTaskVOs())) {
            for (PmsTaskVO taskVO : vo.getTaskVOs()) {
                taskVO.setTaskStatusName(this.cacheUtil.transferSystemSelection("PMS:TASK:SATUS", taskVO.getTaskStatus()));
                taskVO.setWorkTypeName(this.cacheUtil.transferSystemSelection("org:employee:worktype", taskVO.getWorkType()));
                taskVO.setSpecialtyLevelName(this.cacheUtil.transferSystemSelection("org:employee:specialtylevel", taskVO.getSpecialtyLevel()));
                taskVO.setReceiverUserName(this.cacheUtil.getUserName(taskVO.getReceiverUserId()));
                taskVO.setDisterUserName(this.cacheUtil.getUserName(taskVO.getDisterUserId()));
                if ("".equals(receiverUserName)) {
                    receiverUserName = taskVO.getReceiverUserName();
                } else if (((String)receiverUserName).indexOf(taskVO.getReceiverUserName()) < 0) {
                    receiverUserName = (String)receiverUserName + "," + taskVO.getReceiverUserName();
                }
                if ("".equals(disterUserName)) {
                    disterUserName = taskVO.getDisterUserName();
                } else if (((String)disterUserName).indexOf(taskVO.getDisterUserName()) < 0) {
                    disterUserName = (String)disterUserName + "," + taskVO.getDisterUserName();
                }
                if (taskVO.getTaskStatus().equals(TaskStatusEnum.CREATE.getCode())) continue;
                if (taskVO.getDays() != null) {
                    days = days.add(taskVO.getDays());
                }
                if (taskVO.getOldDays() != null) {
                    oldDays = oldDays.add(taskVO.getOldDays());
                }
                if (taskVO.getEqvaQty() != null) {
                    eqvaQty = eqvaQty.add(taskVO.getEqvaQty());
                }
                if (taskVO.getOldEqva() != null) {
                    oldEqva = oldEqva.add(taskVO.getOldEqva());
                }
                if (taskVO.getUsedEqva() != null) {
                    usedEqva = usedEqva.add(taskVO.getUsedEqva());
                }
                if (taskVO.getUsedDays() != null) {
                    usedDays = usedDays.add(taskVO.getUsedDays());
                }
                if (taskVO.getSettledEqva() != null) {
                    settledEqva = settledEqva.add(taskVO.getSettledEqva());
                }
                if (taskVO.getSettledDays() == null) continue;
                settledDays = settledDays.add(taskVO.getSettledDays());
            }
        }
        BigDecimal disCost = eqvaQty.multiply(this.preson_cost);
        BigDecimal usedCost = usedEqva.multiply(this.preson_cost);
        BigDecimal settledCost = settledEqva.multiply(this.preson_cost);
        vo.setDays(days);
        vo.setOldDays(oldDays);
        vo.setEqvaQty(eqvaQty);
        vo.setOldEqva(oldEqva);
        vo.setUsedDays(usedDays);
        vo.setUsedEqva(usedEqva);
        vo.setDisCost(disCost);
        vo.setUsedCost(usedCost);
        vo.setSettledDays(settledDays);
        vo.setSettledEqva(settledEqva);
        vo.setSettledCost(settledCost);
        vo.setReceiverUserName((String)receiverUserName);
        vo.setDisterUserName((String)disterUserName);
    }

    void operPermissionFlag(PmsTaskPackageQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.ADMIN_PMS.getCode(), RoleEnum.PROJECT_ADMIN.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        query.setLoginUserId(GlobalUtil.getLoginUserId());
    }

    void createLog(List<ComLogPayload> logPayloads, String content, Long packageId) {
        ComLogPayload logPayload = new ComLogPayload();
        logPayload.setObjectId("" + packageId);
        logPayload.setLogType(ComLogTypeEnum.pms_task.getCode());
        logPayload.setLogContent(content);
        logPayloads.add(logPayload);
    }

    void updateLog(List<ComLogPayload> logPayloads, Long packageId) {
        logPayloads.forEach(logPayload -> logPayload.setObjectId("" + packageId));
    }

    public PmsTaskPackageServiceImpl(PmsTaskPackageRepo pmsTaskPackageRepo, PmsTaskPackageDAO pmsTaskPackageDAO, PmsTaskDAO pmsTaskDAO, PmsProjectPlanService pmsProjectPlanService, PmsProjectService pmsProjectService, CacheUtil cacheUtil, FileUtil fileUtil, PmsTaskPackageMemberService pmsTaskPackageMemberService, PmsBudgetDetailPlanService pmsBudgetDetailPlanService, PrdCommentService prdCommentService, PrdFsmFileRefService prdFsmFileRefService, PmsBudgetService pmsBudgetService, ComLogService logService, PmsTaskAuthorizeService pmsTaskAuthorizeService) {
        this.pmsTaskPackageRepo = pmsTaskPackageRepo;
        this.pmsTaskPackageDAO = pmsTaskPackageDAO;
        this.pmsTaskDAO = pmsTaskDAO;
        this.pmsProjectPlanService = pmsProjectPlanService;
        this.pmsProjectService = pmsProjectService;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
        this.pmsTaskPackageMemberService = pmsTaskPackageMemberService;
        this.pmsBudgetDetailPlanService = pmsBudgetDetailPlanService;
        this.prdCommentService = prdCommentService;
        this.prdFsmFileRefService = prdFsmFileRefService;
        this.pmsBudgetService = pmsBudgetService;
        this.logService = logService;
        this.pmsTaskAuthorizeService = pmsTaskAuthorizeService;
    }
}

