package com.elitesland.tw.tw5.server.${package}.dao;

import com.elitesland.tw.tw5.api.${package}.payload.${className}Payload;
import com.elitesland.tw.tw5.api.${package}.query.${className}Query;
import com.elitesland.tw.tw5.api.${package}.vo.${className}VO;
import com.elitesland.tw.tw5.server.${package}.entity.${className}DO;
import com.elitesland.tw.tw5.server.${package}.entity.Q${className}DO;
import com.elitesland.tw.tw5.server.${package}.repo.${className}Repo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * ${apiAlias}
 *
 * @author ${author}
 * @date ${date}
 */
@Repository
@RequiredArgsConstructor
public class ${className}DAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ${className}Repo repo;
    private final Q${className}DO qdo = Q${className}DO.${changeClassName}DO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<${className}VO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(${className}VO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
        <#if columns??>
            <#list columns as column>
                <#if column.remark != ''>
                // ${column.remark}
                </#if>
                qdo.${column.changeColumnName}<#if column_has_next>,</#if>
            </#list>
        </#if>
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<${className}VO> getJpaQueryWhere(${className}Query query) {
        JPAQuery<${className}VO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(${className}Query query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(${className}Query query){
        List<Predicate> list = new ArrayList<>();
    <#if queryColumns??>
    <#list queryColumns as column>
    <#if column.queryType = '='>
        /** ${column.remark} 精确 */
        if (!ObjectUtils.isEmpty(query.get${column.capitalColumnName}())) {
            list.add(qdo.${column.changeColumnName}.eq(query.get${column.capitalColumnName}()));
        }
    </#if>
    <#if column.queryType = 'Like'>
        /** ${column.remark} 模糊 */
        if (!ObjectUtils.isEmpty(query.get${column.capitalColumnName}())) {
             list.add(qdo.${column.changeColumnName}.like(SqlUtil.toSqlLikeString(query.get${column.capitalColumnName}())));
        }
    </#if>
    <#if column.queryType = '!='>
        /** ${column.remark} 不等于 */
        if (!ObjectUtils.isEmpty(query.get${column.capitalColumnName}())) {
            list.add(qdo.${column.changeColumnName}.ne(query.get${column.capitalColumnName}()));
        }
    </#if>
    <#if column.queryType = 'NotNull'>
        /** ${column.remark} 不为空 */
        if (!ObjectUtils.isEmpty(query.get${column.capitalColumnName}())) {
            list.add(qdo.${column.changeColumnName}.isNotNull());
        }
    </#if>
    <#if column.queryType = '>='>
        /** ${column.remark} 大于等于 */
        if (!ObjectUtils.isEmpty(query.get${column.capitalColumnName}())) {
             list.add(qdo.${column.changeColumnName}.goe(query.get${column.capitalColumnName}()));
        }
    </#if>
    <#if column.queryType = '<='>
        /** ${column.remark} 小于等于 */
        if (!ObjectUtils.isEmpty(query.get${column.capitalColumnName}())) {
            list.add(qdo.${column.changeColumnName}.loe(query.get${column.capitalColumnName}()));
        }
    </#if>
    </#list>
    </#if>
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ${className}VO queryByKey(Long id) {
        JPAQuery<${className}VO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<${className}VO> queryListDynamic(${className}Query query) {
        JPAQuery<${className}VO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<${className}VO> queryPaging(${className}Query query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<${className}VO> jpaQuery = getJpaQueryWhere(query);
        List<${className}VO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<${className}VO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ${className}DO save(${className}DO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<${className}DO> saveAll(List<${className}DO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(${className}Payload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
    <#if queryColumns??>
        <#list queryColumns as column>
            <#if column.remark != ''>
        // ${column.remark}
            </#if>
        if (payload.get${column.capitalColumnName}() != null) {
            update.set(qdo.${column.changeColumnName}, payload.get${column.capitalColumnName}());
        }
        </#list>
    </#if>
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
        <#if queryColumns??>
            <#list queryColumns as column>
                <#if column.remark != ''>
            // ${column.remark}
                </#if>
            if (nullFields.contains("${column.changeColumnName}")) {
                update.setNull(qdo.${column.changeColumnName});
            }
            </#list>
        </#if>
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

