/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.common.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.partner.common.payload.BookAccountPayload;
import com.elitesland.tw.tw5.api.partner.common.query.BookAccountQuery;
import com.elitesland.tw.tw5.api.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.partner.common.entity.BookAccountDO;
import com.elitesland.tw.tw5.server.partner.common.entity.QBookAccountDO;
import com.elitesland.tw.tw5.server.partner.common.repo.BookAccountRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BookAccountDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BookAccountRepo repo;
    private final QBookAccountDO qdo = QBookAccountDO.bookAccountDO;

    private JPAQuery<BookAccountVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BookAccountVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.bookId, this.qdo.accountType, this.qdo.depositBank, this.qdo.depositCity, this.qdo.depositBankOutlet, this.qdo.accountName, this.qdo.accountNo, this.qdo.currency, this.qdo.isDefault})).from((EntityPath)this.qdo);
    }

    private JPAQuery<BookAccountVO> getJpaQueryWhere(BookAccountQuery query) {
        JPAQuery<BookAccountVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        return jpaQuery;
    }

    public long count(BookAccountQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BookAccountQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBookId())) {
            list.add(this.qdo.bookId.eq((Object)query.getBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccountType())) {
            list.add(this.qdo.accountType.eq((Object)query.getAccountType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDepositBank())) {
            list.add(this.qdo.depositBank.eq((Object)query.getDepositBank()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDepositCity())) {
            list.add(this.qdo.depositCity.eq((Object)query.getDepositCity()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDepositBankOutlet())) {
            list.add(this.qdo.depositBankOutlet.eq((Object)query.getDepositBankOutlet()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccountName())) {
            list.add(this.qdo.accountName.eq((Object)query.getAccountName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccountNo())) {
            list.add(this.qdo.accountNo.eq((Object)query.getAccountNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCurrency())) {
            list.add(this.qdo.currency.eq((Object)query.getCurrency()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIsDefault())) {
            list.add(this.qdo.isDefault.eq(query.getIsDefault()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BookAccountVO queryByKey(Long id) {
        JPAQuery<BookAccountVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BookAccountVO)jpaQuery.fetchFirst();
    }

    public BookAccountVO queryDefaultByBookId(Long bookId) {
        JPAQuery<BookAccountVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.isDefault.eq(Boolean.TRUE));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BookAccountVO)jpaQuery.fetchFirst();
    }

    public List<BookAccountVO> queryListDynamic(BookAccountQuery query) {
        JPAQuery<BookAccountVO> jpaQuery = this.getJpaQueryWhere(query);
        OrderItem sortNoOrderItem = OrderItem.desc((String)"isDefault");
        OrderItem createTimeOrderItem = OrderItem.desc((String)"createTime");
        ArrayList<OrderItem> OrderItemList = new ArrayList<OrderItem>();
        OrderItemList.add(sortNoOrderItem);
        OrderItemList.add(createTimeOrderItem);
        query.setOrders(OrderItemList);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery.fetch();
    }

    public PagingVO<BookAccountVO> queryPaging(BookAccountQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BookAccountVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BookAccountDO save(BookAccountDO ado) {
        return (BookAccountDO)this.repo.save(ado);
    }

    public List<BookAccountDO> saveAll(List<BookAccountDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BookAccountPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBookId() != null) {
            update.set(this.qdo.bookId, (Object)payload.getBookId());
        }
        if (payload.getAccountType() != null) {
            update.set((Path)this.qdo.accountType, (Object)payload.getAccountType());
        }
        if (payload.getDepositBank() != null) {
            update.set((Path)this.qdo.depositBank, (Object)payload.getDepositBank());
        }
        if (payload.getDepositCity() != null) {
            update.set((Path)this.qdo.depositCity, (Object)payload.getDepositCity());
        }
        if (payload.getDepositBankOutlet() != null) {
            update.set((Path)this.qdo.depositBankOutlet, (Object)payload.getDepositBankOutlet());
        }
        if (payload.getAccountName() != null) {
            update.set((Path)this.qdo.accountName, (Object)payload.getAccountName());
        }
        if (payload.getAccountNo() != null) {
            update.set((Path)this.qdo.accountNo, (Object)payload.getAccountNo());
        }
        if (payload.getCurrency() != null) {
            update.set((Path)this.qdo.currency, (Object)payload.getCurrency());
        }
        if (payload.getIsDefault() != null) {
            update.set((Path)this.qdo.isDefault, (Object)payload.getIsDefault());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("bookId")) {
                update.setNull(this.qdo.bookId);
            }
            if (nullFields.contains("accountType")) {
                update.setNull((Path)this.qdo.accountType);
            }
            if (nullFields.contains("depositBank")) {
                update.setNull((Path)this.qdo.depositBank);
            }
            if (nullFields.contains("depositCity")) {
                update.setNull((Path)this.qdo.depositCity);
            }
            if (nullFields.contains("depositBankOutlet")) {
                update.setNull((Path)this.qdo.depositBankOutlet);
            }
            if (nullFields.contains("accountName")) {
                update.setNull((Path)this.qdo.accountName);
            }
            if (nullFields.contains("accountNo")) {
                update.setNull((Path)this.qdo.accountNo);
            }
            if (nullFields.contains("currency")) {
                update.setNull((Path)this.qdo.currency);
            }
            if (nullFields.contains("isDefault")) {
                update.setNull((Path)this.qdo.isDefault);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<BookAccountDO> queryByBookId(Long bookId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public BookAccountDAO(JPAQueryFactory jpaQueryFactory, BookAccountRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

