/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.common.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.partner.common.payload.BookAddressPayload;
import com.elitesland.tw.tw5.api.partner.common.query.BookAddressQuery;
import com.elitesland.tw.tw5.api.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.server.common.constants.BookAddressTypeEnum;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.partner.common.entity.BookAddressDO;
import com.elitesland.tw.tw5.server.partner.common.entity.QBookAddressDO;
import com.elitesland.tw.tw5.server.partner.common.repo.BookAddressRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BookAddressDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BookAddressRepo repo;
    private final QBookAddressDO qdo = QBookAddressDO.bookAddressDO;

    private JPAQuery<BookAddressVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BookAddressVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.bookId, this.qdo.addressType, this.qdo.country, this.qdo.province, this.qdo.city, this.qdo.district, this.qdo.detailAddress, this.qdo.phone, this.qdo.email, this.qdo.fax, this.qdo.contractName, this.qdo.provinceName, this.qdo.cityName, this.qdo.districtName, this.qdo.isDefault, this.qdo.longitudeLatitude})).from((EntityPath)this.qdo);
    }

    private JPAQuery<BookAddressVO> getJpaQueryWhere(BookAddressQuery query) {
        JPAQuery<BookAddressVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        return jpaQuery;
    }

    public long count(BookAddressQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BookAddressQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBookId())) {
            list.add(this.qdo.bookId.eq((Object)query.getBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAddressType())) {
            list.add(this.qdo.addressType.eq((Object)query.getAddressType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCountry())) {
            list.add(this.qdo.country.eq((Object)query.getCountry()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProvince())) {
            list.add(this.qdo.province.eq((Object)query.getProvince()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCity())) {
            list.add(this.qdo.city.eq((Object)query.getCity()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDistrict())) {
            list.add(this.qdo.district.eq((Object)query.getDistrict()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDetailAddress())) {
            list.add(this.qdo.detailAddress.eq((Object)query.getDetailAddress()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPhone())) {
            list.add(this.qdo.phone.eq((Object)query.getPhone()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEmail())) {
            list.add(this.qdo.email.eq((Object)query.getEmail()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFax())) {
            list.add(this.qdo.fax.eq((Object)query.getFax()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProvinceName())) {
            list.add(this.qdo.provinceName.eq((Object)query.getProvinceName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCityName())) {
            list.add(this.qdo.cityName.eq((Object)query.getCityName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDistrictName())) {
            list.add(this.qdo.districtName.eq((Object)query.getDistrictName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIsDefault())) {
            list.add(this.qdo.isDefault.eq(query.getIsDefault()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLongitudeLatitude())) {
            list.add(this.qdo.longitudeLatitude.eq((Object)query.getLongitudeLatitude()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BookAddressVO queryByKey(Long id) {
        JPAQuery<BookAddressVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BookAddressVO)jpaQuery.fetchFirst();
    }

    public List<BookAddressVO> queryListDynamic(BookAddressQuery query) {
        JPAQuery<BookAddressVO> jpaQuery = this.getJpaQueryWhere(query);
        OrderItem sortNoOrderItem = OrderItem.desc((String)"isDefault");
        OrderItem createTimeOrderItem = OrderItem.desc((String)"createTime");
        ArrayList<OrderItem> OrderItemList = new ArrayList<OrderItem>();
        OrderItemList.add(sortNoOrderItem);
        OrderItemList.add(createTimeOrderItem);
        query.setOrders(OrderItemList);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery.fetch();
    }

    public PagingVO<BookAddressVO> queryPaging(BookAddressQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BookAddressVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BookAddressDO save(BookAddressDO ado) {
        return (BookAddressDO)this.repo.save(ado);
    }

    public List<BookAddressDO> saveAll(List<BookAddressDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BookAddressPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBookId() != null) {
            update.set(this.qdo.bookId, (Object)payload.getBookId());
        }
        if (payload.getAddressType() != null) {
            update.set((Path)this.qdo.addressType, (Object)payload.getAddressType());
        }
        if (payload.getCountry() != null) {
            update.set((Path)this.qdo.country, (Object)payload.getCountry());
        }
        if (payload.getProvince() != null) {
            update.set((Path)this.qdo.province, (Object)payload.getProvince());
        }
        if (payload.getCity() != null) {
            update.set((Path)this.qdo.city, (Object)payload.getCity());
        }
        if (payload.getDistrict() != null) {
            update.set((Path)this.qdo.district, (Object)payload.getDistrict());
        }
        if (payload.getDetailAddress() != null) {
            update.set((Path)this.qdo.detailAddress, (Object)payload.getDetailAddress());
        }
        if (payload.getPhone() != null) {
            update.set((Path)this.qdo.phone, (Object)payload.getPhone());
        }
        if (payload.getEmail() != null) {
            update.set((Path)this.qdo.email, (Object)payload.getEmail());
        }
        if (payload.getFax() != null) {
            update.set((Path)this.qdo.fax, (Object)payload.getFax());
        }
        if (payload.getContractName() != null) {
            update.set((Path)this.qdo.contractName, (Object)payload.getContractName());
        }
        if (payload.getProvinceName() != null) {
            update.set((Path)this.qdo.provinceName, (Object)payload.getProvinceName());
        }
        if (payload.getCityName() != null) {
            update.set((Path)this.qdo.cityName, (Object)payload.getCityName());
        }
        if (payload.getDistrictName() != null) {
            update.set((Path)this.qdo.districtName, (Object)payload.getDistrictName());
        }
        if (payload.getIsDefault() != null) {
            update.set((Path)this.qdo.isDefault, (Object)payload.getIsDefault());
        }
        if (payload.getLongitudeLatitude() != null) {
            update.set((Path)this.qdo.longitudeLatitude, (Object)payload.getLongitudeLatitude());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("bookId")) {
                update.setNull(this.qdo.bookId);
            }
            if (nullFields.contains("addressType")) {
                update.setNull((Path)this.qdo.addressType);
            }
            if (nullFields.contains("country")) {
                update.setNull((Path)this.qdo.country);
            }
            if (nullFields.contains("province")) {
                update.setNull((Path)this.qdo.province);
            }
            if (nullFields.contains("city")) {
                update.setNull((Path)this.qdo.city);
            }
            if (nullFields.contains("district")) {
                update.setNull((Path)this.qdo.district);
            }
            if (nullFields.contains("detailAddress")) {
                update.setNull((Path)this.qdo.detailAddress);
            }
            if (nullFields.contains("phone")) {
                update.setNull((Path)this.qdo.phone);
            }
            if (nullFields.contains("email")) {
                update.setNull((Path)this.qdo.email);
            }
            if (nullFields.contains("fax")) {
                update.setNull((Path)this.qdo.fax);
            }
            if (nullFields.contains("provinceName")) {
                update.setNull((Path)this.qdo.provinceName);
            }
            if (nullFields.contains("cityName")) {
                update.setNull((Path)this.qdo.cityName);
            }
            if (nullFields.contains("districtName")) {
                update.setNull((Path)this.qdo.districtName);
            }
            if (nullFields.contains("isDefault")) {
                update.setNull((Path)this.qdo.isDefault);
            }
            if (nullFields.contains("longitudeLatitude")) {
                update.setNull((Path)this.qdo.longitudeLatitude);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<BookAddressVO> queryAddressByBookId(List<Long> bookIds) {
        JPAQuery from = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BookAddressVO.class, (Expression[])new Expression[]{this.qdo.province, this.qdo.city, this.qdo.district, this.qdo.bookId})).from((EntityPath)this.qdo)).where((Predicate)this.qdo.bookId.in(bookIds).and((Predicate)this.qdo.addressType.eq((Object)BookAddressTypeEnum.company_addr.getCode())))).limit(1L);
        return from.fetch();
    }

    public BookAddressVO queryDefaultByBookId(Long bookId) {
        JPAQuery<BookAddressVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.isDefault.eq(Boolean.TRUE));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BookAddressVO)jpaQuery.fetchFirst();
    }

    public List<BookAddressDO> queryByBookId(Long bookId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public BookAddressDAO(JPAQueryFactory jpaQueryFactory, BookAddressRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

