/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.common.payload.BookAddressPayload;
import com.elitesland.tw.tw5.api.partner.common.query.BookAddressQuery;
import com.elitesland.tw.tw5.api.partner.common.service.BookAddressService;
import com.elitesland.tw.tw5.api.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.partner.common.convert.BookAddressConvert;
import com.elitesland.tw.tw5.server.partner.common.dao.BookAddressDAO;
import com.elitesland.tw.tw5.server.partner.common.entity.BookAddressDO;
import com.elitesland.tw.tw5.server.partner.common.repo.BookAddressRepo;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BookAddressServiceImpl
extends BaseServiceImpl
implements BookAddressService {
    private static final Logger log = LoggerFactory.getLogger(BookAddressServiceImpl.class);
    private final BookAddressRepo bookAddressRepo;
    private final BookAddressDAO bookAddressDAO;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;

    public PagingVO<BookAddressVO> queryPaging(BookAddressQuery query) {
        return this.bookAddressDAO.queryPaging(query);
    }

    public List<BookAddressVO> queryListDynamic(BookAddressQuery query) {
        return this.bookAddressDAO.queryListDynamic(query);
    }

    public BookAddressVO queryByKey(Long key) {
        BookAddressDO entity = this.bookAddressRepo.findById(key).orElseGet(BookAddressDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BookAddressVO vo = BookAddressConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public BookAddressVO queryDefaultByBookId(Long bookId) {
        return this.bookAddressDAO.queryDefaultByBookId(bookId);
    }

    public List<BookAddressVO> queryByBookId(Long bookId) {
        ArrayList<BookAddressVO> bookAddressVOS = new ArrayList<BookAddressVO>();
        List<BookAddressDO> bookAddressDOS = this.bookAddressDAO.queryByBookId(bookId);
        for (BookAddressDO bookAddressDO : bookAddressDOS) {
            bookAddressVOS.add(BookAddressConvert.INSTANCE.toVo(bookAddressDO));
        }
        return bookAddressVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public BookAddressVO insert(BookAddressPayload payload, Boolean logFlag) {
        BookAddressDO byBookIdAndIsDefault = this.bookAddressRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
        if (payload.getIsDefault() != null && payload.getIsDefault().booleanValue() && byBookIdAndIsDefault != null) {
            byBookIdAndIsDefault.setIsDefault(false);
            this.bookAddressRepo.save(byBookIdAndIsDefault);
        }
        if (byBookIdAndIsDefault == null) {
            payload.setIsDefault(Boolean.valueOf(true));
        }
        BookAddressDO entityDo = BookAddressConvert.INSTANCE.toDo(payload);
        if (logFlag.booleanValue() && payload.getPartnerId() != null) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u65b0\u589e\u4e86\u4e00\u6761\u5730\u5740\u4fe1\u606f");
        }
        return BookAddressConvert.INSTANCE.toVo((BookAddressDO)this.bookAddressRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BookAddressVO update(BookAddressPayload payload, Boolean logFlag) {
        BookAddressDO byBookIdAndIsDefault;
        BookAddressDO entity = this.bookAddressRepo.findById(payload.getId()).orElseGet(BookAddressDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BookAddressDO entityLog = new BookAddressDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        if (payload.getIsDefault() != null && payload.getIsDefault().booleanValue() && (byBookIdAndIsDefault = this.bookAddressRepo.findByBookIdAndIsDefault(payload.getBookId(), true)) != null && !byBookIdAndIsDefault.getId().equals(payload.getId())) {
            byBookIdAndIsDefault.setIsDefault(false);
            this.bookAddressRepo.save(byBookIdAndIsDefault);
        }
        BookAddressDO entityDo = BookAddressConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (logFlag.booleanValue() && null != payload.getPartnerId()) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u4fee\u6539\u4e86\u4e00\u6761\u5730\u5740\u4fe1\u606f");
        }
        return BookAddressConvert.INSTANCE.toVo((BookAddressDO)this.bookAddressRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys, Long bookId, Long partnerId, Boolean logFlag) {
        if (!keys.isEmpty()) {
            for (int i = 0; i < keys.size(); ++i) {
                Optional optional = this.bookAddressRepo.findById(keys.get(i));
                if (optional.isEmpty()) continue;
                BookAddressDO entity = (BookAddressDO)optional.get();
                entity.setDeleteFlag(1);
                this.bookAddressRepo.save(entity);
            }
            List<BookAddressDO> dos = this.bookAddressDAO.queryByBookId(bookId);
            if (dos != null && dos.size() == 1) {
                BookAddressDO bookAddressDO = dos.get(0);
                bookAddressDO.setIsDefault(true);
                this.bookAddressRepo.save(bookAddressDO);
            }
            if (logFlag.booleanValue() && partnerId != null) {
                this.logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u5220\u9664\u4e86 " + keys.size() + " \u6761\u5730\u5740\u4fe1\u606f");
            }
        }
    }

    public Long count(BookAddressQuery query) {
        return this.bookAddressDAO.count(query);
    }

    public BookAddressServiceImpl(BookAddressRepo bookAddressRepo, BookAddressDAO bookAddressDAO, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil) {
        this.bookAddressRepo = bookAddressRepo;
        this.bookAddressDAO = bookAddressDAO;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
    }
}

