/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.partner.strategy.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.partner.strategy.payload.BusinessStrategyRefPayload;
import com.elitesland.tw.tw5.api.partner.strategy.query.BusinessStrategyRefQuery;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.api.partner.strategy.vo.BusinessStrategyRefVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.partner.identity.entity.QBusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.partner.strategy.entity.BusinessStrategyRefDO;
import com.elitesland.tw.tw5.server.partner.strategy.entity.QBusinessStrategyRefDO;
import com.elitesland.tw.tw5.server.partner.strategy.repo.BusinessStrategyRefRepo;
import com.elitesland.tw.tw5crm.server.partner.business.entity.QBusinessCustomerOperationDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BusinessStrategyRefDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessStrategyRefRepo repo;
    private final QBusinessStrategyRefDO qdo = QBusinessStrategyRefDO.businessStrategyRefDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBusinessCustomerOperationDO qBusinessCustomerOperationDO = QBusinessCustomerOperationDO.businessCustomerOperationDO;
    private final QBusinessCustomerInfoDO qBusinessCustomerInfoDO = QBusinessCustomerInfoDO.businessCustomerInfoDO;

    private JPAQuery<BusinessStrategyRefVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessStrategyRefVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.strategyId, this.qdo.partnerId, this.qdo.optionScore, this.qdo.sortNo, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5})).from((EntityPath)this.qdo);
    }

    private JPAQuery<BusinessStrategyRefVO> getJpaQueryWhere(BusinessStrategyRefQuery query) {
        JPAQuery<BusinessStrategyRefVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(BusinessStrategyRefQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BusinessStrategyRefQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStrategyId())) {
            list.add(this.qdo.strategyId.eq((Object)query.getStrategyId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerId())) {
            list.add(this.qdo.partnerId.eq((Object)query.getPartnerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOptionScore())) {
            list.add(this.qdo.optionScore.eq((Object)query.getOptionScore()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortNo())) {
            list.add(this.qdo.sortNo.eq((Object)query.getSortNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qdo.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt2())) {
            list.add(this.qdo.ext2.eq((Object)query.getExt2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt3())) {
            list.add(this.qdo.ext3.eq((Object)query.getExt3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt4())) {
            list.add(this.qdo.ext4.eq((Object)query.getExt4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt5())) {
            list.add(this.qdo.ext5.eq((Object)query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BusinessStrategyRefVO queryByKey(Long id) {
        JPAQuery<BusinessStrategyRefVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BusinessStrategyRefVO)jpaQuery.fetchFirst();
    }

    public List<BusinessStrategyRefVO> queryListDynamic(BusinessStrategyRefQuery query) {
        JPAQuery<BusinessStrategyRefVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<BusinessStrategyRefVO> queryPaging(BusinessStrategyRefQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BusinessStrategyRefVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BusinessStrategyRefDO save(BusinessStrategyRefDO ado) {
        return (BusinessStrategyRefDO)this.repo.save(ado);
    }

    public List<BusinessStrategyRefDO> saveAll(List<BusinessStrategyRefDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BusinessStrategyRefPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getStrategyId() != null) {
            update.set(this.qdo.strategyId, (Object)payload.getStrategyId());
        }
        if (payload.getPartnerId() != null) {
            update.set(this.qdo.partnerId, (Object)payload.getPartnerId());
        }
        if (payload.getOptionScore() != null) {
            update.set(this.qdo.optionScore, (Object)payload.getOptionScore());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("strategyId")) {
                update.setNull(this.qdo.strategyId);
            }
            if (nullFields.contains("partnerId")) {
                update.setNull(this.qdo.partnerId);
            }
            if (nullFields.contains("optionScore")) {
                update.setNull(this.qdo.optionScore);
            }
            if (nullFields.contains("sortNo")) {
                update.setNull(this.qdo.sortNo);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByStrategyId(Long strategyId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.strategyId.eq((Object)strategyId)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<BusinessStrategyRefVO> findByStrategyId(Long stratrgyId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessStrategyRefVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.strategyId, this.qdo.partnerId, this.qBusinessPartnerDO.partnerName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessPartnerDO.id));
        jpaQuery.where((Predicate)this.qdo.strategyId.eq((Object)stratrgyId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<BusinessStrategyCustomerVO> queryAppointCustomerInfoByStrategyId(Long stratrgyId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessStrategyCustomerVO.class, (Expression[])new Expression[]{this.qBusinessCustomerInfoDO.id, this.qBusinessPartnerDO.id.as("partnerId"), this.qBusinessPartnerDO.partnerNature, this.qBusinessPartnerDO.organizationScale, this.qBusinessCustomerOperationDO.companyTightness, this.qBusinessCustomerOperationDO.industryStand, this.qBusinessCustomerOperationDO.businessStrategy})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessPartnerDO.id))).leftJoin((EntityPath)this.qBusinessCustomerOperationDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessCustomerOperationDO.partnerId))).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qdo.partnerId.eq(this.qBusinessCustomerInfoDO.partnerId))).where((Predicate)this.qBusinessPartnerDO.deleteFlag.eq((Object)0))).where((Predicate)this.qBusinessCustomerInfoDO.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.strategyId.eq((Object)stratrgyId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public BusinessStrategyRefDAO(JPAQueryFactory jpaQueryFactory, BusinessStrategyRefRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

