/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOptionQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadPagingVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsOptionVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsVO;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmLeadsRepo;
import com.elitesland.tw.tw5.server.prd.prj.convert.PrjProjectConvert;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmLeadsDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmLeadsRepo repo;
    private final QCrmLeadsDO qdo = QCrmLeadsDO.crmLeadsDO;
    private final QPrjProjectDO qPrjProjectDO = QPrjProjectDO.prjProjectDO;
    private final QCrmLeadsOffshoreDO qCrmLeadsOffshoreDO = QCrmLeadsOffshoreDO.crmLeadsOffshoreDO;
    private final QCrmLeadsCustomerDO qCrmLeadsCustomerDO = QCrmLeadsCustomerDO.crmLeadsCustomerDO;

    public CrmLeadsDO save(CrmLeadsDO ado) {
        return (CrmLeadsDO)this.repo.save(ado);
    }

    public List<CrmLeadsDO> saveAll(List<CrmLeadsDO> dos) {
        return this.repo.saveAll(dos);
    }

    public CrmLeadsVO queryByKey(Long id) {
        JPAQuery<CrmLeadsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.id.eq((Object)id));
        return (CrmLeadsVO)jpaQuery.fetchFirst();
    }

    private JPAQuery<CrmLeadsVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmLeadsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.leadsNo, this.qdo.leadsName, this.qdo.leadsStatus, this.qdo.leadsStage, this.qdo.sourceType, this.qdo.channel, this.qdo.saleUserId, this.qdo.bonusDistributeType, this.qdo.closeReason, this.qdo.backReason, this.qdo.withdrawReason})).from((EntityPath)this.qdo);
        return jpaQuery;
    }

    private JPAQuery<CrmLeadsVO> getJpaQueryWhere(CrmLeadsQuery query) {
        JPAQuery<CrmLeadsVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getLeadsNo())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsNo.like(SqlUtil.toSqlLikeString((String)query.getLeadsNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsName())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsName.like(SqlUtil.toSqlLikeString((String)query.getLeadsName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsStatus())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsStatus.eq((Object)query.getLeadsStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsStage())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsStage.eq((Object)query.getLeadsStage()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.sourceType.eq((Object)query.getSourceType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerId())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.partnerId.eq((Object)query.getPartnerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMarketId())) {
            // empty if block
        }
        if (!ObjectUtils.isEmpty((Object)query.getChannel())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.channel.like(SqlUtil.toSqlLikeString((String)query.getChannel())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleUserId())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.saleUserId.eq((Object)query.getSaleUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBonusDistributeType())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.bonusDistributeType.eq((Object)query.getBonusDistributeType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCloseReason())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.closeReason.like(SqlUtil.toSqlLikeString((String)query.getCloseReason())));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public Specification<CrmLeadsDO> getSpec(CrmLeadsQuery query) {
        Specification & Serializable querySpecifi = (Specification & Serializable)(root, criteriaQuery, cb) -> {
            CriteriaBuilder.In in;
            Path ids;
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (!ObjectUtils.isEmpty((Object)query.getOffshoreId())) {
                predicates.add(cb.equal(root.get("offshoreId").as(String.class), (Object)query.getOffshoreId()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
                predicates.add(cb.equal(root.get("createUserId").as(String.class), (Object)query.getCreateUserId()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getSaleOrCreateUserId())) {
                Predicate pred1 = cb.equal((javax.persistence.criteria.Expression)root.get("saleUserId"), (Object)query.getSaleOrCreateUserId());
                Predicate pred2 = cb.equal((javax.persistence.criteria.Expression)root.get("createUserId"), (Object)query.getSaleOrCreateUserId());
                predicates.add(cb.or((javax.persistence.criteria.Expression)pred1, (javax.persistence.criteria.Expression)pred2));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsIdsForFollow())) {
                ids = root.get("id");
                in = cb.in((javax.persistence.criteria.Expression)ids);
                for (Object id : query.getLeadsIdsForFollow()) {
                    in.value(id);
                }
                predicates.add(cb.and(new Predicate[]{in}));
            }
            if (!ObjectUtils.isEmpty((Object)query.getSaleUserId())) {
                Predicate pred2 = cb.equal((javax.persistence.criteria.Expression)root.get("saleUserId"), (Object)query.getSaleUserId());
                if (!CollectionUtils.isEmpty((Collection)query.getIds())) {
                    Path ids2 = root.get("id");
                    CriteriaBuilder.In in2 = cb.in((javax.persistence.criteria.Expression)ids2);
                    for (Long id : query.getIds()) {
                        in2.value((Object)id);
                    }
                    CriteriaBuilder.In pred1 = in2;
                    predicates.add(cb.or((javax.persistence.criteria.Expression)pred1, (javax.persistence.criteria.Expression)pred2));
                } else {
                    predicates.add(pred2);
                }
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsStageNotEqual())) {
                predicates.add(cb.notEqual(root.get("leadsStage").as(String.class), (Object)query.getLeadsStageNotEqual()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsStatusNotIn())) {
                List leadsStatusNotIn = query.getLeadsStatusNotIn();
                for (String s : leadsStatusNotIn) {
                    predicates.add(cb.notEqual(root.get("leadsStatus").as(String.class), (Object)s));
                }
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsStageNotIn())) {
                List leadsStageNotIn = query.getLeadsStageNotIn();
                for (String s : leadsStageNotIn) {
                    predicates.add(cb.notEqual(root.get("leadsStage").as(String.class), (Object)s));
                }
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsStageIn())) {
                ids = root.get("leadsStage");
                in = cb.in((javax.persistence.criteria.Expression)ids);
                for (Object id : query.getLeadsStageIn()) {
                    in.value(id);
                }
                predicates.add(cb.and(new Predicate[]{in}));
            }
            if (!ObjectUtils.isEmpty((Object)query.getNotFollowLeadsRemindTimeNotNull()) && query.getNotFollowLeadsRemindTimeNotNull().booleanValue()) {
                predicates.add(cb.isNotNull((javax.persistence.criteria.Expression)root.get("notFollowLeadsRemindTime")));
            }
            if (!StringUtils.isEmpty((CharSequence)query.getLeadsNo())) {
                predicates.add(cb.like(root.get("leadNo").as(String.class), SqlUtil.toSqlLikeString((String)query.getLeadsNo())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsName())) {
                predicates.add(cb.like(root.get("leadsName").as(String.class), SqlUtil.toSqlLikeString((String)query.getLeadsName())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsStatus())) {
                predicates.add(cb.equal(root.get("leadsStatus").as(String.class), (Object)query.getLeadsStatus()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getLeadsStage())) {
                predicates.add(cb.equal(root.get("leadsStage").as(String.class), (Object)query.getLeadsStage()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
                predicates.add(cb.equal(root.get("sourceType").as(String.class), (Object)query.getSourceType()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getFormalCustomerId())) {
                predicates.add(cb.equal(root.get("formalCustomerId").as(Long.class), (Object)query.getFormalCustomerId()));
            }
            Join marketJoin = root.join("market", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getMarketId())) {
                predicates.add(cb.equal(marketJoin.get("id").as(Long.class), (Object)query.getMarketId()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart())) {
                predicates.add(cb.greaterThanOrEqualTo(root.get("createTime").as(LocalDateTime.class), (Comparable)query.getCreateTimeStart()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
                predicates.add(cb.lessThanOrEqualTo(root.get("createTime").as(LocalDateTime.class), (Comparable)query.getCreateTimeEnd()));
            }
            Join customerJoin = root.join("customer", JoinType.LEFT);
            if (!ObjectUtils.isEmpty((Object)query.getCustomerName())) {
                predicates.add(cb.like(customerJoin.get("customerName").as(String.class), SqlUtil.toSqlLikeString((String)query.getCustomerName())));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCustomerIndustry())) {
                predicates.add(cb.equal(customerJoin.get("customerIndustry").as(String.class), (Object)query.getCustomerIndustry()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCustomerGrade())) {
                predicates.add(cb.equal(customerJoin.get("customerGrade").as(String.class), (Object)query.getCustomerGrade()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCustRegion())) {
                predicates.add(cb.equal(customerJoin.get("custRegion").as(String.class), (Object)query.getCustRegion()));
            }
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        return querySpecifi;
    }

    public List<CrmLeadsVO> queryListDynamic(CrmLeadsQuery query) {
        JPAQuery<CrmLeadsVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<CrmLeadsVO> queryPaging(CrmLeadsQuery query) {
        JPAQuery<CrmLeadsVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    @Transactional
    public long updateByKeyDynamic(CrmLeadsPayload payload) {
        CrmLeadsDO crmLeadsDO = this.repo.findById(payload.getId()).orElse(null);
        if (crmLeadsDO != null) {
            List nullFields;
            if (payload.getRemark() != null) {
                crmLeadsDO.setRemark(payload.getRemark());
            }
            if (payload.getPartnerId() != null) {
                crmLeadsDO.setPartnerId(payload.getPartnerId());
            }
            if (payload.getOffshoreId() != null) {
                crmLeadsDO.setOffshoreId(payload.getOffshoreId());
            }
            if (payload.getLeadsNo() != null) {
                crmLeadsDO.setLeadsNo(payload.getLeadsNo());
            }
            if (payload.getLeadsName() != null) {
                crmLeadsDO.setLeadsName(payload.getLeadsName());
            }
            if (payload.getAnnualTurnover() != null) {
                crmLeadsDO.setAnnualTurnover(payload.getAnnualTurnover());
            }
            if (payload.getArea() != null) {
                crmLeadsDO.setArea(payload.getArea());
            }
            if (payload.getLeadsStatus() != null) {
                crmLeadsDO.setLeadsStatus(payload.getLeadsStatus());
            }
            if (payload.getLeadsStage() != null) {
                crmLeadsDO.setLeadsStage(payload.getLeadsStage());
            }
            if (payload.getSourceType() != null) {
                crmLeadsDO.setSourceType(payload.getSourceType());
            }
            if (payload.getMarket() != null) {
                crmLeadsDO.setMarket(PrjProjectConvert.INSTANCE.toDo(payload.getMarket()));
            }
            if (payload.getChannel() != null) {
                crmLeadsDO.setChannel(payload.getChannel());
            }
            if (payload.getSaleUserId() != null) {
                crmLeadsDO.setSaleUserId(payload.getSaleUserId());
            }
            if (payload.getPreSaleUserId() != null) {
                crmLeadsDO.setPreSaleUserId(payload.getPreSaleUserId());
            }
            if (payload.getBonusDistributeType() != null) {
                crmLeadsDO.setBonusDistributeType(payload.getBonusDistributeType());
            }
            if (payload.getBonusDistributeTo() != null) {
                crmLeadsDO.setBonusDistributeTo(payload.getBonusDistributeTo());
            }
            if (payload.getDistributeDate() != null) {
                crmLeadsDO.setDistributeDate(payload.getDistributeDate());
            }
            if (payload.getCloseReason() != null) {
                crmLeadsDO.setCloseReason(payload.getCloseReason());
            }
            if (payload.getWithdrawReason() != null) {
                crmLeadsDO.setWithdrawReason(payload.getWithdrawReason());
            }
            if (payload.getBackReason() != null) {
                crmLeadsDO.setBackReason(payload.getBackReason());
            }
            if (payload.getNotFollowLeadsRemindTime() != null) {
                crmLeadsDO.setNotFollowLeadsRemindTime(payload.getNotFollowLeadsRemindTime());
            }
            if (payload.getLeadsTagIds() != null) {
                crmLeadsDO.setLeadsTagIds(payload.getLeadsTagIds());
            }
            if (payload.getExtString1() != null) {
                crmLeadsDO.setExtString1(payload.getExtString1());
            }
            if (payload.getExtString2() != null) {
                crmLeadsDO.setExtString2(payload.getExtString2());
            }
            if (payload.getExtString3() != null) {
                crmLeadsDO.setExtString3(payload.getExtString3());
            }
            if (payload.getExtString4() != null) {
                crmLeadsDO.setExtString4(payload.getExtString4());
            }
            if (payload.getExtString5() != null) {
                crmLeadsDO.setExtString5(payload.getExtString5());
            }
            if (payload.getMarketChannel() != null) {
                crmLeadsDO.setMarketChannel(payload.getMarketChannel());
            }
            if (payload.getFormalCustomerId() != null) {
                crmLeadsDO.setFormalCustomerId(payload.getFormalCustomerId());
            }
            if (payload.getDemandProduct() != null) {
                crmLeadsDO.setDemandProduct(payload.getDemandProduct());
            }
            if (payload.getDemandProductOrg() != null) {
                crmLeadsDO.setDemandProductOrg(payload.getDemandProductOrg());
            }
            if (payload.getLeadsIdV4() != null) {
                crmLeadsDO.setLeadsIdV4(payload.getLeadsIdV4());
            }
            if (payload.getCustomer() != null) {
                CrmLeadsCustomerDO customerDO = crmLeadsDO.getCustomer();
                CrmLeadsCustomerPayload customer = payload.getCustomer();
                if (customer.getCustomerName() != null) {
                    customerDO.setCustomerName(customer.getCustomerName());
                }
                if (customer.getCustomerIndustry() != null) {
                    customerDO.setCustomerIndustry(customer.getCustomerIndustry());
                }
                if (customer.getCustomerGrade() != null) {
                    customerDO.setCustomerGrade(customer.getCustomerGrade());
                }
                if (customer.getCustomerContacts() != null) {
                    customerDO.setCustomerContacts(customer.getCustomerContacts());
                }
                if (customer.getContactsDepartment() != null) {
                    customerDO.setContactsDepartment(customer.getContactsDepartment());
                }
                if (customer.getContactsPosition() != null) {
                    customerDO.setContactsPosition(customer.getContactsPosition());
                }
                if (customer.getContactsPhone() != null) {
                    customerDO.setContactsPhone(customer.getContactsPhone());
                }
                if (customer.getContactsEmail() != null) {
                    customerDO.setContactsEmail(customer.getContactsEmail());
                }
                if (customer.getCustRegion() != null) {
                    customerDO.setCustRegion(customer.getCustRegion());
                }
                if (customer.getSaleProduct() != null) {
                    customerDO.setSaleProduct(customer.getSaleProduct());
                }
                crmLeadsDO.setCustomer(customerDO);
            }
            if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
                if (nullFields.contains("market")) {
                    crmLeadsDO.setMarket(null);
                }
                if (nullFields.contains("channel")) {
                    crmLeadsDO.setChannel(null);
                }
                if (nullFields.contains("saleUserId")) {
                    crmLeadsDO.setSaleUserId(null);
                }
                if (nullFields.contains("bonusDistributeType")) {
                    crmLeadsDO.setBonusDistributeType(null);
                }
                if (nullFields.contains("bonusDistributeTo")) {
                    crmLeadsDO.setBonusDistributeTo(null);
                }
                if (nullFields.contains("closeReason")) {
                    crmLeadsDO.setCloseReason(null);
                }
                if (nullFields.contains("distributeDate")) {
                    crmLeadsDO.setDistributeDate(null);
                }
                if (nullFields.contains("notFollowLeadsRemindTime")) {
                    crmLeadsDO.setNotFollowLeadsRemindTime(null);
                }
            }
            this.repo.save(crmLeadsDO);
            return 1L;
        }
        return 0L;
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new com.querydsl.core.types.Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public Page<CrmLeadsDO> findAll(Specification<CrmLeadsDO> spec, Pageable pageable) {
        pageable = PageUtil.defaultSort((Pageable)pageable);
        return this.repo.findAll(spec, pageable);
    }

    public List<CrmLeadsDO> findAll(Specification<CrmLeadsDO> spec) {
        return this.repo.findAll(spec);
    }

    public CrmLeadsDO queryById(Long id) {
        return this.repo.findById(id).orElse(null);
    }

    public List<Long> queryByFormalCustomerId(Long customerId) {
        return this.repo.queryByFormalCustomerId(customerId);
    }

    public List<Long> queryByFormalPartnerId(Long partnerId) {
        return this.repo.queryByFormalPartnerId(partnerId);
    }

    public List<Long> findNotBindLeads() {
        return this.repo.findNotBindLeads();
    }

    public void updateCustomerGrade(List<Long> leadsIds, String grade) {
        this.repo.updateCustomerGrade(leadsIds, grade);
    }

    public CrmLeadsDO findByPotentialCustomerId(Long id) {
        List<CrmLeadsDO> leadsDOS = this.repo.findByPotentialCustomerIdOrderByCreateTimeDesc(id);
        if (leadsDOS != null && !leadsDOS.isEmpty()) {
            return leadsDOS.get(0);
        }
        return null;
    }

    public List<Long> queryNotBindLeads() {
        return this.repo.queryNotBindLeads();
    }

    public PagingVO<CrmLeadPagingVO> pagingCrmLead(CrmLeadsQuery query) {
        long total = this.countPagingCrmLead(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmLeadPagingVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createTime, this.qdo.createUserId, this.qdo.offshoreId, this.qdo.leadsNo, this.qdo.leadsName, this.qdo.leadsStatus, this.qdo.leadsStage, this.qdo.sourceType, this.qdo.market.id.as("marketId"), this.qdo.saleUserId, this.qCrmLeadsCustomerDO.customerName, this.qCrmLeadsCustomerDO.customerIndustry, this.qCrmLeadsCustomerDO.contactsPhone, this.qCrmLeadsCustomerDO.customerContacts, this.qCrmLeadsCustomerDO.customerGrade, this.qCrmLeadsCustomerDO.contactsDepartment, this.qCrmLeadsCustomerDO.contactsPosition, this.qdo.partnerId, this.qdo.demandProduct, this.qPrjProjectDO.projectNo, this.qPrjProjectDO.projectName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qCrmLeadsCustomerDO)).on((com.querydsl.core.types.Predicate)this.qdo.customer.id.eq(this.qCrmLeadsCustomerDO.id))).leftJoin((EntityPath)this.qPrjProjectDO)).on((com.querydsl.core.types.Predicate)this.qdo.market.id.eq((Expression)this.qPrjProjectDO.id));
        this.wherePagingCrmLead(jpaQuery, query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public Long countPagingCrmLead(CrmLeadsQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qCrmLeadsCustomerDO)).on((com.querydsl.core.types.Predicate)this.qdo.customer.id.eq(this.qCrmLeadsCustomerDO.id))).leftJoin((EntityPath)this.qPrjProjectDO)).on((com.querydsl.core.types.Predicate)this.qdo.market.id.eq((Expression)this.qPrjProjectDO.id));
        this.wherePagingCrmLead(jpaQuery, query);
        return (Long)jpaQuery.fetchOne();
    }

    public void wherePagingCrmLead(JPAQuery jpaQuery, CrmLeadsQuery query) {
        if (!ObjectUtils.isEmpty((Object)query.getLeadsNo())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsNo.like(SqlUtil.toSqlLikeString((String)query.getLeadsNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerId())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.partnerId.eq((Object)query.getPartnerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsName())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsName.like(SqlUtil.toSqlLikeString((String)query.getLeadsName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsStatus())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsStatus.eq((Object)query.getLeadsStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsStage())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsStage.eq((Object)query.getLeadsStage()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerIndustry())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.customerIndustry.eq((Object)query.getCustomerIndustry()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerName())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.customerName.eq((Object)query.getCustomerName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerGrade())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.customerGrade.eq((Object)query.getCustomerGrade()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.createTime.goe((Comparable)query.getCreateTimeStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.createTime.loe((Comparable)query.getCreateTimeEnd()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.sourceType.eq((Object)query.getSourceType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsStatusNotIn())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsStatus.notIn((Collection)query.getLeadsStatusNotIn()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsStageIn())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsStage.in((Collection)query.getLeadsStageIn()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsStageNotIn())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsStage.notIn((Collection)query.getLeadsStageNotIn()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleUserId())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.saleUserId.eq((Object)query.getSaleUserId()));
        }
        List<Long> list = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)query.getLeadsIdsForFollow())) {
            list = query.getLeadsIdsForFollow();
        }
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(query.getId());
        }
        if (list != null && list.size() > 0) {
            if (list.size() == 1) {
                jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.id.eq((Object)((Long)list.get(0))));
            } else {
                jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.id.in(list));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemark())) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.remark.like(SqlUtil.toSqlLikeString((String)query.getRemark())));
        }
        if (query.getSourceUserIds() != null && query.getSourceUserIds().size() > 0) {
            jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.sourceUserId.in((Collection)query.getSourceUserIds()));
        }
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
    }

    public PagingVO<CrmLeadsOptionVO> repeatPaging(CrmLeadsOptionQuery query) {
        JPAQuery<CrmLeadsOptionVO> jpaQuery = this.getJpaQueryRepeatPagingSelect();
        jpaQuery.where(this.checkRepeatWhere(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        if (!StringUtils.isEmpty((CharSequence)query.getOption())) {
            String[] optionArr = query.getOption().split(",");
            block16: for (int i = 0; i < optionArr.length; ++i) {
                switch (optionArr[i]) {
                    case "leadsName": {
                        jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsName.isNotNull().and((com.querydsl.core.types.Predicate)this.qdo.leadsName.ne((Object)"")));
                        jpaQuery.groupBy((Expression)this.qdo.leadsName);
                        continue block16;
                    }
                    case "customerName": {
                        jpaQuery.where((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.customerName.isNotNull().and((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.customerName.ne((Object)"")));
                        jpaQuery.groupBy((Expression)this.qCrmLeadsCustomerDO.customerName);
                        continue block16;
                    }
                    case "customerContacts": {
                        jpaQuery.where((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.customerContacts.isNotNull().and((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.customerContacts.ne((Object)"")));
                        jpaQuery.groupBy((Expression)this.qCrmLeadsCustomerDO.customerContacts);
                        continue block16;
                    }
                    case "contactsPhone": {
                        jpaQuery.where((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.contactsPhone.isNotNull().and((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.contactsPhone.ne((Object)"")));
                        jpaQuery.groupBy((Expression)this.qCrmLeadsCustomerDO.contactsPhone);
                        continue block16;
                    }
                    case "demandProduct": {
                        jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.demandProduct.isNotNull().and((com.querydsl.core.types.Predicate)this.qdo.demandProduct.ne((Object)"")));
                        jpaQuery.groupBy((Expression)this.qdo.demandProduct);
                        continue block16;
                    }
                    case "leadsStage": {
                        jpaQuery.where((com.querydsl.core.types.Predicate)this.qdo.leadsStage.isNotNull().and((com.querydsl.core.types.Predicate)this.qdo.leadsStage.ne((Object)"")));
                        jpaQuery.groupBy((Expression)this.qdo.leadsStage);
                        continue block16;
                    }
                }
            }
        } else {
            jpaQuery.groupBy(this.qdo.id);
        }
        jpaQuery.having((com.querydsl.core.types.Predicate)this.qdo.count().gt((Number)1));
        List fetch = jpaQuery.fetch();
        if (fetch == null || fetch.size() == 0) {
            return PagingVO.empty();
        }
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total((long)fetch.size()).build();
    }

    public PagingVO<CrmLeadsOptionVO> repeatDeatilPaging(CrmLeadsOptionQuery query) {
        long total = this.repeatDetailPagingCount(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<CrmLeadsOptionVO> jpaQuery = this.repeatDetailPagingJpaQuerySelect();
        jpaQuery.where(this.repeatDetailPagingWhere(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    private JPAQuery<CrmLeadsOptionVO> getJpaQueryRepeatPagingSelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmLeadsOptionVO.class, (Expression[])new Expression[]{this.qdo.count().as("count"), this.qdo.id, this.qdo.createTime, this.qdo.createUserId, this.qdo.creator, this.qdo.offshoreId, this.qdo.leadsNo, this.qdo.leadsName, this.qdo.leadsStatus, this.qdo.leadsStage, this.qdo.saleUserId, this.qCrmLeadsCustomerDO.contactsPhone, this.qCrmLeadsCustomerDO.customerGrade, this.qCrmLeadsCustomerDO.customerContacts, this.qCrmLeadsCustomerDO.customerName, this.qCrmLeadsCustomerDO.customerIndustry, this.qCrmLeadsCustomerDO.contactsEmail, this.qdo.demandProduct})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qCrmLeadsCustomerDO)).on((com.querydsl.core.types.Predicate)this.qdo.customer.id.eq(this.qCrmLeadsCustomerDO.id).and((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.deleteFlag.eq((Object)0)));
    }

    public com.querydsl.core.types.Predicate checkRepeatWhere(CrmLeadsOptionQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getLeadsStatusNotIn())) {
            list.add(this.qdo.leadsStatus.notIn((Collection)query.getLeadsStatusNotIn()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsStageIn())) {
            list.add(this.qdo.leadsStage.in((Collection)query.getLeadsStageIn()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleUserId())) {
            list.add(this.qdo.saleUserId.eq((Object)query.getSaleUserId()));
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            idList.add(query.getId());
        }
        if (idList != null && idList.size() > 0) {
            if (idList.size() == 1) {
                list.add(this.qdo.id.eq((Object)((Long)idList.get(0))));
            } else {
                list.add(this.qdo.id.in(idList));
            }
        }
        return ExpressionUtils.allOf(list);
    }

    private JPAQuery<CrmLeadsOptionVO> repeatDetailPagingJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmLeadsOptionVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createTime, this.qdo.createUserId, this.qdo.creator, this.qdo.offshoreId, this.qdo.leadsNo, this.qdo.leadsName, this.qdo.leadsStatus, this.qdo.leadsStage, this.qdo.saleUserId, this.qCrmLeadsCustomerDO.contactsPhone, this.qCrmLeadsCustomerDO.customerGrade, this.qCrmLeadsCustomerDO.customerContacts, this.qCrmLeadsCustomerDO.customerName, this.qCrmLeadsCustomerDO.customerIndustry, this.qdo.demandProduct})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qCrmLeadsCustomerDO)).on((com.querydsl.core.types.Predicate)this.qdo.customer.id.eq(this.qCrmLeadsCustomerDO.id).and((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.deleteFlag.eq((Object)0)));
    }

    private com.querydsl.core.types.Predicate repeatDetailPagingWhere(CrmLeadsOptionQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getLeadsName())) {
            list.add(this.qdo.leadsName.eq((Object)query.getLeadsName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerName())) {
            list.add(this.qCrmLeadsCustomerDO.customerName.eq((Object)query.getCustomerName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContactsPhone())) {
            list.add(this.qCrmLeadsCustomerDO.contactsPhone.eq((Object)query.getContactsPhone()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerContacts())) {
            list.add(this.qCrmLeadsCustomerDO.customerContacts.eq((Object)query.getCustomerContacts()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDemandProduct())) {
            list.add(this.qdo.demandProduct.eq((Object)query.getDemandProduct()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsId())) {
            list.add(this.qdo.id.eq((Object)query.getLeadsId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsStatusNotIn())) {
            list.add(this.qdo.leadsStatus.notIn((Collection)query.getLeadsStatusNotIn()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsStageIn())) {
            list.add(this.qdo.leadsStage.in((Collection)query.getLeadsStageIn()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleUserId())) {
            list.add(this.qdo.saleUserId.eq((Object)query.getSaleUserId()));
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            idList.add(query.getId());
        }
        if (idList != null && idList.size() > 0) {
            if (idList.size() == 1) {
                list.add(this.qdo.id.eq((Object)((Long)idList.get(0))));
            } else {
                list.add(this.qdo.id.in(idList));
            }
        }
        return ExpressionUtils.allOf(list);
    }

    public long repeatDetailPagingCount(CrmLeadsOptionQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qCrmLeadsCustomerDO)).on((com.querydsl.core.types.Predicate)this.qdo.customer.id.eq(this.qCrmLeadsCustomerDO.id).and((com.querydsl.core.types.Predicate)this.qCrmLeadsCustomerDO.deleteFlag.eq((Object)0)));
        jpaQuery.where(this.repeatDetailPagingWhere(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    public Long count(CrmLeadsQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        this.wherePagingCrmLead(jpaQuery, query);
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    public CrmLeadsDAO(JPAQueryFactory jpaQueryFactory, CrmLeadsRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

