/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.change.payload.PrdSystemBusinessChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.PrdSystemBusinessChangeVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActPlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActPlanService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemWorkTypeVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.change.dao.PrdSystemBusinessChangeDAO;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActPlanConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActPlanDetailConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActPlanDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActActivityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActPlanDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CrmActPlanServiceImpl
extends BaseServiceImpl
implements CrmActPlanService {
    private static final Logger log = LoggerFactory.getLogger(CrmActPlanServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final CrmActPlanDAO dao;
    private final ExcelUtil excelUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdSystemSelectionService service;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdSystemBusinessChangeService changeService;
    private final PrdSystemBusinessChangeDAO changeDAO;
    private final TransactionUtilService transactionUtilService;
    private final TransactionTemplate transactionTemplate;
    private final WorkflowUtil workflowUtil;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    @Transactional
    public CrmActPlanVO insert(CrmActPlanPayload payload) {
        payload.setPlanYear(payload.getPlanYear().trim());
        if (this.dao.queryByYearOrOrgId(payload.getPlanYear(), payload.getOrgId()) != null) {
            throw TwException.error((String)"", (String)("\u8be5\u7ec4\u7ec7\u5df2\u5b58\u5728" + payload.getPlanYear() + "\u5e74\u5ea6\u8ba1\u5212"));
        }
        String code = this.generateSeqNum("ACT_PLAN_NO", new String[0]);
        payload.setPlanNo(code);
        payload.setPlanStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        CrmActPlanDO ado = CrmActPlanConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        CrmActPlanVO crmActPlanVO = CrmActPlanConvert.INSTANCE.toVo(ado);
        return crmActPlanVO;
    }

    @Transactional
    public Long update(CrmActPlanPayload payload) {
        CrmActPlanVO planVO = this.dao.queryBykey(payload.getId());
        this.checkUpdate(planVO);
        if (payload.getPlanStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            this.dao.updateByKeyDynamic(payload);
            if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
                this.submitProc(planVO);
            }
        } else {
            this.changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), (TwCommonPayload)payload, null, null);
            if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
                this.submitChangeProc(planVO);
            }
        }
        return 0L;
    }

    @Transactional
    public boolean deleteSoft(Long key) {
        CrmActPlanVO planVO = this.dao.queryBykey(key);
        if (!planVO.getPlanStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            throw TwException.error((String)"", (String)"\u4ec5\u65b0\u589e\u5e02\u573a\u8ba1\u5212\u53ef\u5220\u9664");
        }
        this.dao.deleteSoft(key);
        this.dao.deleteDetailSoft(key);
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public PagingVO<CrmActPlanVO> paging(CrmActPlanQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        List orgManageIds = this.daoOrg.queryByManageIdOrgIds(userId);
        List userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            userId = null;
        }
        PagingVO<CrmActPlanVO> actPlanVOPagingVO = this.dao.queryPaging(query, userId, orgManageIds);
        List planVOS = actPlanVOPagingVO.getRecords();
        planVOS.forEach(planVO -> {
            this.updateCloseStatus((CrmActPlanVO)planVO);
            planVO.setPlanStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), planVO.getPlanStatus()));
        });
        return actPlanVOPagingVO;
    }

    public void downloadPlans(HttpServletResponse response, CrmActPlanQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmPlanBatch.xlsx");
        PagingVO<CrmActPlanVO> evo = this.paging(query);
        List list = evo.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u5e02\u573a\u8ba1\u5212");
            this.excelUtil.generateRangeList(batchProjectSheet, 3, 1, "\u7ec4\u7ec7\u6570\u636e", 2, "A");
            this.excelUtil.generateRangeList(batchProjectSheet, 9, 1, "\u72b6\u6001", 2, "A");
            if (!CollectionUtils.isEmpty((Collection)list) && batchProjectSheet != null) {
                int nextRow = 1;
                for (CrmActPlanVO dataPayload : list) {
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, (Object)nextRow);
                    this.excelUtil.setCellValue((Row)row, 1, (Object)dataPayload.getPlanNo());
                    this.excelUtil.setCellValue((Row)row, 2, (Object)dataPayload.getPlanName());
                    this.excelUtil.setCellValue((Row)row, 3, (Object)dataPayload.getOrgName());
                    this.excelUtil.setCellFormulas((Row)row, 4, "VLOOKUP(D:rowNo,\u7ec4\u7ec7\u6570\u636e!A:B,2,FALSE)");
                    this.excelUtil.setCellValue((Row)row, 5, (Object)dataPayload.getPlanYear());
                    this.excelUtil.setCellValue((Row)row, 6, (Object)dataPayload.getBudgetMoney());
                    this.excelUtil.setCellValue((Row)row, 7, (Object)dataPayload.getLeadNum());
                    this.excelUtil.setCellValue((Row)row, 8, (Object)dataPayload.getPipeline());
                    this.excelUtil.setCellValue((Row)row, 9, (Object)dataPayload.getPlanStatusName());
                    this.excelUtil.setCellValue((Row)row, 10, (Object)dataPayload.getCreateUserName());
                    this.excelUtil.setCellValue((Row)row, 11, (Object)DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2").format(dataPayload.getCreateTime()));
                    ++nextRow;
                }
            }
            List orgList = this.daoOrg.queryAll(null, null, null);
            Sheet orgSheet = workbook.getSheet("\u7ec4\u7ec7\u6570\u636e");
            if (!CollectionUtils.isEmpty((Collection)orgList) && orgSheet != null) {
                int nextRow = 1;
                for (PrdOrgOrganizationRefVO org : orgList) {
                    Long addrNo = org.getOrgId();
                    String addrName = org.getOrgName();
                    if (addrNo == null || !StringUtils.hasText((String)addrName)) continue;
                    Row row = orgSheet.createRow(nextRow);
                    this.excelUtil.setCellValue(row, 0, (Object)addrName);
                    this.excelUtil.setCellValue(row, 1, (Object)addrNo);
                    ++nextRow;
                }
            }
            List jobList = this.service.selectByCondition(FunctionSelectionEnum.FlowStatus.getCode());
            Sheet jobSheet = workbook.getSheet("\u72b6\u6001");
            if (!CollectionUtils.isEmpty((Collection)jobList) && jobSheet != null) {
                int nextRow = 1;
                for (PrdSystemSelectionVO job : jobList) {
                    String selectionValue = job.getSelectionValue();
                    String selectionName = job.getSelectionName();
                    if (!StringUtils.hasText((String)selectionName) || !StringUtils.hasText((String)selectionValue)) continue;
                    Row row = jobSheet.createRow(nextRow);
                    this.excelUtil.setCellValue(row, 0, (Object)selectionName);
                    this.excelUtil.setCellValue(row, 1, (Object)selectionValue);
                    ++nextRow;
                }
            }
            String fileName = "\u5e02\u573a\u8ba1\u5212\u6570\u636e-" + LocalDate.now();
            ExcelUtil.writeResponse((HttpServletResponse)response, (String)fileName, (Workbook)workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void downloadPlanDetails(HttpServletResponse response, Long planId) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmPlanDetailBatch.xlsx");
        List<CrmActPlanDetailVO> list = this.queryDetails(planId, null);
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u5e02\u573a\u8ba1\u5212\u660e\u7ec6");
            this.excelUtil.generateRangeList(batchProjectSheet, 2, 2, "\u6d3b\u52a8\u7c7b\u578b", 2, "A");
            if (!CollectionUtils.isEmpty(list) && batchProjectSheet != null) {
                int nextRow = 2;
                for (CrmActPlanDetailVO dataPayload : list) {
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, (Object)nextRow);
                    this.excelUtil.setCellValue((Row)row, 1, (Object)dataPayload.getDetailSeason());
                    this.excelUtil.setCellValue((Row)row, 2, (Object)dataPayload.getDetailTypeName());
                    this.excelUtil.setCellValue((Row)row, 3, (Object)dataPayload.getDetailName());
                    this.excelUtil.setCellValue((Row)row, 4, (Object)dataPayload.getPersonMoney());
                    this.excelUtil.setCellValue((Row)row, 5, (Object)dataPayload.getPersonSource());
                    this.excelUtil.setCellValue((Row)row, 6, (Object)dataPayload.getClaimMoney());
                    this.excelUtil.setCellValue((Row)row, 7, (Object)dataPayload.getPurchaseMoney());
                    this.excelUtil.setCellValue((Row)row, 8, (Object)dataPayload.getSundryMoney());
                    this.excelUtil.setCellValue((Row)row, 9, (Object)dataPayload.getTotalMoney());
                    this.excelUtil.setCellValue((Row)row, 10, (Object)dataPayload.getLeadNum());
                    this.excelUtil.setCellValue((Row)row, 11, (Object)dataPayload.getPipeline());
                    ++nextRow;
                }
            }
            List jobList = this.service.selectByCondition(FunctionSelectionEnum.CrmPlanDetailType.getCode());
            Sheet jobSheet = workbook.getSheet("\u6d3b\u52a8\u7c7b\u578b");
            if (!CollectionUtils.isEmpty((Collection)jobList) && jobSheet != null) {
                int nextRow = 2;
                for (PrdSystemSelectionVO job : jobList) {
                    String selectionValue = job.getSelectionValue();
                    String selectionName = job.getSelectionName();
                    if (!StringUtils.hasText((String)selectionName) || !StringUtils.hasText((String)selectionValue)) continue;
                    Row row = jobSheet.createRow(nextRow);
                    this.excelUtil.setCellValue(row, 0, (Object)selectionName);
                    this.excelUtil.setCellValue(row, 1, (Object)selectionValue);
                    ++nextRow;
                }
            }
            String fileName = "\u5e02\u573a\u8ba1\u5212\u660e\u7ec6\u6570\u636e-" + LocalDate.now();
            ExcelUtil.writeResponse((HttpServletResponse)response, (String)fileName, (Workbook)workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<CrmActPlanVO> queryPlans(LocalDateTime newDate) {
        return this.dao.queryList("" + newDate.getYear(), WorkFlowStatusEnum.APPROVED_WORK.getCode());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public CrmActPlanVO queryByKey(Long key) {
        CrmActPlanVO planVO = this.dao.queryBykey(key);
        this.updateCloseStatus(planVO);
        planVO.setPlanStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), planVO.getPlanStatus()));
        List<CrmActPlanDetailVO> planDetailVOS = this.dao.queryDetailsByPlanId(key, new String[0]);
        planDetailVOS.forEach(planDetailVO -> planDetailVO.setDetailTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPlanDetailType.getCode(), planDetailVO.getDetailType())));
        planVO.setPlanDetailVOS(planDetailVOS);
        return planVO;
    }

    @Transactional
    public boolean submitCheck(Long key) {
        CrmActPlanVO planVO = this.dao.queryBykey(key);
        if (planVO == null) {
            throw TwException.error((String)"", (String)"\u672a\u627e\u5230\u76f8\u5173\u7684\u5e02\u573a\u8ba1\u5212");
        }
        if (!planVO.getPlanStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            throw TwException.error((String)"", (String)"\u4ec5\u65b0\u589e\u5e02\u573a\u8ba1\u5212\u53ef\u64cd\u4f5c");
        }
        this.submitProc(planVO);
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    void updateCloseStatus(CrmActPlanVO planVO) {
        if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode()) || LocalDateTime.now().getYear() > Integer.valueOf(planVO.getPlanYear())) {
            // empty if block
        }
    }

    void updateCreateStatus(Long id) {
        CrmActPlanVO planVO = this.dao.queryBykey(id);
        String status = planVO.getPlanStatus();
        if (status.equals(WorkFlowStatusEnum.APPROVING_WORK.getCode())) {
            throw TwException.error((String)"", (String)"\u6b63\u5728\u5ba1\u6279\u4e2d\u3002\u3002\u3002");
        }
        if (status.equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error((String)"", (String)"\u8ba1\u5212\u5df2\u5173\u95ed");
        }
        if (!status.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            this.dao.updateStatus(id, WorkFlowStatusEnum.CREATE_WORK.getCode(), "");
        }
    }

    String checkUpdate(Long id) {
        CrmActPlanVO planVO = this.dao.queryBykey(id);
        String status = planVO.getPlanStatus();
        if (status.equals(WorkFlowStatusEnum.APPROVING_WORK.getCode())) {
            throw TwException.error((String)"", (String)"\u6b63\u5728\u5ba1\u6279\u4e2d\u3002\u3002\u3002");
        }
        if (status.equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error((String)"", (String)"\u8ba1\u5212\u5df2\u5173\u95ed");
        }
        return status;
    }

    @Transactional
    public boolean closePlan(Long key, String operateReason) {
        String status;
        CrmActPlanVO planVO = this.dao.queryBykey(key);
        if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode()) || planVO.getPlanStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            status = WorkFlowStatusEnum.CLOSED_WORK.getCode();
            if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
                status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            }
        } else {
            throw TwException.error((String)"", (String)"\u4e0d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
        this.dao.updatePlanStatus(key, status, operateReason);
        return true;
    }

    @Transactional
    public CrmActPlanDetailVO insertDetail(CrmActPlanDetailPayload payload) {
        CrmActPlanDetailDO planDetailDO = this.dao.queryDetail(payload.getPlanId(), payload.getDetailSeason(), payload.getDetailType());
        if (planDetailDO != null) {
            throw TwException.error((String)"", (String)(payload.getDetailSeason() + "\u5b63\u5ea6\u5df2\u5b58\u5728\u8be5\u7c7b\u578b\u660e\u7ec6"));
        }
        String planStatus = this.checkUpdate(payload.getPlanId());
        List<CrmActPlanDetailVO> planDetailVOS = this.dao.queryDetailsByPlanId(payload.getPlanId(), new String[0]);
        BigDecimal budgetMoney = new BigDecimal("0");
        int leadNum = 0;
        BigDecimal pipeline = new BigDecimal("0");
        for (CrmActPlanDetailVO planDetailVO : planDetailVOS) {
            budgetMoney = budgetMoney.add(planDetailVO.getTotalMoney());
            leadNum += planDetailVO.getLeadNum() == null ? 0 : planDetailVO.getLeadNum();
            pipeline = pipeline.add(planDetailVO.getPipeline() == null ? BigDecimal.ZERO : planDetailVO.getPipeline());
        }
        budgetMoney = budgetMoney.add(payload.getTotalMoney());
        pipeline = pipeline.add(payload.getPipeline() == null ? BigDecimal.ZERO : payload.getPipeline());
        CrmActPlanPayload planPayload = new CrmActPlanPayload();
        planPayload.setId(payload.getPlanId());
        planPayload.setPipeline(pipeline);
        planPayload.setLeadNum(Integer.valueOf(leadNum += payload.getLeadNum() == null ? 0 : payload.getLeadNum()));
        planPayload.setBudgetMoney(budgetMoney);
        if (planStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            this.dao.updateByKeyDynamic(planPayload);
        } else {
            BigDecimal addTotal = budgetMoney;
            planPayload.setBudgetMoney(addTotal);
            this.changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), (TwCommonPayload)planPayload, null, null);
        }
        CrmActPlanDetailDO ado = CrmActPlanDetailConvert.INSTANCE.toDo(payload);
        ado.setExpenditure(new BigDecimal("0"));
        if (planStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            ado = this.dao.saveDetail(ado);
            return CrmActPlanDetailConvert.INSTANCE.toVo(ado);
        }
        CrmActPlanDetailVO crmActPlanDetailVO = CrmActPlanDetailConvert.INSTANCE.toVo(ado);
        crmActPlanDetailVO.setDetailTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPlanDetailType.getCode(), crmActPlanDetailVO.getDetailType()));
        crmActPlanDetailVO.setExpenditure(crmActPlanDetailVO.getExpenditure() == null ? BigDecimal.ZERO : crmActPlanDetailVO.getExpenditure());
        this.changeService.saveNewLog(ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode(), (BaseViewModel)crmActPlanDetailVO, ChangeTypeEnum.MARKET_PLAN.getCode(), payload.getPlanId().toString(), Integer.valueOf(0));
        return crmActPlanDetailVO;
    }

    @Transactional
    public Long updateDetail(CrmActPlanDetailPayload payload) {
        CrmActPlanDetailDO planDetailDO = this.dao.queryDetail(payload.getPlanId(), payload.getDetailSeason(), payload.getDetailType());
        if (planDetailDO != null && payload.getId().longValue() != planDetailDO.getId().longValue()) {
            throw TwException.error((String)"", (String)(payload.getDetailSeason() + "\u5b63\u5ea6\u5df2\u5b58\u5728\u8be5\u7c7b\u578b\u660e\u7ec6"));
        }
        String planStatus = this.checkUpdate(payload.getPlanId());
        List<CrmActPlanDetailVO> planDetailVOS = this.dao.queryDetailsByPlanId(payload.getPlanId(), new String[0]);
        CrmActPlanDetailVO planDetailVO = planDetailVOS.stream().filter(planDetail -> planDetail.getId().longValue() == payload.getId().longValue()).findFirst().get();
        if (payload.getTotalMoney().compareTo(planDetailVO.getTotalMoney()) != 0 || payload.getPipeline() != null && planDetailVO.getPipeline() == null || payload.getPipeline() == null && planDetailVO.getPipeline() != null || payload.getPipeline() != null && planDetailVO.getPipeline() != null && payload.getPipeline().compareTo(planDetailVO.getPipeline()) != 0 || payload.getLeadNum() != null && planDetailVO.getLeadNum() == null || payload.getLeadNum() == null && planDetailVO.getLeadNum() != null || payload.getLeadNum() != null && planDetailVO.getLeadNum() != null && !payload.getLeadNum().equals(planDetailVO.getLeadNum())) {
            BigDecimal budgetMoney = new BigDecimal("0");
            int leadNum = 0;
            BigDecimal pipeline = new BigDecimal("0");
            for (CrmActPlanDetailVO planDetail2 : planDetailVOS) {
                if (planDetail2.getId().longValue() == payload.getId().longValue()) continue;
                budgetMoney = budgetMoney.add(planDetail2.getTotalMoney());
                leadNum += planDetail2.getLeadNum() == null ? 0 : planDetail2.getLeadNum();
                pipeline = pipeline.add(planDetail2.getPipeline() == null ? BigDecimal.ZERO : planDetail2.getPipeline());
            }
            budgetMoney = budgetMoney.add(payload.getTotalMoney());
            pipeline = pipeline.add(payload.getPipeline() == null ? BigDecimal.ZERO : payload.getPipeline());
            CrmActPlanPayload planPayload = new CrmActPlanPayload();
            planPayload.setId(payload.getPlanId());
            planPayload.setPipeline(pipeline);
            planPayload.setLeadNum(Integer.valueOf(leadNum += payload.getLeadNum() == null ? 0 : payload.getLeadNum()));
            planPayload.setBudgetMoney(budgetMoney);
            if (planStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
                this.dao.updateByKeyDynamic(planPayload);
            } else {
                Integer currentActiveVersion = this.changeService.getCurrentActiveVersion(ChangeTypeEnum.MARKET_PLAN.getCode(), payload.getPlanId().toString());
                Integer currentVersion = currentActiveVersion + 1;
                List changeLogChildrenLogs = this.changeService.getChangeLogChildrenLogs(ChangeTypeEnum.MARKET_PLAN.getCode(), payload.getPlanId().toString(), currentVersion);
                BigDecimal changeTotal = budgetMoney;
                for (PrdSystemBusinessChangeVO changeLogChildrenLog : changeLogChildrenLogs) {
                    JSONObject versionMap;
                    String versionContent;
                    JSONObject contentMap;
                    String changeContent = changeLogChildrenLog.getChangeContent();
                    if (changeContent != null && (contentMap = JSON.parseObject((String)changeContent)).get("totalMoney") != null) {
                        Long planDetailId = Long.parseLong(changeLogChildrenLog.getChangeDocId());
                        CrmActPlanDetailDO crmActPlanDetailDO = this.dao.queryDetailById(planDetailId);
                        changeTotal = changeTotal.subtract(crmActPlanDetailDO.getTotalMoney()).add(new BigDecimal(contentMap.get("totalMoney").toString()));
                    }
                    if ((versionContent = changeLogChildrenLog.getVersionContent()) == null || (versionMap = JSON.parseObject((String)versionContent)).get("totalMoney") == null) continue;
                    changeTotal = changeTotal.add(new BigDecimal(versionMap.get("totalMoney").toString()));
                }
                planPayload.setBudgetMoney(changeTotal);
                this.changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), (TwCommonPayload)planPayload, null, null);
            }
        }
        if (planStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            return this.dao.updateDetailByKeyDynamic(payload);
        }
        this.changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode(), (TwCommonPayload)payload, ChangeTypeEnum.MARKET_PLAN.getCode(), payload.getPlanId().toString());
        return -1L;
    }

    @Transactional
    public boolean deleteDetailSoft(Long planId, Long key, Long changeLogId) {
        List<CrmActPlanDetailVO> planDetailVOS = this.dao.queryDetailsByPlanId(planId, new String[0]);
        BigDecimal budgetMoney = new BigDecimal("0");
        int leadNum = 0;
        BigDecimal pipeline = new BigDecimal("0");
        for (CrmActPlanDetailVO planDetail : planDetailVOS) {
            if (key == null || planDetail.getId().longValue() == key.longValue()) continue;
            budgetMoney = budgetMoney.add(planDetail.getTotalMoney());
            leadNum += planDetail.getLeadNum() == null ? 0 : planDetail.getLeadNum();
            pipeline = pipeline.add(planDetail.getPipeline() == null ? BigDecimal.ZERO : planDetail.getPipeline());
        }
        CrmActPlanPayload planPayload = new CrmActPlanPayload();
        planPayload.setId(planId);
        planPayload.setPipeline(pipeline);
        planPayload.setLeadNum(Integer.valueOf(leadNum));
        CrmActPlanDetailDO planDetailDO = null;
        if (key != null) {
            planDetailDO = this.dao.queryDetailById(key);
        }
        planPayload.setBudgetMoney(budgetMoney);
        Integer currentActiveVersion = this.changeService.getCurrentActiveVersion(ChangeTypeEnum.MARKET_PLAN.getCode(), planId.toString());
        Integer currentVersion = currentActiveVersion + 1;
        List changeLogChildrenLogs = this.changeService.getChangeLogChildrenLogs(ChangeTypeEnum.MARKET_PLAN.getCode(), planId.toString(), currentVersion);
        if (changeLogId != null) {
            planPayload.setBudgetMoney(budgetMoney);
            this.changeService.deleteById(changeLogId);
            this.changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), (TwCommonPayload)planPayload, null, null);
        } else {
            List<CrmActActivityDO> actActivityDOS = this.dao.queryActivityByDetailId(key);
            if (actActivityDOS != null && actActivityDOS.size() > 0) {
                throw TwException.error((String)"", (String)"\u5df2\u5b58\u5728\u5e02\u573a\u6d3b\u52a8\u9879\uff0c\u4e0d\u53ef\u5220\u9664");
            }
            CrmActPlanPayload payload = new CrmActPlanPayload();
            payload.setId(planDetailDO.getId());
            payload.setDeleteFlag(Integer.valueOf(1));
            String planStatus = this.checkUpdate(planDetailDO.getPlanId());
            if (planStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
                this.dao.updateByKeyDynamic(planPayload);
                this.dao.deleteDetailSoft(planId, key);
            } else {
                for (PrdSystemBusinessChangeVO changeLogChildrenLog : changeLogChildrenLogs) {
                    JSONObject contentMap;
                    String changeContent;
                    JSONObject versionMap;
                    String versionContent = changeLogChildrenLog.getVersionContent();
                    if (versionContent != null && (versionMap = JSON.parseObject((String)versionContent)).get("totalMoney") != null) {
                        budgetMoney = budgetMoney.add(new BigDecimal(versionMap.get("totalMoney").toString()));
                    }
                    if ((changeContent = changeLogChildrenLog.getChangeContent()) != null && (contentMap = JSON.parseObject((String)changeContent)).get("deleteFlag").equals(1)) {
                        PrdSystemBusinessChangeVO prdSystemBusinessChangeVO = this.changeService.mergeVersionByCurrentDocId(changeLogChildrenLog.getId());
                        String versionContent1 = prdSystemBusinessChangeVO.getVersionContent();
                        JSONObject content = JSON.parseObject((String)versionContent1);
                        budgetMoney = budgetMoney.subtract(new BigDecimal(content.get("totalMoney").toString()));
                    }
                    planPayload.setBudgetMoney(budgetMoney);
                }
                this.changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN.getCode(), (TwCommonPayload)planPayload, null, null);
                this.changeService.saveVersionLog(ChangeTypeEnum.MARKET_PLAN_DETAIL.getCode(), (TwCommonPayload)payload, ChangeTypeEnum.MARKET_PLAN.getCode(), planId.toString());
            }
        }
        return true;
    }

    public List<CrmActPlanDetailVO> queryDetails(Long planId, LocalDateTime newDate) {
        String detailSeason = "";
        if (newDate != null) {
            detailSeason = this.getSeason(newDate);
        }
        List<CrmActPlanDetailVO> planDetailVOS = this.dao.queryDetailsByPlanId(planId, detailSeason);
        planDetailVOS.forEach(planDetailVO -> {
            planDetailVO.setBalanceMoney(planDetailVO.getTotalMoney().subtract(planDetailVO.getExpenditure()));
            planDetailVO.setDetailTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPlanDetailType.getCode(), planDetailVO.getDetailType()));
        });
        return planDetailVOS;
    }

    public Map<String, Map<String, Map<String, BigDecimal>>> queryWorkTypes() {
        List<PrdSystemWorkTypeVO> workTypeVOS = this.dao.queryWorkTypes();
        HashMap<String, Map<String, Map<String, BigDecimal>>> workTypes = new HashMap<String, Map<String, Map<String, BigDecimal>>>();
        for (PrdSystemWorkTypeVO workTypeVO : workTypeVOS) {
            BigDecimal price;
            HashMap<String, BigDecimal> workType;
            String type = workTypeVO.getSysType();
            String work = workTypeVO.getSysWork();
            String level = workTypeVO.getSysLevel();
            BigDecimal unitPrice = workTypeVO.getUnitPrice();
            HashMap typeMap = (HashMap)workTypes.get(type);
            if (typeMap == null) {
                typeMap = new HashMap();
                workTypes.put(type, typeMap);
            }
            if ((workType = (HashMap<String, BigDecimal>)typeMap.get(work)) == null) {
                workType = new HashMap<String, BigDecimal>();
                typeMap.put(work, workType);
            }
            if ((price = (BigDecimal)workType.get(level)) != null) continue;
            workType.put(level, unitPrice);
        }
        return workTypes;
    }

    public List<PrdSystemBusinessChangeVO> changeLogList(Long planId) {
        List result = this.changeService.getChangeLogList(ChangeTypeEnum.MARKET_PLAN.getCode(), planId.toString());
        result.stream().forEach(e -> e.setCreateUserName(this.cacheUtil.getUserName(e.getCreateUserId())));
        return result;
    }

    public Map<String, Object> changeLogDetailByPlanId(Long planId) {
        Long currentVersionId = this.changeService.getCurrentVersionId(ChangeTypeEnum.MARKET_PLAN.getCode(), planId.toString());
        if (currentVersionId == null) {
            return new HashMap<String, Object>();
        }
        return this.changeService.getChangeLogDetail(currentVersionId, null);
    }

    void checkUpdate(CrmActPlanVO planVO) {
        if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.APPROVING_WORK.getCode())) {
            throw TwException.error((String)"", (String)"\u6b63\u5728\u5ba1\u6279\u4e2d\u3002\u3002\u3002");
        }
        if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error((String)"", (String)"\u8ba1\u5212\u5df2\u5173\u95ed");
        }
        if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            throw TwException.error((String)"", (String)"\u8be5\u6d3b\u52a8\u5df2\u6682\u6302");
        }
        if (planVO.getPlanStatus().equals(WorkFlowStatusEnum.INVALID.getCode())) {
            throw TwException.error((String)"", (String)"\u8be5\u6d3b\u52a8\u5df2\u4f5c\u5e9f");
        }
    }

    String getSeason(LocalDateTime newDate) {
        int month = newDate.getMonth().getValue();
        int season = month > 9 ? 4 : (month > 6 ? 3 : (month > 3 ? 2 : 1));
        return "Q" + season;
    }

    private void submitProc(CrmActPlanVO planVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, ArrayList> variables = new HashMap<String, ArrayList>();
            Long strategicCenterUserId = this.daoOrg.queryManageIdByCode("P00");
            Long marketManageUserId = this.daoOrg.queryManageIdByCode("P1MKT");
            Long orgId = planVO.getOrgId();
            Long planOrgManageUserId = this.daoOrg.queryManageIdById(orgId);
            variables.put("Activity_0qfet2u", CollUtil.newArrayList((Object[])new String[]{planOrgManageUserId.toString()}));
            variables.put("Activity_07qo68l", CollUtil.newArrayList((Object[])new String[]{strategicCenterUserId.toString()}));
            variables.put("Activity_1i5ts9h", CollUtil.newArrayList((Object[])new String[]{marketManageUserId.toString()}));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.MARKET_PLAN.name(), (String)(planVO.getPlanName() + "-\u5e02\u573a\u9884\u7b97\u5ba1\u6279\u6d41\u7a0b"), (String)("" + planVO.getId()), variables));
        }
        CrmActPlanPayload planPayload = new CrmActPlanPayload();
        planPayload.setProcInstId(processInfo.getProcInstId());
        planPayload.setId(planVO.getId());
        planPayload.setProcInstStatus(processInfo.getProcInstStatus());
        planPayload.setSubmitTime(LocalDateTime.now());
        planPayload.setPlanStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateByKeyDynamic(planPayload));
    }

    private void submitChangeProc(CrmActPlanVO planVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, ArrayList> variables = new HashMap<String, ArrayList>();
            Long strategicCenterUserId = this.daoOrg.queryManageIdByCode("P00");
            Long marketManageUserId = this.daoOrg.queryManageIdByCode("P1MKT");
            Long orgId = planVO.getOrgId();
            Long planOrgManageUserId = this.daoOrg.queryManageIdById(orgId);
            variables.put("Activity_1fpnkow", CollUtil.newArrayList((Object[])new String[]{planOrgManageUserId.toString()}));
            variables.put("Activity_191bk3m", CollUtil.newArrayList((Object[])new String[]{strategicCenterUserId.toString()}));
            variables.put("Activity_0tw90si", CollUtil.newArrayList((Object[])new String[]{marketManageUserId.toString()}));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.MARKET_PLAN_C.name(), (String)(planVO.getPlanName() + "-\u5e02\u573a\u9884\u7b97\u53d8\u66f4\u6d41\u7a0b"), (String)("" + planVO.getId()), variables));
        }
        CrmActPlanPayload planPayload = new CrmActPlanPayload();
        planPayload.setProcInstId(processInfo.getProcInstId());
        planPayload.setId(planVO.getId());
        planPayload.setProcInstStatus(processInfo.getProcInstStatus());
        planPayload.setSubmitTime(LocalDateTime.now());
        planPayload.setPlanStatus(status);
        List changeLogList = this.changeService.getChangeLogList(ChangeTypeEnum.MARKET_PLAN.getCode(), planVO.getId().toString());
        if (changeLogList != null && !changeLogList.isEmpty()) {
            PrdSystemBusinessChangeVO initVersion = new PrdSystemBusinessChangeVO();
            for (PrdSystemBusinessChangeVO prdSystemBusinessChangeVO : changeLogList) {
                if (prdSystemBusinessChangeVO.getVersionNo() != 0) continue;
                initVersion = prdSystemBusinessChangeVO;
            }
            String versionContent = initVersion.getVersionContent();
            JSONObject versionContentMap = JSON.parseObject((String)versionContent);
            versionContentMap.put("procInsId", processInfo.getProcInstId());
            versionContentMap.put("procInstStatus", processInfo.getProcInstStatus());
            versionContent = JSON.toJSONString((Object)versionContentMap);
            PrdSystemBusinessChangePayload changePayload = new PrdSystemBusinessChangePayload();
            changePayload.setVersionContent(versionContent);
            changePayload.setId(initVersion.getId());
            this.changeDAO.updateByKeyDynamic(changePayload);
        }
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateByKeyDynamic(planPayload));
    }

    public CrmActPlanServiceImpl(CacheUtil cacheUtil, CrmActPlanDAO dao, ExcelUtil excelUtil, PrdOrgOrganizationDAO daoOrg, PrdSystemSelectionService service, PrdSystemRoleDAO systemRoleDAO, PrdSystemBusinessChangeService changeService, PrdSystemBusinessChangeDAO changeDAO, TransactionUtilService transactionUtilService, TransactionTemplate transactionTemplate, WorkflowUtil workflowUtil) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.excelUtil = excelUtil;
        this.daoOrg = daoOrg;
        this.service = service;
        this.systemRoleDAO = systemRoleDAO;
        this.changeService = changeService;
        this.changeDAO = changeDAO;
        this.transactionUtilService = transactionUtilService;
        this.transactionTemplate = transactionTemplate;
        this.workflowUtil = workflowUtil;
    }
}

