/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPartnerPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityPartnerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityPartnerVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityPartnerConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityPartnerDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityPartnerDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmOpportunityPartnerServiceImpl
implements CrmOpportunityPartnerService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityPartnerServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final CrmOpportunityPartnerDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final CrmOpportunityDAO opportunityDAO;
    @Value(value="${tw4.opportunity.partner_operation}")
    private String partner_operation;
    @Value(value="${tw4.opportunity.partner_del}")
    private String partner_del;

    @Transactional
    public CrmOpportunityPartnerVO insert(CrmOpportunityPartnerPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setOppoId(this.opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if (payload.getPartnerIdV4() != null) {
            payload.setId(this.dao.getIdByV4(payload.getPartnerIdV4()));
        }
        CrmOpportunityPartnerDO ado = CrmOpportunityPartnerConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "\u5408\u4f5c\u4f19\u4f34");
        return CrmOpportunityPartnerConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(CrmOpportunityPartnerPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setOppoId(this.opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if (payload.getPartnerIdV4() != null) {
            payload.setId(this.dao.getIdByV4(payload.getPartnerIdV4()));
        }
        CrmOpportunityPartnerDO ado = CrmOpportunityPartnerConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "\u5408\u4f5c\u4f19\u4f34");
        return 0L;
    }

    public List<CrmOpportunityPartnerVO> queryList(Long oppoId) {
        return this.dao.queryList(oppoId);
    }

    @Transactional
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        this.dao.deleteSoft(keys);
        this.logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "\u5408\u4f5c\u4f19\u4f34");
        return true;
    }

    public CrmOpportunityPartnerServiceImpl(CacheUtil cacheUtil, CrmOpportunityPartnerDAO dao, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil, CrmOpportunityDAO opportunityDAO) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
        this.opportunityDAO = opportunityDAO;
    }
}

