/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.act.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActPlanDO;
import com.elitesland.tw.tw5crm.api.act.payload.CrmActPlanPayload;
import com.elitesland.tw.tw5crm.api.act.query.CrmActPlanQuery;
import com.elitesland.tw.tw5crm.api.act.service.CrmActPlanService;
import com.elitesland.tw.tw5crm.api.act.vo.CrmActPlanVO;
import com.elitesland.tw.tw5crm.server.act.convert.CrmActPlanConvert;
import com.elitesland.tw.tw5crm.server.act.dao.CrmActPlanDAO;
import com.elitesland.tw.tw5crm.server.act.repo.CrmActPlanRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class CrmActPlanServiceImpl
extends BaseServiceImpl
implements CrmActPlanService {
    private static final Logger log = LoggerFactory.getLogger(CrmActPlanServiceImpl.class);
    private final CrmActPlanRepo crmActPlanRepo;
    private final CrmActPlanDAO crmActPlanDAO;

    public PagingVO<CrmActPlanVO> queryPaging(CrmActPlanQuery query) {
        return this.crmActPlanDAO.queryPaging(query);
    }

    public List<CrmActPlanVO> queryListDynamic(CrmActPlanQuery query) {
        return this.crmActPlanDAO.queryListDynamic(query);
    }

    public CrmActPlanVO queryByKey(Long key) {
        CrmActPlanDO entity = this.crmActPlanRepo.findById(key).orElseGet(CrmActPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmActPlanVO vo = CrmActPlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmActPlanVO insert(CrmActPlanPayload payload) {
        CrmActPlanDO entityDo = CrmActPlanConvert.INSTANCE.toDo(payload);
        return CrmActPlanConvert.INSTANCE.toVo((CrmActPlanDO)((Object)this.crmActPlanRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmActPlanVO update(CrmActPlanPayload payload) {
        CrmActPlanDO entity = this.crmActPlanRepo.findById(payload.getId()).orElseGet(CrmActPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmActPlanDO entityDo = CrmActPlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmActPlanConvert.INSTANCE.toVo((CrmActPlanDO)((Object)this.crmActPlanRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(CrmActPlanPayload payload) {
        CrmActPlanDO entity = this.crmActPlanRepo.findById(payload.getId()).orElseGet(CrmActPlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.crmActPlanDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.crmActPlanRepo.findById(id);
                if (!optional.isEmpty()) {
                    CrmActPlanDO entity = (CrmActPlanDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.crmActPlanRepo.save((Object)entity);
                }
            });
        }
    }

    public CrmActPlanServiceImpl(CrmActPlanRepo crmActPlanRepo, CrmActPlanDAO crmActPlanDAO) {
        this.crmActPlanRepo = crmActPlanRepo;
        this.crmActPlanDAO = crmActPlanDAO;
    }
}

