/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.bid.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5crm.api.bid.payload.BidCostRecordsPayload;
import com.elitesland.tw.tw5crm.api.bid.query.BidCostRecordsQuery;
import com.elitesland.tw.tw5crm.api.bid.service.BidCostRecordsService;
import com.elitesland.tw.tw5crm.api.bid.vo.BidCostRecordsVO;
import com.elitesland.tw.tw5crm.server.bid.convert.BidCostRecordsConvert;
import com.elitesland.tw.tw5crm.server.bid.dao.BidCostRecordsDAO;
import com.elitesland.tw.tw5crm.server.bid.entity.BidCostRecordsDO;
import com.elitesland.tw.tw5crm.server.bid.repo.BidCostRecordsRepo;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BidCostRecordsServiceImpl
extends BaseServiceImpl
implements BidCostRecordsService {
    private static final Logger log = LoggerFactory.getLogger(BidCostRecordsServiceImpl.class);
    private final BidCostRecordsRepo bidCostRecordsRepo;
    private final BidCostRecordsDAO bidCostRecordsDAO;
    private final PrdSystemLogService logService;

    public PagingVO<BidCostRecordsVO> queryPaging(BidCostRecordsQuery query) {
        return this.bidCostRecordsDAO.queryPaging(query);
    }

    public List<BidCostRecordsVO> queryListDynamic(BidCostRecordsQuery query) {
        return this.bidCostRecordsDAO.queryListDynamic(query);
    }

    public BidCostRecordsVO queryByKey(Long key) {
        BidCostRecordsDO entity = this.bidCostRecordsRepo.findById(key).orElseGet(BidCostRecordsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BidCostRecordsVO vo = BidCostRecordsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BidCostRecordsVO insert(BidCostRecordsPayload payload) {
        BidCostRecordsDO entityDo = BidCostRecordsConvert.INSTANCE.toDo(payload);
        String changeLog = "\u521b\u5efa\u4e00\u6761\u8d39\u7528\u8bb0\u5f55";
        this.logService.saveNewLog(payload.getBidId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog);
        return BidCostRecordsConvert.INSTANCE.toVo((BidCostRecordsDO)this.bidCostRecordsRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BidCostRecordsVO update(BidCostRecordsPayload payload) {
        BidCostRecordsDO entity = this.bidCostRecordsRepo.findById(payload.getId()).orElseGet(BidCostRecordsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BidCostRecordsDO entityDo = BidCostRecordsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        String changeLog = "\u4fee\u6539\u4e00\u6761\u8d39\u7528\u8bb0\u5f55";
        this.logService.saveNewLog(payload.getBidId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog);
        return BidCostRecordsConvert.INSTANCE.toVo((BidCostRecordsDO)this.bidCostRecordsRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.bidCostRecordsRepo.findById(id);
                if (!optional.isEmpty()) {
                    BidCostRecordsDO entity = (BidCostRecordsDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.bidCostRecordsRepo.save(entity);
                    String changeLog = "\u5220\u9664\u4e00\u6761\u8d39\u7528\u8bb0\u5f55";
                    this.logService.saveNewLog(entity.getBidId(), PrdSystemObjectEnum.BID_PROJECT.getCode(), changeLog);
                }
            });
        }
    }

    public List<BidCostRecordsVO> queryCostRecordsByBidKey(Long bidKey) {
        return this.bidCostRecordsDAO.queryCostRecordsByBidKey(bidKey);
    }

    public BidCostRecordsServiceImpl(BidCostRecordsRepo bidCostRecordsRepo, BidCostRecordsDAO bidCostRecordsDAO, PrdSystemLogService logService) {
        this.bidCostRecordsRepo = bidCostRecordsRepo;
        this.bidCostRecordsDAO = bidCostRecordsDAO;
        this.logService = logService;
    }
}

