/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.handover.service;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.server.partner.common.dao.BookAddressDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5crm.api.handover.payload.HandoverRecordPayload;
import com.elitesland.tw.tw5crm.api.handover.query.HandoverQuery;
import com.elitesland.tw.tw5crm.api.handover.query.HandoverRecordQuery;
import com.elitesland.tw.tw5crm.api.handover.service.HandoverRecordService;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverOperateRecordVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryBusPartnerVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryLeadsVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverQueryOpportunityVO;
import com.elitesland.tw.tw5crm.api.handover.vo.HandoverRecordVO;
import com.elitesland.tw.tw5crm.server.common.handover.HandOverEnum;
import com.elitesland.tw.tw5crm.server.common.util.BusinessPartnerUtils;
import com.elitesland.tw.tw5crm.server.handover.convert.HandoverRecordConvert;
import com.elitesland.tw.tw5crm.server.handover.dao.HandoverRecordDAO;
import com.elitesland.tw.tw5crm.server.handover.entity.HandoverRecordDO;
import com.elitesland.tw.tw5crm.server.handover.repo.HandoverRecordRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class HandoverRecordServiceImpl
extends BaseServiceImpl
implements HandoverRecordService {
    private static final Logger log = LoggerFactory.getLogger(HandoverRecordServiceImpl.class);
    private final HandoverRecordRepo handoverRecordRepo;
    private final HandoverRecordDAO handoverRecordDAO;
    private final CacheUtil cacheUtil;
    private final BookAddressDAO bookAddressDAO;

    public List<HandoverOperateRecordVO> statisticsHandOverRecord(Long userId) {
        List<Object[]> objects = this.handoverRecordRepo.statisticsHandOverRecord(userId);
        if (CollectionUtil.isEmpty(objects)) {
            return new ArrayList<HandoverOperateRecordVO>();
        }
        List<HandoverOperateRecordVO> handoverRecordVOS = this.getAll(objects);
        handoverRecordVOS.stream().forEach(item -> {
            List<Long> ids = new ArrayList<Long>();
            if (StringUtils.isNotBlank((CharSequence)item.getId())) {
                ids = Arrays.stream(item.getId().split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            }
            item.setObjTypeDesc(HandOverEnum.queryNameByCode(item.getObjType()));
            item.setLeadsvos(this.queryHaveLeadsRecord(userId, ids));
            item.setOppovos(this.queryHaveOpportunityRecord(userId, ids));
            item.setBuspartvos(this.queryHaveBusPartnerRecord(userId, ids));
        });
        return handoverRecordVOS;
    }

    public List<HandoverOperateRecordVO> getAll(List<Object[]> objects) {
        ArrayList<HandoverOperateRecordVO> list = new ArrayList<HandoverOperateRecordVO>();
        for (Object[] obj : objects) {
            HandoverOperateRecordVO recordVO = new HandoverOperateRecordVO();
            recordVO.setId(String.valueOf(obj[0]));
            recordVO.setCreateTime(String.valueOf(obj[1]));
            recordVO.setFormUserId(obj[2] != null ? Long.valueOf(String.valueOf(obj[2])) : null);
            recordVO.setFormUserName(String.valueOf(obj[3]));
            recordVO.setToUserId(obj[4] != null ? Long.valueOf(String.valueOf(obj[4])) : null);
            recordVO.setToUserName(String.valueOf(obj[5]));
            recordVO.setObjType(String.valueOf(obj[6]));
            recordVO.setOperateUserId(obj[7] != null ? Long.valueOf(String.valueOf(obj[7])) : null);
            recordVO.setOperateUserName(String.valueOf(obj[8]));
            recordVO.setStatCount(obj[9] != null ? Long.valueOf(String.valueOf(obj[9])) : null);
            list.add(recordVO);
        }
        return list;
    }

    private List<HandoverQueryLeadsVO> queryHaveLeadsRecord(Long userId, List<Long> ids) {
        HandoverQuery query = new HandoverQuery();
        query.setUserId(userId);
        query.setObjType(HandOverEnum.LEADSTYPE.getCode());
        List<HandoverQueryLeadsVO> handoverQueryLeadsVOS = this.handoverRecordDAO.queryHaveLeadsRecord(query, ids);
        if (CollectionUtil.isEmpty(handoverQueryLeadsVOS)) {
            return null;
        }
        handoverQueryLeadsVOS.stream().forEach(item -> item.setDemandProductDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), item.getDemandProduct())));
        return handoverQueryLeadsVOS;
    }

    private List<HandoverQueryOpportunityVO> queryHaveOpportunityRecord(Long userId, List<Long> ids) {
        HandoverQuery query = new HandoverQuery();
        query.setUserId(userId);
        query.setObjType(HandOverEnum.OPPORTUNITYTYPE.getCode());
        List<HandoverQueryOpportunityVO> opportunityVOS = this.handoverRecordDAO.queryHaveOpportunityRecord(query, ids);
        if (CollectionUtil.isEmpty(opportunityVOS)) {
            return null;
        }
        opportunityVOS.stream().forEach(item -> {
            item.setOppoLevelDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoLevel.getCode(), item.getOppoLevel()));
            item.setProbabilityDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmProbability.getCode(), item.getProbability()));
            item.setSalePhaseDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmSalePhase.getCode(), item.getSalePhase()));
            item.setProjectStatusDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), item.getProjectStatus()));
        });
        return opportunityVOS;
    }

    private List<HandoverQueryBusPartnerVO> queryHaveBusPartnerRecord(Long userId, List<Long> ids) {
        HandoverQuery query = new HandoverQuery();
        query.setUserId(userId);
        query.setObjType(HandOverEnum.BUSPARTNERTYPE.getCode());
        List<HandoverQueryBusPartnerVO> busPartnerVOS = this.handoverRecordDAO.queryHaveBusPartnerRecord(query, ids);
        if (CollectionUtil.isEmpty(busPartnerVOS)) {
            return null;
        }
        List<Long> bookIds = busPartnerVOS.stream().map(HandoverQueryBusPartnerVO::getBookId).collect(Collectors.toList());
        List<BookAddressVO> bookAddressVOS = this.bookAddressDAO.queryAddressByBookId(bookIds);
        Map<Long, BookAddressVO> bookMap = bookAddressVOS.stream().collect(Collectors.toMap(BookAddressVO::getBookId, a -> a, (k1, k2) -> k1));
        busPartnerVOS.stream().forEach(item -> {
            item.setPartnerIdentityDesc(BusinessPartnerUtils.transIdentity(item.getPartnerIdentity()));
            BookAddressVO bk = (BookAddressVO)bookMap.get(item.getBookId());
            if (bk != null) {
                String pr = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), bk.getProvince());
                String p = StringUtils.isBlank((CharSequence)pr) ? "-" : pr;
                String ci = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), bk.getCity());
                String c = StringUtils.isBlank((CharSequence)ci) ? "-" : ci;
                String di = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), bk.getDistrict());
                String t = StringUtils.isBlank((CharSequence)di) ? "-" : di;
                item.setAddress(p + "/" + c + "/" + t);
            }
        });
        return busPartnerVOS;
    }

    public PagingVO<HandoverRecordVO> queryPaging(HandoverRecordQuery query) {
        return this.handoverRecordDAO.queryPaging(query);
    }

    public List<HandoverRecordVO> queryListDynamic(HandoverRecordQuery query) {
        return this.handoverRecordDAO.queryListDynamic(query);
    }

    public HandoverRecordVO queryByKey(Long key) {
        HandoverRecordDO entity = this.handoverRecordRepo.findById(key).orElseGet(HandoverRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        HandoverRecordVO vo = HandoverRecordConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public HandoverRecordVO insert(HandoverRecordPayload payload) {
        HandoverRecordDO entityDo = HandoverRecordConvert.INSTANCE.toDo(payload);
        return HandoverRecordConvert.INSTANCE.toVo((HandoverRecordDO)this.handoverRecordRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public HandoverRecordVO update(HandoverRecordPayload payload) {
        HandoverRecordDO entity = this.handoverRecordRepo.findById(payload.getId()).orElseGet(HandoverRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        HandoverRecordDO entityDo = HandoverRecordConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return HandoverRecordConvert.INSTANCE.toVo((HandoverRecordDO)this.handoverRecordRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.handoverRecordRepo.findById(id);
                if (!optional.isEmpty()) {
                    HandoverRecordDO entity = (HandoverRecordDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.handoverRecordRepo.save(entity);
                }
            });
        }
    }

    public HandoverRecordServiceImpl(HandoverRecordRepo handoverRecordRepo, HandoverRecordDAO handoverRecordDAO, CacheUtil cacheUtil, BookAddressDAO bookAddressDAO) {
        this.handoverRecordRepo = handoverRecordRepo;
        this.handoverRecordDAO = handoverRecordDAO;
        this.cacheUtil = cacheUtil;
        this.bookAddressDAO = bookAddressDAO;
    }
}

