/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductSkuPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductSkuQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductSkuService;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ea7\u54c1\u7ba1\u7406-\u5546\u54c1\u89c4\u683c\u7ec4\u5408\u8868SKU"})
@RestController
@RequestMapping(value={"/api/crm/product/sku"})
public class ProductSkuController {
    private static final Logger log = LoggerFactory.getLogger(ProductSkuController.class);
    private final ProductSkuService productSkuService;

    @PutMapping(value={"/updateStatus"})
    public TwOutputUtil updateStatus(@RequestBody ProductSkuPayload payload) {
        this.productSkuService.updateStatus(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.productSkuService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    public TwOutputUtil paging(ProductSkuQuery query) {
        return TwOutputUtil.ok((Object)this.productSkuService.paging(query));
    }

    @GetMapping(value={"/list"})
    public TwOutputUtil queryList(ProductSkuQuery query) {
        return TwOutputUtil.ok((Object)this.productSkuService.queryList(query));
    }

    public ProductSkuController(ProductSkuService productSkuService) {
        this.productSkuService = productSkuService;
    }
}

