/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sample.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.sample.payload.SampleReturnRecordPayload;
import com.elitesland.tw.tw5crm.api.sample.query.SampleReturnRecordQuery;
import com.elitesland.tw.tw5crm.api.sample.vo.SampleReturnRecordVO;
import com.elitesland.tw.tw5crm.server.common.constants.SampleEnum;
import com.elitesland.tw.tw5crm.server.product.entity.QProductSkuDO;
import com.elitesland.tw.tw5crm.server.sample.entity.QSampleDetailsDO;
import com.elitesland.tw.tw5crm.server.sample.entity.QSampleReturnRecordDO;
import com.elitesland.tw.tw5crm.server.sample.entity.SampleReturnRecordDO;
import com.elitesland.tw.tw5crm.server.sample.repo.SampleReturnRecordRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class SampleReturnRecordDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final SampleReturnRecordRepo repo;
    private final QSampleReturnRecordDO qdo = QSampleReturnRecordDO.sampleReturnRecordDO;
    private final QSampleDetailsDO qSampleDetailsDO = QSampleDetailsDO.sampleDetailsDO;
    private final QProductSkuDO qProductSkuDO = QProductSkuDO.productSkuDO;

    private JPAQuery<SampleReturnRecordVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SampleReturnRecordVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.sampleDetailsId, this.qdo.returnNumber, this.qdo.returnDate, this.qdo.feedback, this.qdo.feedbackFileId, this.qdo.returnedNumSum, this.qProductSkuDO.skuName, this.qProductSkuDO.attributeStr})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qSampleDetailsDO)).on((Predicate)this.qSampleDetailsDO.id.eq(this.qdo.sampleDetailsId))).leftJoin((EntityPath)this.qProductSkuDO)).on((Predicate)this.qProductSkuDO.id.eq(this.qSampleDetailsDO.productSkuId));
    }

    private JPAQuery<SampleReturnRecordVO> getJpaQueryWhere(SampleReturnRecordQuery query) {
        JPAQuery<SampleReturnRecordVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(SampleReturnRecordQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(SampleReturnRecordQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSampleDetailsId())) {
            list.add(this.qdo.sampleDetailsId.eq((Object)query.getSampleDetailsId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReturnNumber())) {
            list.add(this.qdo.returnNumber.eq((Object)query.getReturnNumber()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReturnDate())) {
            list.add(this.qdo.returnDate.eq((Object)query.getReturnDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFeedback())) {
            list.add(this.qdo.feedback.eq((Object)query.getFeedback()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFeedbackFileId())) {
            list.add(this.qdo.feedbackFileId.eq((Object)query.getFeedbackFileId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public SampleReturnRecordVO queryByKey(Long id) {
        JPAQuery<SampleReturnRecordVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (SampleReturnRecordVO)jpaQuery.fetchFirst();
    }

    public List<SampleReturnRecordVO> queryListDynamic(SampleReturnRecordQuery query) {
        JPAQuery<SampleReturnRecordVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<SampleReturnRecordVO> queryPaging(SampleReturnRecordQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<SampleReturnRecordVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public SampleReturnRecordDO save(SampleReturnRecordDO ado) {
        return (SampleReturnRecordDO)this.repo.save(ado);
    }

    public List<SampleReturnRecordDO> saveAll(List<SampleReturnRecordDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(SampleReturnRecordPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getFeedback() != null) {
            update.set((Path)this.qdo.feedback, (Object)payload.getFeedback());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("feedback")) {
                update.setNull((Path)this.qdo.feedback);
            }
            if (nullFields.contains("feedbackFileId")) {
                update.setNull((Path)this.qdo.feedbackFileId);
            }
            if (nullFields.contains("remark")) {
                update.setNull((Path)this.qdo.remark);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public List<SampleReturnRecordVO> queryListBySampleId(Long sampleId) {
        JPAQuery jpaQuery = (JPAQuery)this.getJpaQuerySelect().where((Predicate)this.qSampleDetailsDO.sampleId.eq((Object)sampleId).and((Predicate)this.qdo.deleteFlag.eq((Object)0)));
        return jpaQuery.fetch();
    }

    public Map<Long, Integer> getReturnedTotal(Set<Long> sampleDetailsIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qSampleDetailsDO.number.sum(), this.qSampleDetailsDO.id}).from((EntityPath)this.qSampleDetailsDO)).where((Predicate)this.qSampleDetailsDO.id.in(sampleDetailsIds).and((Predicate)this.qSampleDetailsDO.returnDemand.eq((Object)SampleEnum.NEED.getCode())))).groupBy(this.qSampleDetailsDO.id);
        List fetch = jpaQuery.fetch();
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>(fetch.size());
        fetch.forEach(tuple -> resultMap.put((Long)tuple.get(1, Long.class), (Integer)tuple.get(0, Integer.class)));
        return resultMap;
    }

    public Integer queryReturnedNumSum(Long sampleDetailsId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.returnNumber.sum().coalesce((Number)0)).from((EntityPath)this.qdo)).where((Predicate)this.qdo.sampleDetailsId.eq((Object)sampleDetailsId));
        return (Integer)jpaQuery.fetchFirst();
    }

    public SampleReturnRecordDAO(JPAQueryFactory jpaQueryFactory, SampleReturnRecordRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

