/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.workflow;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5crm.api.common.change.payload.ComBusinessChangePayload;
import com.elitesland.tw.tw5crm.api.common.change.vo.ComBusinessChangeVO;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityCostEstimatePayload;
import com.elitesland.tw.tw5crm.api.oppo.service.OpportunityCostEstimateService;
import com.elitesland.tw.tw5crm.server.common.change.dao.ComBusinessChangeDAO;
import com.elitesland.tw.tw5crm.server.oppo.dao.OpportunityCostEstimateDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/OPPO_ESTIMATE_CHANGE/callBack"})
@Transactional
public class OpportunityCostEstimateChangeWorkflowController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(OpportunityCostEstimateChangeWorkflowController.class);
    private final OpportunityCostEstimateService opportunityCostEstimateService;
    private final ComBusinessChangeDAO businessChangeDao;
    private final OpportunityCostEstimateDAO opportunityCostEstimateDAO;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    @Transactional
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        ComBusinessChangeVO comBusinessChangeVO = this.businessChangeDao.queryByKey(Long.valueOf(businessKey));
        if (comBusinessChangeVO != null) {
            OpportunityCostEstimatePayload opportunityCostEstimatePayload = new OpportunityCostEstimatePayload();
            opportunityCostEstimatePayload.setId(Long.valueOf(comBusinessChangeVO.getChangeDocId()));
            opportunityCostEstimatePayload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            ComBusinessChangePayload changePayload = new ComBusinessChangePayload();
            changePayload.setId(comBusinessChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            Boolean isUp = false;
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                }
                case INTERRUPT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.INTERRUPT.getCode());
                    changePayload.setApprProcInstId(null);
                    break;
                }
                case INVALID: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.INVALID.getCode());
                    break;
                }
                case REJECTED: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                }
                case APPROVED: {
                    isUp = true;
                    opportunityCostEstimatePayload = (OpportunityCostEstimatePayload)JSON.parseObject((String)comBusinessChangeVO.getChangeContent(), OpportunityCostEstimatePayload.class);
                    opportunityCostEstimatePayload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    opportunityCostEstimatePayload.setApprovedTime(LocalDateTime.now());
                    opportunityCostEstimatePayload.setVersion("v" + comBusinessChangeVO.getVersionNo().toString());
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    break;
                }
            }
            this.businessChangeDao.updateWorkFlow(changePayload);
            if (isUp.booleanValue()) {
                this.opportunityCostEstimateService.updatePro(opportunityCostEstimatePayload);
            } else {
                this.opportunityCostEstimateDAO.updateWorkFlow(opportunityCostEstimatePayload);
            }
        }
    }

    public OpportunityCostEstimateChangeWorkflowController(OpportunityCostEstimateService opportunityCostEstimateService, ComBusinessChangeDAO businessChangeDao, OpportunityCostEstimateDAO opportunityCostEstimateDAO) {
        this.opportunityCostEstimateService = opportunityCostEstimateService;
        this.businessChangeDao = businessChangeDao;
        this.opportunityCostEstimateDAO = opportunityCostEstimateDAO;
    }
}

