/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.common.util.criticalPath;

import com.elitesland.tw.tw5pms.server.common.util.criticalPath.Task;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Wbs {
    private List<Task> tasks;
    private Set<Task> noPreviousTasks;
    private Set<Task> noNextTasks;

    public Wbs(List<Task> tasks) {
        this.tasks = tasks;
        this.noNextTasks = new LinkedHashSet<Task>();
        this.noPreviousTasks = new LinkedHashSet<Task>();
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public static void main(String[] args) {
        Task t1 = new Task("1", "FS", 1.0, 0.0);
        Task t2 = new Task("2", "FS", 2.0, 0.0);
        Task t3 = new Task("3", "FS", 3.0, 0.0);
        Task t4 = new Task("6", "FS", 1.5, 0.0);
        LinkedList<Task> tl = new LinkedList<Task>();
        tl.add(t1);
        tl.add(t2);
        tl.add(t3);
        tl.add(t4);
        LinkedList<Task> tl1 = new LinkedList<Task>();
        LinkedList<Task> tl2 = new LinkedList<Task>();
        tl1.add(t1);
        tl2.add(t2);
        t2.setPreviousTasks(tl1);
        t3.setPreviousTasks(tl1);
        t4.setPreviousTasks(tl2);
        Wbs wbs = new Wbs(tl);
        wbs.calculateTime();
        for (Task task0 : wbs.tasks) {
            task0.setCriticalPath();
            System.out.println(task0.getTaskNumber() + "tnumber==" + task0.getEarlyStartTime() + "est===" + task0.getEarlyFinishTime() + "eft===" + task0.getLateStartTime() + "lst===" + task0.getLateFinishTime() + "lft====" + task0.isCriticalPath());
        }
    }

    public void operKeyPath() {
        this.calculateTime();
        List taskList = this.tasks.stream().filter(task -> task.isCriticalPath()).collect(Collectors.toList());
        Optional<Task> max = taskList.stream().max(Comparator.comparingDouble(Task::getLateFinishTime));
    }

    public void calculateTime() {
        Set<Task> tmpTasks;
        Set<Task> firstTimes = this.calculateNoPreviousEarlyTime(this.tasks);
        Set<Task> nextTimes = this.calculateEarlyTime(firstTimes);
        while ((nextTimes = this.calculateEarlyTime(tmpTasks = nextTimes)).size() > 0) {
        }
        firstTimes.clear();
        nextTimes.clear();
        tmpTasks.clear();
        firstTimes = this.calNoNextTasksLateTime(this.tasks);
        nextTimes = this.calculateLateTime(firstTimes);
        while ((nextTimes = this.calculateLateTime(tmpTasks = nextTimes)).size() > 0) {
        }
    }

    private Set<Task> calculateNoPreviousEarlyTime(List<Task> tasks) {
        LinkedHashSet<Task> calTasks = new LinkedHashSet<Task>();
        if (tasks != null && tasks.size() > 0) {
            Set<Task> noPreviousTasks = this.getNoPreviousTasks(tasks);
            for (Task task : noPreviousTasks) {
                if (!task.isCalEST() && !task.isCalEFT()) {
                    task.calculateET();
                }
                calTasks.add(task);
            }
        }
        return calTasks;
    }

    public Set<Task> getNoPreviousTasks(List<Task> tasks) {
        if (tasks != null && tasks.size() > 0) {
            for (Task task : tasks) {
                if (task == null || task.getPreviousTasks().size() != 0) continue;
                this.noPreviousTasks.add(task);
            }
        }
        return this.noPreviousTasks;
    }

    public Set<Task> calculateEarlyTime(Set<Task> nextTasks) {
        LinkedHashSet<Task> calTasks = new LinkedHashSet<Task>();
        if (nextTasks != null && nextTasks.size() > 0) {
            for (Task task : nextTasks) {
                List<Task> befTask = task.getPreviousTasks();
                int count = 0;
                for (int i = 0; i < befTask.size(); ++i) {
                    Task bfTask = befTask.get(i);
                    if (!bfTask.isCalEST() || !bfTask.isCalEFT()) continue;
                    ++count;
                }
                if (count == befTask.size()) {
                    task.calculateET();
                    calTasks.addAll(task.getNextTasks());
                    continue;
                }
                calTasks.add(task);
            }
        }
        return calTasks;
    }

    public Set<Task> calNoNextTasksLateTime(List<Task> tasks) {
        LinkedHashSet<Task> calTasks = new LinkedHashSet<Task>();
        if (tasks != null && tasks.size() > 0) {
            for (Task task : this.getNoNextTasks(tasks)) {
                if (!task.isCalLST() && !task.isCalLFT()) {
                    task.calculateLT();
                }
                calTasks.add(task);
            }
        }
        return calTasks;
    }

    public Set<Task> getNoNextTasks(List<Task> tasks) {
        if (tasks != null && tasks.size() > 0) {
            for (Task task : tasks) {
                if (task == null || task.getNextTasks().size() != 0) continue;
                this.noNextTasks.add(task);
            }
        }
        return this.noNextTasks;
    }

    public Set<Task> calculateLateTime(Set<Task> nextTasks) {
        LinkedHashSet<Task> calTasks = new LinkedHashSet<Task>();
        if (nextTasks != null && nextTasks.size() > 0) {
            for (Task task : nextTasks) {
                List<Task> nextTask = task.getNextTasks();
                int count = 0;
                for (int i = 0; i < nextTask.size(); ++i) {
                    Task ntTask = nextTask.get(i);
                    if (!ntTask.isCalLST() || !ntTask.isCalLFT()) continue;
                    ++count;
                }
                if (count == nextTask.size()) {
                    task.calculateLT();
                    calTasks.addAll(task.getPreviousTasks());
                    continue;
                }
                calTasks.add(task);
            }
        }
        return calTasks;
    }
}

