/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.my.service;

import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5pms.api.my.service.TaskService;
import com.elitesland.tw.tw5pms.api.my.vo.PmsProjectTaskActDataVO;
import com.elitesland.tw.tw5pms.api.my.vo.TaskVO;
import com.elitesland.tw.tw5pms.api.task.service.PmsTaskService;
import com.elitesland.tw.tw5pms.api.task.vo.PmsProjectTaskDataVO;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    private final PrdOrgEmployeeService employeeService;
    private final PmsTaskService pmsTaskService;
    private final CacheUtil cacheUtil;

    public List<PmsProjectTaskActDataVO> listProjAndTask() {
        LinkedList<PmsProjectTaskActDataVO> result = new LinkedList<PmsProjectTaskActDataVO>();
        result.add(this.getNoProject());
        List list = this.pmsTaskService.queryUseTimeSheetList();
        for (PmsProjectTaskDataVO task : list) {
            PmsProjectTaskActDataVO data = new PmsProjectTaskActDataVO();
            data.setProjectId(task.getProjectId());
            data.setProjectCode(task.getProjectCode());
            data.setProjectName(task.getProjectName());
            List taskVOS = task.getTaskVOS();
            if (!ObjectUtils.isEmpty((Object)taskVOS)) {
                ArrayList<TaskVO> taskS = new ArrayList<TaskVO>();
                for (PmsTaskVO vo : taskVOS) {
                    BigDecimal bigDecimal = vo.getEqvaQty();
                    BigDecimal bigDecimal2 = vo.getUsedEqva() == null ? BigDecimal.ZERO : vo.getUsedEqva();
                    BigDecimal effectiveEqva = bigDecimal.subtract(bigDecimal2);
                    if (!(effectiveEqva.doubleValue() > 0.0)) continue;
                    TaskVO taskVO = new TaskVO();
                    taskVO.setId(vo.getId());
                    taskVO.setTaskCode(vo.getTaskCode());
                    taskVO.setTaskName(vo.getTaskName());
                    taskVO.setEffectiveEqva(effectiveEqva);
                    taskS.add(taskVO);
                }
                data.setTaskVOS(taskS);
            }
            result.add(data);
        }
        return result;
    }

    PmsProjectTaskActDataVO getNoProject() {
        List children;
        List children2;
        PmsProjectTaskActDataVO vo = new PmsProjectTaskActDataVO();
        vo.setProjectId(Long.valueOf(0L));
        vo.setProjectCode("PJ000000000000");
        vo.setProjectName("\u65e0\u9879\u76ee");
        LinkedList<TaskVO> taskVOS = new LinkedList<TaskVO>();
        TaskVO noTask = new TaskVO();
        noTask.setId(Long.valueOf(0L));
        noTask.setTaskName("\u65e0\u4efb\u52a1");
        PrdSystemSelectionVO systemSelectionVO = this.cacheUtil.transferSystemSelectionObj("prd:timesheet:notask");
        if (!ObjectUtils.isEmpty((Object)systemSelectionVO) && (children2 = systemSelectionVO.getChildren()) != null && children2.size() > 0) {
            noTask.setTimesheetActList(children2.stream().map(selectionVO -> selectionVO.getSelectionName()).collect(Collectors.toList()));
        }
        taskVOS.add(noTask);
        TaskVO vacation = new TaskVO();
        vacation.setId(Long.valueOf(1L));
        vacation.setTaskName("\u6cd5\u5b9a\u5047/\u4f11\u5047");
        systemSelectionVO = this.cacheUtil.transferSystemSelectionObj("prd:timesheet:actType");
        if (!ObjectUtils.isEmpty((Object)systemSelectionVO) && (children = systemSelectionVO.getChildren()) != null && children.size() > 0) {
            vacation.setTimesheetActList(children.stream().filter(selectionVO -> "vacation".equals(selectionVO.getExtString2())).map(selectionVO -> selectionVO.getSelectionName()).collect(Collectors.toList()));
        }
        taskVOS.add(vacation);
        vo.setTaskVOS(taskVOS);
        return vo;
    }

    public List<PrdOrgEmployeeVO> getDisterUserIds(Long projectId) {
        HashSet userIds = new HashSet();
        PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
        query.setUserIdList(userIds);
        return this.employeeService.queryList(query);
    }

    public Long getApprResIdByAuthInfo(Long taskId) {
        return null;
    }

    public TaskServiceImpl(PrdOrgEmployeeService employeeService, PmsTaskService pmsTaskService, CacheUtil cacheUtil) {
        this.employeeService = employeeService;
        this.pmsTaskService = pmsTaskService;
        this.cacheUtil = cacheUtil;
    }
}

