/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsBudgetLogQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u9884\u7b97\u57fa\u672c\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/api/pms/pmsBudget"})
public class PmsBudgetController {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetController.class);
    private final PmsBudgetService pmsBudgetService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody PmsBudgetPayload payload) {
        return TwOutputUtil.ok((Object)this.pmsBudgetService.insertOrUpdate(payload));
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody PmsBudgetPayload payload) {
        return TwOutputUtil.ok((Object)this.pmsBudgetService.insertOrUpdate(payload));
    }

    @GetMapping(value={"/{key}"})
    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok((Object)this.pmsBudgetService.queryByKey(key));
    }

    @GetMapping(value={"/queryByProjectId"})
    @ApiOperation(value="\u901a\u8fc7\u9879\u76eeid\u67e5\u8be2")
    public TwOutputUtil queryByProjectId(Long projectId) {
        return TwOutputUtil.ok((Object)this.pmsBudgetService.queryByProjectId2(projectId));
    }

    @PutMapping(value={"/updateWorkflowBudget"})
    @ApiOperation(value="\u6267\u884c\u6d41\u7a0b\u5185\u6570\u636e\u53d8\u66f4")
    public TwOutputUtil updateWorkflowBudget(@RequestBody PmsBudgetPayload payload) {
        this.pmsBudgetService.updateWorkflowBudget(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/batchImport"}, consumes={"multipart/form-data"})
    public TwOutputUtil importProbablyFile(MultipartFile file, Long templateId) {
        return TwOutputUtil.ok((Object)this.pmsBudgetService.importProbablyFile(file, templateId));
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/batchExport"})
    public void batchExport(HttpServletResponse response, Long templateId) {
        this.pmsBudgetService.downloadBatch(response, templateId);
    }

    @GetMapping(value={"/queryLogList"})
    @ApiOperation(value="\u67e5\u8be2\u65e5\u5fd7\u5217\u8868")
    public TwOutputUtil queryLogList(PmsBudgetLogQuery query) {
        return TwOutputUtil.ok((Object)this.pmsBudgetService.queryLogList(query));
    }

    public PmsBudgetController(PmsBudgetService pmsBudgetService) {
        this.pmsBudgetService = pmsBudgetService;
    }
}

