/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetTemplatePayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsBudgetTemplateQuery;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetTemplateVO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsBudgetTemplateDO;
import com.elitesland.tw.tw5pms.server.project.entity.QPmsBudgetTemplateDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetTemplateRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsBudgetTemplateDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsBudgetTemplateRepo repo;
    private final QPmsBudgetTemplateDO qdo = QPmsBudgetTemplateDO.pmsBudgetTemplateDO;

    private JPAQuery<PmsBudgetTemplateVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsBudgetTemplateVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.templateName, this.qdo.suitType, this.qdo.templateStatus, this.qdo.budgetTemplateCode, this.qdo.fileCodes, this.qdo.type})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsBudgetTemplateVO> getJpaQueryWhere(PmsBudgetTemplateQuery query) {
        JPAQuery<PmsBudgetTemplateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsBudgetTemplateQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(PmsBudgetTemplateQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getTemplateName())) {
            list.add(this.qdo.templateName.like(SqlUtil.toSqlLikeString((String)query.getTemplateName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSuitType())) {
            list.add(this.qdo.suitType.eq((Object)query.getSuitType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTemplateStatus())) {
            list.add(this.qdo.templateStatus.eq((Object)query.getTemplateStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetTemplateCode())) {
            list.add(this.qdo.budgetTemplateCode.eq((Object)query.getBudgetTemplateCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getType())) {
            list.add(this.qdo.type.eq((Object)query.getType()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsBudgetTemplateVO queryByKey(Long id) {
        JPAQuery<PmsBudgetTemplateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsBudgetTemplateVO)jpaQuery.fetchFirst();
    }

    public List<PmsBudgetTemplateVO> queryListDynamic(PmsBudgetTemplateQuery query) {
        JPAQuery<PmsBudgetTemplateVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsBudgetTemplateVO> queryPaging(PmsBudgetTemplateQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsBudgetTemplateVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsBudgetTemplateDO save(PmsBudgetTemplateDO ado) {
        return (PmsBudgetTemplateDO)this.repo.save(ado);
    }

    public List<PmsBudgetTemplateDO> saveAll(List<PmsBudgetTemplateDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsBudgetTemplatePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getTemplateName() != null) {
            update.set((Path)this.qdo.templateName, (Object)payload.getTemplateName());
        }
        if (payload.getSuitType() != null) {
            update.set((Path)this.qdo.suitType, (Object)payload.getSuitType());
        }
        if (payload.getTemplateStatus() != null) {
            update.set((Path)this.qdo.templateStatus, (Object)payload.getTemplateStatus());
        }
        if (payload.getBudgetTemplateCode() != null) {
            update.set((Path)this.qdo.budgetTemplateCode, (Object)payload.getBudgetTemplateCode());
        }
        if (payload.getType() != null) {
            update.set((Path)this.qdo.type, (Object)payload.getType());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("templateName")) {
                update.setNull((Path)this.qdo.templateName);
            }
            if (nullFields.contains("suitType")) {
                update.setNull((Path)this.qdo.suitType);
            }
            if (nullFields.contains("templateStatus")) {
                update.setNull((Path)this.qdo.templateStatus);
            }
            if (nullFields.contains("budgetTemplateCode")) {
                update.setNull((Path)this.qdo.budgetTemplateCode);
            }
            if (nullFields.contains("type")) {
                update.setNull((Path)this.qdo.type);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public Long submit(Long key, String status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.templateStatus, (Object)status).where(new Predicate[]{this.qdo.id.in((Object[])new Long[]{key})});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsBudgetTemplateDAO(JPAQueryFactory jpaQueryFactory, PmsBudgetTemplateRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

