/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.project.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetTemplatePayload;
import com.elitesland.tw.tw5pms.api.project.payload.PmsBudgetTemplateSubjectPayload;
import com.elitesland.tw.tw5pms.api.project.query.PmsBudgetTemplateQuery;
import com.elitesland.tw.tw5pms.api.project.service.PmsBudgetTemplateService;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetTemplateSubjectVO;
import com.elitesland.tw.tw5pms.api.project.vo.PmsBudgetTemplateVO;
import com.elitesland.tw.tw5pms.server.project.convert.PmsBudgetTemplateConvert;
import com.elitesland.tw.tw5pms.server.project.convert.PmsBudgetTemplateSubjectConvert;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetTemplateDAO;
import com.elitesland.tw.tw5pms.server.project.dao.PmsBudgetTemplateSubjectDAO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsBudgetTemplateDO;
import com.elitesland.tw.tw5pms.server.project.entity.PmsBudgetTemplateSubjectDO;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetTemplateRepo;
import com.elitesland.tw.tw5pms.server.project.repo.PmsBudgetTemplateSubjectRepo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsBudgetTemplateServiceImpl
extends BaseServiceImpl
implements PmsBudgetTemplateService {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetTemplateServiceImpl.class);
    private final PmsBudgetTemplateRepo pmsBudgetTemplateRepo;
    private final PmsBudgetTemplateSubjectRepo pmsBudgetTemplateSubjectRepo;
    private final PmsBudgetTemplateDAO pmsBudgetTemplateDAO;
    private final PmsBudgetTemplateSubjectDAO pmsBudgetTemplateSubjectDAO;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;

    public PagingVO<PmsBudgetTemplateVO> queryPaging(PmsBudgetTemplateQuery query) {
        PagingVO<PmsBudgetTemplateVO> pagingVO = this.pmsBudgetTemplateDAO.queryPaging(query);
        pagingVO.getRecords().forEach(this::transferData);
        return pagingVO;
    }

    public List<PmsBudgetTemplateVO> queryListDynamic(PmsBudgetTemplateQuery query) {
        List<PmsBudgetTemplateVO> pmsBudgetTemplateVOS = this.pmsBudgetTemplateDAO.queryListDynamic(query);
        pmsBudgetTemplateVOS.forEach(this::transferData);
        return pmsBudgetTemplateVOS;
    }

    public PmsBudgetTemplateVO queryByKey(Long key) {
        PmsBudgetTemplateVO vo = this.pmsBudgetTemplateDAO.queryByKey(key);
        List<PmsBudgetTemplateSubjectVO> pmsBudgetTemplateSubjectVOS = this.pmsBudgetTemplateSubjectDAO.queryByTemplateId(key);
        vo.setDetails(pmsBudgetTemplateSubjectVOS);
        vo.setFileDatas(this.fileUtil.getFileDatas(vo.getFileCodes()));
        vo.getDetails().sort(Comparator.comparing(PmsBudgetTemplateSubjectVO::getSubjectCode));
        this.transferData(vo);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsBudgetTemplateVO insertOrUpdate(PmsBudgetTemplatePayload payload) {
        this.checkDate(payload);
        List<Object> vos = new ArrayList();
        if (payload.getId() != null) {
            vos = this.pmsBudgetTemplateSubjectDAO.queryByTemplateId(payload.getId());
            if (!ObjectUtils.isEmpty((Object)payload.getDeleteSubjectIds())) {
                List collect = vos.stream().filter(vo -> payload.getDeleteSubjectIds().contains(vo.getId())).collect(Collectors.toList());
                this.pmsBudgetTemplateSubjectDAO.deleteSoft(payload.getDeleteSubjectIds());
                vos.removeAll(collect);
            }
        }
        PmsBudgetTemplateDO entityDo = PmsBudgetTemplateConvert.INSTANCE.toDo(payload);
        String code = this.generateSeqNum("PMS_BUDGET_TEMP", new String[0]);
        entityDo.setBudgetTemplateCode(code);
        entityDo = this.pmsBudgetTemplateDAO.save(entityDo);
        List details = payload.getDetails();
        if (!ObjectUtils.isEmpty((Object)details)) {
            if (vos.size() > 0) {
                List<Object> finalVos = vos;
                details.forEach(detail -> {
                    Optional<PmsBudgetTemplateSubjectVO> first = finalVos.stream().filter(vo -> detail.getId() != null && detail.getId().equals(vo.getId())).findFirst();
                    if (first.isPresent()) {
                        first.get().setSubjectId(detail.getSubjectId());
                    } else {
                        PmsBudgetTemplateSubjectVO pmsBudgetTemplateSubjectVO = PmsBudgetTemplateSubjectConvert.INSTANCE.toVo((PmsBudgetTemplateSubjectPayload)detail);
                        finalVos.add(pmsBudgetTemplateSubjectVO);
                    }
                });
                List collect = finalVos.stream().map(PmsBudgetTemplateSubjectVO::getSubjectId).distinct().collect(Collectors.toList());
                if (collect.size() < finalVos.size()) {
                    throw TwException.error((String)"", (String)"\u79d1\u76ee\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            } else {
                List collect = details.stream().map(PmsBudgetTemplateSubjectPayload::getSubjectId).distinct().collect(Collectors.toList());
                if (collect.size() < details.size()) {
                    throw TwException.error((String)"", (String)"\u79d1\u76ee\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            }
            ArrayList<PmsBudgetTemplateSubjectDO> dDetails = new ArrayList<PmsBudgetTemplateSubjectDO>();
            Long templateId = entityDo.getId();
            details.forEach(detail -> {
                detail.setTemplateId(templateId);
                dDetails.add(PmsBudgetTemplateSubjectConvert.INSTANCE.toDo((PmsBudgetTemplateSubjectPayload)detail));
            });
            this.pmsBudgetTemplateSubjectDAO.saveAll(dDetails);
        }
        return PmsBudgetTemplateConvert.INSTANCE.toVo(entityDo);
    }

    private void checkDate(PmsBudgetTemplatePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getTemplateName())) {
            throw TwException.error((String)"", (String)"\u6a21\u677f\u540d\u79f0\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getTemplateStatus())) {
            throw TwException.error((String)"", (String)"\u6a21\u677f\u72b6\u6001\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getType())) {
            throw TwException.error((String)"", (String)"\u7c7b\u522b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSuitType())) {
            throw TwException.error((String)"", (String)"\u9002\u7528\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsBudgetTemplateDAO.deleteSoft(keys);
            this.pmsBudgetTemplateSubjectDAO.deleteSoftByTemplateIds(keys);
        }
    }

    void transferData(PmsBudgetTemplateVO vo) {
        vo.setTemplateStatusName(this.cacheUtil.transferSystemSelection("SYSTEM_BASIC:STATUS", vo.getTemplateStatus()));
        vo.setTypeName(this.cacheUtil.transferSystemSelection("PMS:BUDGET:TYPE", vo.getType()));
        vo.setSuitTypeName(this.cacheUtil.transferSystemSelection("PMS:BUDGET:SUIT_TYPE", vo.getSuitType()));
    }

    public PmsBudgetTemplateServiceImpl(PmsBudgetTemplateRepo pmsBudgetTemplateRepo, PmsBudgetTemplateSubjectRepo pmsBudgetTemplateSubjectRepo, PmsBudgetTemplateDAO pmsBudgetTemplateDAO, PmsBudgetTemplateSubjectDAO pmsBudgetTemplateSubjectDAO, CacheUtil cacheUtil, FileUtil fileUtil) {
        this.pmsBudgetTemplateRepo = pmsBudgetTemplateRepo;
        this.pmsBudgetTemplateSubjectRepo = pmsBudgetTemplateSubjectRepo;
        this.pmsBudgetTemplateDAO = pmsBudgetTemplateDAO;
        this.pmsBudgetTemplateSubjectDAO = pmsBudgetTemplateSubjectDAO;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
    }
}

