/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5pms.server.task.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5pms.api.task.payload.PmsTaskPackageMemberPayload;
import com.elitesland.tw.tw5pms.api.task.query.PmsTaskPackageMemberQuery;
import com.elitesland.tw.tw5pms.api.task.vo.PmsTaskPackageMemberVO;
import com.elitesland.tw.tw5pms.server.task.entity.PmsTaskPackageMemberDO;
import com.elitesland.tw.tw5pms.server.task.entity.QPmsTaskPackageMemberDO;
import com.elitesland.tw.tw5pms.server.task.repo.PmsTaskPackageMemberRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsTaskPackageMemberDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsTaskPackageMemberRepo repo;
    private final QPmsTaskPackageMemberDO qdo = QPmsTaskPackageMemberDO.pmsTaskPackageMemberDO;

    private JPAQuery<PmsTaskPackageMemberVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsTaskPackageMemberVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.packageId, this.qdo.userId, this.qdo.userName, this.qdo.taskRole, this.qdo.extStr1, this.qdo.extStr2, this.qdo.extStr3})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsTaskPackageMemberVO> getJpaQueryWhere(PmsTaskPackageMemberQuery query) {
        JPAQuery<PmsTaskPackageMemberVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn((EntityPathBase)this.qdo, (List)query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsTaskPackageMemberQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery((JPAQuery)jpaQuery, (QBaseModel)this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PmsTaskPackageMemberQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPackageId())) {
            list.add(this.qdo.packageId.eq((Object)query.getPackageId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getUserId())) {
            list.add(this.qdo.userId.eq((Object)query.getUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getUserName())) {
            list.add(this.qdo.userName.like(SqlUtil.toSqlLikeString((String)query.getUserName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskRole())) {
            list.add(this.qdo.taskRole.eq((Object)query.getTaskRole()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtStr1())) {
            list.add(this.qdo.extStr1.like(SqlUtil.toSqlLikeString((String)query.getExtStr1())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtStr2())) {
            list.add(this.qdo.extStr2.like(SqlUtil.toSqlLikeString((String)query.getExtStr2())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtStr3())) {
            list.add(this.qdo.extStr3.like(SqlUtil.toSqlLikeString((String)query.getExtStr3())));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsTaskPackageMemberVO queryByKey(Long id) {
        JPAQuery<PmsTaskPackageMemberVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsTaskPackageMemberVO)jpaQuery.fetchFirst();
    }

    public List<PmsTaskPackageMemberVO> queryByPackageId(Long packageId) {
        JPAQuery<PmsTaskPackageMemberVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.packageId.eq((Object)packageId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsTaskPackageMemberVO> queryListDynamic(PmsTaskPackageMemberQuery query) {
        JPAQuery<PmsTaskPackageMemberVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsTaskPackageMemberVO> queryPaging(PmsTaskPackageMemberQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsTaskPackageMemberVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsTaskPackageMemberDO save(PmsTaskPackageMemberDO ado) {
        return (PmsTaskPackageMemberDO)this.repo.save(ado);
    }

    public List<PmsTaskPackageMemberDO> saveAll(List<PmsTaskPackageMemberDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsTaskPackageMemberPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getPackageId() != null) {
            update.set(this.qdo.packageId, (Object)payload.getPackageId());
        }
        if (payload.getUserId() != null) {
            update.set(this.qdo.userId, (Object)payload.getUserId());
        }
        if (payload.getUserName() != null) {
            update.set((Path)this.qdo.userName, (Object)payload.getUserName());
        }
        if (payload.getTaskRole() != null) {
            update.set((Path)this.qdo.taskRole, (Object)payload.getTaskRole());
        }
        if (payload.getExtStr1() != null) {
            update.set((Path)this.qdo.extStr1, (Object)payload.getExtStr1());
        }
        if (payload.getExtStr2() != null) {
            update.set((Path)this.qdo.extStr2, (Object)payload.getExtStr2());
        }
        if (payload.getExtStr3() != null) {
            update.set((Path)this.qdo.extStr3, (Object)payload.getExtStr3());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("packageId")) {
                update.setNull(this.qdo.packageId);
            }
            if (nullFields.contains("userId")) {
                update.setNull(this.qdo.userId);
            }
            if (nullFields.contains("userName")) {
                update.setNull((Path)this.qdo.userName);
            }
            if (nullFields.contains("taskRole")) {
                update.setNull((Path)this.qdo.taskRole);
            }
            if (nullFields.contains("extStr1")) {
                update.setNull((Path)this.qdo.extStr1);
            }
            if (nullFields.contains("extStr2")) {
                update.setNull((Path)this.qdo.extStr2);
            }
            if (nullFields.contains("extStr3")) {
                update.setNull((Path)this.qdo.extStr3);
            }
        }
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery((JPAUpdateClause)update, (QBaseModel)this.qdo._super);
        return update.execute();
    }

    public PmsTaskPackageMemberDAO(JPAQueryFactory jpaQueryFactory, PmsTaskPackageMemberRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

